/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.action;

import com.github.setial.intellijjavadocs.action.BaseAction;
import com.github.setial.intellijjavadocs.action.JavaDocGenerateHandler;
import com.github.setial.intellijjavadocs.generator.JavaDocGenerator;
import com.github.setial.intellijjavadocs.generator.impl.AbstractJavaDocGenerator;
import com.github.setial.intellijjavadocs.generator.impl.ClassJavaDocGenerator;
import com.github.setial.intellijjavadocs.generator.impl.FieldJavaDocGenerator;
import com.github.setial.intellijjavadocs.generator.impl.MethodJavaDocGenerator;
import com.github.setial.intellijjavadocs.operation.JavaDocWriter;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocGenerateAction
extends BaseAction {
    private JavaDocWriter writer = (JavaDocWriter)ServiceManager.getService(JavaDocWriter.class);

    public JavaDocGenerateAction() {
        this((CodeInsightActionHandler)new JavaDocGenerateHandler());
    }

    public JavaDocGenerateAction(CodeInsightActionHandler handler) {
        super(handler);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)DataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        int startPosition = editor.getSelectionModel().getSelectionStart();
        int endPosition = editor.getSelectionModel().getSelectionEnd();
        PsiFile file = (PsiFile)DataKeys.PSI_FILE.getData(e.getDataContext());
        if (file == null) {
            return;
        }
        LinkedList<PsiElement> elements = new LinkedList<PsiElement>();
        PsiElement firstElement = this.getJavaElement(PsiUtilCore.getElementAtOffset((PsiFile)file, (int)startPosition));
        if (firstElement != null) {
            PsiElement element = firstElement;
            do {
                if (!this.isAllowedElementType(element)) continue;
                elements.add(element);
            } while ((element = element.getNextSibling()) != null && this.isElementInSelection(element, startPosition, endPosition));
        }
        for (PsiElement element : elements) {
            this.processElement(element);
        }
    }

    protected void processElement(@NotNull PsiElement element) {
        PsiDocComment javaDoc;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "processElement"));
        }
        JavaDocGenerator generator = this.getGenerator(element);
        if (generator != null && (javaDoc = generator.generate(element)) != null) {
            this.writer.write(javaDoc, element);
        }
    }

    @Nullable
    protected JavaDocGenerator getGenerator(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "getGenerator"));
        }
        Project project = element.getProject();
        AbstractJavaDocGenerator generator = null;
        if (PsiClass.class.isAssignableFrom(element.getClass())) {
            generator = new ClassJavaDocGenerator(project);
        } else if (PsiMethod.class.isAssignableFrom(element.getClass())) {
            generator = new MethodJavaDocGenerator(project);
        } else if (PsiField.class.isAssignableFrom(element.getClass())) {
            generator = new FieldJavaDocGenerator(project);
        }
        return generator;
    }

    @NotNull
    private PsiElement getJavaElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "getJavaElement"));
        }
        PsiElement result = element;
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (field != null) {
            result = field;
        } else if (method != null) {
            result = method;
        } else if (clazz != null) {
            result = clazz;
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "getJavaElement"));
        }
        return psiElement;
    }

    private boolean isElementInSelection(@NotNull PsiElement element, int startPosition, int endPosition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "isElementInSelection"));
        }
        boolean result = false;
        int elementTextOffset = element.getTextRange().getStartOffset();
        if (elementTextOffset >= startPosition && elementTextOffset <= endPosition) {
            result = true;
        }
        return result;
    }

    private boolean isAllowedElementType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/action/JavaDocGenerateAction", "isAllowedElementType"));
        }
        boolean result = false;
        if (element instanceof PsiClass || element instanceof PsiField || element instanceof PsiMethod) {
            result = true;
        }
        return result;
    }
}

