/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.generator.impl;

import com.github.setial.intellijjavadocs.generator.impl.AbstractJavaDocGenerator;
import com.github.setial.intellijjavadocs.model.JavaDoc;
import com.github.setial.intellijjavadocs.model.settings.GeneralSettings;
import com.github.setial.intellijjavadocs.model.settings.JavaDocSettings;
import com.github.setial.intellijjavadocs.model.settings.Level;
import com.github.setial.intellijjavadocs.utils.JavaDocUtils;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.velocity.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldJavaDocGenerator
extends AbstractJavaDocGenerator<PsiField> {
    public FieldJavaDocGenerator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/setial/intellijjavadocs/generator/impl/FieldJavaDocGenerator", "<init>"));
        }
        super(project);
    }

    @Override
    @Nullable
    protected JavaDoc generateJavaDoc(@NotNull PsiField element) {
        String date;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/generator/impl/FieldJavaDocGenerator", "generateJavaDoc"));
        }
        JavaDocSettings configuration = this.getSettings().getConfiguration();
        GeneralSettings generalSettings = configuration.getGeneralSettings();
        if (configuration != null && !generalSettings.getLevels().contains((Object)Level.FIELD) || !this.shouldGenerate(element.getModifierList())) {
            return null;
        }
        Template template = this.getDocTemplateManager().getFieldTemplate(element);
        Map<String, Object> params = this.getDefaultParameters((PomNamedTarget)element);
        if (PsiEnumConstant.class.isAssignableFrom(element.getClass())) {
            params.put("name", element.getName());
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(generalSettings.getDateFormat());
            date = sdf.format(new Date());
        }
        catch (Exception e) {
            date = new Date().toString();
        }
        params.put("date", date);
        params.put("author", generalSettings.getAuthName());
        String javaDocText = this.getDocTemplateProcessor().merge(template, params);
        return JavaDocUtils.toJavaDoc(javaDocText, this.getPsiElementFactory());
    }
}

