/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.generator.impl;

import com.github.setial.intellijjavadocs.generator.impl.AbstractJavaDocGenerator;
import com.github.setial.intellijjavadocs.model.JavaDoc;
import com.github.setial.intellijjavadocs.model.settings.GeneralSettings;
import com.github.setial.intellijjavadocs.model.settings.JavaDocSettings;
import com.github.setial.intellijjavadocs.model.settings.Level;
import com.github.setial.intellijjavadocs.utils.JavaDocUtils;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.Template;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodJavaDocGenerator
extends AbstractJavaDocGenerator<PsiMethod> {
    public MethodJavaDocGenerator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/setial/intellijjavadocs/generator/impl/MethodJavaDocGenerator", "<init>"));
        }
        super(project);
    }

    @Override
    @Nullable
    protected JavaDoc generateJavaDoc(@NotNull PsiMethod element) {
        String date;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/generator/impl/MethodJavaDocGenerator", "generateJavaDoc"));
        }
        if (!this.shouldGenerate(element) || !this.shouldGenerate(element.getModifierList())) {
            return null;
        }
        Template template = this.getDocTemplateManager().getMethodTemplate(element);
        HashMap<String, String> paramNames = new HashMap<String, String>();
        for (PsiParameter parameter : element.getParameterList().getParameters()) {
            paramNames.put(parameter.getName(), this.getDocTemplateProcessor().buildDescription(parameter.getName(), false));
        }
        HashMap<String, String> exceptionNames = new HashMap<String, String>();
        for (PsiJavaCodeReferenceElement exception : element.getThrowsList().getReferenceElements()) {
            exceptionNames.put(exception.getReferenceName(), this.getDocTemplateProcessor().buildDescription(exception.getReferenceName(), false));
        }
        String returnDescription = "";
        PsiTypeElement returnElement = element.getReturnTypeElement();
        if (returnElement != null) {
            returnDescription = returnElement.getText();
        }
        Map<String, Object> params = this.getDefaultParameters((PomNamedTarget)element);
        if (returnElement != null) {
            params.put("isNotVoid", !returnElement.getType().isAssignableFrom((PsiType)PsiType.VOID));
            params.put("return", this.getDocTemplateProcessor().buildDescription(returnDescription, false));
        }
        params.put("paramNames", paramNames);
        params.put("exceptionNames", exceptionNames);
        GeneralSettings generalSettings = this.getSettings().getConfiguration().getGeneralSettings();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(generalSettings.getDateFormat());
            date = sdf.format(new Date());
        }
        catch (Exception e) {
            date = new Date().toString();
        }
        params.put("date", date);
        params.put("author", generalSettings.getAuthName());
        String javaDocText = this.getDocTemplateProcessor().merge(template, params);
        return JavaDocUtils.toJavaDoc(javaDocText, this.getPsiElementFactory());
    }

    private boolean shouldGenerate(@NotNull PsiMethod element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/generator/impl/MethodJavaDocGenerator", "shouldGenerate"));
        }
        PsiMethod[] superMethods = element.findSuperMethods();
        JavaDocSettings configuration = this.getSettings().getConfiguration();
        boolean overriddenMethods = superMethods.length > 0 && configuration != null && !configuration.getGeneralSettings().isOverriddenMethods();
        boolean level = configuration != null && configuration.getGeneralSettings().getLevels().contains((Object)Level.METHOD);
        return !level || !overriddenMethods;
    }
}

