/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.model.settings;

import com.github.setial.intellijjavadocs.model.settings.GeneralSettings;
import com.github.setial.intellijjavadocs.model.settings.Level;
import com.github.setial.intellijjavadocs.model.settings.Mode;
import com.github.setial.intellijjavadocs.model.settings.TemplateSettings;
import com.github.setial.intellijjavadocs.model.settings.Visibility;
import com.github.setial.intellijjavadocs.utils.XmlUtils;
import java.io.Serializable;
import org.apache.commons.beanutils.BeanUtils;
import org.jdom.Element;

public class JavaDocSettings
implements Serializable {
    private static final String MODE = "MODE";
    private static final String LEVELS = "LEVELS";
    private static final String LEVEL = "LEVEL";
    private static final String VISIBILITIES = "VISIBILITIES";
    private static final String VISIBILITY = "VISIBILITY";
    public static final String AUTHNAME = "AUTHNAME";
    public static final String DATEFORMAT = "DATEFORMAT";
    private static final String OVERRIDDEN_METHODS = "OVERRIDDEN_METHODS";
    private static final String SPLITTED_CLASS_NAME = "SPLITTED_CLASS_NAME";
    private static final String GENERAL = "GENERAL";
    private static final String TEMPLATES = "TEMPLATES";
    private static final String CLASS = "CLASS";
    private static final String CLASSES = "CLASSES";
    private static final String CONSTRUCTOR = "CONSTRUCTOR";
    private static final String CONSTRUCTORS = "CONSTRUCTORS";
    private static final String FIELD = "FIELD";
    private static final String FIELDS = "FIELDS";
    private static final String METHOD = "METHOD";
    private static final String METHODS = "METHODS";
    private GeneralSettings generalSettings = new GeneralSettings();
    private TemplateSettings templateSettings = new TemplateSettings();

    public JavaDocSettings() {
    }

    public JavaDocSettings(Element element) {
        Element templates;
        Element general = element.getChild(GENERAL);
        if (general != null) {
            this.generalSettings.setMode(XmlUtils.getValue(general, MODE, Mode.class));
            this.generalSettings.setOverriddenMethods(Boolean.parseBoolean(general.getChild(OVERRIDDEN_METHODS).getValue()));
            this.generalSettings.setSplittedClassName(Boolean.parseBoolean(general.getChild(SPLITTED_CLASS_NAME).getValue()));
            this.generalSettings.setLevels(XmlUtils.getValues(general, LEVELS, LEVEL, Level.class));
            this.generalSettings.setVisibilities(XmlUtils.getValues(general, VISIBILITIES, VISIBILITY, Visibility.class));
            this.generalSettings.setAuthName(XmlUtils.getValue(general, AUTHNAME));
            this.generalSettings.setDateFormat(XmlUtils.getValue(general, DATEFORMAT));
        }
        if ((templates = element.getChild(TEMPLATES)) != null) {
            this.templateSettings.setClassTemplates(XmlUtils.getMap(templates, CLASSES, CLASS));
            this.templateSettings.setConstructorTemplates(XmlUtils.getMap(templates, CONSTRUCTORS, CONSTRUCTOR));
            this.templateSettings.setFieldTemplates(XmlUtils.getMap(templates, FIELDS, FIELD));
            this.templateSettings.setMethodTemplates(XmlUtils.getMap(templates, METHODS, METHOD));
        }
    }

    public void addToDom(Element root) {
        Element general = new Element(GENERAL);
        root.addContent(general);
        general.addContent(XmlUtils.getElement(MODE, this.generalSettings.getMode().toString()));
        general.addContent(XmlUtils.getElement(OVERRIDDEN_METHODS, String.valueOf(this.generalSettings.isOverriddenMethods())));
        general.addContent(XmlUtils.getElement(SPLITTED_CLASS_NAME, String.valueOf(this.generalSettings.isSplittedClassName())));
        general.addContent(XmlUtils.getElement(LEVELS, LEVEL, this.generalSettings.getLevels()));
        general.addContent(XmlUtils.getElement(VISIBILITIES, VISIBILITY, this.generalSettings.getVisibilities()));
        general.addContent(XmlUtils.getElement(AUTHNAME, this.generalSettings.getAuthName()));
        general.addContent(XmlUtils.getElement(DATEFORMAT, this.generalSettings.getDateFormat()));
        Element templates = new Element(TEMPLATES);
        root.addContent(templates);
        templates.addContent(XmlUtils.getElement(CLASSES, CLASS, this.templateSettings.getClassTemplates()));
        templates.addContent(XmlUtils.getElement(CONSTRUCTORS, CONSTRUCTOR, this.templateSettings.getConstructorTemplates()));
        templates.addContent(XmlUtils.getElement(METHODS, METHOD, this.templateSettings.getMethodTemplates()));
        templates.addContent(XmlUtils.getElement(FIELDS, FIELD, this.templateSettings.getFieldTemplates()));
    }

    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    public TemplateSettings getTemplateSettings() {
        return this.templateSettings;
    }

    public Object clone() throws CloneNotSupportedException {
        JavaDocSettings result = new JavaDocSettings();
        try {
            if (this.generalSettings != null) {
                result.generalSettings = (GeneralSettings)BeanUtils.cloneBean((Object)this.generalSettings);
            }
            if (this.templateSettings != null) {
                result.templateSettings = (TemplateSettings)BeanUtils.cloneBean((Object)this.templateSettings);
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return result;
    }
}

