/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.operation.impl;

import com.github.setial.intellijjavadocs.operation.JavaDocWriter;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JavaDocWriterImpl
implements JavaDocWriter {
    public static final String COMPONENT_NAME = "JavaDocWriter";

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/operation/impl/JavaDocWriterImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    @Override
    public void write(@NotNull PsiDocComment javaDoc, @NotNull PsiElement beforeElement) {
        if (javaDoc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDoc", "com/github/setial/intellijjavadocs/operation/impl/JavaDocWriterImpl", "write"));
        }
        if (beforeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeElement", "com/github/setial/intellijjavadocs/operation/impl/JavaDocWriterImpl", "write"));
        }
        ReadonlyStatusHandler.OperationStatus status = ReadonlyStatusHandler.getInstance((Project)beforeElement.getProject()).ensureFilesWritable(Arrays.asList(beforeElement.getContainingFile().getVirtualFile()));
        if (status.hasReadonlyFiles()) {
            // empty if block
        }
        WriteCommandActionImpl command = new WriteCommandActionImpl(javaDoc, beforeElement);
        RunResult result = command.execute();
    }

    private static class WriteCommandActionImpl
    extends WriteCommandAction {
        private PsiDocComment javaDoc;
        private PsiElement element;

        public WriteCommandActionImpl(@NotNull PsiDocComment javaDoc, @NotNull PsiElement element) {
            if (javaDoc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaDoc", "com/github/setial/intellijjavadocs/operation/impl/JavaDocWriterImpl$WriteCommandActionImpl", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/operation/impl/JavaDocWriterImpl$WriteCommandActionImpl", "<init>"));
            }
            super(element.getProject(), JavaDocWriterImpl.COMPONENT_NAME, "com.github.setial.operation", new PsiFile[]{element.getContainingFile()});
            this.javaDoc = javaDoc;
            this.element = element;
        }

        protected void run(Result result) throws Throwable {
            if (this.javaDoc == null) {
                return;
            }
            if (this.element.getFirstChild() instanceof PsiDocComment) {
                this.element.getFirstChild().replace((PsiElement)this.javaDoc);
            } else {
                this.element.getNode().addChild(this.javaDoc.getNode(), this.element.getFirstChild().getNode());
            }
            this.ensureWhitespaceAfterJavaDoc(this.element);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.element.getProject());
            codeStyleManager.reformatNewlyAddedElement(this.element.getNode(), this.element.getFirstChild().getNode());
        }

        private void ensureWhitespaceAfterJavaDoc(PsiElement element) {
            PsiElement firstChild = element.getFirstChild();
            if (!PsiDocComment.class.isAssignableFrom(firstChild.getClass())) {
                return;
            }
            PsiElement nextElement = firstChild.getNextSibling();
            if (PsiWhiteSpace.class.isAssignableFrom(nextElement.getClass())) {
                return;
            }
            element.getNode().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), nextElement.getNode());
        }
    }
}

