/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.template.impl;

import com.github.setial.intellijjavadocs.template.DocTemplateManager;
import com.github.setial.intellijjavadocs.template.DocTemplateProcessor;
import com.github.setial.intellijjavadocs.template.logging.IntellijPluginLogSystem;
import com.github.setial.intellijjavadocs.utils.XmlUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocTemplateManagerImpl
implements DocTemplateManager {
    private static final String TEMPLATES_PATH = "/templates.xml";
    private static final String TEMPLATE = "template";
    private static final String REGEXP = "regexp";
    private static final String CLASS = "class";
    private static final String FIELD = "field";
    private static final String METHOD = "method";
    private static final String CONSTRUCTOR = "constructor";
    private Map<String, Template> classTemplates = new LinkedHashMap<String, Template>();
    private Map<String, Template> fieldTemplates = new LinkedHashMap<String, Template>();
    private Map<String, Template> methodTemplates = new LinkedHashMap<String, Template>();
    private Map<String, Template> constructorTemplates = new LinkedHashMap<String, Template>();
    private final RuntimeServices velocityServices = new RuntimeInstance();

    public DocTemplateManagerImpl() {
        this.velocityServices.setProperty("runtime.log.logsystem", (Object)new IntellijPluginLogSystem());
        this.velocityServices.setProperty("runtime.log.logsystem.intellij.plugin.level", (Object)"warn");
        this.velocityServices.init();
    }

    public void initComponent() {
        try {
            Document document = new SAXBuilder().build(DocTemplateProcessor.class.getResourceAsStream(TEMPLATES_PATH));
            Element root = document.getRootElement();
            if (root != null) {
                this.readTemplates(root, CLASS, this.classTemplates);
                this.readTemplates(root, FIELD, this.fieldTemplates);
                this.readTemplates(root, METHOD, this.methodTemplates);
                this.readTemplates(root, CONSTRUCTOR, this.constructorTemplates);
            }
        }
        catch (Exception e) {
            Logger.getInstance(DocTemplateManagerImpl.class).error((Throwable)e);
        }
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("DocTemplateManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getComponentName"));
        }
        return "DocTemplateManager";
    }

    @Override
    @Nullable
    public Template getClassTemplate(@NotNull PsiClass classElement) {
        if (classElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classElement", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getClassTemplate"));
        }
        StringBuilder builder = this.getClassSignature(classElement);
        return this.getMatchingTemplate(builder.toString(), this.classTemplates);
    }

    @Override
    @Nullable
    public Template getMethodTemplate(@NotNull PsiMethod methodElement) {
        if (methodElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodElement", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getMethodTemplate"));
        }
        Map<String, Template> templates = methodElement.isConstructor() ? this.constructorTemplates : this.methodTemplates;
        String signature = methodElement.getText();
        PsiCodeBlock methodBody = methodElement.getBody();
        if (methodBody != null) {
            signature = signature.replace(methodBody.getText(), "");
        }
        return this.getMatchingTemplate(signature, templates);
    }

    @Override
    @Nullable
    public Template getFieldTemplate(@NotNull PsiField psiField) {
        if (psiField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiField", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getFieldTemplate"));
        }
        return this.getMatchingTemplate(psiField.getText(), this.fieldTemplates);
    }

    @Override
    @NotNull
    public Map<String, String> getClassTemplates() {
        LinkedHashMap<String, String> templates = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Template> entry : this.classTemplates.entrySet()) {
            String template = this.extractTemplate(entry.getValue().getData());
            templates.put(entry.getKey(), template);
        }
        LinkedHashMap<String, String> linkedHashMap = templates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getClassTemplates"));
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public Map<String, String> getConstructorTemplates() {
        LinkedHashMap<String, String> templates = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Template> entry : this.constructorTemplates.entrySet()) {
            String template = this.extractTemplate(entry.getValue().getData());
            templates.put(entry.getKey(), template);
        }
        LinkedHashMap<String, String> linkedHashMap = templates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getConstructorTemplates"));
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public Map<String, String> getMethodTemplates() {
        LinkedHashMap<String, String> templates = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Template> entry : this.methodTemplates.entrySet()) {
            String template = this.extractTemplate(entry.getValue().getData());
            templates.put(entry.getKey(), template);
        }
        LinkedHashMap<String, String> linkedHashMap = templates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getMethodTemplates"));
        }
        return linkedHashMap;
    }

    @Override
    @NotNull
    public Map<String, String> getFieldTemplates() {
        LinkedHashMap<String, String> templates = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Template> entry : this.fieldTemplates.entrySet()) {
            String template = this.extractTemplate(entry.getValue().getData());
            templates.put(entry.getKey(), template);
        }
        LinkedHashMap<String, String> linkedHashMap = templates;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getFieldTemplates"));
        }
        return linkedHashMap;
    }

    @Override
    public void setClassTemplates(@NotNull Map<String, String> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "setClassTemplates"));
        }
        this.setupTemplates(templates, this.classTemplates);
    }

    @Override
    public void setConstructorTemplates(@NotNull Map<String, String> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "setConstructorTemplates"));
        }
        this.setupTemplates(templates, this.constructorTemplates);
    }

    @Override
    public void setMethodTemplates(@NotNull Map<String, String> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "setMethodTemplates"));
        }
        this.setupTemplates(templates, this.methodTemplates);
    }

    @Override
    public void setFieldTemplates(@NotNull Map<String, String> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "setFieldTemplates"));
        }
        this.setupTemplates(templates, this.fieldTemplates);
    }

    private void readTemplates(Element document, String elementName, Map<String, Template> templates) throws IOException, ParseException {
        Element root = document.getChild(elementName);
        List elements = root.getChildren(TEMPLATE);
        for (Element element : elements) {
            String name = element.getAttribute(REGEXP).getValue();
            templates.put(name, this.createTemplate(name, XmlUtils.trimElementContent(element)));
        }
    }

    @Nullable
    private Template getMatchingTemplate(@NotNull String elementText, @NotNull Map<String, Template> templates) {
        if (elementText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementText", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getMatchingTemplate"));
        }
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/github/setial/intellijjavadocs/template/impl/DocTemplateManagerImpl", "getMatchingTemplate"));
        }
        Template result = null;
        for (Map.Entry<String, Template> entry : templates.entrySet()) {
            if (!Pattern.compile(entry.getKey(), 40).matcher(elementText).matches()) continue;
            result = entry.getValue();
            break;
        }
        return result;
    }

    private void setupTemplates(Map<String, String> from, Map<String, Template> to) {
        LinkedHashMap<String, Template> result = new LinkedHashMap<String, Template>();
        for (Map.Entry<String, String> entry : from.entrySet()) {
            try {
                result.put(entry.getKey(), this.createTemplate(entry.getKey(), entry.getValue()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        to.clear();
        to.putAll(result);
    }

    private StringBuilder getClassSignature(PsiClass classElement) {
        PsiClassType[] implementTypes;
        StringBuilder builder = new StringBuilder();
        PsiModifierList modifierList = classElement.getModifierList();
        if (modifierList != null) {
            builder.append(modifierList.getText());
        }
        builder.append(" ");
        if (classElement.isInterface()) {
            builder.append("interface ");
        } else if (classElement.isEnum()) {
            builder.append("enum ");
        } else {
            builder.append("class ");
        }
        builder.append(classElement.getName());
        builder.append(" ");
        PsiClassType[] extendsTypes = classElement.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            builder.append("extends ");
            for (int i = 0; i < extendsTypes.length; ++i) {
                PsiClassType extendsType = extendsTypes[i];
                builder.append(extendsType.getClassName());
                if (i < extendsTypes.length - 1) {
                    builder.append(",");
                }
                builder.append(" ");
            }
        }
        if ((implementTypes = classElement.getImplementsListTypes()).length > 0) {
            builder.append("implements");
            for (int i = 0; i < implementTypes.length; ++i) {
                PsiClassType implementType = implementTypes[i];
                builder.append(implementType.getClassName());
                if (i < implementTypes.length - 1) {
                    builder.append(",");
                }
                builder.append(" ");
            }
        }
        return builder;
    }

    private Template createTemplate(String templateRegexp, String templateContent) throws ParseException {
        SimpleNode node = this.velocityServices.parse(templateContent, templateRegexp);
        Template template = new Template();
        template.setRuntimeServices(this.velocityServices);
        template.setData((Object)node);
        template.setName(node.getTemplateName());
        template.initDocument();
        return template;
    }

    private String extractTemplate(Object data) {
        StringBuilder template = new StringBuilder();
        Token token = ((SimpleNode)data).getFirstToken();
        while (token != null && token.kind != 0) {
            template.append(token.toString());
            token = token.next;
        }
        return template.toString();
    }
}

