/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.ui.component;

import com.github.setial.intellijjavadocs.ui.component.TemplateConfigDialog;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class TemplatesTable
extends JBTable {
    private List<Map.Entry<String, String>> settings;

    public TemplatesTable(Map<String, String> model) {
        this.setStriped(true);
        this.setAutoResizeMode(4);
        this.settings = new LinkedList<Map.Entry<String, String>>();
        CollectionUtils.addAll(this.settings, (Object[])model.entrySet().toArray(new Map.Entry[model.entrySet().size()]));
        this.setModel(new TableModel());
        Enumeration<TableColumn> columns = this.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            columns.nextElement().setCellRenderer(new FieldRenderer());
        }
    }

    public Map<String, String> getSettings() {
        return MapUtils.putAll(new LinkedHashMap(), (Object[])this.settings.toArray());
    }

    public void setSettingsModel(Map<String, String> model) {
        this.settings.clear();
        CollectionUtils.addAll(this.settings, (Object[])model.entrySet().toArray(new Map.Entry[model.entrySet().size()]));
        ((TableModel)this.getModel()).fireTableDataChanged();
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        MouseEvent event;
        if (e == null) {
            return false;
        }
        if (e instanceof MouseEvent && (event = (MouseEvent)e).getClickCount() == 1) {
            return false;
        }
        TemplateConfigDialog dialog = new TemplateConfigDialog(this.settings.get(row));
        dialog.show();
        if (dialog.isOK()) {
            this.settings.set(row, dialog.getModel());
        }
        return false;
    }

    private static class FieldRenderer
    extends JLabel
    implements TableCellRenderer {
        public FieldRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBorder(hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    private class TableModel
    extends AbstractTableModel
    implements EditableModel {
        private List<String> columnNames = new LinkedList<String>();

        public TableModel() {
            this.columnNames.add("Regular expression");
            this.columnNames.add("Preview");
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames.get(column);
        }

        public void addRow() {
            TemplateConfigDialog dialog = new TemplateConfigDialog();
            dialog.show();
            if (dialog.isOK()) {
                TemplatesTable.this.settings.add(dialog.getModel());
            }
        }

        public void removeRow(int index) {
            TemplatesTable.this.settings.remove(index);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            Map.Entry oldItem = (Map.Entry)TemplatesTable.this.settings.get(oldIndex);
            TemplatesTable.this.settings.set(oldIndex, TemplatesTable.this.settings.get(newIndex));
            TemplatesTable.this.settings.set(newIndex, oldItem);
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return TemplatesTable.this.settings.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? (String)((Map.Entry)TemplatesTable.this.settings.get(rowIndex)).getKey() : (String)((Map.Entry)TemplatesTable.this.settings.get(rowIndex)).getValue();
        }
    }
}

