/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.utils;

import com.github.setial.intellijjavadocs.model.JavaDoc;
import com.github.setial.intellijjavadocs.model.JavaDocTag;
import com.github.setial.intellijjavadocs.transformation.JavaDocBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDocUtils {
    @NotNull
    public static String convertJavaDoc(@NotNull JavaDoc javadoc) {
        if (javadoc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javadoc", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "convertJavaDoc"));
        }
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.createDefaultJavaDoc(javadoc);
        String string = builder.build();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "convertJavaDoc"));
        }
        return string;
    }

    @NotNull
    public static JavaDoc mergeJavaDocs(@NotNull JavaDoc oldJavaDoc, @NotNull JavaDoc newJavaDoc) {
        String name;
        if (oldJavaDoc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldJavaDoc", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocs"));
        }
        if (newJavaDoc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newJavaDoc", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocs"));
        }
        List<String> description = oldJavaDoc.getDescription();
        if (JavaDocUtils.descriptionIsEmpty(description)) {
            description = newJavaDoc.getDescription();
        }
        Map<String, List<JavaDocTag>> oldTags = oldJavaDoc.getTags();
        Map<String, List<JavaDocTag>> newTags = newJavaDoc.getTags();
        LinkedHashMap<String, List<JavaDocTag>> tags = new LinkedHashMap<String, List<JavaDocTag>>();
        LinkedList<String> processedTagNames = new LinkedList<String>();
        for (Map.Entry<String, List<JavaDocTag>> newTagsEntry : newTags.entrySet()) {
            name = newTagsEntry.getKey();
            if (!tags.containsKey(name)) {
                tags.put(name, new LinkedList());
            }
            List<JavaDocTag> tagsEntry = newTagsEntry.getValue();
            for (JavaDocTag tag : tagsEntry) {
                if (oldTags.containsKey(name)) {
                    List<JavaDocTag> oldTagsEntry = oldTags.get(name);
                    JavaDocTag oldTag = !"param".equals(name) ? oldTagsEntry.get(0) : JavaDocUtils.findOldTag(oldTagsEntry, tag.getValue(), tag.getRefParam());
                    if (oldTag != null) {
                        ((List)tags.get(name)).add(JavaDocUtils.mergeJavaDocTag(oldTag, tag));
                        continue;
                    }
                    ((List)tags.get(name)).add(tag);
                    continue;
                }
                ((List)tags.get(name)).add(tag);
            }
            processedTagNames.add(name);
        }
        for (Map.Entry<String, List<JavaDocTag>> entry : oldTags.entrySet()) {
            name = entry.getKey();
            if (processedTagNames.contains(name)) continue;
            tags.put(name, entry.getValue());
        }
        JavaDoc javaDoc = new JavaDoc(description, tags);
        if (javaDoc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocs"));
        }
        return javaDoc;
    }

    @NotNull
    public static JavaDocTag mergeJavaDocTag(@NotNull JavaDocTag oldJavaDocTag, @NotNull JavaDocTag newJavaDocTag) {
        if (oldJavaDocTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldJavaDocTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocTag"));
        }
        if (newJavaDocTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newJavaDocTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocTag"));
        }
        List<String> description = oldJavaDocTag.getDescription();
        if (JavaDocUtils.descriptionIsEmpty(description)) {
            description = newJavaDocTag.getDescription();
        }
        JavaDocTag javaDocTag = new JavaDocTag(oldJavaDocTag.getRefParam(), oldJavaDocTag.getValue(), description);
        if (javaDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "mergeJavaDocTag"));
        }
        return javaDocTag;
    }

    @NotNull
    public static JavaDocTag createJavaDocTag(@NotNull PsiDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "createJavaDocTag"));
        }
        JavaDocTag javaDocTag = new JavaDocTag(JavaDocUtils.findDocTagRefParam(docTag), JavaDocUtils.findDocTagValue(docTag), JavaDocUtils.findDocTagDescription(docTag));
        if (javaDocTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "createJavaDocTag"));
        }
        return javaDocTag;
    }

    @NotNull
    public static JavaDoc createJavaDoc(@NotNull PsiDocComment docComment) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "createJavaDoc"));
        }
        JavaDoc javaDoc = new JavaDoc(JavaDocUtils.findDocDescription(docComment), JavaDocUtils.findDocTags(docComment));
        if (javaDoc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "createJavaDoc"));
        }
        return javaDoc;
    }

    @NotNull
    public static List<String> findDocDescription(@NotNull PsiDocComment docComment) {
        PsiElement[] descriptionElements;
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocDescription"));
        }
        LinkedList<String> descriptions = new LinkedList<String>();
        for (PsiElement descriptionElement : descriptionElements = docComment.getDescriptionElements()) {
            descriptions.add(descriptionElement.getText());
        }
        LinkedList<String> linkedList = descriptions;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocDescription"));
        }
        return linkedList;
    }

    @NotNull
    public static Map<String, List<JavaDocTag>> findDocTags(@NotNull PsiDocComment docComment) {
        PsiDocTag[] docTags;
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTags"));
        }
        LinkedHashMap<String, List<JavaDocTag>> tags = new LinkedHashMap<String, List<JavaDocTag>>();
        for (PsiDocTag docTag : docTags = docComment.getTags()) {
            String name = docTag.getName();
            if (!tags.containsKey(name)) {
                tags.put(name, new LinkedList());
            }
            ((List)tags.get(name)).add(JavaDocUtils.createJavaDocTag(docTag));
        }
        LinkedHashMap<String, List<JavaDocTag>> linkedHashMap = tags;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTags"));
        }
        return linkedHashMap;
    }

    @Nullable
    public static String findDocTagRefParam(@NotNull PsiDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTagRefParam"));
        }
        String refParam = null;
        for (PsiElement element : docTag.getDataElements()) {
            if (!(element instanceof PsiDocParamRef) && !(element instanceof PsiDocMethodOrFieldRef)) continue;
            refParam = element.getText();
            break;
        }
        return refParam;
    }

    @Nullable
    public static String findDocTagValue(@NotNull PsiDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTagValue"));
        }
        String value = null;
        for (PsiElement element : docTag.getDataElements()) {
            if (!(element instanceof PsiDocTagValue)) continue;
            value = element.getText();
            break;
        }
        return value;
    }

    @NotNull
    public static List<String> findDocTagDescription(@NotNull PsiDocTag docTag) {
        if (docTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docTag", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTagDescription"));
        }
        LinkedList<String> descriptions = new LinkedList<String>();
        for (PsiElement element : docTag.getDataElements()) {
            if (!(element instanceof PsiDocToken)) continue;
            descriptions.add(element.getText());
        }
        LinkedList<String> linkedList = descriptions;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "findDocTagDescription"));
        }
        return linkedList;
    }

    @Nullable
    public static JavaDoc toJavaDoc(@Nullable String javaDocText, @NotNull PsiElementFactory psiElementFactory) {
        if (psiElementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementFactory", "com/github/setial/intellijjavadocs/utils/JavaDocUtils", "toJavaDoc"));
        }
        JavaDoc result = null;
        if (StringUtils.isNotBlank((CharSequence)javaDocText)) {
            PsiDocComment javaDocComment = psiElementFactory.createDocCommentFromText(javaDocText);
            result = JavaDocUtils.createJavaDoc(javaDocComment);
        }
        return result;
    }

    @Nullable
    private static JavaDocTag findOldTag(List<JavaDocTag> oldTagsEntry, String value, String refParam) {
        JavaDocTag result = null;
        for (JavaDocTag oldTag : oldTagsEntry) {
            if (!StringUtils.equals((CharSequence)oldTag.getValue(), (CharSequence)value) || !StringUtils.equals((CharSequence)oldTag.getRefParam(), (CharSequence)refParam)) continue;
            result = oldTag;
            break;
        }
        return result;
    }

    private static boolean descriptionIsEmpty(List<String> description) {
        boolean result = true;
        if (!CollectionUtils.isEmpty(description)) {
            for (String item : description) {
                result = result && StringUtils.isBlank((CharSequence)item);
            }
        }
        return result;
    }

    private JavaDocUtils() {
    }
}

