/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.configuration.impl;

import com.github.setial.intellijjavadocs.configuration.JavaDocConfiguration;
import com.github.setial.intellijjavadocs.model.settings.JavaDocSettings;
import com.github.setial.intellijjavadocs.model.settings.Level;
import com.github.setial.intellijjavadocs.model.settings.Mode;
import com.github.setial.intellijjavadocs.model.settings.Visibility;
import com.github.setial.intellijjavadocs.template.DocTemplateManager;
import com.github.setial.intellijjavadocs.ui.settings.ConfigPanel;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JavaDocConfiguration_1.0.7", storages={@Storage(id="other", file="$APP_CONFIG$/intellij-javadocs.xml")})
public class JavaDocConfigurationImpl
implements JavaDocConfiguration,
Configurable,
PersistentStateComponent<Element> {
    private JavaDocSettings settings;
    private ConfigPanel configPanel;
    private DocTemplateManager templateManager = (DocTemplateManager)ServiceManager.getService(DocTemplateManager.class);
    private boolean loadedStoredConfig = false;

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nls
    public String getDisplayName() {
        return "JavaDoc";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public String getComponentName() {
        if ("JavaDocConfiguration_1.0.7" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/configuration/impl/JavaDocConfigurationImpl", "getComponentName"));
        }
        return "JavaDocConfiguration_1.0.7";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.configPanel == null) {
            this.configPanel = new ConfigPanel(this.getSettings());
        }
        this.reset();
        return this.configPanel;
    }

    public boolean isModified() {
        return this.configPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.configPanel.apply();
        this.setupTemplates();
    }

    public void reset() {
        this.configPanel.reset();
    }

    public void disposeUIResources() {
        this.configPanel.disposeUIResources();
        this.configPanel = null;
    }

    @Override
    public JavaDocSettings getConfiguration() {
        JavaDocSettings result;
        try {
            result = (JavaDocSettings)this.getSettings().clone();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    @Nullable
    public Element getState() {
        Element root = new Element("JAVA_DOC_SETTINGS_PLUGIN");
        if (this.settings != null) {
            this.settings.addToDom(root);
            this.loadedStoredConfig = true;
        }
        return root;
    }

    public void loadState(Element javaDocSettings) {
        this.settings = new JavaDocSettings(javaDocSettings);
        this.setupTemplates();
        this.loadedStoredConfig = true;
    }

    private JavaDocSettings getSettings() {
        if (!this.loadedStoredConfig) {
            this.settings = new JavaDocSettings();
            HashSet<Level> levels = new HashSet<Level>();
            levels.add(Level.TYPE);
            levels.add(Level.METHOD);
            levels.add(Level.FIELD);
            HashSet<Visibility> visibilities = new HashSet<Visibility>();
            visibilities.add(Visibility.PUBLIC);
            visibilities.add(Visibility.PROTECTED);
            visibilities.add(Visibility.DEFAULT);
            this.settings.getGeneralSettings().setOverriddenMethods(false);
            this.settings.getGeneralSettings().setSplittedClassName(true);
            this.settings.getGeneralSettings().setMode(Mode.UPDATE);
            this.settings.getGeneralSettings().setLevels(levels);
            this.settings.getGeneralSettings().setVisibilities(visibilities);
            this.settings.getTemplateSettings().setClassTemplates(this.templateManager.getClassTemplates());
            this.settings.getTemplateSettings().setConstructorTemplates(this.templateManager.getConstructorTemplates());
            this.settings.getTemplateSettings().setMethodTemplates(this.templateManager.getMethodTemplates());
            this.settings.getTemplateSettings().setFieldTemplates(this.templateManager.getFieldTemplates());
        }
        return this.settings;
    }

    private void setupTemplates() {
        this.templateManager.setClassTemplates(this.settings.getTemplateSettings().getClassTemplates());
        this.templateManager.setConstructorTemplates(this.settings.getTemplateSettings().getConstructorTemplates());
        this.templateManager.setMethodTemplates(this.settings.getTemplateSettings().getMethodTemplates());
        this.templateManager.setFieldTemplates(this.settings.getTemplateSettings().getFieldTemplates());
    }
}

