/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.generator.impl;

import com.github.setial.intellijjavadocs.configuration.JavaDocConfiguration;
import com.github.setial.intellijjavadocs.generator.JavaDocGenerator;
import com.github.setial.intellijjavadocs.model.JavaDoc;
import com.github.setial.intellijjavadocs.model.settings.JavaDocSettings;
import com.github.setial.intellijjavadocs.model.settings.Mode;
import com.github.setial.intellijjavadocs.model.settings.Visibility;
import com.github.setial.intellijjavadocs.template.DocTemplateManager;
import com.github.setial.intellijjavadocs.template.DocTemplateProcessor;
import com.github.setial.intellijjavadocs.utils.JavaDocUtils;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaDocGenerator<T extends PsiElement>
implements JavaDocGenerator<T> {
    private DocTemplateManager docTemplateManager;
    private DocTemplateProcessor docTemplateProcessor;
    private PsiElementFactory psiElementFactory;
    private JavaDocConfiguration settings;

    public AbstractJavaDocGenerator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "<init>"));
        }
        this.docTemplateManager = (DocTemplateManager)ServiceManager.getService((Project)project, DocTemplateManager.class);
        this.docTemplateProcessor = (DocTemplateProcessor)ServiceManager.getService((Project)project, DocTemplateProcessor.class);
        this.psiElementFactory = PsiElementFactory.SERVICE.getInstance((Project)project);
        this.settings = (JavaDocConfiguration)ServiceManager.getService((Project)project, JavaDocConfiguration.class);
    }

    @Override
    @Nullable
    public final PsiDocComment generate(@NotNull T element) {
        JavaDocSettings configuration;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "generate"));
        }
        PsiDocComment result = null;
        PsiDocComment oldDocComment = null;
        PsiElement firstElement = element.getFirstChild();
        if (firstElement instanceof PsiDocComment) {
            oldDocComment = (PsiDocComment)firstElement;
        }
        if ((configuration = this.settings.getConfiguration()) != null) {
            Mode mode = configuration.getGeneralSettings().getMode();
            switch (mode) {
                case KEEP: {
                    if (oldDocComment != null) break;
                }
                case REPLACE: {
                    result = this.replaceJavaDocAction(element);
                    break;
                }
                default: {
                    result = oldDocComment != null ? this.updateJavaDocAction(element, oldDocComment) : this.replaceJavaDocAction(element);
                }
            }
        }
        return result;
    }

    @NotNull
    protected DocTemplateManager getDocTemplateManager() {
        DocTemplateManager docTemplateManager = this.docTemplateManager;
        if (docTemplateManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "getDocTemplateManager"));
        }
        return docTemplateManager;
    }

    @NotNull
    protected DocTemplateProcessor getDocTemplateProcessor() {
        DocTemplateProcessor docTemplateProcessor = this.docTemplateProcessor;
        if (docTemplateProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "getDocTemplateProcessor"));
        }
        return docTemplateProcessor;
    }

    @NotNull
    protected PsiElementFactory getPsiElementFactory() {
        PsiElementFactory psiElementFactory = this.psiElementFactory;
        if (psiElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "getPsiElementFactory"));
        }
        return psiElementFactory;
    }

    @NotNull
    protected JavaDocConfiguration getSettings() {
        JavaDocConfiguration javaDocConfiguration = this.settings;
        if (javaDocConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/generator/impl/AbstractJavaDocGenerator", "getSettings"));
        }
        return javaDocConfiguration;
    }

    protected boolean shouldGenerate(PsiModifierList modifiers) {
        return this.checkModifiers(modifiers, "public", Visibility.PUBLIC) || this.checkModifiers(modifiers, "protected", Visibility.PROTECTED) || this.checkModifiers(modifiers, "packageLocal", Visibility.DEFAULT) || this.checkModifiers(modifiers, "private", Visibility.PRIVATE);
    }

    protected Map<String, Object> getDefaultParameters(PomNamedTarget element) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("element", element);
        params.put("name", this.getDocTemplateProcessor().buildDescription(element.getName(), true));
        params.put("partName", this.getDocTemplateProcessor().buildPartialDescription(element.getName()));
        params.put("splitNames", StringUtils.splitByCharacterTypeCamelCase((String)element.getName()));
        return params;
    }

    private PsiDocComment updateJavaDocAction(T element, PsiDocComment oldDocComment) {
        PsiDocComment result = null;
        JavaDoc newJavaDoc = this.generateJavaDoc(element);
        JavaDoc oldJavaDoc = JavaDocUtils.createJavaDoc(oldDocComment);
        if (newJavaDoc != null) {
            newJavaDoc = JavaDocUtils.mergeJavaDocs(oldJavaDoc, newJavaDoc);
            String javaDoc = newJavaDoc.toJavaDoc();
            result = this.psiElementFactory.createDocCommentFromText(javaDoc);
        }
        return result;
    }

    private PsiDocComment replaceJavaDocAction(T element) {
        PsiDocComment result = null;
        JavaDoc newJavaDoc = this.generateJavaDoc(element);
        if (newJavaDoc != null) {
            String javaDoc = newJavaDoc.toJavaDoc();
            result = this.psiElementFactory.createDocCommentFromText(javaDoc);
        }
        return result;
    }

    private boolean checkModifiers(PsiModifierList modifiers, String modifier, Visibility visibility) {
        JavaDocSettings configuration = this.getSettings().getConfiguration();
        return modifiers != null && modifiers.hasModifierProperty(modifier) && configuration != null && configuration.getGeneralSettings().getVisibilities().contains((Object)visibility);
    }

    @Nullable
    protected abstract JavaDoc generateJavaDoc(@NotNull T var1);
}

