/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.template.logging;

import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.diagnostic.Logger;
import org.apache.log4j.Level;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;

public class IntellijPluginLogSystem
implements LogChute {
    public static final String RUNTIME_LOG_LEVEL_KEY = "runtime.log.logsystem.intellij.plugin.level";
    public static final String TRACE_LEVEL = "trace";
    public static final String DEBUG_LEVEL = "debug";
    public static final String INFO_LEVEL = "info";
    public static final String WARN_LEVEL = "warn";
    public static final String ERROR_LEVEL = "error";
    private Logger logger;
    private Level logLevel;

    public void init(RuntimeServices rs) throws Exception {
        String level = (String)rs.getProperty(RUNTIME_LOG_LEVEL_KEY);
        this.logger = PluginManager.getLogger();
        this.logLevel = Level.toLevel((String)level);
        this.logger.setLevel(this.logLevel);
    }

    public void log(int level, String message) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        switch (level) {
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.info(message);
                break;
            }
            case -1: {
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        switch (level) {
            case 2: {
                this.logger.warn(message, t);
                break;
            }
            case 1: {
                this.logger.info(message, t);
                break;
            }
            case -1: {
                this.logger.debug(message, t);
                break;
            }
            case 3: {
                this.logger.error(message, t);
                break;
            }
            default: {
                this.logger.debug(message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        return this.logLevel.getSyslogEquivalent() == level;
    }
}

