/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.transformation;

import com.github.setial.intellijjavadocs.model.JavaDoc;
import com.github.setial.intellijjavadocs.model.JavaDocElements;
import com.github.setial.intellijjavadocs.model.JavaDocTag;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class JavaDocBuilder {
    private StringBuilder builder = new StringBuilder();

    public JavaDocBuilder openJavaDoc() {
        this.builder.append(JavaDocElements.STARTING.getPresentation());
        this.builder.append(JavaDocElements.LINE_START.getPresentation());
        return this;
    }

    public JavaDocBuilder closeJavaDoc() {
        if (!this.closeRegularJavaDoc()) {
            this.closeOneLineJavaDoc();
        }
        this.builder.append(JavaDocElements.ENDING.getPresentation());
        return this;
    }

    public JavaDocBuilder addNewLine() {
        this.builder.append(JavaDocElements.NEW_LINE.getPresentation());
        this.builder.append(JavaDocElements.LINE_START.getPresentation());
        return this;
    }

    public JavaDocBuilder addDescription(List<String> descriptions) {
        Iterator<String> iterator = descriptions.iterator();
        while (iterator.hasNext()) {
            String description = iterator.next();
            if (!this.isAcceptedDescription(description, iterator.hasNext())) continue;
            this.builder.append(description);
            if (!StringUtils.contains((CharSequence)description, (CharSequence)JavaDocElements.NEW_LINE.getPresentation())) continue;
            this.builder.append(JavaDocElements.LINE_START.getPresentation());
        }
        return this;
    }

    public JavaDocBuilder addTagDescription(List<String> descriptions) {
        for (int i = 0; i < descriptions.size(); ++i) {
            String description = descriptions.get(i);
            if (!StringUtils.isNotBlank((CharSequence)description)) continue;
            if (i != 0) {
                this.addNewLine();
            }
            this.builder.append(description);
        }
        return this;
    }

    public JavaDocBuilder addTag(String name, JavaDocTag tag) {
        this.builder.append(JavaDocElements.WHITE_SPACE.getPresentation());
        this.builder.append(JavaDocElements.TAG_START.getPresentation());
        this.builder.append(name);
        this.builder.append(JavaDocElements.WHITE_SPACE.getPresentation());
        if (StringUtils.isNotBlank((CharSequence)tag.getRefParam())) {
            this.builder.append(tag.getRefParam());
        } else if (StringUtils.isNotBlank((CharSequence)tag.getValue())) {
            this.builder.append(tag.getValue());
        }
        this.builder.append(JavaDocElements.WHITE_SPACE.getPresentation());
        this.addTagDescription(tag.getDescription());
        return this;
    }

    public JavaDocBuilder addTags(@NotNull Map<String, List<JavaDocTag>> tags) {
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/github/setial/intellijjavadocs/transformation/JavaDocBuilder", "addTags"));
        }
        Iterator<Map.Entry<String, List<JavaDocTag>>> iterator = tags.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<JavaDocTag>> entry = iterator.next();
            String name = entry.getKey();
            Iterator<JavaDocTag> javaDocTagsIterator = entry.getValue().iterator();
            while (javaDocTagsIterator.hasNext()) {
                JavaDocTag javaDocTag = javaDocTagsIterator.next();
                this.addTag(name, javaDocTag);
                if (!javaDocTagsIterator.hasNext()) continue;
                this.addNewLine();
            }
            if (!iterator.hasNext()) continue;
            this.addNewLine();
        }
        return this;
    }

    public JavaDocBuilder createDefaultJavaDoc(@NotNull JavaDoc javadoc) {
        if (javadoc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javadoc", "com/github/setial/intellijjavadocs/transformation/JavaDocBuilder", "createDefaultJavaDoc"));
        }
        this.openJavaDoc();
        this.addDescription(javadoc.getDescription());
        this.addTags(javadoc.getTags());
        this.closeJavaDoc();
        return this;
    }

    @NotNull
    public String build() {
        String string = this.builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/github/setial/intellijjavadocs/transformation/JavaDocBuilder", "build"));
        }
        return string;
    }

    private boolean closeRegularJavaDoc() {
        boolean result = false;
        if (this.builder.lastIndexOf(JavaDocElements.LINE_START.getPresentation()) != this.builder.length() - 1 && this.builder.lastIndexOf(JavaDocElements.NEW_LINE.getPresentation()) >= 0) {
            this.builder.append(JavaDocElements.NEW_LINE.getPresentation());
            this.builder.append(JavaDocElements.WHITE_SPACE.getPresentation());
            this.builder.append(JavaDocElements.LINE_START.getPresentation());
            result = true;
        }
        return result;
    }

    private boolean closeOneLineJavaDoc() {
        boolean result = false;
        if (this.builder.indexOf(JavaDocElements.NEW_LINE.getPresentation()) < 0) {
            this.builder.append(JavaDocElements.LINE_START.getPresentation());
            result = true;
        }
        return result;
    }

    private boolean isAcceptedDescription(String description, boolean hasNext) {
        boolean result = false;
        if (hasNext && StringUtils.isNotEmpty((CharSequence)description) || !hasNext && !description.matches(" +")) {
            result = true;
        }
        return result;
    }
}

