/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.ui.settings;

import com.github.setial.intellijjavadocs.model.settings.JavaDocSettings;
import com.github.setial.intellijjavadocs.model.settings.Level;
import com.github.setial.intellijjavadocs.model.settings.Mode;
import com.github.setial.intellijjavadocs.model.settings.Visibility;
import com.github.setial.intellijjavadocs.ui.component.TemplatesTable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;

public class ConfigPanel
extends JPanel {
    private JavaDocSettings settings;
    private JTabbedPane tabbedPane;
    private JPanel panel;
    private JRadioButton generalModeKeepRadioButton;
    private JRadioButton generalModeUpdateRadioButton;
    private JRadioButton generalModeReplaceRadioButton;
    private JCheckBox generalLevelTypeCheckbox;
    private JCheckBox generalLevelMethodCheckbox;
    private JCheckBox generalLevelFieldCheckbox;
    private JCheckBox generalVisibilityPublicCheckbox;
    private JCheckBox generalVisibilityProtectedCheckbox;
    private JCheckBox generalVisibilityDefaultCheckbox;
    private JCheckBox generalVisibilityPrivateCheckbox;
    private JCheckBox generalOtherOverriddenMethodsCheckbox;
    private JCheckBox generalOtherSplittedClassName;
    private JPanel generalPanel;
    private JPanel generalModePanel;
    private JPanel generalLevelPanel;
    private JPanel generalVisibilityPanel;
    private JPanel generalOtherPanel;
    private JEditorPane editorAuthor;
    private JEditorPane editorDate;
    private TemplatesTable classTemplatesTable;
    private TemplatesTable constructorTemplatesTable;
    private TemplatesTable methodTemplatesTable;
    private TemplatesTable fieldTemplatesTable;

    public ConfigPanel(JavaDocSettings settings) {
        this.$$$setupUI$$$();
        this.settings = settings;
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
        this.setupBorders();
        this.setupTemplatesPanel();
    }

    public boolean isModified() {
        boolean result = false;
        if (this.generalModeKeepRadioButton.isSelected()) {
            result = this.settings.getGeneralSettings().getMode() != Mode.KEEP;
        } else if (this.generalModeUpdateRadioButton.isSelected()) {
            result = this.settings.getGeneralSettings().getMode() != Mode.UPDATE;
        } else if (this.generalModeReplaceRadioButton.isSelected()) {
            result = this.settings.getGeneralSettings().getMode() != Mode.REPLACE;
        }
        result = result || this.isCheckboxModified(this.generalLevelTypeCheckbox, this.settings.getGeneralSettings().getLevels().contains((Object)Level.TYPE));
        result = result || this.isCheckboxModified(this.generalLevelMethodCheckbox, this.settings.getGeneralSettings().getLevels().contains((Object)Level.METHOD));
        result = result || this.isCheckboxModified(this.generalLevelFieldCheckbox, this.settings.getGeneralSettings().getLevels().contains((Object)Level.FIELD));
        result = result || this.isCheckboxModified(this.generalVisibilityPublicCheckbox, this.settings.getGeneralSettings().getVisibilities().contains((Object)Visibility.PUBLIC));
        result = result || this.isCheckboxModified(this.generalVisibilityProtectedCheckbox, this.settings.getGeneralSettings().getVisibilities().contains((Object)Visibility.PROTECTED));
        result = result || this.isCheckboxModified(this.generalVisibilityDefaultCheckbox, this.settings.getGeneralSettings().getVisibilities().contains((Object)Visibility.DEFAULT));
        result = result || this.isCheckboxModified(this.generalVisibilityPrivateCheckbox, this.settings.getGeneralSettings().getVisibilities().contains((Object)Visibility.PRIVATE));
        result = result || this.isCheckboxModified(this.generalOtherOverriddenMethodsCheckbox, this.settings.getGeneralSettings().isOverriddenMethods());
        result = result || this.isCheckboxModified(this.generalOtherSplittedClassName, this.settings.getGeneralSettings().isSplittedClassName());
        result = result || this.checkIfTableContentModified(this.classTemplatesTable.getSettings(), this.settings.getTemplateSettings().getClassTemplates());
        result = result || this.checkIfTableContentModified(this.constructorTemplatesTable.getSettings(), this.settings.getTemplateSettings().getConstructorTemplates());
        result = result || this.checkIfTableContentModified(this.methodTemplatesTable.getSettings(), this.settings.getTemplateSettings().getMethodTemplates());
        result = result || this.checkIfTableContentModified(this.fieldTemplatesTable.getSettings(), this.settings.getTemplateSettings().getFieldTemplates());
        result = result || !this.editorAuthor.getText().equals(this.settings.getGeneralSettings().getAuthName());
        result = result || !this.editorDate.getText().equals(this.settings.getGeneralSettings().getDateFormat());
        return result;
    }

    public void apply() {
        if (this.generalModeKeepRadioButton.isSelected()) {
            this.settings.getGeneralSettings().setMode(Mode.KEEP);
        } else if (this.generalModeUpdateRadioButton.isSelected()) {
            this.settings.getGeneralSettings().setMode(Mode.UPDATE);
        } else if (this.generalModeReplaceRadioButton.isSelected()) {
            this.settings.getGeneralSettings().setMode(Mode.REPLACE);
        }
        this.settings.getGeneralSettings().getLevels().clear();
        if (this.generalLevelTypeCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getLevels().add(Level.TYPE);
        }
        if (this.generalLevelMethodCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getLevels().add(Level.METHOD);
        }
        if (this.generalLevelFieldCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getLevels().add(Level.FIELD);
        }
        this.settings.getGeneralSettings().getVisibilities().clear();
        if (this.generalVisibilityPublicCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getVisibilities().add(Visibility.PUBLIC);
        }
        if (this.generalVisibilityProtectedCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getVisibilities().add(Visibility.PROTECTED);
        }
        if (this.generalVisibilityDefaultCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getVisibilities().add(Visibility.DEFAULT);
        }
        if (this.generalVisibilityPrivateCheckbox.isSelected()) {
            this.settings.getGeneralSettings().getVisibilities().add(Visibility.PRIVATE);
        }
        this.settings.getGeneralSettings().setOverriddenMethods(this.generalOtherOverriddenMethodsCheckbox.isSelected());
        this.settings.getGeneralSettings().setSplittedClassName(this.generalOtherSplittedClassName.isSelected());
        this.settings.getGeneralSettings().setAuthName(this.editorAuthor.getText());
        this.settings.getGeneralSettings().setDateFormat(this.editorDate.getText());
        this.settings.getTemplateSettings().setClassTemplates(this.classTemplatesTable.getSettings());
        this.settings.getTemplateSettings().setConstructorTemplates(this.constructorTemplatesTable.getSettings());
        this.settings.getTemplateSettings().setMethodTemplates(this.methodTemplatesTable.getSettings());
        this.settings.getTemplateSettings().setFieldTemplates(this.fieldTemplatesTable.getSettings());
    }

    public void reset() {
        switch (this.settings.getGeneralSettings().getMode()) {
            case KEEP: {
                this.generalModeKeepRadioButton.setSelected(true);
                break;
            }
            case UPDATE: {
                this.generalModeUpdateRadioButton.setSelected(true);
                break;
            }
            case REPLACE: {
                this.generalModeReplaceRadioButton.setSelected(true);
            }
        }
        for (Level level : this.settings.getGeneralSettings().getLevels()) {
            switch (level) {
                case TYPE: {
                    this.generalLevelTypeCheckbox.setSelected(true);
                    break;
                }
                case METHOD: {
                    this.generalLevelMethodCheckbox.setSelected(true);
                    break;
                }
                case FIELD: {
                    this.generalLevelFieldCheckbox.setSelected(true);
                }
            }
        }
        for (Visibility visibility : this.settings.getGeneralSettings().getVisibilities()) {
            switch (visibility) {
                case PUBLIC: {
                    this.generalVisibilityPublicCheckbox.setSelected(true);
                    break;
                }
                case PROTECTED: {
                    this.generalVisibilityProtectedCheckbox.setSelected(true);
                    break;
                }
                case DEFAULT: {
                    this.generalVisibilityDefaultCheckbox.setSelected(true);
                    break;
                }
                case PRIVATE: {
                    this.generalVisibilityPrivateCheckbox.setSelected(true);
                }
            }
        }
        this.generalOtherOverriddenMethodsCheckbox.setSelected(this.settings.getGeneralSettings().isOverriddenMethods());
        this.generalOtherSplittedClassName.setSelected(this.settings.getGeneralSettings().isSplittedClassName());
        this.classTemplatesTable.setSettingsModel(this.settings.getTemplateSettings().getClassTemplates());
        this.constructorTemplatesTable.setSettingsModel(this.settings.getTemplateSettings().getConstructorTemplates());
        this.methodTemplatesTable.setSettingsModel(this.settings.getTemplateSettings().getMethodTemplates());
        this.fieldTemplatesTable.setSettingsModel(this.settings.getTemplateSettings().getFieldTemplates());
        this.editorDate.setText(this.settings.getGeneralSettings().getDateFormat());
        this.editorAuthor.setText(this.settings.getGeneralSettings().getAuthName());
    }

    public void disposeUIResources() {
    }

    private boolean checkIfTableContentModified(Map<String, String> templatesTableSettings, Map<String, String> templatesSettings) {
        boolean result = false;
        Map.Entry[] templatesTableEntries = templatesTableSettings.entrySet().toArray(new Map.Entry[templatesTableSettings.size()]);
        Map.Entry[] templatesEntries = templatesSettings.entrySet().toArray(new Map.Entry[templatesSettings.size()]);
        if (templatesEntries.length == templatesTableEntries.length) {
            for (int i = 0; i < templatesEntries.length; ++i) {
                result = result || !((String)templatesEntries[i].getKey()).equals(templatesTableEntries[i].getKey());
                result = result || !((String)templatesEntries[i].getValue()).equals(templatesTableEntries[i].getValue());
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean isCheckboxModified(JCheckBox checkbox, boolean oldValue) {
        return checkbox.isSelected() != oldValue;
    }

    private void setupBorders() {
        this.generalModePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Mode", (boolean)false, (Insets)new Insets(0, 0, 0, 10)));
        this.generalLevelPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Level", (boolean)false, (Insets)new Insets(0, 0, 0, 10)));
        this.generalVisibilityPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Visibility", (boolean)false, (Insets)new Insets(0, 0, 0, 0)));
        this.generalOtherPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Other", (boolean)false, (Insets)new Insets(10, 0, 10, 10)));
    }

    private void setupTemplatesPanel() {
        this.classTemplatesTable = new TemplatesTable(this.settings.getTemplateSettings().getClassTemplates());
        JPanel classTemplatesLocalPanel = ToolbarDecorator.createDecorator((JTable)((Object)this.classTemplatesTable)).createPanel();
        JPanel classPanel = new JPanel(new BorderLayout());
        classPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Class level", (boolean)false, (Insets)new Insets(0, 0, 10, 0)));
        classPanel.add((Component)classTemplatesLocalPanel, "Center");
        this.constructorTemplatesTable = new TemplatesTable(this.settings.getTemplateSettings().getConstructorTemplates());
        JPanel constructorTemplatesLocalPanel = ToolbarDecorator.createDecorator((JTable)((Object)this.constructorTemplatesTable)).createPanel();
        JPanel constructorPanel = new JPanel(new BorderLayout());
        constructorPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Constructor level", (boolean)false, (Insets)new Insets(0, 0, 10, 0)));
        constructorPanel.add((Component)constructorTemplatesLocalPanel, "Center");
        this.methodTemplatesTable = new TemplatesTable(this.settings.getTemplateSettings().getMethodTemplates());
        JPanel methodTemplatesLocalPanel = ToolbarDecorator.createDecorator((JTable)((Object)this.methodTemplatesTable)).createPanel();
        JPanel methodPanel = new JPanel(new BorderLayout());
        methodPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Method level", (boolean)false, (Insets)new Insets(0, 0, 10, 0)));
        methodPanel.add((Component)methodTemplatesLocalPanel, "Center");
        this.fieldTemplatesTable = new TemplatesTable(this.settings.getTemplateSettings().getFieldTemplates());
        JPanel fieldTemplatesLocalPanel = ToolbarDecorator.createDecorator((JTable)((Object)this.fieldTemplatesTable)).createPanel();
        JPanel fieldPanel = new JPanel(new BorderLayout());
        fieldPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Field level", (boolean)false, (Insets)new Insets(0, 0, 0, 0)));
        fieldPanel.add((Component)fieldTemplatesLocalPanel, "Center");
        JPanel templatesPanel = new JPanel();
        templatesPanel.setLayout(new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1));
        templatesPanel.add((Component)classPanel, this.getConstraints(0, 0));
        templatesPanel.add((Component)constructorPanel, this.getConstraints(1, 0));
        templatesPanel.add((Component)methodPanel, this.getConstraints(2, 0));
        templatesPanel.add((Component)fieldPanel, this.getConstraints(3, 0));
        this.tabbedPane.addTab("Templates", templatesPanel);
    }

    private GridConstraints getConstraints(int row, int column) {
        return new GridConstraints(row, column, 1, 1, 0, 3, 3, 3, null, null, null, 0, false);
    }

    private void $$$setupUI$$$() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPane = new JTabbedPane();
        this.panel.add((Component)this.tabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new GridLayoutManager(4, 3, new Insets(10, 10, 10, 10), -1, -1));
        this.tabbedPane.addTab("General", this.generalPanel);
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), null));
        this.generalModePanel = new JPanel();
        this.generalModePanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.generalPanel.add((Component)this.generalModePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.generalModePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), null));
        this.generalModeKeepRadioButton = new JRadioButton();
        this.generalModeKeepRadioButton.setSelected(false);
        this.generalModeKeepRadioButton.setText("Keep old javadoc");
        this.generalModePanel.add((Component)this.generalModeKeepRadioButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalModeUpdateRadioButton = new JRadioButton();
        this.generalModeUpdateRadioButton.setSelected(false);
        this.generalModeUpdateRadioButton.setText("Update old javadoc");
        this.generalModePanel.add((Component)this.generalModeUpdateRadioButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalModeReplaceRadioButton = new JRadioButton();
        this.generalModeReplaceRadioButton.setText("Replace old javadoc");
        this.generalModePanel.add((Component)this.generalModeReplaceRadioButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalLevelPanel = new JPanel();
        this.generalLevelPanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.generalPanel.add((Component)this.generalLevelPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.generalLevelPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), null));
        this.generalLevelTypeCheckbox = new JCheckBox();
        this.generalLevelTypeCheckbox.setSelected(false);
        this.generalLevelTypeCheckbox.setText("Type");
        this.generalLevelPanel.add((Component)this.generalLevelTypeCheckbox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalLevelMethodCheckbox = new JCheckBox();
        this.generalLevelMethodCheckbox.setSelected(false);
        this.generalLevelMethodCheckbox.setText("Method");
        this.generalLevelPanel.add((Component)this.generalLevelMethodCheckbox, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalLevelFieldCheckbox = new JCheckBox();
        this.generalLevelFieldCheckbox.setSelected(false);
        this.generalLevelFieldCheckbox.setText("Field");
        this.generalLevelPanel.add((Component)this.generalLevelFieldCheckbox, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalVisibilityPanel = new JPanel();
        this.generalVisibilityPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.generalPanel.add((Component)this.generalVisibilityPanel, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.generalVisibilityPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), "Visibility"));
        this.generalVisibilityPublicCheckbox = new JCheckBox();
        this.generalVisibilityPublicCheckbox.setSelected(false);
        this.generalVisibilityPublicCheckbox.setText("Public");
        this.generalVisibilityPanel.add((Component)this.generalVisibilityPublicCheckbox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalVisibilityProtectedCheckbox = new JCheckBox();
        this.generalVisibilityProtectedCheckbox.setSelected(false);
        this.generalVisibilityProtectedCheckbox.setText("Protected");
        this.generalVisibilityPanel.add((Component)this.generalVisibilityProtectedCheckbox, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalVisibilityDefaultCheckbox = new JCheckBox();
        this.generalVisibilityDefaultCheckbox.setSelected(false);
        this.generalVisibilityDefaultCheckbox.setText("Default");
        this.generalVisibilityPanel.add((Component)this.generalVisibilityDefaultCheckbox, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalVisibilityPrivateCheckbox = new JCheckBox();
        this.generalVisibilityPrivateCheckbox.setText("Private");
        this.generalVisibilityPanel.add((Component)this.generalVisibilityPrivateCheckbox, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalOtherPanel = new JPanel();
        this.generalOtherPanel.setLayout(new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.generalPanel.add((Component)this.generalOtherPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        this.generalOtherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), "Other"));
        this.generalOtherOverriddenMethodsCheckbox = new JCheckBox();
        this.generalOtherOverriddenMethodsCheckbox.setText("Comment overridden methods");
        this.generalOtherPanel.add((Component)this.generalOtherOverriddenMethodsCheckbox, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.generalOtherSplittedClassName = new JCheckBox();
        this.generalOtherSplittedClassName.setSelected(true);
        this.generalOtherSplittedClassName.setText("Generate splitted class name");
        this.generalOtherPanel.add((Component)this.generalOtherSplittedClassName, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.editorAuthor = new JEditorPane();
        this.editorAuthor.setOpaque(true);
        this.editorAuthor.setToolTipText("Author");
        this.generalOtherPanel.add((Component)this.editorAuthor, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        this.editorDate = new JEditorPane();
        this.generalOtherPanel.add((Component)this.editorDate, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("\u4f5c\u8005(author)");
        this.generalOtherPanel.add((Component)label1, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("\u65f6\u95f4(date)");
        this.generalOtherPanel.add((Component)label2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.generalPanel.add((Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.generalModeKeepRadioButton);
        buttonGroup.add(this.generalModeUpdateRadioButton);
        buttonGroup.add(this.generalModeReplaceRadioButton);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

