/*
 * Decompiled with CFR 0.152.
 */
package com.github.setial.intellijjavadocs.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public class XmlUtils {
    public static final String KEY = "KEY";
    public static final String VALUE = "VALUE";

    public static String trimElementContent(Element element) throws IOException {
        return element.getTextTrim();
    }

    public static String normalizeTemplate(String template) throws IOException {
        Element element = new Element("template");
        element.addContent(template);
        return element.getTextNormalize().replaceAll("\\\\n", "\n");
    }

    public static Element getElement(String name, String value) {
        Element element = new Element(name);
        element.addContent(value);
        return element;
    }

    public static Element getElement(String nameParent, String nameChild, Collection<?> values) {
        Element root = new Element(nameParent);
        for (Object value : values) {
            root.addContent(XmlUtils.getElement(nameChild, value.toString()));
        }
        return root;
    }

    public static Element getElement(String nameParent, String nameChild, Map<String, String> values) {
        Element root = new Element(nameParent);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            Element child = new Element(nameChild);
            root.addContent(child);
            child.addContent(XmlUtils.getElement(KEY, entry.getKey()));
            child.addContent(XmlUtils.getElement(VALUE, entry.getValue()));
        }
        return root;
    }

    public static <T extends Enum<T>> T getValue(Element element, String name, Class<T> type) {
        String result;
        T enumVal = null;
        Element child = element.getChild(name);
        if (child != null && (result = child.getValue()) != null) {
            enumVal = Enum.valueOf(type, result);
        }
        return enumVal;
    }

    public static String getValue(Element element, String name) {
        Element child = element.getChild(name);
        if (child != null) {
            String result = child.getValue();
            return result;
        }
        return "";
    }

    public static <T extends Enum<T>> Set<T> getValues(Element element, String parentName, String childName, Class<T> type) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        Element root = element.getChild(parentName);
        for (Object value : root.getChildren(childName)) {
            if (!(value instanceof Element)) continue;
            Element elem = (Element)value;
            String name = elem.getValue();
            result.add(Enum.valueOf(type, name));
        }
        return result;
    }

    public static Set<Element> getValues(Element element, String parentName, String childName) {
        LinkedHashSet<Element> result = new LinkedHashSet<Element>();
        Element root = element.getChild(parentName);
        for (Object value : root.getChildren(childName)) {
            if (!(value instanceof Element)) continue;
            result.add((Element)value);
        }
        return result;
    }

    public static Map<String, String> getMap(Element root, String parentName, String childName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Set<Element> templates = XmlUtils.getValues(root, parentName, childName);
        for (Element template : templates) {
            String key = template.getChild(KEY).getValue();
            String value = template.getChild(VALUE).getValue();
            result.put(key, value);
        }
        return result;
    }

    private XmlUtils() {
    }
}

