package
{
	import flash.display.Sprite;
	
	public class StyleTest extends Sprite
	{
		public function StyleTest()
		{
			super();
			styleTest();
		}
		
		private function styleTest():void
		{
			var parentStyle:Object = 
				{
					"fontSize":12 , 
					"fontColor":0xffffff , 
					"fontFamily":"微软雅黑"
				};
			
			var childStyle:Object = addStyleToProtoChain(parentStyle);
			childStyle["fontSize"] = 20;
			childStyle["fontWeight"] = "bold";
			
			parentStyle["fontSize"] = 18;
			parentStyle["fontFamily"] = "宋体";
			
			trace("-----以下为parent的样式信息-----");
			traceObject(parentStyle);
			
			trace("-----以下为child的样式信息-----");
			traceObject(childStyle);
		}
		
		/**
		 * 将样式信息添加到原型链
		 * @param originalStyle 原始样式 
		 * @return 原始样式的子样式
		 */
		private function addStyleToProtoChain(originalStyle:Object):Object
		{
			var inheritStyle:Object;
			var factory:Function = function():void{};
			factory.prototype = originalStyle;
			inheritStyle = new factory();
			factory.prototype = null;
			return inheritStyle;
		}
		
		/**
		 * 打印排序后的对象的属性
		 */
		private function traceObject(obj:Object):void
		{
			var keys:Array = [];
			var valueMap:Object = {};
			
			for(var key:String in obj)
			{
				if(keys.indexOf(key)>=0)
					continue;
				keys.push(key);
				valueMap[key] = obj[key];
			}
			keys.sort();
			for each (key in keys)
			{
				trace(key+":"+valueMap[key]);
			}
		}
	}
}