#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define LOG_INFINITY 20


int main(int argc, char** argv)
{
  int N = 100;
  float J = 1.0;

  scanf("%d %f", &N, &J);

  int N_MINUS_ONE = N-1;
  int N_MUL_N_MINUS_ONE = N*(N-1);
  int N_SQUARED = N*N;
  float swap_probability[9];
  int S[256*256];

  // Genearting random lattice.
  for (int i = 0; i < N*N; i++) S[i] = (rand()%2*2)-1;

  float T;
  int iters;
  int repeats;

  while(scanf("%f%d%d", &T, &iters, &repeats)==3) {

    // Calculating swap probabilities.
    for (int dS=-4;dS<=4;dS++) {
      float beta_mul_dE = (J/T) * 2 * dS;
      if (beta_mul_dE < -LOG_INFINITY) swap_probability[dS+4] = 1;
      else if (beta_mul_dE > LOG_INFINITY) swap_probability[dS+4] = 0;
      else swap_probability[dS+4] = (1 / (exp(beta_mul_dE) + 1));
    }


    float avg_E_sum = 0;
    float m_sum = 0;
    for (int r = 0; r < repeats; r++) {
      // Monte-Carlo Modelling.
      for(int iter=0; iter < iters; iter++) {
        int pos = rand() % N_SQUARED;
        int x = pos / N;
        int y = pos % N;

        int dS = S[pos] * (
           S[(x==0)?(pos+N_MUL_N_MINUS_ONE):(pos-N)] +           // Top neigbor
           S[(x==N_MINUS_ONE)?(pos-N_MUL_N_MINUS_ONE):(pos+N)] + // Bottom neigbor
           S[(y==0)?(pos+N_MINUS_ONE):(pos-1)] +                 // Left neigbor
           S[(y==N_MINUS_ONE)?(pos-N_MINUS_ONE):(pos+1)]         // Right neigbor
        );

        if ( ((1.0*rand())/RAND_MAX) < swap_probability[dS+4]) {
          S[pos] *= -1;
        }
      }

      // Calculating magnetization
      int spinSum = 0;
      for (int i=0;i<N_SQUARED;i++) spinSum += S[i];
      m_sum += fabs((1.0 * spinSum) / N_SQUARED);

      // Calculating energy.
      int E_sum = 0;
      for (int i = 0; i < N; i++) {
        for (int j = 1; j < N; j++) {
          E_sum += S[i*N + (j-1)]*S[i*N + j];
          E_sum += S[(j-1)*N + i]*S[j*N + i];
        }
        E_sum += S[i*N + (N-1)]*S[i*N];
        E_sum += S[N_MUL_N_MINUS_ONE + i]*S[i];
      }
      avg_E_sum += (1.0 * E_sum) / N_SQUARED;
    }

    printf("%f\t%f\t%f\n", T, m_sum/repeats, -J*avg_E_sum/repeats);
    fprintf(stderr, "%f\t%f\t%f\n", T, m_sum/repeats, -J*avg_E_sum/repeats);
  }
}
