# -*- coding: utf-8 -*-
import xbmcgui, xbmcplugin, xbmcvfs
import sys, os
import common

sys.path.insert(0, common.profileDir)
params = dict(common.parse_qsl(sys.argv[2].replace('?','')))
provider = params.get('provider')
url = params.get('url', '')
#mode = params.get('mode')

try:
	if provider is None:
		dialog = xbmcgui.Dialog()
		selectedfiles = dialog.browseMultiple(1, 'Select provider files', 'files', '*.py')
		for source in selectedfiles:
			destination = os.path.join(common.profileDir, os.path.basename(source))
			xbmcvfs.copy(source, destination)
	else:
		moduleScript = __import__(provider, fromlist=[provider])
		link = moduleScript.Resolve(url)
		listitem = xbmcgui.ListItem(path=link)
		xbmcplugin.setResolvedUrl(handle=int(sys.argv[1]), succeeded=True, listitem=listitem)
except Exception as ex:
	common.Log(ex, 3)
