/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import processing.app.Base;
import processing.app.Messages;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.ASTGenerator;
import processing.mode.java.pdex.ErrorCheckerService;
import processing.mode.java.pdex.OffsetMatcher;

public class ASTNodeWrapper {
    private ASTNode node;
    private String label;
    private int lineNumber;

    public ASTNodeWrapper(ASTNode node) {
        if (node == null) {
            return;
        }
        this.node = node;
        this.label = ASTNodeWrapper.getNodeAsString(node);
        if (this.label == null) {
            this.label = node.toString();
        }
        this.lineNumber = ASTNodeWrapper.getLineNumber(node);
        this.label = String.valueOf(this.label) + " | Line " + this.lineNumber;
    }

    public ASTNodeWrapper(ASTNode node, String label) {
        if (node == null) {
            return;
        }
        this.node = node;
        if (label != null) {
            this.label = label;
        } else {
            label = ASTNodeWrapper.getNodeAsString(node);
            if (label == null) {
                label = node.toString();
            }
            label = String.valueOf(label) + " | Line " + this.lineNumber;
        }
        this.lineNumber = ASTNodeWrapper.getLineNumber(node);
    }

    public int[] getJavaCodeOffsets(ErrorCheckerService ecs) {
        int[] pdeoffsets;
        String pdeCode;
        int[] vals;
        int nodeOffset = this.node.getStartPosition();
        int nodeLength = this.node.getLength();
        Messages.log((String)("0.nodeOffset " + nodeOffset));
        ASTNode thisNode = this.node;
        while (thisNode.getParent() != null) {
            if (ASTNodeWrapper.getLineNumber(thisNode.getParent()) != this.lineNumber) break;
            thisNode = thisNode.getParent();
        }
        int altStartPos = thisNode.getStartPosition();
        Messages.log((String)("1.Altspos " + altStartPos));
        thisNode = thisNode.getParent();
        Javadoc jd = null;
        if (thisNode instanceof TypeDeclaration) {
            jd = ((TypeDeclaration)thisNode).getJavadoc();
            altStartPos = this.getJavadocOffset((TypeDeclaration)thisNode);
            Messages.log((String)("Has t jdoc " + ((TypeDeclaration)thisNode).getJavadoc()));
        } else if (thisNode instanceof MethodDeclaration) {
            altStartPos = this.getJavadocOffset((MethodDeclaration)thisNode);
            jd = ((MethodDeclaration)thisNode).getJavadoc();
            Messages.log((String)("Has m jdoc " + jd));
        } else if (thisNode instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)thisNode;
            jd = fd.getJavadoc();
            Messages.log((String)("Has f jdoc " + fd.getJavadoc()));
            altStartPos = this.getJavadocOffset(fd);
        }
        if (jd == null) {
            Messages.log((String)("Visiting children of node " + ASTNodeWrapper.getNodeAsString(thisNode)));
            Iterator it = thisNode.structuralPropertiesForType().iterator();
            boolean flag = true;
            block1: while (it.hasNext()) {
                StructuralPropertyDescriptor prop = (StructuralPropertyDescriptor)it.next();
                if (!prop.isChildListProperty()) continue;
                List nodelist = (List)thisNode.getStructuralProperty(prop);
                Messages.log((String)("prop " + prop));
                for (ASTNode cnode : nodelist) {
                    Messages.log((String)("Visiting node " + ASTNodeWrapper.getNodeAsString(cnode)));
                    if (ASTNodeWrapper.getLineNumber(cnode) != this.lineNumber) continue;
                    if (flag) {
                        altStartPos = cnode.getStartPosition();
                        flag = false;
                        continue;
                    }
                    if (cnode == this.node) continue block1;
                }
            }
            Messages.log((String)("Altspos " + altStartPos));
        }
        if ((vals = this.createOffsetMapping(ecs, pdeCode = ecs.getPdeCodeAtLine((pdeoffsets = this.getPDECodeOffsets(ecs))[0], pdeoffsets[1] - 1).trim(), nodeOffset - altStartPos, nodeLength)) != null) {
            return new int[]{this.lineNumber, nodeOffset + vals[0] - altStartPos, vals[1]};
        }
        Messages.log((String)("joff[1] = " + (nodeOffset - altStartPos)));
        return new int[]{this.lineNumber, nodeOffset - altStartPos, nodeLength};
    }

    private int getJavadocOffset(FieldDeclaration fd) {
        List list = fd.modifiers();
        SimpleName sn = (SimpleName)this.getNode();
        Type tp = fd.getType();
        int lineNum = ASTNodeWrapper.getLineNumber((ASTNode)sn);
        Messages.log((String)("SN " + sn + ", " + lineNum));
        for (ASTNode astNode : list) {
            if (ASTNodeWrapper.getLineNumber(astNode) != lineNum) continue;
            Messages.log((String)("first node in that line " + astNode));
            Messages.log((String)("diff " + (sn.getStartPosition() - astNode.getStartPosition())));
            return astNode.getStartPosition();
        }
        if (ASTNodeWrapper.getLineNumber((ASTNode)fd.getType()) == lineNum) {
            Messages.log((String)("first node in that line " + tp));
            Messages.log((String)("diff " + (sn.getStartPosition() - tp.getStartPosition())));
            return tp.getStartPosition();
        }
        return 0;
    }

    private int getJavadocOffset(MethodDeclaration md) {
        Type tp;
        List list = md.modifiers();
        SimpleName sn = (SimpleName)this.getNode();
        int lineNum = ASTNodeWrapper.getLineNumber((ASTNode)sn);
        Messages.log((String)("SN " + sn + ", " + lineNum));
        for (ASTNode astNode : list) {
            if (ASTNodeWrapper.getLineNumber(astNode) != lineNum) continue;
            Messages.log((String)("first node in that line " + astNode));
            Messages.log((String)("diff " + (sn.getStartPosition() - astNode.getStartPosition())));
            return astNode.getStartPosition();
        }
        if (!md.isConstructor() && ASTNodeWrapper.getLineNumber((ASTNode)(tp = md.getReturnType2())) == lineNum) {
            Messages.log((String)("first node in that line " + tp));
            Messages.log((String)("diff " + (sn.getStartPosition() - tp.getStartPosition())));
            return tp.getStartPosition();
        }
        return 0;
    }

    private int getJavadocOffset(TypeDeclaration td) {
        List list = td.modifiers();
        SimpleName sn = (SimpleName)this.getNode();
        int lineNum = ASTNodeWrapper.getLineNumber((ASTNode)sn);
        Messages.log((String)("SN " + sn + ", " + lineNum));
        for (ASTNode astNode : list) {
            if (ASTNodeWrapper.getLineNumber(astNode) != lineNum) continue;
            Messages.log((String)("first node in that line " + astNode));
            Messages.log((String)("diff " + (sn.getStartPosition() - astNode.getStartPosition())));
            return astNode.getStartPosition();
        }
        if (td.getJavadoc() != null) {
            Messages.log((String)("diff " + (td.getJavadoc().getStartPosition() + td.getJavadoc().getLength() + 1)));
            return td.getJavadoc().getStartPosition() + td.getJavadoc().getLength() + 1;
        }
        Messages.log((String)("getJavadocOffset(TypeDeclaration td) " + sn + ", found nothing. Meh."));
        return 0;
    }

    private int[] createOffsetMapping(ErrorCheckerService ecs, String source, int inpOffset, int nodeLen) {
        int[][] ret = this.getOffsetMapping(ecs, source);
        if (ret == null) {
            return null;
        }
        int[] javaCodeMap = ret[0];
        int[] pdeCodeMap = ret[1];
        int pi = 1;
        int pj = 1;
        pj = 0;
        pi = 0;
        int count = 1;
        pj = inpOffset;
        int startIndex = javaCodeMap[pj];
        while (pdeCodeMap[pi] != startIndex && pi < pdeCodeMap.length) {
            ++pi;
        }
        int startoffDif = pi - pj;
        int stopindex = javaCodeMap[pj + nodeLen - 1];
        Messages.log((String)(String.valueOf(startIndex) + "SI,St" + stopindex + "sod " + startoffDif));
        while (pdeCodeMap[pi] < stopindex && pi < pdeCodeMap.length) {
            ++pi;
            ++count;
        }
        Messages.log((String)("pde len " + count));
        return new int[]{startoffDif, count};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[][] getOffsetMapping(ErrorCheckerService ecs, String source) {
        String[] dataTypeFunc;
        String sourceJava;
        Messages.log((String)("Src:" + source));
        String sourceAlt = new String(source);
        ASTGenerator aSTGenerator = ecs.astGenerator;
        synchronized (aSTGenerator) {
            sourceJava = ecs.astGenerator.getJavaSourceCodeLine(this.lineNumber);
        }
        TreeMap<Integer, Integer> offsetmap = new TreeMap<Integer, Integer>();
        if (sourceJava.trim().startsWith("public") && !source.startsWith("public")) {
            offsetmap.put(0, 6);
        }
        Pattern webPattern = Pattern.compile("#{1}[A-F|a-f|0-9]{6}\\W");
        Matcher webMatcher = webPattern.matcher(sourceAlt);
        while (webMatcher.find()) {
            offsetmap.put(webMatcher.end() - 1, 3);
        }
        Pattern colorPattern = Pattern.compile("color(?![a-zA-Z0-9_])(?=\\[*)(?!(\\s*\\())");
        Matcher colorMatcher = colorPattern.matcher(sourceAlt);
        while (colorMatcher.find()) {
            offsetmap.put(colorMatcher.end() - 1, -2);
        }
        String[] stringArray = dataTypeFunc = new String[]{"int", "char", "float", "boolean", "byte"};
        int n = dataTypeFunc.length;
        int n2 = 0;
        while (n2 < n) {
            String dataType = stringArray[n2];
            String dataTypeRegexp = "\\b" + dataType + "\\s*\\(";
            Pattern pattern = Pattern.compile(dataTypeRegexp);
            Matcher matcher = pattern.matcher(sourceAlt);
            while (matcher.find()) {
                offsetmap.put(matcher.end() - 1, "PApplet.parse".length());
            }
            matcher.reset();
            sourceAlt = matcher.replaceAll("PApplet.parse" + Character.toUpperCase(dataType.charAt(0)) + dataType.substring(1) + "(");
            ++n2;
        }
        if (offsetmap.isEmpty()) {
            Messages.log((String)"No offset matching needed.");
            return null;
        }
        webMatcher = webPattern.matcher(sourceAlt);
        while (webMatcher.find()) {
            String found = sourceAlt.substring(webMatcher.start(), webMatcher.end());
            sourceAlt = webMatcher.replaceFirst("0xff" + found.substring(1));
            webMatcher = webPattern.matcher(sourceAlt);
        }
        colorMatcher = colorPattern.matcher(sourceAlt);
        sourceAlt = colorMatcher.replaceAll("int");
        Messages.log((String)"From direct source: ");
        Messages.log((String)sourceAlt);
        int[] javaCodeMap = new int[source.length() * 2];
        int[] pdeCodeMap = new int[source.length() * 2];
        int pi = 1;
        int pj = 1;
        int keySum = 0;
        for (Integer key : offsetmap.keySet()) {
            int i;
            while (pi < key + keySum) {
                javaCodeMap[pi] = javaCodeMap[pi - 1] + 1;
                ++pi;
            }
            while (pj < key) {
                pdeCodeMap[pj] = pdeCodeMap[pj - 1] + 1;
                ++pj;
            }
            Messages.log((String)(key + ":" + offsetmap.get(key)));
            int kval = (Integer)offsetmap.get(key);
            if (kval > 0) {
                --pi;
                --pj;
                i = 0;
                while (i < kval) {
                    if (pi > 1 && pj > 1) {
                        javaCodeMap[pi] = javaCodeMap[pi - 1];
                        pdeCodeMap[pj] = pdeCodeMap[pj - 1] + 1;
                    }
                    ++i;
                    ++pi;
                    ++pj;
                }
            } else {
                --pi;
                --pj;
                i = 0;
                while (i < -kval) {
                    if (pi > 1 && pj > 1) {
                        javaCodeMap[pi] = javaCodeMap[pi - 1] + 1;
                        pdeCodeMap[pj] = pdeCodeMap[pj - 1];
                    }
                    ++i;
                    ++pi;
                    ++pj;
                }
            }
            keySum += kval;
        }
        javaCodeMap[pi] = javaCodeMap[pi - 1] + 1;
        pdeCodeMap[pj] = pdeCodeMap[pj - 1] + 1;
        while (pi < sourceAlt.length()) {
            javaCodeMap[pi] = javaCodeMap[pi - 1] + 1;
            ++pi;
        }
        while (pj < source.length()) {
            pdeCodeMap[pj] = pdeCodeMap[pj - 1] + 1;
            ++pj;
        }
        if (Base.DEBUG) {
            int i = 0;
            while (i < pdeCodeMap.length) {
                if (pdeCodeMap[i] > 0 || javaCodeMap[i] > 0 || i == 0) {
                    if (i < source.length()) {
                        System.out.print(source.charAt(i));
                    }
                    System.out.print(String.valueOf(pdeCodeMap[i]) + " - " + javaCodeMap[i]);
                    if (i < sourceAlt.length()) {
                        System.out.print(sourceAlt.charAt(i));
                    }
                    System.out.print(" <-[" + i + "]");
                    System.out.println();
                }
                ++i;
            }
            System.out.println();
        }
        return new int[][]{javaCodeMap, pdeCodeMap};
    }

    public boolean highlightNode(JavaEditor editor) {
        int highlightStart;
        int[] pdeOffs;
        SimpleName nodeName;
        block8: {
            String pdeLine;
            String javaLine;
            Element lineElement;
            block7: {
                PlainDocument javaSource;
                int javaLineNumber;
                block6: {
                    if (!(this.node instanceof SimpleName)) {
                        return false;
                    }
                    nodeName = (SimpleName)this.node;
                    try {
                        javaLineNumber = ASTNodeWrapper.getLineNumber((ASTNode)nodeName);
                        pdeOffs = editor.getErrorChecker().calculateTabIndexAndLineNumber(javaLineNumber);
                        javaSource = new PlainDocument();
                        javaSource.insertString(0, editor.getErrorChecker().lastCodeCheckResult.sourceCode, null);
                        lineElement = javaSource.getDefaultRootElement().getElement(javaLineNumber - 1);
                        if (lineElement != null) break block6;
                        Messages.log((String)(String.valueOf(this.lineNumber) + " line element null while highlighting " + nodeName));
                        return false;
                    }
                    catch (BadLocationException e) {
                        Messages.loge((String)("BLE in highLightNode() for " + nodeName));
                        e.printStackTrace();
                        return false;
                    }
                }
                javaLine = javaSource.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
                editor.getSketch().setCurrentCode(pdeOffs[0]);
                pdeLine = editor.getLineText(pdeOffs[1]);
                String lookingFor = nodeName.toString();
                Messages.log((String)(String.valueOf(lookingFor) + ", " + nodeName.getStartPosition()));
                Messages.log((String)(String.valueOf(javaLineNumber) + " JL " + javaLine + " LSO " + lineElement.getStartOffset() + "," + lineElement.getEndOffset()));
                Messages.log((String)(String.valueOf(pdeOffs[1]) + " PL " + pdeLine));
                if (javaLine.contains(lookingFor) && pdeLine.contains(lookingFor)) break block7;
                Messages.loge((String)"Logical error in highLightNode(). Please file a bug report.");
                return false;
            }
            OffsetMatcher ofm = new OffsetMatcher(pdeLine, javaLine);
            highlightStart = ofm.getPdeOffForJavaOff(nodeName.getStartPosition() - lineElement.getStartOffset(), nodeName.getLength());
            if (highlightStart != -1) break block8;
            Messages.loge((String)"Logical error in highLightNode() during offset matching. Please file a bug report.");
            return false;
        }
        int lso = editor.getTextArea().getLineStartOffset(pdeOffs[1]);
        editor.setSelection(highlightStart += lso, highlightStart + nodeName.getLength());
        return true;
    }

    public int[][] getOffsetMapping(ErrorCheckerService ecs) {
        int[] pdeoffsets = this.getPDECodeOffsets(ecs);
        String pdeCode = ecs.getPdeCodeAtLine(pdeoffsets[0], pdeoffsets[1] - 1).trim();
        return this.getOffsetMapping(ecs, pdeCode);
    }

    public int[] getPDECodeOffsets(ErrorCheckerService ecs) {
        return ecs.JavaToPdeOffsets(this.lineNumber + 1, this.node.getStartPosition());
    }

    public int getPDECodeOffsetForSN(ASTGenerator astGen) {
        if (this.node instanceof SimpleName) {
            Element lineElement = astGen.getJavaSourceCodeElement(this.lineNumber);
            Messages.log((String)("Line element off " + lineElement.getStartOffset()));
            OffsetMatcher ofm = new OffsetMatcher(astGen.getPDESourceCodeLine(this.lineNumber), astGen.getJavaSourceCodeLine(this.lineNumber));
            int pdeOffset = ofm.getPdeOffForJavaOff(this.node.getStartPosition() - lineElement.getStartOffset(), this.node.toString().length());
            return pdeOffset;
        }
        return -1;
    }

    public String toString() {
        return this.label;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNodeType() {
        return this.node.getNodeType();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static String getJavaCode(String source) {
        String[] dataTypeFunc;
        Messages.log((String)("Src:" + source));
        String sourceAlt = new String(source);
        Pattern webPattern = Pattern.compile("#{1}[A-F|a-f|0-9]{6}\\W");
        Matcher webMatcher = webPattern.matcher(sourceAlt);
        while (webMatcher.find()) {
        }
        Pattern colorPattern = Pattern.compile("color(?![a-zA-Z0-9_])(?=\\[*)(?!(\\s*\\())");
        Matcher colorMatcher = colorPattern.matcher(sourceAlt);
        while (colorMatcher.find()) {
        }
        String[] stringArray = dataTypeFunc = new String[]{"int", "char", "float", "boolean", "byte"};
        int n = dataTypeFunc.length;
        int n2 = 0;
        while (n2 < n) {
            String dataType = stringArray[n2];
            String dataTypeRegexp = "\\b" + dataType + "\\s*\\(";
            Pattern pattern = Pattern.compile(dataTypeRegexp);
            Matcher matcher = pattern.matcher(sourceAlt);
            while (matcher.find()) {
            }
            matcher.reset();
            sourceAlt = matcher.replaceAll("PApplet.parse" + Character.toUpperCase(dataType.charAt(0)) + dataType.substring(1) + "(");
            ++n2;
        }
        webMatcher = webPattern.matcher(sourceAlt);
        while (webMatcher.find()) {
            String found = sourceAlt.substring(webMatcher.start(), webMatcher.end());
            sourceAlt = webMatcher.replaceFirst("0xff" + found.substring(1));
            webMatcher = webPattern.matcher(sourceAlt);
        }
        colorMatcher = colorPattern.matcher(sourceAlt);
        sourceAlt = colorMatcher.replaceAll("int");
        Messages.log((String)("Converted:" + sourceAlt));
        return sourceAlt;
    }

    private static int getLineNumber(ASTNode node) {
        return ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
    }

    private static String getNodeAsString(ASTNode node) {
        if (node == null) {
            return "NULL";
        }
        String className = node.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index > 0) {
            className = className.substring(index + 1);
        }
        String value = className;
        if (node instanceof TypeDeclaration) {
            value = String.valueOf(((TypeDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodDeclaration) {
            value = String.valueOf(((MethodDeclaration)node).getName().toString()) + " | " + className;
        } else if (node instanceof MethodInvocation) {
            value = String.valueOf(((MethodInvocation)node).getName().toString()) + " | " + className;
        } else if (node instanceof FieldDeclaration) {
            value = String.valueOf(((FieldDeclaration)node).toString()) + " FldDecl| ";
        } else if (node instanceof SingleVariableDeclaration) {
            value = ((SingleVariableDeclaration)node).getName() + " - " + ((SingleVariableDeclaration)node).getType() + " | SVD ";
        } else if (node instanceof ExpressionStatement) {
            value = String.valueOf(node.toString()) + className;
        } else if (node instanceof SimpleName) {
            value = String.valueOf(((SimpleName)node).getFullyQualifiedName()) + " | " + className;
        } else if (node instanceof QualifiedName) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (className.startsWith("Variable")) {
            value = String.valueOf(node.toString()) + " | " + className;
        } else if (className.endsWith("Type")) {
            value = String.valueOf(node.toString()) + " |" + className;
        }
        value = String.valueOf(value) + " [" + node.getStartPosition() + "," + (node.getStartPosition() + node.getLength()) + "]";
        value = String.valueOf(value) + " Line: " + ((CompilationUnit)node.getRoot()).getLineNumber(node.getStartPosition());
        return value;
    }
}

