/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Util;
import processing.core.PApplet;
import processing.mode.java.JavaEditor;
import processing.mode.java.pdex.LineMarker;
import processing.mode.java.pdex.Problem;

public class MarkerColumn
extends JPanel {
    protected JavaEditor editor;
    private Color errorColor;
    private Color warningColor;
    private List<LineMarker> errorPoints = Collections.synchronizedList(new ArrayList());

    public MarkerColumn(JavaEditor editor, int height) {
        this.editor = editor;
        Mode mode = editor.getMode();
        this.errorColor = mode.getColor("editor.column.error.color");
        this.warningColor = mode.getColor("editor.column.warning.color");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MarkerColumn.this.scrollToMarkerAt(e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MarkerColumn.this.showMarkerHover(e.getY());
            }
        });
    }

    @Override
    public void repaint() {
        this.recalculateMarkerPositions();
        super.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.editor.getJavaTextArea().getGutterGradient(), 0, 0, this.getWidth(), this.getHeight(), this);
        for (LineMarker m : this.errorPoints) {
            if (m.getType() == 1) {
                g.setColor(this.errorColor);
            } else {
                g.setColor(this.warningColor);
            }
            g.drawLine(2, m.getY(), this.getWidth() - 2, m.getY());
        }
    }

    public List<LineMarker> getErrorPoints() {
        return this.errorPoints;
    }

    public synchronized void updateErrorPoints(final List<Problem> problems) {
        try {
            new SwingWorker(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Object doInBackground() throws Exception {
                    Sketch sketch = MarkerColumn.this.editor.getSketch();
                    int currentTab = sketch.getCurrentCodeIndex();
                    MarkerColumn.this.errorPoints = new ArrayList();
                    List list = problems;
                    synchronized (list) {
                        for (Problem problem : problems) {
                            if (problem.getTabIndex() != currentTab) continue;
                            MarkerColumn.this.errorPoints.add(new LineMarker(problem, problem.isError()));
                        }
                    }
                    MarkerColumn.this.recalculateMarkerPositions();
                    return null;
                }

                @Override
                protected void done() {
                    MarkerColumn.this.repaint();
                    MarkerColumn.this.editor.getErrorChecker().updateEditorStatus();
                }
            }.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void scrollToMarkerAt(final int y) {
        try {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    LineMarker m = MarkerColumn.this.findClosestMarker(y);
                    if (m != null) {
                        MarkerColumn.this.editor.getErrorChecker().scrollToErrorLine(m.getProblem());
                    }
                    return null;
                }
            }.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showMarkerHover(final int y) {
        try {
            new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    LineMarker m = MarkerColumn.this.findClosestMarker(y);
                    if (m != null) {
                        Problem p = m.getProblem();
                        MarkerColumn.this.editor.statusToolTip(MarkerColumn.this, p.getMessage(), p.isError());
                        MarkerColumn.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    return null;
                }
            }.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void recalculateMarkerPositions() {
        List<LineMarker> errorPoints = this.getErrorPoints();
        if (errorPoints != null && errorPoints.size() > 0) {
            int totalLines;
            Sketch sketch = this.editor.getSketch();
            SketchCode code = sketch.getCurrentCode();
            try {
                totalLines = Util.countLines((String)code.getDocumentText());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                totalLines = 1;
            }
            int visibleLines = this.editor.getTextArea().getVisibleLines();
            totalLines = PApplet.max((int)totalLines, (int)visibleLines);
            for (LineMarker m : errorPoints) {
                float y = (float)(m.getLineNumber() + 1) / (float)totalLines;
                y *= (float)this.getHeight();
                m.setY((int)(y -= 15.0f));
            }
        }
    }

    private LineMarker findClosestMarker(int y) {
        LineMarker closest = null;
        int closestDist = Integer.MAX_VALUE;
        for (LineMarker m : this.errorPoints) {
            int dist = Math.abs(y - m.getY());
            if (dist >= 3 || dist >= closestDist) continue;
            closest = m;
            closestDist = dist;
        }
        return closest;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(12, super.getPreferredSize().height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(12, super.getMinimumSize().height);
    }
}

