/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.Util;
import processing.app.syntax.SyntaxDocument;
import processing.app.ui.Editor;
import processing.app.ui.ErrorTable;
import processing.core.PApplet;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.ASTGenerator;
import processing.mode.java.pdex.ASTNodeWrapper;
import processing.mode.java.pdex.CompilationChecker;
import processing.mode.java.pdex.ErrorMessageSimplifier;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.pdex.LineMarker;
import processing.mode.java.pdex.OffsetMatcher;
import processing.mode.java.pdex.Problem;
import processing.mode.java.pdex.XQPreprocessor;
import processing.mode.java.preproc.PdePreprocessor;

public class ErrorCheckerService {
    protected JavaEditor editor;
    protected ASTParser parser;
    private volatile boolean running;
    protected AtomicBoolean pauseThread;
    protected String className;
    protected URL[] classPath;
    public int mainClassOffset;
    public int defaultImportsOffset;
    public PdePreprocessor.Mode mode = PdePreprocessor.Mode.ACTIVE;
    protected boolean loadCompClass = true;
    protected Class<?> checkerClass;
    protected CompilationChecker compilationChecker;
    protected List<URL> classpathJars;
    public int currentTab = 0;
    public int lastTab = 0;
    protected ArrayList<ImportStatement> programImports;
    protected ArrayList<ImportStatement> previousImports = new ArrayList();
    protected ArrayList<ImportStatement> codeFolderImports = new ArrayList();
    protected XQPreprocessor xqpreproc;
    public static final String IMPORT_REGEX = "(?:^|;)\\s*(import\\s+)((?:static\\s+)?\\S+)(\\s*;)";
    protected ErrorMessageSimplifier errorMsgSimplifier;
    private static final long errorCheckInterval = 650L;
    private Thread errorCheckerThread;
    private BlockingQueue<Boolean> requestQueue = new ArrayBlockingQueue<Boolean>(1);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    volatile ScheduledFuture<?> scheduledUiUpdate = null;
    volatile long nextUiUpdate = 0L;
    private Runnable mainLoop = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ErrorCheckerService.access$0(ErrorCheckerService.this, true);
            ErrorCheckerService.this.lastCodeCheckResult = ErrorCheckerService.this.checkCode();
            if (!ErrorCheckerService.this.lastCodeCheckResult.syntaxErrors) {
                ErrorCheckerService.this.editor.showConsole();
            }
            var1_1 = ErrorCheckerService.this.astGenerator;
            synchronized (var1_1) {
                ErrorCheckerService.this.astGenerator.buildAST(ErrorCheckerService.this.lastCodeCheckResult.sourceCode, ErrorCheckerService.this.lastCodeCheckResult.compilationUnit);
                // MONITOREXIT @DISABLED, blocks:[0, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (true) ** GOTO lbl40
            }
            do {
                try {
                    ErrorCheckerService.access$2(ErrorCheckerService.this).take();
                }
                catch (InterruptedException v1) {
                    break;
                }
                ErrorCheckerService.access$2(ErrorCheckerService.this).clear();
                try {
                    Messages.log((String)"Starting error check");
                    result = ErrorCheckerService.this.checkCode();
                    if (!JavaMode.errorCheckEnabled) {
                        ErrorCheckerService.this.lastCodeCheckResult.problems.clear();
                        Messages.log((String)"Error Check disabled, so not updating UI.");
                    }
                    ErrorCheckerService.this.lastCodeCheckResult = result;
                    ErrorCheckerService.this.checkForMissingImports(ErrorCheckerService.this.lastCodeCheckResult);
                    if (!JavaMode.errorCheckEnabled) continue;
                    if (ErrorCheckerService.this.scheduledUiUpdate != null) {
                        ErrorCheckerService.this.scheduledUiUpdate.cancel(true);
                    }
                    delay = ErrorCheckerService.this.nextUiUpdate - System.currentTimeMillis();
                    uiUpdater = new Runnable(){
                        final CodeCheckResult result;
                        {
                            this.result = (this).ErrorCheckerService.this.lastCodeCheckResult;
                        }

                        @Override
                        public void run() {
                            if ((this).ErrorCheckerService.this.nextUiUpdate > 0L && System.currentTimeMillis() >= (this).ErrorCheckerService.this.nextUiUpdate) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ErrorCheckerService.this.calcPdeOffsetsForProbList(result);
                                        ErrorCheckerService.this.updateErrorTable(result.problems);
                                        ((this).this).ErrorCheckerService.this.editor.updateErrorBar(result.problems);
                                        ((this).this).ErrorCheckerService.this.editor.getTextArea().repaint();
                                        ((this).this).ErrorCheckerService.this.editor.updateErrorToggle(result.containsErrors);
                                    }
                                });
                            }
                        }
                    };
                    ErrorCheckerService.this.scheduledUiUpdate = ErrorCheckerService.access$4(ErrorCheckerService.this).schedule(uiUpdater, delay, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl40:
                // 4 sources

            } while (ErrorCheckerService.access$1(ErrorCheckerService.this));
            var1_1 = ErrorCheckerService.this.astGenerator;
            synchronized (var1_1) {
                ErrorCheckerService.this.astGenerator.disposeAllWindows();
            }
            ErrorCheckerService.this.compilationChecker = null;
            ErrorCheckerService.this.checkerClass = null;
            ErrorCheckerService.this.classLoader = null;
            System.gc();
            Messages.loge((String)("Thread stopped: " + ErrorCheckerService.this.editor.getSketch().getName()));
            System.gc();
            ErrorCheckerService.access$0(ErrorCheckerService.this, false);
        }
    };
    protected ASTGenerator astGenerator;
    protected final DocumentListener sketchChangedListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (JavaMode.errorCheckEnabled) {
                ErrorCheckerService.this.request();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (JavaMode.errorCheckEnabled) {
                ErrorCheckerService.this.request();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (JavaMode.errorCheckEnabled) {
                ErrorCheckerService.this.request();
            }
        }
    };
    protected volatile CodeCheckResult lastCodeCheckResult = new CodeCheckResult();
    public TreeMap<String, IProblem> tempErrorLog;
    protected URLClassLoader classLoader;
    private int loadClassCounter = 0;
    protected Map<String, String> compilerSettings;
    protected int pdeImportsCount;

    public ErrorCheckerService(JavaEditor debugEditor) {
        this.editor = debugEditor;
        this.pauseThread = new AtomicBoolean(false);
        this.classpathJars = new ArrayList<URL>();
        try {
            this.parser = ASTParser.newParser((int)8);
        }
        catch (Exception exception) {
            System.err.println("Experimental Mode initialization failed. Are you running the right version of Processing? ");
            this.cancel();
        }
        catch (Error e) {
            System.err.println("Experimental Mode initialization failed. ");
            e.printStackTrace();
            this.cancel();
        }
        this.xqpreproc = new XQPreprocessor(this);
        PdePreprocessor pdePrepoc = new PdePreprocessor(null);
        this.defaultImportsOffset = pdePrepoc.getCoreImports().length + pdePrepoc.getDefaultImports().length + 1;
        this.astGenerator = new ASTGenerator(this);
        this.errorMsgSimplifier = new ErrorMessageSimplifier();
        this.tempErrorLog = new TreeMap();
    }

    public void start() {
        this.errorCheckerThread = new Thread(this.mainLoop);
        this.errorCheckerThread.start();
    }

    public void stop() {
        this.cancel();
        this.running = false;
        this.errorCheckerThread.interrupt();
    }

    public void cancel() {
        this.requestQueue.clear();
        this.nextUiUpdate = 0L;
        if (this.scheduledUiUpdate != null) {
            this.scheduledUiUpdate.cancel(true);
        }
    }

    public void request() {
        this.nextUiUpdate = System.currentTimeMillis() + 650L;
        this.requestQueue.offer(Boolean.TRUE);
    }

    public void addListener(Document doc) {
        doc.addDocumentListener(this.sketchChangedListener);
    }

    protected void checkForMissingImports(CodeCheckResult result) {
        if (Preferences.getBoolean((String)"pdex.suggest.imports")) {
            for (Problem p : result.problems) {
                String[] args;
                if (p.getIProblem().getID() != 0x1000002 || (args = p.getIProblem().getArguments()).length <= 0) continue;
                String missingClass = args[0];
                Messages.log((String)("Will suggest for type:" + missingClass));
            }
        }
    }

    public ASTGenerator getASTGenerator() {
        return this.astGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CodeCheckResult checkCode() {
        CodeCheckResult result;
        block15: {
            result = new CodeCheckResult();
            result.sourceCode = this.preprocessCode();
            result.sourceCodeOffset = 0;
            char[] sourceCodeArray = result.sourceCode.toCharArray();
            result.syntaxErrors = true;
            result.containsErrors = true;
            this.parser.setSource(sourceCodeArray);
            this.parser.setKind(8);
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions((String)"1.8", (Map)options);
            options.put("org.eclipse.jdt.core.compiler.source", "1.8");
            options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
            this.parser.setCompilerOptions((Map)options);
            this.parser.setStatementsRecovery(true);
            result.compilationUnit = (CompilationUnit)this.parser.createAST(null);
            IProblem[] problems = result.compilationUnit.getProblems();
            if (problems.length == 0) {
                result.syntaxErrors = false;
                result.containsErrors = false;
            } else {
                result.syntaxErrors = true;
                result.containsErrors = true;
            }
            if (problems.length == 0 && !this.editor.hasJavaTabs()) {
                String sourceCode = this.xqpreproc.handle(result.sourceCode, this.programImports);
                this.prepareCompilerClasspath();
                this.parser.setSource(sourceCodeArray);
                this.parser.setKind(8);
                Hashtable options2 = JavaCore.getOptions();
                JavaCore.setComplianceOptions((String)"1.8", (Map)options2);
                options2.put("org.eclipse.jdt.core.compiler.source", "1.8");
                options2.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                this.parser.setCompilerOptions((Map)options2);
                this.parser.setStatementsRecovery(true);
                result.compilationUnit = (CompilationUnit)this.parser.createAST(null);
                result.sourceCode = sourceCode;
                result.sourceCodeOffset = 1;
                try {
                    if (this.loadCompClass) {
                        this.classPath = new URL[this.classpathJars.size()];
                        this.classpathJars.toArray(this.classPath);
                        this.compilationChecker = null;
                        this.classLoader = null;
                        System.gc();
                        this.classLoader = new URLClassLoader(this.classPath);
                        this.compilationChecker = new CompilationChecker();
                        this.loadCompClass = false;
                    }
                    if (this.compilerSettings == null) {
                        this.prepareCompilerSetting();
                    }
                    problems = this.compilationChecker.getErrors(this.className, sourceCode, this.compilerSettings, this.classLoader);
                }
                catch (Exception e) {
                    System.err.println("compileCheck() problem." + e);
                    e.printStackTrace();
                    this.cancel();
                }
                catch (NoClassDefFoundError e) {
                    e.printStackTrace();
                    this.cancel();
                }
            }
            if (problems == null) break block15;
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    Problem p;
                    block18: {
                        block17: {
                            IProblem problem = iProblemArray[n2];
                            if (problem.getMessage().contains("Syntax error, insert \":: IdentifierOrNew\"")) break block16;
                            int sourceLine = problem.getSourceLineNumber() - result.sourceCodeOffset;
                            int[] a = this.calculateTabIndexAndLineNumber(sourceLine);
                            p = new Problem(problem, a[0], a[1]);
                            if (!p.isError()) break block17;
                            result.containsErrors = true;
                            break block18;
                        }
                        if (p.isWarning() && !JavaMode.warningsEnabled) break block16;
                    }
                    result.problems.add(p);
                }
                ++n2;
            }
        }
        ASTGenerator aSTGenerator = this.astGenerator;
        synchronized (aSTGenerator) {
            this.astGenerator.buildAST(result.sourceCode, result.compilationUnit);
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return this.lastCodeCheckResult.syntaxErrors;
    }

    public boolean hasErrors() {
        return this.lastCodeCheckResult.containsErrors;
    }

    private void calcPdeOffsetsForProbList(CodeCheckResult codeCheckResult) {
        try {
            PlainDocument javaSource = new PlainDocument();
            javaSource.insertString(0, codeCheckResult.sourceCode, null);
            ArrayList<PlainDocument> pdeTabs = new ArrayList<PlainDocument>();
            SketchCode[] sketchCodeArray = this.editor.getSketch().getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode sc = sketchCodeArray[n2];
                PlainDocument tab = new PlainDocument();
                if (this.editor.getSketch().getCurrentCode().equals(sc)) {
                    tab.insertString(0, sc.getDocumentText(), null);
                } else {
                    tab.insertString(0, sc.getProgram(), null);
                }
                pdeTabs.add(tab);
                ++n2;
            }
            int pkgNameOffset = ("package " + this.className + ";\n").length();
            if (codeCheckResult.sourceCodeOffset == 0) {
                pkgNameOffset = 0;
            }
            for (Problem p : codeCheckResult.problems) {
                Element lineElement;
                int prbStart = p.getIProblem().getSourceStart() - pkgNameOffset;
                int prbEnd = p.getIProblem().getSourceEnd() - pkgNameOffset;
                int javaLineNumber = p.getSourceLineNumber() - 1;
                if ((javaLineNumber -= codeCheckResult.sourceCodeOffset) < 0) {
                    javaLineNumber = 0;
                }
                if ((lineElement = javaSource.getDefaultRootElement().getElement(javaLineNumber)) == null) {
                    Messages.log((String)("calcPDEOffsetsForProbList(): Couldn't fetch Java line number " + javaLineNumber + "\nProblem: " + p));
                    p.setPDEOffsets(-1, -1);
                    continue;
                }
                int lineStart = lineElement.getStartOffset();
                int lineLength = lineElement.getEndOffset() - lineStart;
                String javaLine = javaSource.getText(lineStart, lineLength);
                Document doc = (Document)pdeTabs.get(p.getTabIndex());
                Element pdeLineElement = doc.getDefaultRootElement().getElement(p.getLineNumber());
                if (pdeLineElement == null) {
                    Messages.log((String)("calcPDEOffsetsForProbList(): Couldn't fetch pde line number " + javaLineNumber + "\nProblem: " + p));
                    p.setPDEOffsets(-1, -1);
                    continue;
                }
                int pdeLineStart = pdeLineElement.getStartOffset();
                int pdeLineLength = pdeLineElement.getEndOffset() - pdeLineStart;
                String pdeLine = ((Document)pdeTabs.get(p.getTabIndex())).getText(pdeLineStart, pdeLineLength);
                OffsetMatcher ofm = new OffsetMatcher(pdeLine, javaLine);
                int pdeOffset = ofm.getPdeOffForJavaOff(prbStart - lineStart, prbEnd - prbStart + 1);
                p.setPDEOffsets(pdeOffset, pdeOffset + prbEnd - prbStart);
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompilationUnit getLatestCU() {
        return this.lastCodeCheckResult.compilationUnit;
    }

    public URLClassLoader getSketchClassLoader() {
        ++this.loadClassCounter;
        if (this.loadClassCounter > 100) {
            this.loadClassCounter = 0;
            this.classLoader = null;
            System.gc();
            this.classLoader = new URLClassLoader(this.classPath);
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareCompilerClasspath() {
        if (!this.loadCompClass) {
            return;
        }
        List<URL> list = this.classpathJars;
        synchronized (list) {
            String searchPath;
            File codeFolder;
            String codeFolderClassPath;
            Object pathItem;
            this.classpathJars = new ArrayList<URL>();
            String entry = "";
            for (ImportStatement impstat : this.programImports) {
                String item = impstat.getImportName();
                int dot = item.lastIndexOf(46);
                entry = dot == -1 ? item : item.substring(0, dot);
                if (this.ignorableImport(entry = entry.substring(6).trim())) continue;
                Library library = null;
                try {
                    String[] libraryPath;
                    library = this.editor.getMode().getLibrary(entry);
                    String[] stringArray = libraryPath = PApplet.split((String)library.getClassPath().substring(1).trim(), (char)File.pathSeparatorChar);
                    int n = libraryPath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        pathItem = stringArray[n2];
                        this.classpathJars.add(new File((String)pathItem).toURI().toURL());
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Messages.log((String)("Encountered " + e + " while adding library to classpath"));
                }
            }
            if (this.editor.getSketch().hasCodeFolder() && !(codeFolderClassPath = Util.contentsToClassPath((File)(codeFolder = this.editor.getSketch().getCodeFolder()))).equalsIgnoreCase("")) {
                Messages.log((String)"Sketch has a code folder. Adding its jars");
                String[] codeFolderPath = PApplet.split((String)codeFolderClassPath.substring(1).trim(), (char)File.pathSeparatorChar);
                try {
                    pathItem = codeFolderPath;
                    int n = codeFolderPath.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String pathItem2 = pathItem[n3];
                        this.classpathJars.add(new File(pathItem2).toURI().toURL());
                        Messages.log((String)("Addind cf jar: " + pathItem2));
                        ++n3;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if ((searchPath = ((JavaMode)this.getEditor().getMode()).getSearchPath()) != null) {
                String[] modeJars;
                String[] stringArray = modeJars = PApplet.split((String)searchPath, (char)File.pathSeparatorChar);
                int n = modeJars.length;
                int n4 = 0;
                while (n4 < n) {
                    String mj = stringArray[n4];
                    try {
                        this.classpathJars.add(new File(mj).toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ASTGenerator aSTGenerator = ErrorCheckerService.this.astGenerator;
                synchronized (aSTGenerator) {
                    ErrorCheckerService.this.astGenerator.loadJars();
                }
            }
        }).start();
    }

    protected boolean ignorableImport(String packageName) {
        return packageName.startsWith("java.") || packageName.startsWith("javax.");
    }

    protected boolean ignorableSuggestionImport(String impName) {
        String impNameLc = impName.toLowerCase();
        for (ImportStatement impS : this.programImports) {
            if (!impNameLc.startsWith(impS.getPackageName().toLowerCase())) continue;
            return false;
        }
        for (ImportStatement impS : this.codeFolderImports) {
            if (!impNameLc.startsWith(impS.getPackageName().toLowerCase())) continue;
            return false;
        }
        if (impName.startsWith("processing")) {
            if (JavaMode.suggestionsMap.get("include").contains(impName)) {
                return false;
            }
            if (JavaMode.suggestionsMap.get("exclude").contains(impName)) {
                return true;
            }
        } else if (impName.startsWith("java") && JavaMode.suggestionsMap.get("include").contains(impName)) {
            return false;
        }
        return true;
    }

    protected void prepareCompilerSetting() {
        this.compilerSettings = new HashMap<String, String>();
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.source", "1.8");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        this.compilerSettings.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorTable(List<Problem> problems) {
        try {
            ErrorTable table = this.editor.getErrorTable();
            table.clearRows();
            Sketch sketch = this.editor.getSketch();
            for (Problem p : problems) {
                String[] args;
                String message = p.getMessage();
                if (Preferences.getBoolean((String)"pdex.suggest.imports") && p.getIProblem().getID() == 0x1000002 && (args = p.getIProblem().getArguments()).length > 0) {
                    String[] si;
                    String missingClass = args[0];
                    ASTGenerator aSTGenerator = this.astGenerator;
                    synchronized (aSTGenerator) {
                        si = this.astGenerator.getSuggestImports(missingClass);
                    }
                    if (si != null && si.length > 0) {
                        p.setImportSuggestions(si);
                        message = String.valueOf(message) + " (double-click for suggestions)";
                    }
                }
                table.addRow((ErrorTable.Entry)p, message, sketch.getCode(p.getTabIndex()).getPrettyName(), Integer.toString(p.getLineNumber() + 1));
            }
        }
        catch (Exception e) {
            Messages.loge((String)"Exception at updateErrorTable()", (Throwable)e);
            e.printStackTrace();
            this.cancel();
        }
    }

    public void updateEditorStatus() {
        if (JavaMode.errorCheckEnabled) {
            LineMarker errorMarker = this.editor.findError(this.editor.getTextArea().getCaretLine());
            if (errorMarker != null) {
                if (errorMarker.getType() == 2) {
                    this.editor.statusMessage(errorMarker.getProblem().getMessage(), 4);
                } else {
                    this.editor.statusMessage(errorMarker.getProblem().getMessage(), 2);
                }
            } else {
                switch (this.editor.getStatusMode()) {
                    case 2: 
                    case 4: {
                        this.editor.statusEmpty();
                    }
                }
            }
        }
    }

    protected int[] JavaToPdeOffsets(int line, int offset) {
        int codeIndex = 0;
        int x = line - this.mainClassOffset;
        if (x < 0) {
            x = line - 2;
            if (x < this.programImports.size() && x >= 0) {
                ImportStatement is = this.programImports.get(x);
                return new int[]{is.getTab(), is.getLineNumber()};
            }
            int[] nArray = new int[2];
            nArray[1] = 1;
            return nArray;
        }
        try {
            SketchCode[] sketchCodeArray = this.editor.getSketch().getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode sc = sketchCodeArray[n2];
                if (sc.isExtension("pde")) {
                    int len = 0;
                    len = this.editor.getSketch().getCurrentCode().equals(sc) ? Util.countLines((String)sc.getDocumentText()) + 1 : Util.countLines((String)sc.getProgram()) + 1;
                    if (x >= len) {
                        if (codeIndex >= this.editor.getSketch().getCodeCount() - 1) {
                            x = this.editor.getSketch().getCode(codeIndex).getLineCount();
                            break;
                        }
                        x -= len;
                        ++codeIndex;
                    } else {
                        if (codeIndex >= this.editor.getSketch().getCodeCount()) {
                            codeIndex = this.editor.getSketch().getCodeCount() - 1;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println("Error inside ErrorCheckerService.JavaToPdeOffset()");
            e.printStackTrace();
        }
        return new int[]{codeIndex, x};
    }

    protected String getPdeCodeAtLine(int tab, int linenumber) {
        if (linenumber < 0) {
            return null;
        }
        this.editor.getSketch().setCurrentCode(tab);
        return this.editor.getTextArea().getLineText(linenumber);
    }

    protected int[] calculateTabIndexAndLineNumber(int javalineNumber) {
        int codeIndex = 0;
        int x = javalineNumber - this.mainClassOffset;
        if (x < 0) {
            x = javalineNumber - 2;
            if (x < this.programImports.size() && x >= 0) {
                ImportStatement is = this.programImports.get(x);
                return new int[]{is.getTab(), is.getLineNumber()};
            }
            int[] nArray = new int[2];
            nArray[1] = 1;
            return nArray;
        }
        try {
            SketchCode[] sketchCodeArray = this.editor.getSketch().getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode sc = sketchCodeArray[n2];
                if (sc.isExtension("pde")) {
                    int len = 0;
                    len = this.editor.getSketch().getCurrentCode().equals(sc) ? Util.countLines((String)sc.getDocumentText()) + 1 : Util.countLines((String)sc.getProgram()) + 1;
                    if (x >= len) {
                        if (codeIndex >= this.editor.getSketch().getCodeCount() - 1) {
                            x = this.editor.getSketch().getCode(codeIndex).getLineCount();
                            break;
                        }
                        x -= len;
                        ++codeIndex;
                    } else {
                        if (codeIndex >= this.editor.getSketch().getCodeCount()) {
                            codeIndex = this.editor.getSketch().getCodeCount() - 1;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Things got messed up in ErrorCheckerService.calculateTabIndexAndLineNumber()");
        }
        return new int[]{codeIndex, x};
    }

    protected int getJavaLineNumFromPDElineNum(int tab, int pdeLineNum) {
        int jLineNum = this.programImports.size() + 1;
        int i = 0;
        while (i < tab) {
            SketchCode sc = this.editor.getSketch().getCode(i);
            int len = Util.countLines((String)sc.getProgram()) + 1;
            jLineNum += len;
            ++i;
        }
        return jLineNum;
    }

    protected String preprocessCode() {
        String uncommented;
        String[] dataTypeFunc;
        this.programImports = new ArrayList();
        StringBuilder rawCode = new StringBuilder();
        Sketch sketch = this.editor.getSketch();
        try {
            SketchCode[] sketchCodeArray = sketch.getCode();
            int n = sketchCodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode sc = sketchCodeArray[n2];
                if (sc.isExtension("pde")) {
                    try {
                        if (sketch.getCurrentCode().equals(sc)) {
                            rawCode.append(this.scrapImportStatements(sc.getDocumentText(), sketch.getCodeIndex(sc)));
                        } else {
                            rawCode.append(this.scrapImportStatements(sc.getProgram(), sketch.getCodeIndex(sc)));
                        }
                        rawCode.append('\n');
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    rawCode.append('\n');
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Messages.log((String)"Exception in preprocessCode()");
        }
        String sourceAlt = rawCode.toString();
        String[] stringArray = dataTypeFunc = new String[]{"int", "char", "float", "boolean", "byte"};
        int e = dataTypeFunc.length;
        int n = 0;
        while (n < e) {
            String dataType = stringArray[n];
            String dataTypeRegexp = "\\b" + dataType + "\\s*\\(";
            Pattern pattern = Pattern.compile(dataTypeRegexp);
            Matcher matcher = pattern.matcher(sourceAlt);
            sourceAlt = matcher.replaceAll("PApplet.parse" + Character.toUpperCase(dataType.charAt(0)) + dataType.substring(1) + "(");
            ++n;
        }
        Pattern webPattern = Pattern.compile("#{1}[A-F|a-f|0-9]{6}\\W");
        Matcher webMatcher = webPattern.matcher(sourceAlt);
        while (webMatcher.find()) {
            String found = sourceAlt.substring(webMatcher.start(), webMatcher.end());
            sourceAlt = webMatcher.replaceFirst("0xff" + found.substring(1));
            webMatcher = webPattern.matcher(sourceAlt);
        }
        Pattern colorPattern = Pattern.compile("color(?![a-zA-Z0-9_])(?=\\[*)(?!(\\s*\\())");
        Matcher colorMatcher = colorPattern.matcher(sourceAlt);
        sourceAlt = colorMatcher.replaceAll("int");
        this.checkForChangedImports();
        this.className = this.editor == null ? "DefaultClass" : this.editor.getSketch().getName();
        try {
            uncommented = PdePreprocessor.scrubComments(sourceAlt);
            this.mode = PdePreprocessor.parseMode(uncommented);
        }
        catch (RuntimeException runtimeException) {
            uncommented = PdePreprocessor.scrubComments(String.valueOf(sourceAlt) + "*/");
            this.mode = PdePreprocessor.parseMode(uncommented);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.xqpreproc.prepareImports(this.programImports));
        if (this.mode != PdePreprocessor.Mode.JAVA) {
            sb.append("public class " + this.className + " extends PApplet {\n");
            if (this.mode == PdePreprocessor.Mode.STATIC) {
                sb.append("public void setup() {\n");
            }
        }
        this.mainClassOffset = 1;
        int i = 0;
        while (i < sb.length()) {
            if (sb.charAt(i) == '\n') {
                ++this.mainClassOffset;
            }
            ++i;
        }
        sb.append(sourceAlt);
        if (this.mode != PdePreprocessor.Mode.JAVA) {
            if (this.mode == PdePreprocessor.Mode.STATIC) {
                sb.append("\n}");
            }
            sb.append("\n}");
        }
        return ErrorCheckerService.substituteUnicode(sb.toString());
    }

    private boolean highlightNode(ASTNodeWrapper awrap) {
        Messages.log((String)("Highlighting: " + awrap));
        try {
            int[] pdeoffsets = awrap.getPDECodeOffsets(this);
            int[] javaoffsets = awrap.getJavaCodeOffsets(this);
            Messages.log((String)("offsets: " + pdeoffsets[0] + "," + pdeoffsets[1] + "," + javaoffsets[1] + "," + javaoffsets[2]));
            ErrorCheckerService.scrollToErrorLine(this.editor, pdeoffsets[0], pdeoffsets[1], javaoffsets[1], javaoffsets[2]);
            return true;
        }
        catch (Exception exception) {
            Messages.loge((String)("Scrolling failed for " + awrap));
            return false;
        }
    }

    public boolean highlightNode(ASTNode node) {
        ASTNodeWrapper awrap = new ASTNodeWrapper(node);
        return this.highlightNode(awrap);
    }

    public void scrollToErrorLine(int errorIndex) {
        if (this.editor == null) {
            return;
        }
        CodeCheckResult lastCodeCheckResult = this.lastCodeCheckResult;
        if (errorIndex < lastCodeCheckResult.problems.size() && errorIndex >= 0) {
            Problem p = lastCodeCheckResult.problems.get(errorIndex);
            this.scrollToErrorLine(p);
        }
    }

    public void scrollToErrorLine(Problem p) {
        if (this.editor == null) {
            return;
        }
        if (p == null) {
            return;
        }
        try {
            if (p.getPDELineStartOffset() == -1 || p.getPDELineStopOffset() == -1) {
                this.editor.toFront();
                this.editor.getSketch().setCurrentCode(p.getTabIndex());
            } else {
                this.astGenerator.highlightPDECode(p.getTabIndex(), p.getLineNumber(), p.getPDELineStartOffset(), p.getPDELineStopOffset() - p.getPDELineStartOffset() + 1);
            }
            SyntaxDocument doc = this.editor.getTextArea().getDocument();
            int lineCount = Util.countLines((String)doc.getText(0, doc.getLength()));
            if (p.getLineNumber() < lineCount && p.getLineNumber() >= 0) {
                this.editor.getTextArea().scrollTo(p.getLineNumber(), 0);
            }
            this.editor.repaint();
        }
        catch (Exception e) {
            Messages.loge((String)("Error while selecting text in scrollToErrorLine(), for problem: " + p), (Throwable)e);
        }
    }

    public static boolean scrollToErrorLine(Editor edt, int tabIndex, int lineNoInTab, int lineStartOffset, int length) {
        if (edt == null) {
            return false;
        }
        try {
            edt.toFront();
            edt.getSketch().setCurrentCode(tabIndex);
            int lsno = edt.getTextArea().getLineStartNonWhiteSpaceOffset(lineNoInTab - 1) + lineStartOffset;
            edt.setSelection(lsno, lsno + length);
            edt.getTextArea().scrollTo(lineNoInTab - 1, 0);
            edt.repaint();
            Messages.log((String)(String.valueOf(lineStartOffset) + " LSO,len " + length));
        }
        catch (Exception e) {
            System.err.println(e + " : Error while selecting text in static scrollToErrorLine()");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void checkForChangedImports() {
        if (this.programImports.size() != this.previousImports.size()) {
            this.loadCompClass = true;
            this.previousImports = this.programImports;
        } else {
            int i = 0;
            while (i < this.programImports.size()) {
                if (!this.programImports.get(i).getImportName().equals(this.previousImports.get(i).getImportName())) {
                    this.loadCompClass = true;
                    this.previousImports = this.programImports;
                    break;
                }
                ++i;
            }
        }
    }

    public int getPdeImportsCount() {
        return this.pdeImportsCount;
    }

    protected String scrapImportStatements(String tabProgram, int tabNumber) {
        String[] pieces;
        this.pdeImportsCount = 0;
        String tabSource = tabProgram;
        while ((pieces = PApplet.match((String)tabSource, (String)IMPORT_REGEX)) != null) {
            String piece = String.valueOf(pieces[1]) + pieces[2] + pieces[3];
            int len = piece.length();
            int idx = tabSource.indexOf(piece);
            int lineCount = Util.countLines((String)tabSource.substring(0, idx));
            this.programImports.add(new ImportStatement(piece, tabNumber, lineCount));
            String whiteSpace = "";
            int j = 0;
            while (j < piece.length()) {
                whiteSpace = String.valueOf(whiteSpace) + " ";
                ++j;
            }
            tabSource = String.valueOf(tabSource.substring(0, idx)) + whiteSpace + tabSource.substring(idx + len);
            ++this.pdeImportsCount;
        }
        return tabSource;
    }

    public static String substituteUnicode(String program) {
        char[] p = program.toCharArray();
        int unicodeCount = 0;
        int i = 0;
        while (i < p.length) {
            if (p[i] > '\u007f') {
                ++unicodeCount;
            }
            ++i;
        }
        if (unicodeCount == 0) {
            return program;
        }
        int index = 0;
        char[] p2 = new char[p.length + unicodeCount * 5];
        int i2 = 0;
        while (i2 < p.length) {
            if (p[i2] < '\u0080') {
                p2[index++] = p[i2];
            } else if (p[i2] == '\u00a0') {
                p2[index++] = 32;
            } else {
                char c = p[i2];
                p2[index++] = 92;
                p2[index++] = 117;
                char[] str = Integer.toHexString(c).toCharArray();
                int m = 0;
                while (m < 4 - str.length) {
                    p2[index++] = 48;
                    ++m;
                }
                System.arraycopy(str, 0, p2, index, str.length);
                index += str.length;
            }
            ++i2;
        }
        return new String(p2, 0, index);
    }

    public void handleErrorCheckingToggle() {
        if (!JavaMode.errorCheckEnabled) {
            Messages.log((String)(String.valueOf(this.editor.getSketch().getName()) + " Error Checker disabled."));
            this.editor.getErrorPoints().clear();
            this.lastCodeCheckResult.problems.clear();
            this.updateErrorTable(Collections.emptyList());
            this.updateEditorStatus();
            this.editor.getTextArea().repaint();
            this.editor.repaintErrorBar();
        } else {
            Messages.log((String)(String.valueOf(this.editor.getSketch().getName()) + " Error Checker enabled."));
            this.request();
        }
    }

    public JavaEditor getEditor() {
        return this.editor;
    }

    public ArrayList<ImportStatement> getProgramImports() {
        return this.programImports;
    }

    static /* synthetic */ void access$0(ErrorCheckerService errorCheckerService, boolean bl) {
        errorCheckerService.running = bl;
    }

    static /* synthetic */ boolean access$1(ErrorCheckerService errorCheckerService) {
        return errorCheckerService.running;
    }

    static /* synthetic */ BlockingQueue access$2(ErrorCheckerService errorCheckerService) {
        return errorCheckerService.requestQueue;
    }

    static /* synthetic */ ScheduledExecutorService access$4(ErrorCheckerService errorCheckerService) {
        return errorCheckerService.scheduler;
    }

    public static class CodeCheckResult {
        boolean syntaxErrors;
        boolean containsErrors;
        CompilationUnit compilationUnit;
        String sourceCode;
        int sourceCodeOffset;
        List<Problem> problems = new ArrayList<Problem>();
    }
}

