/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.JavaScriptEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import processing.app.Messages;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.ui.Toolkit;

public class DirectivesEditor {
    JavaScriptEditor editor;
    JFrame frame;
    JCheckBox crispBox;
    JTextField fontField;
    JCheckBox globalKeyEventsBox;
    JCheckBox pauseOnBlurBox;
    JTextField preloadField;
    private static final ArrayList<String> validKeys = new ArrayList();
    private static final int CRISP = 0;
    private static final int FONT = 1;
    private static final int GLOBAL_KEY_EVENTS = 2;
    private static final int PAUSE_ON_BLUR = 3;
    private static final int PRELOAD = 4;
    private static final int TRANSPARENT = 5;
    private Pattern pjsPattern;

    public DirectivesEditor(JavaScriptEditor javaScriptEditor) {
        this.editor = javaScriptEditor;
        if (this.frame == null) {
            this.createFrame();
        }
        this.pjsPattern = Pattern.compile("\\/\\*\\s*@pjs\\s+((?:[^\\*]|\\*+[^\\*\\/])*)\\*\\/\\s*", 32);
    }

    public void show() {
        if (this.editor.getSketch().isModified()) {
            Messages.showWarning((String)"Directives Editor", (String)"Please save your sketch before changing the directives.", null);
            return;
        }
        this.resetInterface();
        this.findRemoveDirectives(false);
        this.frame.setVisible(true);
    }

    private void resetInterface() {
        for (JCheckBox jComponent : new JCheckBox[]{this.crispBox, this.globalKeyEventsBox, this.pauseOnBlurBox}) {
            jComponent.setSelected(false);
        }
        for (JComponent jComponent : new JTextField[]{this.fontField, this.preloadField}) {
            ((JTextComponent)jComponent).setText("");
        }
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    void applyDirectives() {
        this.findRemoveDirectives(true);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "; \n";
        if (this.crispBox.isSelected()) {
            stringBuffer.append(string + "crisp=true" + string2);
        }
        if (!this.fontField.getText().trim().equals("")) {
            stringBuffer.append(string + "font=\"" + this.fontField.getText().trim() + "\"" + string2);
        }
        if (this.globalKeyEventsBox.isSelected()) {
            stringBuffer.append(string + "globalKeyEvents=true" + string2);
        }
        if (this.pauseOnBlurBox.isSelected()) {
            stringBuffer.append(string + "pauseOnBlur=true" + string2);
        }
        if (!this.preloadField.getText().trim().equals("")) {
            stringBuffer.append(string + "preload=\"" + this.preloadField.getText().trim() + "\"" + string2);
        }
        Sketch sketch = this.editor.getSketch();
        SketchCode sketchCode = sketch.getCode(0);
        if (stringBuffer.length() > 0) {
            sketchCode.setProgram("/* @pjs " + stringBuffer.toString() + " */\n\n" + sketchCode.getProgram());
            if (sketch.getCurrentCode() == sketchCode) {
                this.editor.setText(sketch.getCurrentCode().getProgram());
                this.editor.setSelection(0, 0);
            }
            sketch.setModified(false);
            sketch.setModified(true);
        }
    }

    void findRemoveDirectives(boolean bl) {
        Sketch sketch = this.editor.getSketch();
        for (int i = 0; i < sketch.getCodeCount(); ++i) {
            SketchCode sketchCode = sketch.getCode(i);
            String string = sketchCode.getProgram();
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = this.pjsPattern.matcher(string);
            while (matcher.find()) {
                String[] stringArray;
                String string2 = matcher.group();
                string2 = string2.replaceAll("^\\/\\*\\s*@pjs", "").replaceAll("\\s*\\*\\/\\s*$", "");
                string2 = string2.replaceAll("[\\s]*([^;\\s\\n\\r]+)[\\s]*,[\\s]*[\\n\\r]+", "$1,");
                string2 = string2.replaceAll("[\\s]*([^;\\s\\n\\r]+)[\\s]*[\\n\\r]+", "$1;");
                string2 = string2.replaceAll("\n", " ").replaceAll("\r", " ");
                if (bl) {
                    matcher.appendReplacement(stringBuffer, "");
                    continue;
                }
                for (String string3 : stringArray = string2.split(";")) {
                    this.parseDirective(string3);
                }
            }
            if (!bl) continue;
            matcher.appendTail(stringBuffer);
            sketchCode.setProgram(stringBuffer.toString());
            sketchCode.setModified(true);
        }
        if (bl) {
            this.editor.setText(sketch.getCurrentCode().getProgram());
            sketch.setModified(false);
            sketch.setModified(true);
        }
    }

    private void parseDirective(String string) {
        if (string == null) {
            System.err.println("Directive is null.");
            return;
        }
        String[] stringArray = string.split("=");
        if (stringArray == null || stringArray.length != 2) {
            System.err.println("Unable to parse directive: \"" + string + "\" Ignored.");
            return;
        }
        String string2 = stringArray[0].trim();
        String string3 = stringArray[1].trim();
        if (validKeys.indexOf(string2) == 1 || validKeys.indexOf(string2) == 4) {
            string3 = string3.replaceAll("[\\s]*,[\\s]*", ",");
        }
        if (validKeys.indexOf(string2) == -1) {
            System.err.println("Directive key not recognized: \"" + string2 + "\" Ignored.");
            return;
        }
        if (string3.equals("")) {
            System.err.println("Directive value empty. Ignored.");
            return;
        }
        string3 = string3.replaceAll("^\"|\"$", "").replaceAll("^'|'$", "");
        switch (validKeys.indexOf(string2)) {
            case 0: {
                boolean bl = string3.toLowerCase().equals("true");
                this.crispBox.setSelected(bl);
                break;
            }
            case 1: {
                this.fontField.setText(string3);
                break;
            }
            case 2: {
                boolean bl = string3.toLowerCase().equals("true");
                this.globalKeyEventsBox.setSelected(bl);
                break;
            }
            case 3: {
                boolean bl = string3.toLowerCase().equals("true");
                this.pauseOnBlurBox.setSelected(bl);
                break;
            }
            case 4: {
                this.preloadField.setText(string3);
                break;
            }
            case 5: {
                boolean bl = string3.toLowerCase().equals("true");
            }
        }
    }

    void createFrame() {
        int n = 13;
        int n2 = 10;
        int n3 = 6;
        int n4 = 30;
        int n5 = n;
        int n6 = n;
        int n7 = 0;
        this.frame = new JFrame("Directives Editor");
        Container container = this.frame.getContentPane();
        container.setLayout(null);
        JLabel jLabel = new JLabel("Click here to read about directives.");
        jLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Platform.openURL((String)"http://processingjs.org/reference/pjs%20directive");
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        container.add(jLabel);
        Dimension dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n5, n6, dimension.width, dimension.height);
        this.crispBox = new JCheckBox("\"crisp\": disable antialiasing for line(), triangle() and rect()");
        container.add(this.crispBox);
        dimension = this.crispBox.getPreferredSize();
        this.crispBox.setBounds(n5, n6 += dimension.height + n2 + n2, dimension.width + 10, dimension.height);
        n7 = Math.max(n7, n5 + dimension.width);
        jLabel = new JLabel("\"font\": to load (comma separated)");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n5, n6 += dimension.height + n2, dimension.width, dimension.height);
        this.fontField = new JTextField(n4);
        container.add(this.fontField);
        dimension = this.fontField.getPreferredSize();
        this.fontField.setBounds(n5, n6 += dimension.height + n3, dimension.width, dimension.height);
        JButton jButton = new JButton("scan");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectivesEditor.this.handleScanFonts();
            }
        });
        container.add(jButton);
        Dimension dimension2 = jButton.getPreferredSize();
        jButton.setBounds(n5 + dimension.width + n3, n6, dimension2.width, dimension2.height);
        n7 = Math.max(n7, n5 + dimension.width + n3 + dimension2.width);
        this.globalKeyEventsBox = new JCheckBox("\"globalKeyEvents\": receive global key events");
        container.add(this.globalKeyEventsBox);
        dimension = this.globalKeyEventsBox.getPreferredSize();
        this.globalKeyEventsBox.setBounds(n5, n6 += dimension.height + n2, dimension.width + 10, dimension.height);
        n7 = Math.max(n7, n5 + dimension.width);
        this.pauseOnBlurBox = new JCheckBox("\"pauseOnBlur\": pause if applet loses focus");
        container.add(this.pauseOnBlurBox);
        dimension = this.pauseOnBlurBox.getPreferredSize();
        this.pauseOnBlurBox.setBounds(n5, n6 += dimension.height + n2, dimension.width + 10, dimension.height);
        n7 = Math.max(n7, n5 + dimension.width);
        jLabel = new JLabel("\"preload\": images (comma separated)");
        container.add(jLabel);
        dimension = jLabel.getPreferredSize();
        jLabel.setBounds(n5, n6 += dimension.height + n2, dimension.width, dimension.height);
        this.preloadField = new JTextField(n4);
        container.add(this.preloadField);
        dimension = this.preloadField.getPreferredSize();
        this.preloadField.setBounds(n5, n6 += dimension.height + n3, dimension.width, dimension.height);
        jButton = new JButton("scan");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectivesEditor.this.handleScanImages();
            }
        });
        container.add(jButton);
        dimension2 = jButton.getPreferredSize();
        jButton.setBounds(n5 + dimension.width + n3, n6, dimension2.width, dimension2.height);
        n7 = Math.max(n7, n5 + dimension.width + n3 + dimension2.width);
        n6 += dimension.height + n2;
        jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectivesEditor.this.applyDirectives();
                DirectivesEditor.this.hide();
            }
        });
        container.add(jButton);
        dimension2 = jButton.getPreferredSize();
        int n8 = dimension2.height;
        int n9 = 80;
        int n10 = n7 - (n9 + n3 + n9);
        jButton.setBounds(n10, n6, n9, n8);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectivesEditor.this.hide();
            }
        });
        container.add(jButton);
        jButton.setBounds(n10 += n9 + n3, n6, n9, n8);
        this.frame.pack();
        Insets insets = this.frame.getInsets();
        this.frame.setSize(n7 + n + insets.left + insets.right, (n6 += n8 + n2) + n3 + insets.top + insets.bottom);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DirectivesEditor.this.frame.setVisible(false);
            }
        });
        Toolkit.registerWindowCloseKeys((JRootPane)this.frame.getRootPane(), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DirectivesEditor.this.frame.setVisible(false);
            }
        });
        Toolkit.setIcon((Frame)this.frame);
    }

    void handleScanFonts() {
        this.handleScanFiles(this.fontField, new String[]{"woff", "svg", "eot", "ttf", "otf"});
    }

    void handleScanImages() {
        this.handleScanFiles(this.preloadField, new String[]{"gif", "jpg", "jpeg", "png", "tga"});
    }

    /*
     * WARNING - void declaration
     */
    void handleScanFiles(JTextField jTextField, String[] stringArray) {
        void var6_9;
        String[] stringArray2 = this.scanDataFolderForFilesByType(stringArray);
        if (stringArray2 == null || stringArray2.length == 0) {
            return;
        }
        String[] stringArray3 = jTextField.getText().trim().split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray3) {
            if ((string2 = string2.trim()).equals("") || arrayList.indexOf(string2) != -1) continue;
            arrayList.add(string2);
        }
        for (String string2 : stringArray2) {
            if ((string2 = string2.trim()).equals("") || arrayList.indexOf(string2) != -1) continue;
            arrayList.add(string2);
        }
        Collections.sort(arrayList);
        String string = "";
        int n = 0;
        for (String string2 : arrayList) {
            String string3 = (String)var6_9 + (n > 0 ? ", " : "") + string2;
            ++n;
        }
        jTextField.setText((String)var6_9);
    }

    String[] scanDataFolderForFilesByType(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = this.editor.getSketch().getDataFolder();
        if (!file.exists()) {
            return null;
        }
        for (String string : stringArray) {
            String[] stringArray2 = this.listFiles(file, true, string);
            if (stringArray2 == null || stringArray2.length == 0) continue;
            for (String string2 : stringArray2) {
                if (arrayList.indexOf(string2) != -1) continue;
                arrayList.add(string2);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private String[] listFiles(File file, boolean bl, String string) {
        String string2 = file.getAbsolutePath();
        Vector<String> vector = new Vector<String>();
        if (string != null && !string.startsWith(".")) {
            string = "." + string;
        }
        this.listFiles(bl ? string2 + File.separator : "", string2, string, vector);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void listFiles(String string, String string2, String string3, Vector<String> vector) {
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (String string4 : stringArray) {
                if (string4.charAt(0) == '.') continue;
                File file2 = new File(string2, string4);
                String string5 = file2.getAbsolutePath();
                if (string5.startsWith(string)) {
                    string5 = string5.substring(string.length());
                }
                if (string3 == null || string4.toLowerCase().endsWith(string3)) {
                    vector.add(string5);
                }
                if (!file2.isDirectory()) continue;
                this.listFiles(string, file2.getAbsolutePath(), string3, vector);
            }
        }
    }

    static {
        validKeys.add("crisp");
        validKeys.add("font");
        validKeys.add("globalKeyEvents");
        validKeys.add("pauseOnBlur");
        validKeys.add("preload");
        validKeys.add("transparent");
    }
}

