/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import de.bezier.mode.javascript.JavaScriptMode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.core.PApplet;
import processing.mode.java.preproc.PdePreprocessor;

public class JavaScriptBuild {
    public static final String TEMPLATE_FOLDER_NAME = "template";
    public static final String EXPORTED_FOLDER_NAME = "web-export";
    public static final String TEMPLATE_FILE_NAME = "template.html";
    public static final String IMPORT_REGEX = "^[\\s]*import[\\s]+([^\\s]+)[\\s]*";
    protected Sketch sketch;
    protected Mode mode;
    protected File binFolder;

    public static String getDocString(String string) {
        String[] stringArray = PApplet.match((String)string, (String)"/\\*{2,}(.*?)\\*+/");
        if (stringArray != null) {
            String[] stringArray2;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : stringArray2 = PApplet.split((String)stringArray[1], (char)'\n')) {
                String[] stringArray3 = PApplet.match((String)string2, (String)"^\\s*\\*+(.*)");
                stringBuffer.append(stringArray3 != null ? stringArray3[1] : string2);
                stringBuffer.append('\n');
            }
            return stringBuffer.toString().trim();
        }
        return "";
    }

    public static void writeTemplate(File file, File file2, Map<String, String> map) throws IOException {
        BufferedReader bufferedReader = PApplet.createReader((File)file);
        PrintWriter printWriter = PApplet.createWriter((File)file2);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf("@@") != -1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n = 0;
                int n2 = 0;
                while ((n = stringBuffer.indexOf("@@")) != -1) {
                    n2 = stringBuffer.indexOf("@@", n + 1);
                    if (n2 != -1) {
                        String string2 = map.get(stringBuffer.substring(n + 2, n2));
                        stringBuffer.replace(n, n2 + 2, string2 == null ? "" : string2);
                        continue;
                    }
                    Messages.showWarning((String)"Problem replacing field in template", (String)"The template appears to have an unterminated field. The output may look a little funny.");
                }
                string = stringBuffer.toString();
            }
            printWriter.println(string);
        }
        printWriter.close();
    }

    public JavaScriptBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public boolean build(File file) throws IOException, SketchException {
        String[] stringArray;
        File file2;
        Object object;
        Object object2;
        String[] stringArray2;
        int n;
        int n2;
        String string;
        String[] stringArray3;
        block28: {
            String string222;
            this.sketch.ensureExistence();
            this.binFolder = file;
            if (file.exists()) {
                Util.removeDir((File)file);
            }
            this.preprocess(file);
            if (this.sketch.hasDataFolder()) {
                try {
                    Util.copyDir((File)this.sketch.getDataFolder(), (File)file);
                }
                catch (IOException iOException) {
                    Messages.showWarning((String)"Problem building the sketch", (String)"An exception occured while trying to copy the data folder. You may have to manually move the contents of sketch/data to the web-export/ folder. Processing.js doesn't look for a data folder, so lump them together.");
                    iOException.printStackTrace();
                }
            }
            String[] stringArray4 = this.sketch.getFolder().list();
            stringArray3 = new String[]{};
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray4 != null) {
                for (String string222 : stringArray4) {
                    if (string222.toLowerCase().startsWith(".") || !string222.toLowerCase().endsWith(".js")) continue;
                    arrayList.add(string222);
                }
                if (arrayList.size() > 0) {
                    stringArray3 = arrayList.toArray(new String[0]);
                }
            }
            for (String string222 : stringArray3) {
                try {
                    Util.copyFile((File)new File(this.sketch.getFolder(), string222), (File)new File(file, string222));
                }
                catch (IOException iOException) {
                    String string3 = "Unable to copy file: " + string222;
                    Messages.showWarning((String)"Problem building the sketch", (String)string3);
                    iOException.printStackTrace();
                    return false;
                }
            }
            string = PdePreprocessor.scrubComments((String)this.sketch.getCode(0).getProgram());
            n2 = 100;
            n = 100;
            string222 = "(?:^|\\s|;)size\\s*\\(\\s*([^\\s,]+)\\s*,\\s*([^\\s,\\)]+)\\s*,?\\s*([^\\)]*)\\s*\\)\\s*\\;";
            stringArray2 = PApplet.match((String)string, (String)string222);
            if (stringArray2 != null) {
                try {
                    n2 = Integer.parseInt(stringArray2[1]);
                    n = Integer.parseInt(stringArray2[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!((JavaScriptMode)this.mode).showSizeWarning) break block28;
                    Messages.showWarning((String)"Could not find applet size", (String)"The size of this applet could not automatically be\ndetermined from your code. You'll have to edit the\nHTML file to set the size of the applet.\nUse only numeric values (not variables) for the size()\ncommand. See the size() reference for an explanation.");
                    ((JavaScriptMode)this.mode).showSizeWarning = false;
                }
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray5 = string.split("\n");
        for (String object32 : stringArray5) {
            int n3 = object32.indexOf("import");
            if (n3 == -1) continue;
            object = object2 = object32.split(";");
            int n4 = ((String[])object).length;
            for (int i = 0; i < n4; ++i) {
                String string2 = object[i];
                stringArray2 = PApplet.match((String)string2, (String)IMPORT_REGEX);
                if (stringArray2 == null || stringArray2.length < 2 || stringArray2[1] == null) continue;
                String string3 = stringArray2[1];
                if (arrayList.contains(string3 = (string3 = string3.trim()).indexOf(".*") != -1 ? string3.replace(".*", "") : string3.replaceAll("\\.[^.]+$", ""))) continue;
                arrayList.add(string3);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        if (arrayList.size() > 0 && !(file2 = new File(file, "libs")).mkdir()) {
            Messages.showWarning((String)"Error", (String)"Unable to create 'libs' in export folder.");
            return false;
        }
        for (String string6 : arrayList) {
            String string4;
            Library library = this.mode.getLibrary(string6);
            if (library == null || !((File)(object2 = new File(string4 = library.getJarPath()))).exists() || !((File)(object = new File(((File)object2).getParent(), ((File)object2).getName().replace(".jar", ".js")))).exists()) continue;
            String iOException = "libs" + File.separator + ((File)object).getName();
            File file3 = new File(file, iOException);
            if (file3.exists()) {
                System.out.println("Duplicate import!");
            }
            try {
                Util.copyFile((File)object, (File)file3);
                arrayList2.add(iOException.replaceAll(File.separator, "/"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        File file4 = this.getTemplateFile();
        File file5 = new File(file, "index.html");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("width", String.valueOf(n2));
        hashMap.put("height", String.valueOf(n));
        hashMap.put("sketch", this.sketch.getName());
        hashMap.put("description", this.getSketchDescription());
        String string5 = this.sketch.getName().replaceAll("[^a-zA-Z0-9]+", "").replaceAll("^[^a-zA-Z]+", "");
        object2 = "<script type=\"text/javascript\">\n";
        object2 = (String)object2 + "// convenience function to get the id attribute of generated sketch html element\nfunction getProcessingSketchId () { return '" + string5 + "'; }\n";
        object2 = (String)object2 + "</script>\n";
        object = arrayList2.iterator();
        while (object.hasNext()) {
            String stringArray4 = (String)object.next();
            object2 = (String)object2 + "<script type=\"text/javascript\" src=\"" + stringArray4 + "\"></script>";
        }
        object = "<a href=\"" + this.sketch.getName() + ".pde\">" + this.sketch.getName() + "</a> ";
        if (stringArray3 != null) {
            for (String string3 : stringArray3) {
                object = (String)object + "<a href=\"" + string3 + "\">" + string3 + "</a> ";
                object2 = (String)object2 + "<script src=\"" + string3 + "\" type=\"text/javascript\"></script>\n";
            }
        }
        hashMap.put("source", (String)object);
        hashMap.put("scripts", (String)object2);
        hashMap.put("id", string5);
        try {
            JavaScriptBuild.writeTemplate(file4, file5, hashMap);
        }
        catch (IOException iOException) {
            Messages.showWarning((String)"A problem occured during the build", (String)"There was a problem writing the html template to the build folder.");
            iOException.printStackTrace();
            return false;
        }
        for (String string6 : stringArray = new String[]{"processing.js"}) {
            File file6 = new File(file, string6);
            if (file6.exists()) continue;
            try {
                Util.copyFile((File)this.sketch.getMode().getContentFile(TEMPLATE_FOLDER_NAME + File.separator + string6), (File)new File(file, string6));
            }
            catch (IOException iOException) {
                String string7 = "There was a problem copying " + string6 + " to the " + "build folder. You will have to manually add " + string6 + " to the build folder before the sketch " + "will run.";
                Messages.showWarning((String)"There was a problem writing to the build folder", (String)string7);
                iOException.printStackTrace();
            }
        }
        return true;
    }

    private File getTemplateFile() {
        File file = this.sketch.getFolder();
        File file2 = new File(file, TEMPLATE_FOLDER_NAME);
        if (file2.exists() && file2.isDirectory() && file2.canRead()) {
            File file3 = new File(file, EXPORTED_FOLDER_NAME);
            try {
                Util.copyDir((File)file2, (File)file3);
                if (!new File(file3, TEMPLATE_FILE_NAME).delete()) {
                    // empty if block
                }
                return new File(file2, TEMPLATE_FILE_NAME);
            }
            catch (Exception exception) {
                String string = "";
                Messages.showWarning((String)"There was a problem copying your custom template folder", (String)string);
                exception.printStackTrace();
                return this.sketch.getMode().getContentFile(TEMPLATE_FOLDER_NAME + File.separator + TEMPLATE_FILE_NAME);
            }
        }
        return this.sketch.getMode().getContentFile(TEMPLATE_FOLDER_NAME + File.separator + TEMPLATE_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preprocess(File file) throws IOException, SketchException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Object fileNotFoundException : this.sketch.getCode()) {
            if (!fileNotFoundException.isExtension("pde")) continue;
            fileNotFoundException.setPreprocOffset(n);
            stringBuffer.append(fileNotFoundException.getProgram());
            stringBuffer.append('\n');
            n += fileNotFoundException.getLineCount();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, this.sketch.getName() + ".pde");
        String string = stringBuffer.toString();
        Util.saveFile((String)string, (File)file2);
        PdePreprocessor pdePreprocessor = new PdePreprocessor(this.sketch.getName());
        pdePreprocessor.initSketchSize(string, true);
        try {
            Object fileNotFoundException;
            fileNotFoundException = this.sketch.makeTempFolder();
            File string2 = new File((File)fileNotFoundException, this.sketch.getName() + ".java");
            try (PrintWriter n3 = new PrintWriter(new FileWriter(string2));){
                pdePreprocessor.write((Writer)n3, string, null);
            }
        }
        catch (FileNotFoundException recognitionException) {
            recognitionException.printStackTrace();
            String n2 = "Build folder disappeared or could not be written";
            throw new SketchException(n2);
        }
        catch (RecognitionException tokenStreamRecognitionException) {
            int string4 = tokenStreamRecognitionException.getLine() - 1;
            int stringArray = this.findErrorFile(string4);
            string4 -= this.sketch.getCode(stringArray).getPreprocOffset();
            String n4 = tokenStreamRecognitionException.getMessage();
            if (n4.equals("expecting RCURLY, found 'null'")) {
                throw new SketchException("Found one too many { characters without a } to match it.", stringArray, string4, tokenStreamRecognitionException.getColumn());
            }
            if (n4.indexOf("expecting RBRACK") != -1) {
                System.err.println(n4);
                throw new SketchException("Syntax error, maybe a missing ] character?", stringArray, string4, tokenStreamRecognitionException.getColumn());
            }
            if (n4.indexOf("expecting SEMI") != -1) {
                System.err.println(n4);
                throw new SketchException("Syntax error, maybe a missing semicolon?", stringArray, string4, tokenStreamRecognitionException.getColumn());
            }
            if (n4.indexOf("expecting RPAREN") != -1) {
                System.err.println(n4);
                throw new SketchException("Syntax error, maybe a missing right parenthesis?", stringArray, string4, tokenStreamRecognitionException.getColumn());
            }
            if (n4.indexOf("preproc.web_colors") != -1) {
                throw new SketchException("A web color (such as #ffcc00) must be six digits.", stringArray, string4, tokenStreamRecognitionException.getColumn(), false);
            }
            throw new SketchException(n4, stringArray, string4, tokenStreamRecognitionException.getColumn());
        }
        catch (TokenStreamRecognitionException sketchException) {
            String string2 = "^line (\\d+):(\\d+):\\s";
            String[] stringArray = PApplet.match((String)sketchException.toString(), (String)string2);
            if (stringArray != null) {
                int string5 = Integer.parseInt(stringArray[1]) - 1;
                int n2 = Integer.parseInt(stringArray[2]);
                int n3 = 0;
                for (int i = 1; i < this.sketch.getCodeCount(); ++i) {
                    SketchCode sketchCode = this.sketch.getCode(i);
                    if (!sketchCode.isExtension("pde") || sketchCode.getPreprocOffset() >= string5) continue;
                    n3 = i;
                }
                throw new SketchException(sketchException.getMessage(), n3, string5 -= this.sketch.getCode(n3).getPreprocOffset(), n2);
            }
            String string3 = sketchException.toString();
            throw new SketchException(string3, 0, -1, -1);
        }
        catch (SketchException exception) {
            throw exception;
        }
        catch (Exception exception) {
            System.err.println("Uncaught exception type:" + exception.getClass());
            exception.printStackTrace();
            throw new SketchException(exception.toString());
        }
    }

    protected int findErrorFile(int n) {
        for (int i = this.sketch.getCodeCount() - 1; i > 0; --i) {
            SketchCode sketchCode = this.sketch.getCode(i);
            if (!sketchCode.isExtension("pde") || sketchCode.getPreprocOffset() >= n) continue;
            return i;
        }
        return 0;
    }

    public String getSketchDescription() {
        return JavaScriptBuild.getDocString(this.sketch.getCode(0).getProgram());
    }

    public boolean export() throws IOException, SketchException {
        File file = new File(this.sketch.getFolder(), EXPORTED_FOLDER_NAME);
        return this.build(file);
    }
}

