/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.DirectivesEditor;
import de.bezier.mode.javascript.JavaScriptMode;
import de.bezier.mode.javascript.JavaScriptToolbar;
import de.bezier.mode.javascript.ServingEditor;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import processing.app.Base;
import processing.app.Formatter;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Settings;
import processing.app.Sketch;
import processing.app.Util;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.app.ui.EditorToolbar;
import processing.app.ui.Toolkit;
import processing.mode.java.AutoFormat;

public class JavaScriptEditor
extends ServingEditor {
    static final String PROP_KEY_MODE = "mode";
    static final String PROP_VAL_MODE = "JavaScript";
    private JavaScriptMode jsMode;
    private DirectivesEditor directivesEditor;

    protected JavaScriptEditor(Base base, String string, EditorState editorState, Mode mode) throws EditorException {
        super(base, string, editorState, mode);
        this.jsMode = (JavaScriptMode)mode;
    }

    public EditorToolbar createToolbar() {
        return new JavaScriptToolbar((Editor)this);
    }

    public Formatter createFormatter() {
        return new AutoFormat();
    }

    public JMenu buildFileMenu() {
        JMenuItem jMenuItem = Toolkit.newJMenuItem((String)"Export", (int)69);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleExport(true);
            }
        });
        return this.buildFileMenu(new JMenuItem[]{jMenuItem});
    }

    public JMenu buildSketchMenu() {
        JMenuItem jMenuItem = Toolkit.newJMenuItem((String)"Run in Browser", (int)82);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleStartServer();
            }
        });
        JMenuItem jMenuItem2 = Toolkit.newJMenuItem((String)"Reopen in Browser", (int)66);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleOpenInBrowser();
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Stop");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleStopServer();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3});
    }

    public JMenu buildModeMenu() {
        JMenu jMenu = new JMenu(PROP_VAL_MODE);
        JMenuItem jMenuItem = new JMenuItem("Playback Settings (Directives)");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleShowDirectivesEditor();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Copy Server Address");
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleCopyServerAddress();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Set Server Port");
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleSetServerPort();
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Start Custom Template");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleCreateCustomTemplate();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Custom Template");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleOpenCustomTemplateFolder();
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenu buildHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("QuickStart for Processing Devs");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.openURL((String)"http://processingjs.org/articles/p5QuickStart.html");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("QuickStart for JavaScript Devs");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.openURL((String)"http://processingjs.org/articles/jsQuickStart.html");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reference");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.openURL((String)"http://processingjs.org/reference/");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = Toolkit.newJMenuItemShift((String)"Find in Reference", (int)70);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaScriptEditor.this.handleFindReference();
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Visit Processingjs.org");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.openURL((String)"http://processingjs.org/");
            }
        });
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Report a JavaScriptMode bug");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Platform.openURL((String)"https://github.com/fjenett/javascript-mode-processing/issues");
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public String getCommentPrefix() {
        return "//";
    }

    public void internalCloseRunner() {
        this.handleStopServer();
        if (this.directivesEditor != null) {
            this.directivesEditor.hide();
            this.directivesEditor = null;
        }
    }

    public void deactivateRun() {
    }

    private void handleSetServerPort() {
        this.statusEmpty();
        boolean bl = this.serverRunning();
        if (bl) {
            this.statusNotice("Server was running, changing the port requires a restart.");
            this.stopServer();
        }
        this.setServerPort();
        this.saveSketchSettings();
        if (bl) {
            this.startServer(this.getExportFolder());
        }
    }

    private void handleCreateCustomTemplate() {
        Sketch sketch = this.getSketch();
        File file = sketch.getMode().getContentFile("template");
        File file2 = this.getCustomTemplateFolder();
        if (!file2.exists()) {
            try {
                Util.copyDir((File)file, (File)file2);
                this.statusNotice("Default template copied.");
                Platform.openFolder((File)file2);
            }
            catch (IOException iOException) {
                Messages.showWarning((String)"Copy default template folder", (String)"Something went wrong when copying the template folder.", (Throwable)iOException);
            }
        } else {
            this.statusError("You need to remove the current \"template\" folder from the sketch.");
        }
    }

    private void handleOpenCustomTemplateFolder() {
        File file = this.getCustomTemplateFolder();
        if (file.exists()) {
            Platform.openFolder((File)file);
        } else {
            this.statusNotice("You have no custom template with this sketch. Create one from the menu!");
        }
    }

    private void handleCopyServerAddress() {
        String string = this.getServerAddress();
        if (string != null) {
            StringSelection stringSelection = new StringSelection(string);
            Clipboard clipboard = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private void handleShowDirectivesEditor() {
        if (this.directivesEditor == null) {
            this.directivesEditor = new DirectivesEditor(this);
        }
        this.directivesEditor.show();
    }

    public void showReference(String string) {
        File file = new File(this.jsMode.getDefaultMode().getReferenceFolder(), string);
        Platform.openURL((String)file.toURI().toString());
    }

    public void handleStartServer() {
        this.statusEmpty();
        if (!this.startServer(this.getExportFolder())) {
            if (!this.handleExport(false)) {
                return;
            }
            this.toolbar.activateRun();
        }
    }

    private void handleOpenInBrowser() {
        this.openBrowserForServer();
    }

    public void handleStopServer() {
        this.stopServer();
        this.toolbar.deactivateRun();
    }

    public boolean handleExport(boolean bl) {
        if (!this.handleExportCheckModifiedMod()) {
            return false;
        }
        try {
            boolean bl2 = this.jsMode.handleExport(this.sketch);
            if (bl2 && bl) {
                File file = new File(this.sketch.getFolder(), "web-export");
                Platform.openFolder((File)file);
                this.statusNotice("Finished exporting.");
            } else if (!bl2) {
                return false;
            }
        }
        catch (Exception exception) {
            this.statusError(exception);
            return false;
        }
        return true;
    }

    public boolean handleSave(boolean bl) {
        if (this.sketch.isUntitled()) {
            return this.handleSaveAs();
        }
        if (bl) {
            this.handleSave();
            this.statusEmpty();
            if (this.serverRunning()) {
                this.handleStartServer();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaScriptEditor.this.handleSave();
                    JavaScriptEditor.this.statusEmpty();
                    if (JavaScriptEditor.this.serverRunning()) {
                        JavaScriptEditor.this.handleStartServer();
                    }
                }
            });
        }
        return true;
    }

    public void handleSave() {
        this.handleSaveImpl();
    }

    private boolean handleExportCheckModifiedMod() {
        if (this.sketch.isModified()) {
            Object[] objectArray = new Object[]{"OK", "Cancel"};
            int n = JOptionPane.showOptionDialog((Component)((Object)this), "Save changes before export?", "Save", 2, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.handleSave(true);
            } else {
                this.statusNotice("Export canceled, changes must first be saved.");
                return false;
            }
        }
        return true;
    }

    public boolean handleSaveAs() {
        boolean bl = super.handleSaveAs();
        return bl;
    }

    public void handleImportLibrary(String string) {
        this.sketch.ensureExistence();
        if (this.mode.isDefaultExtension(this.sketch.getCurrentCode())) {
            this.sketch.setCurrentCode(0);
        }
        String[] stringArray = Util.packageListFromClassPath((String)string).array();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("import ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(".*;\n");
        }
        stringBuffer.append('\n');
        stringBuffer.append(this.getText());
        this.setText(stringBuffer.toString());
        this.setSelection(0, 0);
        this.sketch.setModified(true);
    }

    @Override
    public void serverStarted() {
        super.serverStarted();
        if (!this.handleExport(false)) {
            return;
        }
        this.toolbar.activateRun();
    }

    private File getExportFolder() {
        return new File(this.getSketch().getFolder(), "web-export");
    }

    private File getCustomTemplateFolder() {
        return new File(this.getSketch().getFolder(), "template");
    }

    private void saveSketchSettings() {
        Settings settings;
        this.statusEmpty();
        File file = this.getSketchPropertiesFile();
        try {
            settings = new Settings(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (settings == null) {
            this.statusError("Unable to create sketch properties file!");
            return;
        }
        settings.set(PROP_KEY_MODE, PROP_VAL_MODE);
        int n = this.getServerPort();
        if (n > 0) {
            settings.set("basicserver.port", n + "");
        }
        settings.save();
    }
}

