/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.BasicServer;
import de.bezier.mode.javascript.HttpConstants;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Hashtable;

class Worker
extends BasicServer
implements HttpConstants,
Runnable {
    static final int BUF_SIZE = 2048;
    static final byte[] EOL = new byte[]{13, 10};
    byte[] buf = new byte[2048];
    private Socket socket = null;
    private boolean stopping = false;
    static Hashtable map = new Hashtable();

    Worker(File file) {
        super(file);
    }

    synchronized void setSocket(Socket socket) {
        this.socket = socket;
        this.notify();
    }

    synchronized void stop() {
        this.stopping = true;
        this.notify();
    }

    @Override
    public synchronized void run() {
        while (!this.stopping) {
            if (this.socket == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            if (this.socket != null && !this.stopping) {
                try {
                    this.handleClient();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.socket = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClient() throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.socket.getInputStream());
        PrintStream printStream = new PrintStream(this.socket.getOutputStream());
        this.socket.setSoTimeout(this.getTimeout());
        this.socket.setTcpNoDelay(true);
        for (n = 0; n < 2048; ++n) {
            this.buf[n] = 0;
        }
        try {
            int n2;
            int n3;
            n = 0;
            int n4 = 0;
            block6: while (n < 2048) {
                n4 = ((InputStream)bufferedInputStream).read(this.buf, n, 2048 - n);
                if (n4 == -1) {
                    return;
                }
                n3 = n;
                n += n4;
                while (n3 < n) {
                    if (this.buf[n3] == 10 || this.buf[n3] == 13) break block6;
                    ++n3;
                }
            }
            if (this.buf[0] == 71 && this.buf[1] == 69 && this.buf[2] == 84 && this.buf[3] == 32) {
                n3 = 1;
                n2 = 4;
            } else if (this.buf[0] == 72 && this.buf[1] == 69 && this.buf[2] == 65 && this.buf[3] == 68 && this.buf[4] == 32) {
                n3 = 0;
                n2 = 5;
            } else {
                printStream.print("HTTP/1.0 405 unsupported method type: ");
                printStream.write(this.buf, 0, 5);
                printStream.write(EOL);
                printStream.flush();
                this.socket.close();
                return;
            }
            int n5 = 0;
            for (n5 = n2; n5 < n && this.buf[n5] != 32; ++n5) {
            }
            String string = new String(this.buf, n2, n5 - n2).replace('/', File.separatorChar);
            if (string.startsWith(File.separator)) {
                string = string.substring(1);
            }
            if ((string = URLDecoder.decode(string, "UTF-8")).startsWith("logger?")) {
                System.out.println(string.substring(7));
            } else {
                File file;
                File file2 = new File(this.getRoot(), string);
                if (file2.isDirectory() && (file = new File(file2, "index.html")).exists()) {
                    file2 = file;
                }
                boolean bl = this.printHeaders(file2, printStream);
                if (n3 != 0) {
                    if (bl) {
                        this.sendFile(file2, printStream);
                    } else {
                        this.send404(file2, printStream);
                    }
                }
            }
        }
        finally {
            this.socket.close();
        }
    }

    boolean printHeaders(File file, PrintStream printStream) throws IOException {
        boolean bl = false;
        if (!file.exists()) {
            printStream.print("HTTP/1.0 404 not found");
            printStream.write(EOL);
            bl = false;
        } else {
            printStream.print("HTTP/1.0 200 OK");
            printStream.write(EOL);
            bl = true;
        }
        printStream.print("Server: Processing/2.0");
        printStream.write(EOL);
        printStream.print("Date: " + new Date());
        printStream.write(EOL);
        if (bl) {
            if (!file.isDirectory()) {
                printStream.print("Content-length: " + file.length());
                printStream.write(EOL);
                printStream.print("Last Modified: " + new Date(file.lastModified()));
                printStream.write(EOL);
                String string = file.getName();
                int n = string.lastIndexOf(46);
                String string2 = null;
                if (n > 0) {
                    string2 = (String)map.get(string.substring(n));
                }
                if (string2 == null) {
                    string2 = "unknown/unknown";
                }
                printStream.print("Content-type: " + string2);
                printStream.write(EOL);
            } else {
                printStream.print("Content-type: text/html");
                printStream.write(EOL);
            }
        }
        return bl;
    }

    void send404(File file, PrintStream printStream) throws IOException {
        printStream.write(EOL);
        printStream.write(EOL);
        printStream.println("Not Found\n\nThe requested resource was not found.\n");
    }

    void listDirectory(File file, PrintStream printStream) throws IOException {
        printStream.println("<TITLE>Directory listing</TITLE><P>\n");
        printStream.println("<A HREF=\"..\">Parent Directory</A><BR>\n");
        String[] stringArray = file.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                printStream.println("<A HREF=\"" + stringArray[i] + "/\">" + stringArray[i] + "/</A><BR>");
                continue;
            }
            printStream.println("<A HREF=\"" + stringArray[i] + "\">" + stringArray[i] + "</A><BR");
        }
        printStream.println("<P><HR><BR><I>" + new Date() + "</I>");
    }

    void logAndSendNop(PrintStream printStream) throws IOException {
        printStream.write(EOL);
        printStream.write(EOL);
        printStream.println("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFile(File file, PrintStream printStream) throws IOException {
        FileInputStream fileInputStream = null;
        printStream.write(EOL);
        if (file.isDirectory()) {
            this.listDirectory(file, printStream);
            return;
        }
        fileInputStream = new FileInputStream(file.getAbsolutePath());
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(this.buf)) > 0) {
                printStream.write(this.buf, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    static void setSuffix(String string, String string2) {
        map.put(string, string2);
    }

    static void fillMap() {
        Worker.setSuffix("", "content/unknown");
        Worker.setSuffix(".3dm", "x-world/x-3dmf");
        Worker.setSuffix(".3dmf", "x-world/x-3dmf");
        Worker.setSuffix(".ai", "application/pdf");
        Worker.setSuffix(".aif", "audio/x-aiff");
        Worker.setSuffix(".aifc", "audio/x-aiff");
        Worker.setSuffix(".aiff", "audio/x-aiff");
        Worker.setSuffix(".asc", "text/plain");
        Worker.setSuffix(".asd", "application/astound");
        Worker.setSuffix(".asn", "application/astound");
        Worker.setSuffix(".atom", "application/atom+xml");
        Worker.setSuffix(".au", "audio/basic");
        Worker.setSuffix(".avi", "video/x-msvideo");
        Worker.setSuffix(".avi", "video/x-msvideo");
        Worker.setSuffix(".bcpio", "application/x-bcpio");
        Worker.setSuffix(".bin", "application/octet-stream");
        Worker.setSuffix(".bmp", "image/bmp");
        Worker.setSuffix(".c", "text/plain");
        Worker.setSuffix(".c++", "text/plain");
        Worker.setSuffix(".cab", "application/x-shockwave-flash");
        Worker.setSuffix(".cc", "text/plain");
        Worker.setSuffix(".cdf", "application/x-netcdf");
        Worker.setSuffix(".cgm", "image/cgm");
        Worker.setSuffix(".chm", "application/mshelp");
        Worker.setSuffix(".cht", "audio/x-dspeeh");
        Worker.setSuffix(".class", "application/octet-stream");
        Worker.setSuffix(".cod", "image/cis-cod");
        Worker.setSuffix(".coffee", "text/coffeescript");
        Worker.setSuffix(".com", "application/octet-stream");
        Worker.setSuffix(".cpio", "application/x-cpio");
        Worker.setSuffix(".cpt", "application/mac-compactpro");
        Worker.setSuffix(".csh", "application/x-csh");
        Worker.setSuffix(".css", "text/css");
        Worker.setSuffix(".csv", "text/comma-separated-values");
        Worker.setSuffix(".dcr", "application/x-director");
        Worker.setSuffix(".dif", "video/x-dv");
        Worker.setSuffix(".dir", "application/x-director");
        Worker.setSuffix(".djv", "image/vnd.djvu");
        Worker.setSuffix(".djvu", "image/vnd.djvu");
        Worker.setSuffix(".dll", "application/octet-stream");
        Worker.setSuffix(".dmg", "application/octet-stream");
        Worker.setSuffix(".dms", "application/octet-stream");
        Worker.setSuffix(".doc", "application/msword");
        Worker.setSuffix(".dot", "application/msword");
        Worker.setSuffix(".dtd", "application/xml-dtd");
        Worker.setSuffix(".dus", "audio/x-dspeeh");
        Worker.setSuffix(".dv", "video/x-dv");
        Worker.setSuffix(".dvi", "application/x-dvi");
        Worker.setSuffix(".dwf", "drawing/x-dwf");
        Worker.setSuffix(".dwg", "application/acad");
        Worker.setSuffix(".dxf", "application/dxf");
        Worker.setSuffix(".dxr", "application/x-director");
        Worker.setSuffix(".eps", "application/pdf");
        Worker.setSuffix(".es", "audio/echospeech");
        Worker.setSuffix(".etx", "text/x-setext");
        Worker.setSuffix(".etx", "text/x-setext");
        Worker.setSuffix(".evy", "application/x-envoy");
        Worker.setSuffix(".exe", "application/octet-stream");
        Worker.setSuffix(".ez", "application/andrew-inset");
        Worker.setSuffix(".fh4", "image/x-freehand");
        Worker.setSuffix(".fh5", "image/x-freehand");
        Worker.setSuffix(".fhc", "image/x-freehand");
        Worker.setSuffix(".fif", "image/fif");
        Worker.setSuffix(".gif", "image/gif");
        Worker.setSuffix(".gram", "application/srgs");
        Worker.setSuffix(".grxml", "application/srgs+xml");
        Worker.setSuffix(".gtar", "application/x-gtar");
        Worker.setSuffix(".gtar", "application/x-gtar");
        Worker.setSuffix(".gz", "application/gzip");
        Worker.setSuffix(".h", "text/plain");
        Worker.setSuffix(".hdf", "application/x-hdf");
        Worker.setSuffix(".hlp", "application/mshelp");
        Worker.setSuffix(".hqx", "application/mac-binhex40");
        Worker.setSuffix(".htm", "text/html");
        Worker.setSuffix(".html", "text/html");
        Worker.setSuffix(".ice", "x-conference/x-cooltalk");
        Worker.setSuffix(".ico", "image/x-icon");
        Worker.setSuffix(".ics", "text/calendar");
        Worker.setSuffix(".ief", "image/ief");
        Worker.setSuffix(".ifb", "text/calendar");
        Worker.setSuffix(".iges", "model/iges");
        Worker.setSuffix(".igs", "model/iges");
        Worker.setSuffix(".java", "text/plain");
        Worker.setSuffix(".jnlp", "application/x-java-jnlp-file");
        Worker.setSuffix(".jp2", "image/jp2");
        Worker.setSuffix(".jpe", "image/jpeg");
        Worker.setSuffix(".jpeg", "image/jpeg");
        Worker.setSuffix(".jpg", "image/jpeg");
        Worker.setSuffix(".js", "text/javascript");
        Worker.setSuffix(".kar", "audio/midi");
        Worker.setSuffix(".latex", "application/x-latex");
        Worker.setSuffix(".latex", "application/x-latex");
        Worker.setSuffix(".lha", "application/octet-stream");
        Worker.setSuffix(".lzh", "application/octet-stream");
        Worker.setSuffix(".m3u", "audio/x-mpegurl");
        Worker.setSuffix(".m4a", "audio/mp4a-latm");
        Worker.setSuffix(".m4b", "audio/mp4a-latm");
        Worker.setSuffix(".m4p", "audio/mp4a-latm");
        Worker.setSuffix(".m4u", "video/vnd.mpegurl");
        Worker.setSuffix(".m4v", "video/m4v");
        Worker.setSuffix(".mac", "image/x-macpaint");
        Worker.setSuffix(".man", "application/x-troff-man");
        Worker.setSuffix(".mathml", "application/mathml+xml");
        Worker.setSuffix(".mbd", "application/mbedlet");
        Worker.setSuffix(".mcf", "image/vasa");
        Worker.setSuffix(".me", "application/x-troff-me");
        Worker.setSuffix(".mesh", "model/mesh");
        Worker.setSuffix(".mid", "audio/midi");
        Worker.setSuffix(".midi", "audio/midi");
        Worker.setSuffix(".mif", "application/mif");
        Worker.setSuffix(".mov", "video/quicktime");
        Worker.setSuffix(".movie", "video/x-sgi-movie");
        Worker.setSuffix(".mp2", "audio/mpeg");
        Worker.setSuffix(".mp3", "audio/mpeg");
        Worker.setSuffix(".mp4", "video/mp4");
        Worker.setSuffix(".mpe", "video/mpeg");
        Worker.setSuffix(".mpeg", "video/mpeg");
        Worker.setSuffix(".mpg", "video/mpeg");
        Worker.setSuffix(".mpga", "audio/mpeg");
        Worker.setSuffix(".ms", "application/x-troff-ms");
        Worker.setSuffix(".msh", "model/mesh");
        Worker.setSuffix(".mxu", "video/vnd.mpegurl");
        Worker.setSuffix(".nc", "application/x-netcdf");
        Worker.setSuffix(".nsc", "application/x-nschat");
        Worker.setSuffix(".oda", "application/oda");
        Worker.setSuffix(".oga", "audio/ogg");
        Worker.setSuffix(".ogg", "application/ogg");
        Worker.setSuffix(".ogv", "video/ogg");
        Worker.setSuffix(".pbm", "image/x-portable-bitmap");
        Worker.setSuffix(".pct", "image/pict");
        Worker.setSuffix(".pdb", "chemical/x-pdb");
        Worker.setSuffix(".pde", "text/plain");
        Worker.setSuffix(".pdf", "application/pdf");
        Worker.setSuffix(".pgm", "image/x-portable-graymap");
        Worker.setSuffix(".pgn", "application/x-chess-pgn");
        Worker.setSuffix(".php", "application/x-httpd-php");
        Worker.setSuffix(".phtml", "application/x-httpd-php");
        Worker.setSuffix(".pic", "image/pict");
        Worker.setSuffix(".pict", "image/pict");
        Worker.setSuffix(".pl", "text/plain");
        Worker.setSuffix(".png", "image/png");
        Worker.setSuffix(".pnm", "image/x-portable-anymap");
        Worker.setSuffix(".pnt", "image/x-macpaint");
        Worker.setSuffix(".pntg", "image/x-macpaint");
        Worker.setSuffix(".pot", "application/mspowerpoint");
        Worker.setSuffix(".ppm", "image/x-portable-pixmap");
        Worker.setSuffix(".pps", "application/mspowerpoint");
        Worker.setSuffix(".ppt", "application/mspowerpoint");
        Worker.setSuffix(".ppz", "application/mspowerpoint");
        Worker.setSuffix(".ps", "application/postscript");
        Worker.setSuffix(".ps", "application/postscript");
        Worker.setSuffix(".ptlk", "application/listenup");
        Worker.setSuffix(".qd3", "x-world/x-3dmf");
        Worker.setSuffix(".qd3d", "x-world/x-3dmf");
        Worker.setSuffix(".qt", "video/quicktime");
        Worker.setSuffix(".qti", "image/x-quicktime");
        Worker.setSuffix(".qtif", "image/x-quicktime");
        Worker.setSuffix(".ra", "audio/x-pn-realaudio");
        Worker.setSuffix(".ra", "audio/x-pn-realaudio");
        Worker.setSuffix(".ram", "audio/x-mpeg");
        Worker.setSuffix(".ras", "image/cmu-raster");
        Worker.setSuffix(".rdf", "application/rdf+xml");
        Worker.setSuffix(".rgb", "image/x-rgb");
        Worker.setSuffix(".rm", "application/vnd.rn-realmedia");
        Worker.setSuffix(".roff", "application/x-troff");
        Worker.setSuffix(".rpm", "audio/x-pn-realaudio-plugin");
        Worker.setSuffix(".rtc", "application/rtc");
        Worker.setSuffix(".rtf", "text/rtf");
        Worker.setSuffix(".rtx", "text/richtext");
        Worker.setSuffix(".sca", "application/x-supercard");
        Worker.setSuffix(".sgm", "text/sgml");
        Worker.setSuffix(".sgml", "text/sgml");
        Worker.setSuffix(".sh", "application/x-sh");
        Worker.setSuffix(".shar", "application/x-shar");
        Worker.setSuffix(".shtml", "text/html");
        Worker.setSuffix(".silo", "model/mesh");
        Worker.setSuffix(".sit", "application/x-stuffit");
        Worker.setSuffix(".skd", "application/x-koan");
        Worker.setSuffix(".skm", "application/x-koan");
        Worker.setSuffix(".skp", "application/x-koan");
        Worker.setSuffix(".skt", "application/x-koan");
        Worker.setSuffix(".smi", "application/smil");
        Worker.setSuffix(".smil", "application/smil");
        Worker.setSuffix(".smp", "application/studiom");
        Worker.setSuffix(".snd", "audio/basic");
        Worker.setSuffix(".so", "application/octet-stream");
        Worker.setSuffix(".spc", "text/x-speech");
        Worker.setSuffix(".spl", "application/futuresplash");
        Worker.setSuffix(".spr", "application/x-sprite");
        Worker.setSuffix(".sprite", "application/x-sprite");
        Worker.setSuffix(".src", "application/x-wais-source");
        Worker.setSuffix(".stream", "audio/x-qt-stream");
        Worker.setSuffix(".sv4cpio", "application/x-sv4cpio");
        Worker.setSuffix(".sv4crc", "application/x-sv4crc");
        Worker.setSuffix(".svg", "image/svg+xml");
        Worker.setSuffix(".swf", "application/x-shockwave-flash");
        Worker.setSuffix(".t", "application/x-troff");
        Worker.setSuffix(".talk", "text/x-speech");
        Worker.setSuffix(".tar", "application/x-tar");
        Worker.setSuffix(".tbk", "application/toolbook");
        Worker.setSuffix(".tcl", "application/x-tcl");
        Worker.setSuffix(".tex", "application/x-tex");
        Worker.setSuffix(".texi", "application/x-texinfo");
        Worker.setSuffix(".texinfo", "text/plain");
        Worker.setSuffix(".text", "text/plain");
        Worker.setSuffix(".tif", "image/tiff");
        Worker.setSuffix(".tiff", "image/tiff");
        Worker.setSuffix(".tr", "application/x-troff");
        Worker.setSuffix(".troff", "application/x-troff-man");
        Worker.setSuffix(".tsi", "audio/tsplayer");
        Worker.setSuffix(".tsp", "application/dsptype");
        Worker.setSuffix(".tsv", "text/tab-separated-values");
        Worker.setSuffix(".tsv", "text/tab-separated-values");
        Worker.setSuffix(".txt", "text/plain");
        Worker.setSuffix(".ustar", "application/x-ustar");
        Worker.setSuffix(".uu", "application/octet-stream");
        Worker.setSuffix(".vcd", "application/x-cdlink");
        Worker.setSuffix(".viv", "video/vnd.vivo");
        Worker.setSuffix(".vivo", "video/vnd.vivo");
        Worker.setSuffix(".vmd", "application/vocaltec-media-desc");
        Worker.setSuffix(".vmf", "application/vocaltec-media-file");
        Worker.setSuffix(".vox", "audio/voxware");
        Worker.setSuffix(".vrml", "model/vrml");
        Worker.setSuffix(".vts", "workbook/formulaone");
        Worker.setSuffix(".vtts", "workbook/formulaone");
        Worker.setSuffix(".vxml", "application/voicexml+xml");
        Worker.setSuffix(".wav", "audio/x-wav");
        Worker.setSuffix(".wav", "audio/x-wav");
        Worker.setSuffix(".wbmp", "image/vnd.wap.wbmp");
        Worker.setSuffix(".wbmxl", "application/vnd.wap.wbxml");
        Worker.setSuffix(".webm", "video/webm");
        Worker.setSuffix(".wml", "text/vnd.wap.wml");
        Worker.setSuffix(".wmlc", "application/vnd.wap.wmlc");
        Worker.setSuffix(".wmls", "text/vnd.wap.wmlscript");
        Worker.setSuffix(".wmlsc", "application/vnd.wap.wmlscriptc");
        Worker.setSuffix(".wrl", "model/vrml");
        Worker.setSuffix(".xbm", "image/x-xbitmap");
        Worker.setSuffix(".xht", "application/xhtml+xml");
        Worker.setSuffix(".xhtml", "application/xhtml+xml");
        Worker.setSuffix(".xla", "application/msexcel");
        Worker.setSuffix(".xls", "application/msexcel");
        Worker.setSuffix(".xml", "text/xml");
        Worker.setSuffix(".xpm", "image/x-xpixmap");
        Worker.setSuffix(".xsl", "application/xml");
        Worker.setSuffix(".xslt", "application/xslt+xml");
        Worker.setSuffix(".xul", "application/vnd.mozilla.xul+xml");
        Worker.setSuffix(".xwd", "image/x-windowdump");
        Worker.setSuffix(".xyz", "chemical/x-xyz");
        Worker.setSuffix(".z", "application/x-compress");
        Worker.setSuffix(".zip", "application/zip");
    }

    static {
        Worker.fillMap();
    }
}

