/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import processing.app.Util;
import processing.data.StringList;
import processing.mode.java.pdex.ErrorCheckerService;
import processing.mode.java.pdex.ImportStatement;
import processing.mode.java.preproc.PdePreprocessor;

public class XQPreprocessor {
    private ASTRewrite rewrite = null;
    private List<ImportStatement> extraImports;
    private ErrorCheckerService ecs;
    private String[] coreImports;
    private String[] defaultImports;

    public XQPreprocessor(ErrorCheckerService ecs) {
        this.ecs = ecs;
        PdePreprocessor p = new PdePreprocessor(null);
        this.defaultImports = p.getDefaultImports();
        this.coreImports = p.getCoreImports();
    }

    protected String handle(String source, List<ImportStatement> programImports) {
        this.extraImports = programImports;
        Document doc = new Document(source);
        ASTParser parser = ASTParser.newParser((int)8);
        parser.setSource(doc.get().toCharArray());
        parser.setKind(8);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        options.put("org.eclipse.jdt.core.compiler.source", "1.8");
        parser.setCompilerOptions((Map)options);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        cu.recordModifications();
        this.rewrite = ASTRewrite.create((AST)cu.getAST());
        cu.accept((ASTVisitor)new XQVisitor());
        TextEdit edits = cu.rewrite((IDocument)doc, null);
        try {
            edits.apply((IDocument)doc);
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return doc.get();
    }

    protected String prepareImports(List<ImportStatement> programImports) {
        this.extraImports = programImports;
        StringList imports = new StringList();
        for (ImportStatement importStatement : this.extraImports) {
            imports.append(importStatement.getImportName());
        }
        imports.append("// Default Imports");
        Object object = this.coreImports;
        int n = this.coreImports.length;
        int n2 = 0;
        while (n2 < n) {
            String string = object[n2];
            imports.append("import " + string + ";");
            ++n2;
        }
        object = this.defaultImports;
        n = this.defaultImports.length;
        n2 = 0;
        while (n2 < n) {
            String string = object[n2];
            imports.append("import " + string + ";");
            ++n2;
        }
        if (this.ecs.getEditor().getSketch().getCodeFolder().exists()) {
            Object var3_11 = null;
            String codeFolderClassPath = Util.contentsToClassPath((File)this.ecs.getEditor().getSketch().getCodeFolder());
            StringList stringList = Util.packageListFromClassPath((String)codeFolderClassPath);
            if (stringList != null) {
                this.ecs.codeFolderImports.clear();
                for (String item : stringList) {
                    imports.append("import " + item + ".*;");
                    this.ecs.codeFolderImports.add(new ImportStatement("import " + item + ".*;", 0, 0));
                }
            }
        }
        return String.valueOf(imports.join("\n")) + "\n";
    }

    private class XQVisitor
    extends ASTVisitor {
        private XQVisitor() {
        }

        public boolean visit(MethodDeclaration node) {
            node.getReturnType2();
            if (node.modifiers().size() == 0 && !node.isConstructor()) {
                List newMod = XQPreprocessor.this.rewrite.getAST().newModifiers(1);
                node.modifiers().add(newMod.get(0));
            }
            return true;
        }

        public boolean visit(NumberLiteral node) {
            String lower = node.getToken().toLowerCase();
            if (!lower.endsWith("f") && !lower.endsWith("d")) {
                int i = 0;
                while (i < node.getToken().length()) {
                    if (node.getToken().charAt(i) == '.') {
                        String s = String.valueOf(node.getToken()) + "f";
                        node.setToken(s);
                        break;
                    }
                    ++i;
                }
            }
            return true;
        }
    }
}

