/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.JavaScriptBuild;
import de.bezier.mode.javascript.JavaScriptEditor;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import processing.app.Base;
import processing.app.Library;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Sketch;
import processing.app.SketchException;
import processing.app.ui.Editor;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.mode.java.JavaMode;

public class JavaScriptMode
extends JavaMode {
    public boolean showSizeWarning = true;
    private JavaScriptEditor jsEditor;
    private JavaMode defaultJavaMode;

    public JavaScriptMode(Base base, File file) {
        super(base, file);
    }

    public Editor createEditor(Base base, String string, EditorState editorState) throws EditorException {
        this.jsEditor = new JavaScriptEditor(base, string, editorState, (Mode)this);
        return this.jsEditor;
    }

    public Editor getEditor() {
        return this.jsEditor;
    }

    public JavaMode getDefaultMode() {
        if (this.defaultJavaMode == null) {
            for (Mode mode : this.base.getModeList()) {
                if (mode.getClass() != JavaMode.class) continue;
                this.defaultJavaMode = (JavaMode)mode;
                break;
            }
        }
        return this.defaultJavaMode;
    }

    public File[] getKeywordFiles() {
        return new File[]{Platform.getContentFile((String)"modes/java/keywords.txt"), new File(this.folder, "keywords.txt")};
    }

    public String getTitle() {
        return "JavaScript";
    }

    public File[] getExampleCategoryFolders() {
        int n;
        Object[] objectArray = this.examplesFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        Arrays.sort(objectArray);
        JavaMode javaMode = this.getDefaultMode();
        if (javaMode == null) {
            return objectArray;
        }
        File file = javaMode.getContentFile("examples");
        File[] fileArray = new File[]{new File(file, "Basics")};
        Object[] objectArray2 = new File[objectArray.length + fileArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray2[n] = objectArray[n];
        }
        for (n = 0; n < fileArray.length; ++n) {
            objectArray2[objectArray.length + n] = fileArray[n];
        }
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    public String getDefaultExtension() {
        return "pde";
    }

    public String[] getExtensions() {
        return new String[]{"pde", "js"};
    }

    public String[] getIgnorable() {
        return new String[]{"applet", "applet_js", "web-export"};
    }

    public Library getLibrary(String string) throws SketchException {
        return super.getLibrary(string);
    }

    public boolean handleExport(Sketch sketch) throws IOException, SketchException {
        JavaScriptBuild javaScriptBuild = new JavaScriptBuild(sketch);
        return javaScriptBuild.export();
    }
}

