/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.BasicServer;
import de.bezier.mode.javascript.BasicServerListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Settings;
import processing.app.ui.EditorException;
import processing.app.ui.EditorState;
import processing.mode.java.JavaEditor;

public abstract class ServingEditor
extends JavaEditor
implements BasicServerListener {
    public static final String PROP_KEY_SERVER_PORT = "basicserver.port";
    BasicServer server;
    public boolean showSizeWarning = true;

    protected ServingEditor(Base base, String string, EditorState editorState, Mode mode) throws EditorException {
        super(base, string, editorState, mode);
    }

    protected void setServerPort() {
        File file;
        String string = null;
        String string2 = "Set the server port (1024 < port < 65535)";
        int n = -1;
        if (this.server != null) {
            n = this.server.getPort();
        }
        if ((string = n > 0 ? JOptionPane.showInputDialog(string2, (Object)(n + "")) : JOptionPane.showInputDialog(string2)) == null) {
            return;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.statusError("That number was not okay ..");
            return;
        }
        if (n2 < 0 || n2 > 49151) {
            this.statusError("That port number is out of range");
            return;
        }
        if (this.server != null) {
            this.server.setPort(n2);
        }
        if ((file = this.getSketchPropertiesFile()).exists()) {
            try {
                Settings settings = new Settings(file);
                settings.set(PROP_KEY_SERVER_PORT, n2 + "");
                settings.save();
            }
            catch (IOException iOException) {
                this.statusError(iOException);
            }
        }
    }

    public int getServerPort() {
        if (this.server != null) {
            return this.server.getPort();
        }
        return -1;
    }

    public String getServerAddress() {
        if (this.server != null && this.server.isRunning()) {
            return this.server.getAddress();
        }
        return null;
    }

    public BasicServer getServer() {
        return this.server;
    }

    protected void startStopServer(File file) {
        if (this.serverRunning()) {
            this.stopServer();
        } else {
            this.startServer(file);
        }
    }

    protected BasicServer createServer(File file) {
        if (this.server != null) {
            return this.server;
        }
        if (file.exists() || !file.mkdir()) {
            // empty if block
        }
        this.server = new BasicServer(file);
        this.server.addListener(this);
        File file2 = this.getSketchPropertiesFile();
        if (file2.exists()) {
            try {
                Settings settings = new Settings(file2);
                String string = settings.get(PROP_KEY_SERVER_PORT);
                if (string != null && !string.trim().equals("")) {
                    int n = Integer.parseInt(string);
                    this.server.setPort(n);
                }
            }
            catch (IOException iOException) {
                this.statusError(iOException);
            }
        }
        return this.server;
    }

    protected boolean startServer(File file) {
        if (!(this.server == null || this.server.isRunning() && this.server.getRoot().equals(file))) {
            this.server.shutDown();
            this.server = null;
        }
        if (this.server == null) {
            this.server = this.createServer(file);
        }
        if (!this.server.isRunning()) {
            this.server.setRoot(file);
            this.server.start();
            this.statusNotice("Waiting for server to start ...");
        } else if (this.server.isRunning()) {
            this.statusNotice("Server running ( " + this.server.getAddress() + " ), reload your browser window.");
            return false;
        }
        return true;
    }

    protected boolean serverRunning() {
        return this.server != null && this.server.isRunning();
    }

    protected void stopServer() {
        if (this.serverRunning()) {
            this.server.shutDown();
        }
    }

    protected File getSketchPropertiesFile() {
        File file = new File(this.getSketch().getFolder(), "sketch.properties");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.statusError("Unable to create sketch properties file!");
                return null;
            }
        }
        return file;
    }

    protected void openBrowserForServer() {
        if (this.serverRunning()) {
            Platform.openURL((String)this.server.getAddress());
        }
    }

    @Override
    public void serverStarted() {
        String string = this.server.getAddress();
        this.statusNotice("Server started: " + string);
        this.openBrowserForServer();
    }

    @Override
    public void serverStopped() {
        this.statusNotice("Server stopped.");
    }
}

