/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jface.text.Document;

public class CompilationChecker {
    private URLClassLoader urlClassLoader;
    private static String fileName = null;
    IProblem[] prob;
    String sourceText = null;

    private ClassLoader getClassLoader() {
        if (this.urlClassLoader != null) {
            return this.urlClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    private void prepareClassLoader(ArrayList<File> jarList) {
        URL[] urls = new URL[jarList.size()];
        int i = 0;
        while (i < urls.length) {
            try {
                urls[i] = jarList.get(i).toURI().toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.urlClassLoader = new URLClassLoader(urls);
    }

    private ICompilationUnit generateCompilationUnit() {
        ASTParser parser = ASTParser.newParser((int)8);
        try {
            parser.setSource("".toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.8", (Map)options);
        parser.setCompilerOptions((Map)options);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        unit.recordModifications();
        AST ast = unit.getAST();
        PackageDeclaration packageDeclaration = ast.newPackageDeclaration();
        unit.setPackage(packageDeclaration);
        packageDeclaration.setName((Name)ast.newSimpleName(fileName));
        TypeDeclaration classType = ast.newTypeDeclaration();
        classType.setInterface(false);
        classType.setName(ast.newSimpleName(fileName));
        unit.types().add(classType);
        return new CompilationUnitImpl(unit);
    }

    private void compileMeQuitely(ICompilationUnit unit, Map<String, String> compilerSettings) {
        Map<String, String> settings;
        if (compilerSettings == null) {
            settings = new HashMap<String, String>();
            settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
            settings.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", "disabled");
        } else {
            settings = compilerSettings;
        }
        CompileRequestorImpl requestor = new CompileRequestorImpl();
        Compiler compiler = new Compiler((INameEnvironment)new NameEnvironmentImpl(unit), DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(settings), (ICompilerRequestor)requestor, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        compiler.compile(new ICompilationUnit[]{unit});
        List<IProblem> problems = requestor.getProblems();
        this.prob = new IProblem[problems.size()];
        int count = 0;
        for (IProblem problem : problems) {
            this.prob[count++] = problem;
        }
    }

    private void compileMeQuitely(ICompilationUnit unit) {
        this.compileMeQuitely(unit, null);
    }

    private static String[] getSimpleNames(String qualifiedName) {
        StringTokenizer st = new StringTokenizer(qualifiedName, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (name.equals("*")) continue;
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    public static void main(String[] args) {
        ArrayList<File> fl = new ArrayList<File>();
        fl.add(new File("/home/quarkninja/Workspaces/processing_workspace/processing/core/library/core.jar"));
        CompilationChecker cc = new CompilationChecker(fl);
        cc.getErrors("Brightness");
        cc.display();
    }

    public void display() {
        boolean error = false;
        int errorCount = 0;
        int warningCount = 0;
        int count = 0;
        int i = 0;
        while (i < this.prob.length) {
            IProblem problem = this.prob[i];
            if (problem != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(problem.getMessage());
                sb.append(" | line: ");
                sb.append(problem.getSourceLineNumber());
                String msg = sb.toString();
                if (problem.isError()) {
                    error = true;
                    msg = "Error: " + msg;
                    ++errorCount;
                } else if (problem.isWarning()) {
                    msg = "Warning: " + msg;
                    ++warningCount;
                }
                System.out.println(msg);
                this.prob[count++] = problem;
            }
            ++i;
        }
        if (!error) {
            System.out.println("====================================");
            System.out.println("    Compiled without any errors.    ");
            System.out.println("====================================");
        } else {
            System.out.println("====================================");
            System.out.println(" Compilation failed. You erred man! ");
            System.out.println("====================================");
        }
        System.out.print("Total warnings: " + warningCount);
        System.out.println(", Total errors: " + errorCount);
    }

    public IProblem[] getErrors(String name) {
        fileName = name;
        this.compileMeQuitely(this.generateCompilationUnit());
        return this.prob;
    }

    public IProblem[] getErrors(String sourceName, String source, Map<String, String> settings, URLClassLoader classLoader) {
        fileName = sourceName;
        this.sourceText = "package " + fileName + ";\n" + source;
        if (classLoader != null) {
            this.urlClassLoader = classLoader;
        }
        this.compileMeQuitely(this.generateCompilationUnit(), settings);
        return this.prob;
    }

    public IProblem[] getErrors(String sourceName, String source) {
        return this.getErrors(sourceName, source, null);
    }

    public IProblem[] getErrors(String sourceName, String source, Map<String, String> settings) {
        fileName = sourceName;
        this.sourceText = "package " + fileName + ";\n" + source;
        this.compileMeQuitely(this.generateCompilationUnit(), settings);
        return this.prob;
    }

    public CompilationChecker() {
    }

    public CompilationChecker(ArrayList<File> fileList) {
        this.prepareClassLoader(fileList);
    }

    private class CompilationUnitImpl
    implements ICompilationUnit {
        private CompilationUnit unit;

        CompilationUnitImpl(CompilationUnit unit) {
            this.unit = unit;
        }

        public char[] getContents() {
            char[] contents = null;
            try {
                Document doc = new Document();
                doc.set(CompilationChecker.this.sourceText);
                String sourceCode = doc.get();
                if (sourceCode != null) {
                    contents = sourceCode.toCharArray();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return contents;
        }

        public char[] getMainTypeName() {
            TypeDeclaration classType = (TypeDeclaration)this.unit.types().get(0);
            return classType.getName().getFullyQualifiedName().toCharArray();
        }

        public char[][] getPackageName() {
            String[] names = CompilationChecker.getSimpleNames(this.unit.getPackage().getName().getFullyQualifiedName());
            char[][] packages = new char[names.length][];
            int i = 0;
            while (i < names.length) {
                packages[i] = names[i].toCharArray();
                ++i;
            }
            return packages;
        }

        public char[] getFileName() {
            TypeDeclaration classType = (TypeDeclaration)this.unit.types().get(0);
            String name = String.valueOf(classType.getName().getFullyQualifiedName()) + ".java";
            return name.toCharArray();
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }
    }

    private class CompileRequestorImpl
    implements ICompilerRequestor {
        private List<IProblem> problems = new ArrayList<IProblem>();
        private List<ClassFile> classes = new ArrayList<ClassFile>();

        public void acceptResult(CompilationResult result) {
            int i;
            boolean errors = false;
            if (result.hasProblems()) {
                CategorizedProblem[] problems = result.getProblems();
                i = 0;
                while (i < problems.length) {
                    if (problems[i].isError()) {
                        errors = true;
                    }
                    this.problems.add((IProblem)problems[i]);
                    ++i;
                }
            }
            if (!errors) {
                ClassFile[] classFiles = result.getClassFiles();
                i = 0;
                while (i < classFiles.length) {
                    this.classes.add(classFiles[i]);
                    ++i;
                }
            }
        }

        List<IProblem> getProblems() {
            return this.problems;
        }
    }

    private class NameEnvironmentImpl
    implements INameEnvironment {
        private ICompilationUnit unit;
        private String fullName;

        NameEnvironmentImpl(ICompilationUnit unit) {
            this.unit = unit;
            this.fullName = String.valueOf(CharOperation.toString((char[][])this.unit.getPackageName())) + "." + new String(this.unit.getMainTypeName());
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            return this.findType(CharOperation.toString((char[][])compoundTypeName));
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            String fullName = CharOperation.toString((char[][])packageName);
            if (typeName != null) {
                if (fullName.length() > 0) {
                    fullName = String.valueOf(fullName) + ".";
                }
                fullName = String.valueOf(fullName) + new String(typeName);
            }
            return this.findType(fullName);
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            String fullName = CharOperation.toString((char[][])parentPackageName);
            if (packageName != null) {
                if (fullName.length() > 0) {
                    fullName = String.valueOf(fullName) + ".";
                }
                fullName = String.valueOf(fullName) + new String(packageName);
            }
            if (this.findType(fullName) != null) {
                return false;
            }
            try {
                return CompilationChecker.this.getClassLoader().loadClass(fullName) == null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return true;
            }
        }

        public void cleanup() {
        }

        private NameEnvironmentAnswer findType(String fullName) {
            if (this.fullName.equals(fullName)) {
                return new NameEnvironmentAnswer(this.unit, null);
            }
            try {
                InputStream is = CompilationChecker.this.getClassLoader().getResourceAsStream(String.valueOf(fullName.replace('.', '/')) + ".class");
                if (is != null) {
                    byte[] buffer = new byte[8192];
                    int bytes = 0;
                    ByteArrayOutputStream os = new ByteArrayOutputStream(buffer.length);
                    while ((bytes = is.read(buffer, 0, buffer.length)) > 0) {
                        os.write(buffer, 0, bytes);
                    }
                    os.flush();
                    ClassFileReader classFileReader = new ClassFileReader(os.toByteArray(), fullName.toCharArray(), true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassFormatException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

