/*
 * Decompiled with CFR 0.152.
 */
package de.bezier.mode.javascript;

import de.bezier.mode.javascript.BasicServerListener;
import de.bezier.mode.javascript.HttpConstants;
import de.bezier.mode.javascript.Worker;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;

class BasicServer
implements HttpConstants,
Runnable {
    ArrayList<BasicServerListener> listeners;
    public static final String localDomain = "http://127.0.0.1";
    static final int MIN_PORT = 0;
    static final int MAX_PORT = 49151;
    Thread thread = null;
    ServerSocket server = null;
    private File virtualRoot;
    private int timeout = 5000;
    private int port = -1;
    private boolean running = false;
    private boolean inited = false;
    private ArrayList<String> addresses;

    BasicServer(File file) {
        this.setRoot(file);
        this.findPort();
    }

    public File getRoot() {
        return this.virtualRoot;
    }

    public void setRoot(File file) {
        if (file.exists() && file.isDirectory() && file.canRead()) {
            this.virtualRoot = file;
        } else {
            System.err.println("BasicServer: error setting <root>");
        }
    }

    public void addListener(BasicServerListener basicServerListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (basicServerListener != null) {
            this.listeners.add(basicServerListener);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getAddress() {
        return "http://127.0.0.1:" + this.getPort() + "/";
    }

    public ArrayList<String> getInetAddresses() {
        this.addresses = new ArrayList();
        try {
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (inetAddress instanceof Inet6Address) continue;
                this.addresses.add(inetAddress.getHostAddress());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.addresses;
    }

    private void findPort() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
            serverSocket.setReuseAddress(true);
            this.port = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (!this.isRunning() && n >= 0) {
            if (!BasicServer.available(n)) {
                System.err.println("BasicServer: that port (" + n + ") seems to be taken " + "or is out of range (<1025 or >49151)");
                System.out.println("... if it works anyway, ignore the warning.");
            } else {
                this.port = n;
            }
        }
    }

    public void start() {
        if (this.virtualRoot == null) {
            System.err.println("BasicServer: virtual root is null.");
            return;
        }
        this.thread = null;
        this.thread = new Thread((Runnable)this, "Processing.BasicServer");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int n) {
        if (n < 1025 || n > 49151) {
            return false;
        }
        ServerSocket serverSocket = null;
        DatagramSocket datagramSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.setReuseAddress(true);
            serverSocket.close();
            datagramSocket = new DatagramSocket(n);
            datagramSocket.setReuseAddress(true);
            datagramSocket.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void restart() {
        if (this.running) {
            this.shutDown();
        }
        this.start();
    }

    public void shutDown() {
        this.thread = null;
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.listeners != null) {
            for (BasicServerListener basicServerListener : this.listeners) {
                basicServerListener.serverStopped();
            }
        }
    }

    public boolean isRunning() {
        return this.running && this.inited;
    }

    @Override
    public void run() {
        try {
            this.running = true;
            if (this.port < 0) {
                this.server = new ServerSocket(0);
                this.port = this.server.getLocalPort();
            } else {
                this.server = new ServerSocket(this.port);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException);
        }
        try {
            if (this.server != null) {
                this.inited = true;
                if (this.listeners != null) {
                    for (BasicServerListener object : this.listeners) {
                        object.serverStarted();
                    }
                }
                while (this.thread != null) {
                    Socket socket = this.server.accept();
                    Worker worker = new Worker(this.virtualRoot);
                    worker.setSocket(socket);
                    new Thread((Runnable)worker, "Processing.BasicServer.Worker").start();
                }
            } else {
                System.err.println("Server is null. Bad. Really.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.running = false;
    }
}

