/**
 *    <p>This example shows you how to use video with a transparency
 *    which currently is not natively supported by web video formats (H264 / OGV).</p>
 *
 *    <p>The "disco effects" in the back are generated by Processing code
 *    while Charmy dancing upfront is coming from a HTML5 video element.</p>
 *
 *    <p>The video contains both the image and the mask side by side, have a look 
 *    at the war file here: <a href="charmy.mp4">charmy.mp4</a></p>
 *
 *    Greenscreen material by <a href="http://mint.gs/">mint.gs</a> and used with permission.
 *
 *    <video width="480" height="360" style="display:none">
 *        <source src="charmy.mp4" />
 *        <source src="charmy.ogv" />
 *        <source src="charmy.webm" />
 *    </video>
 */
 
 Video video;
 PImage frame;
 
 void setup ()
 {
     size( 320, 240 );
     
     noStroke();
     textFont(createFont("Arial", 20));
     background(255,0);
 }
 
 void draw ()
 {
     if ( video != null )
     {
         background(255, 0);
         
         timeLineEffects();
         
         PImage frame = video.getFrame();
         PImage rgbImage = frame.get(frame.width/2,0,frame.width/2,frame.height);
         PImage maskImage = frame.get(0,0,frame.width/2,frame.height);
         rgbImage.loadPixels();
         maskImage.loadPixels();
         for ( int i = 0; i < rgbImage.pixels.length; i++ )
         {
             rgbImage.pixels[i] = (rgbImage.pixels[i] & 0x00FFFFFF) + ((maskImage.pixels[i] & 0xFF) << 24);
         }
         rgbImage.updatePixels();
         image( rgbImage, width/2-rgbImage.width/2, 0 );
     }
 }
 
 void mousePressed ()
 {
     if ( video != null )
     {
        if ( video.paused ) video.play();
        else video.pause(); 
     }  
 }
 
 /* called from JavaScript to set the freshly loaded video */
 void addVideo ( Video v )
 {
     v.play();
     video = v;
 }
 
 /* make Processing understand the HTMLVideoElement */
 interface Video
 {
     boolean autoplay;
     boolean controls;
     
     int width;
     int height;
     int videoWidth; /*readonly*/
     int videoHeight; /*readonly*/
     
     boolean muted;
     float volume;
     
     boolean loop;
     boolean paused;
     boolean ended;
     
     String currentSrc;
     
     float duration;
     float currentTime;
     
     void play();
     void pause();
 }
