// See: http://box2d-js.sourceforge.net/
/*
* Copyright (c) 2006-2007 Erin Catto http:
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked, and must not be
* misrepresented the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/
var b2Settings=Class.create();b2Settings.prototype={initialize:function(){}};b2Settings.USHRT_MAX=65535;b2Settings.b2_pi=Math.PI;b2Settings.b2_massUnitsPerKilogram=1;b2Settings.b2_timeUnitsPerSecond=1;b2Settings.b2_lengthUnitsPerMeter=30;b2Settings.b2_maxManifoldPoints=2;b2Settings.b2_maxShapesPerBody=64;b2Settings.b2_maxPolyVertices=8;b2Settings.b2_maxProxies=1024;b2Settings.b2_maxPairs=8*b2Settings.b2_maxProxies;b2Settings.b2_linearSlop=0.0050*b2Settings.b2_lengthUnitsPerMeter;
b2Settings.b2_angularSlop=2/180*b2Settings.b2_pi;b2Settings.b2_velocityThreshold=1*b2Settings.b2_lengthUnitsPerMeter/b2Settings.b2_timeUnitsPerSecond;b2Settings.b2_maxLinearCorrection=0.2*b2Settings.b2_lengthUnitsPerMeter;b2Settings.b2_maxAngularCorrection=8/180*b2Settings.b2_pi;b2Settings.b2_contactBaumgarte=0.2;b2Settings.b2_timeToSleep=0.5*b2Settings.b2_timeUnitsPerSecond;b2Settings.b2_linearSleepTolerance=0.01*b2Settings.b2_lengthUnitsPerMeter/b2Settings.b2_timeUnitsPerSecond;
b2Settings.b2_angularSleepTolerance=2/180/b2Settings.b2_timeUnitsPerSecond;b2Settings.b2Assert=function(a){a||(void 0).x++};var b2Vec2=Class.create();
b2Vec2.prototype={initialize:function(a,c){this.x=a;this.y=c},SetZero:function(){this.y=this.x=0},Set:function(a,c){this.x=a;this.y=c},SetV:function(a){this.x=a.x;this.y=a.y},Negative:function(){return new b2Vec2(-this.x,-this.y)},Copy:function(){return new b2Vec2(this.x,this.y)},Add:function(a){this.x+=a.x;this.y+=a.y},Subtract:function(a){this.x-=a.x;this.y-=a.y},Multiply:function(a){this.x*=a;this.y*=a},MulM:function(a){var c=this.x;this.x=a.col1.x*c+a.col2.x*this.y;this.y=a.col1.y*c+a.col2.y*
this.y},MulTM:function(a){var c=b2Math.b2Dot(this,a.col1);this.y=b2Math.b2Dot(this,a.col2);this.x=c},CrossVF:function(a){var c=this.x;this.x=a*this.y;this.y=-a*c},CrossFV:function(a){var c=this.x;this.x=-a*this.y;this.y=a*c},MinV:function(a){this.x=this.x<a.x?this.x:a.x;this.y=this.y<a.y?this.y:a.y},MaxV:function(a){this.x=this.x>a.x?this.x:a.x;this.y=this.y>a.y?this.y:a.y},Abs:function(){this.x=Math.abs(this.x);this.y=Math.abs(this.y)},Length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},
Normalize:function(){var a=this.Length();if(a<Number.MIN_VALUE)return 0;var c=1/a;this.x*=c;this.y*=c;return a},IsValid:function(){return b2Math.b2IsValid(this.x)&&b2Math.b2IsValid(this.y)},x:null,y:null};b2Vec2.Make=function(a,c){return new b2Vec2(a,c)};var b2Mat22=Class.create();
b2Mat22.prototype={initialize:function(a,c,b){a==null&&(a=0);this.col1=new b2Vec2;this.col2=new b2Vec2;c!=null&&b!=null?(this.col1.SetV(c),this.col2.SetV(b)):(c=Math.cos(a),a=Math.sin(a),this.col1.x=c,this.col2.x=-a,this.col1.y=a,this.col2.y=c)},Set:function(a){var c=Math.cos(a),a=Math.sin(a);this.col1.x=c;this.col2.x=-a;this.col1.y=a;this.col2.y=c},SetVV:function(a,c){this.col1.SetV(a);this.col2.SetV(c)},Copy:function(){return new b2Mat22(0,this.col1,this.col2)},SetM:function(a){this.col1.SetV(a.col1);
this.col2.SetV(a.col2)},AddM:function(a){this.col1.x+=a.col1.x;this.col1.y+=a.col1.y;this.col2.x+=a.col2.x;this.col2.y+=a.col2.y},SetIdentity:function(){this.col1.x=1;this.col2.x=0;this.col1.y=0;this.col2.y=1},SetZero:function(){this.col1.x=0;this.col2.x=0;this.col1.y=0;this.col2.y=0},Invert:function(a){var c=this.col1.x,b=this.col2.x,e=this.col1.y,f=this.col2.y,g;g=1/(c*f-b*e);a.col1.x=g*f;a.col2.x=-g*b;a.col1.y=-g*e;a.col2.y=g*c;return a},Solve:function(a,c,b){var e=this.col1.x,f=this.col2.x,g=
this.col1.y,h=this.col2.y,i;i=1/(e*h-f*g);a.x=i*(h*c-f*b);a.y=i*(e*b-g*c);return a},Abs:function(){this.col1.Abs();this.col2.Abs()},col1:new b2Vec2,col2:new b2Vec2};var b2Math=Class.create();b2Math.prototype={initialize:function(){}};b2Math.b2IsValid=function(a){return isFinite(a)};b2Math.b2Dot=function(a,c){return a.x*c.x+a.y*c.y};b2Math.b2CrossVV=function(a,c){return a.x*c.y-a.y*c.x};b2Math.b2CrossVF=function(a,c){return new b2Vec2(c*a.y,-c*a.x)};
b2Math.b2CrossFV=function(a,c){return new b2Vec2(-a*c.y,a*c.x)};b2Math.b2MulMV=function(a,c){return new b2Vec2(a.col1.x*c.x+a.col2.x*c.y,a.col1.y*c.x+a.col2.y*c.y)};b2Math.b2MulTMV=function(a,c){return new b2Vec2(b2Math.b2Dot(c,a.col1),b2Math.b2Dot(c,a.col2))};b2Math.AddVV=function(a,c){return new b2Vec2(a.x+c.x,a.y+c.y)};b2Math.SubtractVV=function(a,c){return new b2Vec2(a.x-c.x,a.y-c.y)};b2Math.MulFV=function(a,c){return new b2Vec2(a*c.x,a*c.y)};
b2Math.AddMM=function(a,c){return new b2Mat22(0,b2Math.AddVV(a.col1,c.col1),b2Math.AddVV(a.col2,c.col2))};b2Math.b2MulMM=function(a,c){return new b2Mat22(0,b2Math.b2MulMV(a,c.col1),b2Math.b2MulMV(a,c.col2))};b2Math.b2MulTMM=function(a,c){var b=new b2Vec2(b2Math.b2Dot(a.col1,c.col1),b2Math.b2Dot(a.col2,c.col1)),e=new b2Vec2(b2Math.b2Dot(a.col1,c.col2),b2Math.b2Dot(a.col2,c.col2));return new b2Mat22(0,b,e)};b2Math.b2Abs=function(a){return a>0?a:-a};
b2Math.b2AbsV=function(a){return new b2Vec2(b2Math.b2Abs(a.x),b2Math.b2Abs(a.y))};b2Math.b2AbsM=function(a){return new b2Mat22(0,b2Math.b2AbsV(a.col1),b2Math.b2AbsV(a.col2))};b2Math.b2Min=function(a,c){return a<c?a:c};b2Math.b2MinV=function(a,c){return new b2Vec2(b2Math.b2Min(a.x,c.x),b2Math.b2Min(a.y,c.y))};b2Math.b2Max=function(a,c){return a>c?a:c};b2Math.b2MaxV=function(a,c){return new b2Vec2(b2Math.b2Max(a.x,c.x),b2Math.b2Max(a.y,c.y))};
b2Math.b2Clamp=function(a,c,b){return b2Math.b2Max(c,b2Math.b2Min(a,b))};b2Math.b2ClampV=function(a,c,b){return b2Math.b2MaxV(c,b2Math.b2MinV(a,b))};b2Math.b2Swap=function(a,c){var b=a[0];a[0]=c[0];c[0]=b};b2Math.b2Random=function(){return Math.random()*2-1};b2Math.b2NextPowerOfTwo=function(a){a|=a>>1&2147483647;a|=a>>2&1073741823;a|=a>>4&268435455;a|=a>>8&16777215;a|=a>>16&65535;return a+1};b2Math.b2IsPowerOfTwo=function(a){return a>0&&(a&a-1)==0};b2Math.tempVec2=new b2Vec2;b2Math.tempVec3=new b2Vec2;
b2Math.tempVec4=new b2Vec2;b2Math.tempVec5=new b2Vec2;b2Math.tempMat=new b2Mat22;var b2AABB=Class.create();b2AABB.prototype={IsValid:function(){var a=this.maxVertex.x,c=this.maxVertex.y,a=this.maxVertex.x,c=this.maxVertex.y;a-=this.minVertex.x;c-=this.minVertex.y;return a=a>=0&&c>=0&&this.minVertex.IsValid()&&this.maxVertex.IsValid()},minVertex:new b2Vec2,maxVertex:new b2Vec2,initialize:function(){this.minVertex=new b2Vec2;this.maxVertex=new b2Vec2}};var b2Bound=Class.create();
b2Bound.prototype={IsLower:function(){return(this.value&1)==0},IsUpper:function(){return(this.value&1)==1},Swap:function(a){var c=this.value,b=this.proxyId,e=this.stabbingCount;this.value=a.value;this.proxyId=a.proxyId;this.stabbingCount=a.stabbingCount;a.value=c;a.proxyId=b;a.stabbingCount=e},value:0,proxyId:0,stabbingCount:0,initialize:function(){}};var b2BoundValues=Class.create();
b2BoundValues.prototype={lowerValues:[0,0],upperValues:[0,0],initialize:function(){this.lowerValues=[0,0];this.upperValues=[0,0]}};var b2Pair=Class.create();
b2Pair.prototype={SetBuffered:function(){this.status|=b2Pair.e_pairBuffered},ClearBuffered:function(){this.status&=~b2Pair.e_pairBuffered},IsBuffered:function(){return(this.status&b2Pair.e_pairBuffered)==b2Pair.e_pairBuffered},SetRemoved:function(){this.status|=b2Pair.e_pairRemoved},ClearRemoved:function(){this.status&=~b2Pair.e_pairRemoved},IsRemoved:function(){return(this.status&b2Pair.e_pairRemoved)==b2Pair.e_pairRemoved},SetFinal:function(){this.status|=b2Pair.e_pairFinal},IsFinal:function(){return(this.status&
b2Pair.e_pairFinal)==b2Pair.e_pairFinal},userData:null,proxyId1:0,proxyId2:0,next:0,status:0,initialize:function(){}};b2Pair.b2_nullPair=b2Settings.USHRT_MAX;b2Pair.b2_nullProxy=b2Settings.USHRT_MAX;b2Pair.b2_tableCapacity=b2Settings.b2_maxPairs;b2Pair.b2_tableMask=b2Pair.b2_tableCapacity-1;b2Pair.e_pairBuffered=1;b2Pair.e_pairRemoved=2;b2Pair.e_pairFinal=4;var b2PairCallback=Class.create();b2PairCallback.prototype={PairAdded:function(){return null},PairRemoved:function(){},initialize:function(){}};
var b2BufferedPair=Class.create();b2BufferedPair.prototype={proxyId1:0,proxyId2:0,initialize:function(){}};var b2PairManager=Class.create();
b2PairManager.prototype={initialize:function(){var a=0;this.m_hashTable=Array(b2Pair.b2_tableCapacity);for(a=0;a<b2Pair.b2_tableCapacity;++a)this.m_hashTable[a]=b2Pair.b2_nullPair;this.m_pairs=Array(b2Settings.b2_maxPairs);for(a=0;a<b2Settings.b2_maxPairs;++a)this.m_pairs[a]=new b2Pair;this.m_pairBuffer=Array(b2Settings.b2_maxPairs);for(a=0;a<b2Settings.b2_maxPairs;++a)this.m_pairBuffer[a]=new b2BufferedPair;for(a=0;a<b2Settings.b2_maxPairs;++a)this.m_pairs[a].proxyId1=b2Pair.b2_nullProxy,this.m_pairs[a].proxyId2=
b2Pair.b2_nullProxy,this.m_pairs[a].userData=null,this.m_pairs[a].status=0,this.m_pairs[a].next=a+1;this.m_pairs[b2Settings.b2_maxPairs-1].next=b2Pair.b2_nullPair;this.m_pairCount=0},Initialize:function(a,c){this.m_broadPhase=a;this.m_callback=c},AddBufferedPair:function(a,c){var b=this.AddPair(a,c);if(b.IsBuffered()==!1)b.SetBuffered(),this.m_pairBuffer[this.m_pairBufferCount].proxyId1=b.proxyId1,this.m_pairBuffer[this.m_pairBufferCount].proxyId2=b.proxyId2,++this.m_pairBufferCount;b.ClearRemoved();
b2BroadPhase.s_validate&&this.ValidateBuffer()},RemoveBufferedPair:function(a,c){var b=this.Find(a,c);if(b!=null){if(b.IsBuffered()==!1)b.SetBuffered(),this.m_pairBuffer[this.m_pairBufferCount].proxyId1=b.proxyId1,this.m_pairBuffer[this.m_pairBufferCount].proxyId2=b.proxyId2,++this.m_pairBufferCount;b.SetRemoved();b2BroadPhase.s_validate&&this.ValidateBuffer()}},Commit:function(){for(var a=0,c=0,b=this.m_broadPhase.m_proxyPool,a=0;a<this.m_pairBufferCount;++a){var e=this.Find(this.m_pairBuffer[a].proxyId1,
this.m_pairBuffer[a].proxyId2);e.ClearBuffered();var f=b[e.proxyId1],g=b[e.proxyId2];if(e.IsRemoved())e.IsFinal()==!0&&this.m_callback.PairRemoved(f.userData,g.userData,e.userData),this.m_pairBuffer[c].proxyId1=e.proxyId1,this.m_pairBuffer[c].proxyId2=e.proxyId2,++c;else if(e.IsFinal()==!1)e.userData=this.m_callback.PairAdded(f.userData,g.userData),e.SetFinal()}for(a=0;a<c;++a)this.RemovePair(this.m_pairBuffer[a].proxyId1,this.m_pairBuffer[a].proxyId2);this.m_pairBufferCount=0;b2BroadPhase.s_validate&&
this.ValidateTable()},AddPair:function(a,c){if(a>c)var b=a,a=c,c=b;var b=b2PairManager.Hash(a,c)&b2Pair.b2_tableMask,e=e=this.FindHash(a,c,b);if(e!=null)return e;var f=this.m_freePair,e=this.m_pairs[f];this.m_freePair=e.next;e.proxyId1=a;e.proxyId2=c;e.status=0;e.userData=null;e.next=this.m_hashTable[b];this.m_hashTable[b]=f;++this.m_pairCount;return e},RemovePair:function(a,c){if(a>c)var b=a,a=c,c=b;for(var e=b2PairManager.Hash(a,c)&b2Pair.b2_tableMask,f=this.m_hashTable[e],g=null;f!=b2Pair.b2_nullPair;)if(b2PairManager.Equals(this.m_pairs[f],
a,c))return b=f,g?g.next=this.m_pairs[f].next:this.m_hashTable[e]=this.m_pairs[f].next,e=this.m_pairs[b],f=e.userData,e.next=this.m_freePair,e.proxyId1=b2Pair.b2_nullProxy,e.proxyId2=b2Pair.b2_nullProxy,e.userData=null,e.status=0,this.m_freePair=b,--this.m_pairCount,f;else g=this.m_pairs[f],f=g.next;return null},Find:function(a,c){if(a>c)var b=a,a=c,c=b;b=b2PairManager.Hash(a,c)&b2Pair.b2_tableMask;return this.FindHash(a,c,b)},FindHash:function(a,c,b){for(b=this.m_hashTable[b];b!=b2Pair.b2_nullPair&&
b2PairManager.Equals(this.m_pairs[b],a,c)==!1;)b=this.m_pairs[b].next;if(b==b2Pair.b2_nullPair)return null;return this.m_pairs[b]},ValidateBuffer:function(){},ValidateTable:function(){},m_broadPhase:null,m_callback:null,m_pairs:null,m_freePair:0,m_pairCount:0,m_pairBuffer:null,m_pairBufferCount:0,m_hashTable:null};b2PairManager.Hash=function(a,c){var b=c<<16&4294901760|a,b=~b+(b<<15&4294934528);b^=b>>12&1048575;b+=b<<2&4294967292;b^=b>>4&268435455;b*=2057;b^=b>>16&65535;return b};
b2PairManager.Equals=function(a,c,b){return a.proxyId1==c&&a.proxyId2==b};b2PairManager.EqualsPair=function(a,c){return a.proxyId1==c.proxyId1&&a.proxyId2==c.proxyId2};var b2BroadPhase=Class.create();
b2BroadPhase.prototype={initialize:function(a,c){this.m_pairManager=new b2PairManager;this.m_proxyPool=Array(b2Settings.b2_maxPairs);this.m_bounds=Array(2*b2Settings.b2_maxProxies);this.m_queryResults=Array(b2Settings.b2_maxProxies);this.m_quantizationFactor=new b2Vec2;var b=0;this.m_pairManager.Initialize(this,c);this.m_worldAABB=a;for(b=this.m_proxyCount=0;b<b2Settings.b2_maxProxies;b++)this.m_queryResults[b]=0;this.m_bounds=Array(2);for(b=0;b<2;b++){this.m_bounds[b]=Array(2*b2Settings.b2_maxProxies);
for(var e=0;e<2*b2Settings.b2_maxProxies;e++)this.m_bounds[b][e]=new b2Bound}b=a.maxVertex.x;e=a.maxVertex.y;b-=a.minVertex.x;e-=a.minVertex.y;this.m_quantizationFactor.x=b2Settings.USHRT_MAX/b;this.m_quantizationFactor.y=b2Settings.USHRT_MAX/e;for(b=0;b<b2Settings.b2_maxProxies-1;++b)e=new b2Proxy,this.m_proxyPool[b]=e,e.SetNext(b+1),e.timeStamp=0,e.overlapCount=b2BroadPhase.b2_invalid,e.userData=null;e=new b2Proxy;this.m_proxyPool[b2Settings.b2_maxProxies-1]=e;e.SetNext(b2Pair.b2_nullProxy);e.timeStamp=
0;e.overlapCount=b2BroadPhase.b2_invalid;e.userData=null;this.m_freeProxy=0;this.m_timeStamp=1;this.m_queryResultCount=0},InRange:function(a){var c,b,e,f;c=a.minVertex.x;b=a.minVertex.y;c-=this.m_worldAABB.maxVertex.x;b-=this.m_worldAABB.maxVertex.y;e=this.m_worldAABB.minVertex.x;f=this.m_worldAABB.minVertex.y;e-=a.maxVertex.x;f-=a.maxVertex.y;c=b2Math.b2Max(c,e);b=b2Math.b2Max(b,f);return b2Math.b2Max(c,b)<0},GetProxy:function(a){if(a==b2Pair.b2_nullProxy||this.m_proxyPool[a].IsValid()==!1)return null;
return this.m_proxyPool[a]},CreateProxy:function(a,c){var b=0,e,f=this.m_freeProxy;e=this.m_proxyPool[f];this.m_freeProxy=e.GetNext();e.overlapCount=0;e.userData=c;e=2*this.m_proxyCount;var g=[],h=[];this.ComputeBounds(g,h,a);for(var i=0;i<2;++i){var k=this.m_bounds[i],j=0,l=0,j=[j],l=[l];this.Query(j,l,g[i],h[i],k,e,i);for(var j=j[0],l=l[0],b=[],m=0,n=e-l,o,p,m=0;m<n;m++)b[m]=new b2Bound,o=b[m],p=k[l+m],o.value=p.value,o.proxyId=p.proxyId,o.stabbingCount=p.stabbingCount;for(var n=b.length,q=l+2,
m=0;m<n;m++)p=b[m],o=k[q+m],o.value=p.value,o.proxyId=p.proxyId,o.stabbingCount=p.stabbingCount;b=[];n=l-j;for(m=0;m<n;m++)b[m]=new b2Bound,o=b[m],p=k[j+m],o.value=p.value,o.proxyId=p.proxyId,o.stabbingCount=p.stabbingCount;n=b.length;q=j+1;for(m=0;m<n;m++)p=b[m],o=k[q+m],o.value=p.value,o.proxyId=p.proxyId,o.stabbingCount=p.stabbingCount;++l;k[j].value=g[i];k[j].proxyId=f;k[l].value=h[i];k[l].proxyId=f;k[j].stabbingCount=j==0?0:k[j-1].stabbingCount;k[l].stabbingCount=k[l-1].stabbingCount;for(b=j;b<
l;++b)k[b].stabbingCount++;for(b=j;b<e+2;++b)j=this.m_proxyPool[k[b].proxyId],k[b].IsLower()?j.lowerBounds[i]=b:j.upperBounds[i]=b}++this.m_proxyCount;for(e=0;e<this.m_queryResultCount;++e)this.m_pairManager.AddBufferedPair(f,this.m_queryResults[e]);this.m_pairManager.Commit();this.m_queryResultCount=0;this.IncrementTimeStamp();return f},DestroyProxy:function(a){for(var c=this.m_proxyPool[a],b=2*this.m_proxyCount,e=0;e<2;++e){for(var f=this.m_bounds[e],g=c.lowerBounds[e],h=c.upperBounds[e],i=f[g].value,
k=f[h].value,j=[],l=0,m=h-g-1,n,o,l=0;l<m;l++)j[l]=new b2Bound,n=j[l],o=f[g+1+l],n.value=o.value,n.proxyId=o.proxyId,n.stabbingCount=o.stabbingCount;for(var m=j.length,p=g,l=0;l<m;l++)o=j[l],n=f[p+l],n.value=o.value,n.proxyId=o.proxyId,n.stabbingCount=o.stabbingCount;j=[];m=b-h-1;for(l=0;l<m;l++)j[l]=new b2Bound,n=j[l],o=f[h+1+l],n.value=o.value,n.proxyId=o.proxyId,n.stabbingCount=o.stabbingCount;m=j.length;p=h-1;for(l=0;l<m;l++)o=j[l],n=f[p+l],n.value=o.value,n.proxyId=o.proxyId,n.stabbingCount=
o.stabbingCount;m=b-2;for(j=g;j<m;++j)l=this.m_proxyPool[f[j].proxyId],f[j].IsLower()?l.lowerBounds[e]=j:l.upperBounds[e]=j;for(m=h-1;g<m;++g)f[g].stabbingCount--;this.Query([0],[0],i,k,f,b-2,e)}for(b=0;b<this.m_queryResultCount;++b)this.m_pairManager.RemoveBufferedPair(a,this.m_queryResults[b]);this.m_pairManager.Commit();this.m_queryResultCount=0;this.IncrementTimeStamp();c.userData=null;c.overlapCount=b2BroadPhase.b2_invalid;c.lowerBounds[0]=b2BroadPhase.b2_invalid;c.lowerBounds[1]=b2BroadPhase.b2_invalid;
c.upperBounds[0]=b2BroadPhase.b2_invalid;c.upperBounds[1]=b2BroadPhase.b2_invalid;c.SetNext(this.m_freeProxy);this.m_freeProxy=a;--this.m_proxyCount},MoveProxy:function(a,c){var b=0,e=0,f,g,h=0,i;if(!(a==b2Pair.b2_nullProxy||b2Settings.b2_maxProxies<=a)&&c.IsValid()!=!1){var k=2*this.m_proxyCount,j=this.m_proxyPool[a],l=new b2BoundValues;this.ComputeBounds(l.lowerValues,l.upperValues,c);for(var m=new b2BoundValues,b=0;b<2;++b)m.lowerValues[b]=this.m_bounds[b][j.lowerBounds[b]].value,m.upperValues[b]=
this.m_bounds[b][j.upperBounds[b]].value;for(b=0;b<2;++b){var n=this.m_bounds[b],o=j.lowerBounds[b],p=j.upperBounds[b],q=l.lowerValues[b],s=l.upperValues[b],r=q-n[o].value,u=s-n[p].value;n[o].value=q;n[p].value=s;if(r<0)for(e=o;e>0&&q<n[e-1].value;)f=n[e],g=n[e-1],h=g.proxyId,i=this.m_proxyPool[g.proxyId],g.stabbingCount++,g.IsUpper()==!0?(this.TestOverlap(l,i)&&this.m_pairManager.AddBufferedPair(a,h),i.upperBounds[b]++,f.stabbingCount++):(i.lowerBounds[b]++,f.stabbingCount--),j.lowerBounds[b]--,
f.Swap(g),--e;if(u>0)for(e=p;e<k-1&&n[e+1].value<=s;)f=n[e],g=n[e+1],h=g.proxyId,i=this.m_proxyPool[h],g.stabbingCount++,g.IsLower()==!0?(this.TestOverlap(l,i)&&this.m_pairManager.AddBufferedPair(a,h),i.lowerBounds[b]--,f.stabbingCount++):(i.upperBounds[b]--,f.stabbingCount--),j.upperBounds[b]++,f.Swap(g),e++;if(r>0)for(e=o;e<k-1&&n[e+1].value<=q;)f=n[e],g=n[e+1],h=g.proxyId,i=this.m_proxyPool[h],g.stabbingCount--,g.IsUpper()?(this.TestOverlap(m,i)&&this.m_pairManager.RemoveBufferedPair(a,h),i.upperBounds[b]--,
f.stabbingCount--):(i.lowerBounds[b]--,f.stabbingCount++),j.lowerBounds[b]++,f.Swap(g),e++;if(u<0)for(e=p;e>0&&s<n[e-1].value;)f=n[e],g=n[e-1],h=g.proxyId,i=this.m_proxyPool[h],g.stabbingCount--,g.IsLower()==!0?(this.TestOverlap(m,i)&&this.m_pairManager.RemoveBufferedPair(a,h),i.lowerBounds[b]++,f.stabbingCount--):(i.upperBounds[b]++,f.stabbingCount++),j.upperBounds[b]--,f.Swap(g),e--}}},Commit:function(){this.m_pairManager.Commit()},QueryAABB:function(a,c,b){var e=[],f=[];this.ComputeBounds(e,f,
a);var a=[0],g=[0];this.Query(a,g,e[0],f[0],this.m_bounds[0],2*this.m_proxyCount,0);this.Query(a,g,e[1],f[1],this.m_bounds[1],2*this.m_proxyCount,1);for(f=e=0;f<this.m_queryResultCount&&e<b;++f,++e)c[f]=this.m_proxyPool[this.m_queryResults[f]].userData;this.m_queryResultCount=0;this.IncrementTimeStamp();return e},Validate:function(){for(var a=0;a<2;++a)for(var c=this.m_bounds[a],b=2*this.m_proxyCount,e=0,f=0;f<b;++f)c[f].IsLower()==!0?e++:e--},ComputeBounds:function(a,c,b){var e=b.minVertex.x,f=b.minVertex.y,
e=b2Math.b2Min(e,this.m_worldAABB.maxVertex.x),f=b2Math.b2Min(f,this.m_worldAABB.maxVertex.y),e=b2Math.b2Max(e,this.m_worldAABB.minVertex.x),f=b2Math.b2Max(f,this.m_worldAABB.minVertex.y),g=b.maxVertex.x,b=b.maxVertex.y,g=b2Math.b2Min(g,this.m_worldAABB.maxVertex.x),b=b2Math.b2Min(b,this.m_worldAABB.maxVertex.y),g=b2Math.b2Max(g,this.m_worldAABB.minVertex.x),b=b2Math.b2Max(b,this.m_worldAABB.minVertex.y);a[0]=this.m_quantizationFactor.x*(e-this.m_worldAABB.minVertex.x)&b2Settings.USHRT_MAX-1;c[0]=
this.m_quantizationFactor.x*(g-this.m_worldAABB.minVertex.x)&65535|1;a[1]=this.m_quantizationFactor.y*(f-this.m_worldAABB.minVertex.y)&b2Settings.USHRT_MAX-1;c[1]=this.m_quantizationFactor.y*(b-this.m_worldAABB.minVertex.y)&65535|1},TestOverlapValidate:function(a,c){for(var b=0;b<2;++b){var e=this.m_bounds[b];if(e[a.lowerBounds[b]].value>e[c.upperBounds[b]].value)return!1;if(e[a.upperBounds[b]].value<e[c.lowerBounds[b]].value)return!1}return!0},TestOverlap:function(a,c){for(var b=0;b<2;++b){var e=
this.m_bounds[b];if(a.lowerValues[b]>e[c.upperBounds[b]].value)return!1;if(a.upperValues[b]<e[c.lowerBounds[b]].value)return!1}return!0},Query:function(a,c,b,e,f,g,h){b=b2BroadPhase.BinarySearch(f,g,b);e=b2BroadPhase.BinarySearch(f,g,e);for(g=b;g<e;++g)f[g].IsLower()&&this.IncrementOverlapCount(f[g].proxyId);if(b>0)for(var g=b-1,i=f[g].stabbingCount;i;)f[g].IsLower()&&b<=this.m_proxyPool[f[g].proxyId].upperBounds[h]&&(this.IncrementOverlapCount(f[g].proxyId),--i),--g;a[0]=b;c[0]=e},IncrementOverlapCount:function(a){var c=
this.m_proxyPool[a];c.timeStamp<this.m_timeStamp?(c.timeStamp=this.m_timeStamp,c.overlapCount=1):(c.overlapCount=2,this.m_queryResults[this.m_queryResultCount]=a,++this.m_queryResultCount)},IncrementTimeStamp:function(){if(this.m_timeStamp==b2Settings.USHRT_MAX){for(var a=0;a<b2Settings.b2_maxProxies;++a)this.m_proxyPool[a].timeStamp=0;this.m_timeStamp=1}else++this.m_timeStamp},m_pairManager:new b2PairManager,m_proxyPool:Array(b2Settings.b2_maxPairs),m_freeProxy:0,m_bounds:Array(2*b2Settings.b2_maxProxies),
m_queryResults:Array(b2Settings.b2_maxProxies),m_queryResultCount:0,m_worldAABB:null,m_quantizationFactor:new b2Vec2,m_proxyCount:0,m_timeStamp:0};b2BroadPhase.s_validate=!1;b2BroadPhase.b2_invalid=b2Settings.USHRT_MAX;b2BroadPhase.b2_nullEdge=b2Settings.USHRT_MAX;b2BroadPhase.BinarySearch=function(a,c,b){var e=0;for(c-=1;e<=c;){var f=Math.floor((e+c)/2);if(a[f].value>b)c=f-1;else if(a[f].value<b)e=f+1;else return f}return e};var b2Collision=Class.create();b2Collision.prototype={initialize:function(){}};
b2Collision.b2_nullFeature=255;b2Collision.ClipSegmentToLine=function(a,c,b,e){var f=0,g=c[0].v,h=c[1].v,i=b2Math.b2Dot(b,c[0].v)-e,b=b2Math.b2Dot(b,c[1].v)-e;i<=0&&(a[f++]=c[0]);b<=0&&(a[f++]=c[1]);if(i*b<0)b=i/(i-b),e=a[f].v,e.x=g.x+b*(h.x-g.x),e.y=g.y+b*(h.y-g.y),a[f].id=i>0?c[0].id:c[1].id,++f;return f};
b2Collision.EdgeSeparation=function(a,c,b){for(var e=a.m_vertices,f=b.m_vertexCount,g=b.m_vertices,h=a.m_normals[c].x,i=a.m_normals[c].y,k=h,j=a.m_R,h=j.col1.x*k+j.col2.x*i,i=j.col1.y*k+j.col2.y*i,l=h,m=i,j=b.m_R,k=l*j.col1.x+m*j.col1.y,m=l*j.col2.x+m*j.col2.y,l=k,k=0,j=Number.MAX_VALUE,n=0;n<f;++n){var o=g[n],o=o.x*l+o.y*m;o<j&&(j=o,k=n)}j=a.m_R;f=a.m_position.x+(j.col1.x*e[c].x+j.col2.x*e[c].y);a=a.m_position.y+(j.col1.y*e[c].x+j.col2.y*e[c].y);j=b.m_R;c=b.m_position.x+(j.col1.x*g[k].x+j.col2.x*
g[k].y);b=b.m_position.y+(j.col1.y*g[k].x+j.col2.y*g[k].y);c-=f;b-=a;return c*h+b*i};
b2Collision.FindMaxSeparation=function(a,c,b,e){for(var f=c.m_vertexCount,g=b.m_position.x-c.m_position.x,h=b.m_position.y-c.m_position.y,i=g*c.m_R.col1.x+h*c.m_R.col1.y,h=g*c.m_R.col2.x+h*c.m_R.col2.y,g=0,k=-Number.MAX_VALUE,j=0;j<f;++j){var l=c.m_normals[j].x*i+c.m_normals[j].y*h;l>k&&(k=l,g=j)}i=b2Collision.EdgeSeparation(c,g,b);if(i>0&&e==!1)return i;j=g-1>=0?g-1:f-1;l=b2Collision.EdgeSeparation(c,j,b);if(l>0&&e==!1)return l;var m=g+1<f?g+1:0,n=b2Collision.EdgeSeparation(c,m,b);if(n>0&&e==!1)return n;
k=h=0;if(l>i&&l>n)k=-1,h=j,j=l;else if(n>i)k=1,h=m,j=n;else return a[0]=g,i;for(;;){g=k==-1?h-1>=0?h-1:f-1:h+1<f?h+1:0;i=b2Collision.EdgeSeparation(c,g,b);if(i>0&&e==!1)return i;if(i>j)h=g,j=i;else break}a[0]=h;return j};
b2Collision.FindIncidentEdge=function(a,c,b,e){var f=c.m_vertices,g=e.m_vertexCount,h=e.m_vertices,i=f[b+1==c.m_vertexCount?0:b+1],k=i.x,j=i.y,i=f[b];k-=i.x;j-=i.y;i=k;k=j;j=-i;i=1/Math.sqrt(k*k+j*j);k*=i;j*=i;for(var i=k,f=c.m_R,c=f.col1.x*i+f.col2.x*j,k=j=f.col1.y*i+f.col2.y*j,f=e.m_R,i=c*f.col1.x+k*f.col1.y,k=c*f.col2.x+k*f.col2.y,c=i,f=j=0,l=Number.MAX_VALUE,m=0;m<g;++m){var n=m,o=m+1<g?m+1:0,i=h[o],p=i.x,q=i.y,i=h[n];p-=i.x;q-=i.y;i=p;p=q;q=-i;i=1/Math.sqrt(p*p+q*q);p*=i;q*=i;i=p*c+q*k;i<l&&
(l=i,j=n,f=o)}g=a[0];i=g.v;i.SetV(h[j]);i.MulM(e.m_R);i.Add(e.m_position);g.id.features.referenceFace=b;g.id.features.incidentEdge=j;g.id.features.incidentVertex=j;g=a[1];i=g.v;i.SetV(h[f]);i.MulM(e.m_R);i.Add(e.m_position);g.id.features.referenceFace=b;g.id.features.incidentEdge=j;g.id.features.incidentVertex=f};b2Collision.b2CollidePolyTempVec=new b2Vec2;
b2Collision.b2CollidePoly=function(a,c,b,e){a.pointCount=0;var f,g=[0],h=b2Collision.FindMaxSeparation(g,c,b,e);f=g[0];if(!(h>0&&e==!1)){var i,g=[0],k=b2Collision.FindMaxSeparation(g,b,c,e);i=g[0];if(!(k>0&&e==!1)){var j=0,g=0;k>0.98*h+0.0010?(h=b,j=i,g=1):(h=c,c=b,j=f,g=0);b=[new ClipVertex,new ClipVertex];b2Collision.FindIncidentEdge(b,h,j,c);var c=h.m_vertices,l=c[j],m=j+1<h.m_vertexCount?c[j+1]:c[0];f=m.x-l.x;i=m.y-l.y;var n=f,o=h.m_R;f=o.col1.x*n+o.col2.x*i;i=o.col1.y*n+o.col2.y*i;j=1/Math.sqrt(f*
f+i*i);f*=j;i*=j;var n=f,j=i,c=-n,k=l.x,p=l.y,n=k,o=h.m_R,k=o.col1.x*n+o.col2.x*p,p=o.col1.y*n+o.col2.y*p;k+=h.m_position.x;p+=h.m_position.y;l=m.x;m=m.y;n=l;o=h.m_R;l=o.col1.x*n+o.col2.x*m;m=o.col1.y*n+o.col2.y*m;l+=h.m_position.x;m+=h.m_position.y;h=j*k+c*p;n=-(f*k+i*p);l=f*l+i*m;m=[new ClipVertex,new ClipVertex];k=[new ClipVertex,new ClipVertex];o=0;b2Collision.b2CollidePolyTempVec.Set(-f,-i);o=b2Collision.ClipSegmentToLine(m,b,b2Collision.b2CollidePolyTempVec,n);if(!(o<2)&&(b2Collision.b2CollidePolyTempVec.Set(f,
i),o=b2Collision.ClipSegmentToLine(k,m,b2Collision.b2CollidePolyTempVec,l),!(o<2))){g?a.normal.Set(-j,-c):a.normal.Set(j,c);for(f=b=0;f<b2Settings.b2_maxManifoldPoints;++f)if(i=k[f].v,i=j*i.x+c*i.y-h,i<=0||e==!0)l=a.points[b],l.separation=i,l.position.SetV(k[f].v),l.id.Set(k[f].id),l.id.features.flip=g,++b;a.pointCount=b}}}};
b2Collision.b2CollideCircle=function(a,c,b,e){a.pointCount=0;var f=b.m_position.x-c.m_position.x,g=b.m_position.y-c.m_position.y,h=f*f+g*g,c=c.m_radius+b.m_radius;if(!(h>c*c&&e==!1))h<Number.MIN_VALUE?(e=-c,a.normal.Set(0,1)):(h=Math.sqrt(h),e=h-c,h=1/h,a.normal.x=h*f,a.normal.y=h*g),a.pointCount=1,f=a.points[0],f.id.set_key(0),f.separation=e,f.position.x=b.m_position.x-b.m_radius*a.normal.x,f.position.y=b.m_position.y-b.m_radius*a.normal.y};
b2Collision.b2CollidePolyAndCircle=function(a,c,b){a.pointCount=0;var e,f,g;f=b.m_position.x-c.m_position.x;g=b.m_position.y-c.m_position.y;var h=c.m_R,i=f*h.col1.x+g*h.col1.y;g=f*h.col2.x+g*h.col2.y;f=i;var k=0,j=-Number.MAX_VALUE,i=b.m_radius;for(e=0;e<c.m_vertexCount;++e){var l=c.m_normals[e].x*(f-c.m_vertices[e].x)+c.m_normals[e].y*(g-c.m_vertices[e].y);if(l>i)return;l>j&&(j=l,k=e)}if(j<Number.MIN_VALUE)a.pointCount=1,g=c.m_normals[k],a.normal.x=h.col1.x*g.x+h.col2.x*g.y,a.normal.y=h.col1.y*g.x+
h.col2.y*g.y,e=a.points[0],e.id.features.incidentEdge=k,e.id.features.incidentVertex=b2Collision.b2_nullFeature,e.id.features.referenceFace=b2Collision.b2_nullFeature,e.id.features.flip=0,e.position.x=b.m_position.x-i*a.normal.x,e.position.y=b.m_position.y-i*a.normal.y,e.separation=j-i;else{var j=k+1<c.m_vertexCount?k+1:0,m=c.m_vertices[j].x-c.m_vertices[k].x,l=c.m_vertices[j].y-c.m_vertices[k].y,n=Math.sqrt(m*m+l*l);m/=n;l/=n;if(n<Number.MIN_VALUE){if(f-=c.m_vertices[k].x,g-=c.m_vertices[k].y,c=
Math.sqrt(f*f+g*g),f/=c,g/=c,!(c>i))a.pointCount=1,a.normal.Set(h.col1.x*f+h.col2.x*g,h.col1.y*f+h.col2.y*g),e=a.points[0],e.id.features.incidentEdge=b2Collision.b2_nullFeature,e.id.features.incidentVertex=k,e.id.features.referenceFace=b2Collision.b2_nullFeature,e.id.features.flip=0,e.position.x=b.m_position.x-i*a.normal.x,e.position.y=b.m_position.y-i*a.normal.y,e.separation=c-i}else{var o=(f-c.m_vertices[k].x)*m+(g-c.m_vertices[k].y)*l;e=a.points[0];e.id.features.incidentEdge=b2Collision.b2_nullFeature;
e.id.features.incidentVertex=b2Collision.b2_nullFeature;e.id.features.referenceFace=b2Collision.b2_nullFeature;e.id.features.flip=0;o<=0?(m=c.m_vertices[k].x,c=c.m_vertices[k].y,e.id.features.incidentVertex=k):o>=n?(m=c.m_vertices[j].x,c=c.m_vertices[j].y,e.id.features.incidentVertex=j):(m=m*o+c.m_vertices[k].x,c=l*o+c.m_vertices[k].y,e.id.features.incidentEdge=k);f-=m;g-=c;c=Math.sqrt(f*f+g*g);f/=c;g/=c;if(!(c>i))a.pointCount=1,a.normal.Set(h.col1.x*f+h.col2.x*g,h.col1.y*f+h.col2.y*g),e.position.x=
b.m_position.x-i*a.normal.x,e.position.y=b.m_position.y-i*a.normal.y,e.separation=c-i}}};b2Collision.b2TestOverlap=function(a,c){var b=c.minVertex,e=a.maxVertex,f=b.x-e.x,g=b.y-e.y,b=a.minVertex,e=c.maxVertex,h=b.y-e.y;if(f>0||g>0)return!1;if(b.x-e.x>0||h>0)return!1;return!0};var Features=Class.create();
Features.prototype={set_referenceFace:function(a){this._referenceFace=a;this._m_id._key=this._m_id._key&4294967040|this._referenceFace&255},get_referenceFace:function(){return this._referenceFace},_referenceFace:0,set_incidentEdge:function(a){this._incidentEdge=a;this._m_id._key=this._m_id._key&4294902015|this._incidentEdge<<8&65280},get_incidentEdge:function(){return this._incidentEdge},_incidentEdge:0,set_incidentVertex:function(a){this._incidentVertex=a;this._m_id._key=this._m_id._key&4278255615|
this._incidentVertex<<16&16711680},get_incidentVertex:function(){return this._incidentVertex},_incidentVertex:0,set_flip:function(a){this._flip=a;this._m_id._key=this._m_id._key&16777215|this._flip<<24&4278190080},get_flip:function(){return this._flip},_flip:0,_m_id:null,initialize:function(){}};var b2ContactID=Class.create();
b2ContactID.prototype={initialize:function(){this.features=new Features;this.features._m_id=this},Set:function(a){this.set_key(a._key)},Copy:function(){var a=new b2ContactID;a.set_key(this._key);return a},get_key:function(){return this._key},set_key:function(a){this._key=a;this.features._referenceFace=this._key&255;this.features._incidentEdge=(this._key&65280)>>8&255;this.features._incidentVertex=(this._key&16711680)>>16&255;this.features._flip=(this._key&4278190080)>>24&255},features:new Features,
_key:0};var b2ContactPoint=Class.create();b2ContactPoint.prototype={position:new b2Vec2,separation:null,normalImpulse:null,tangentImpulse:null,id:new b2ContactID,initialize:function(){this.position=new b2Vec2;this.id=new b2ContactID}};var b2Distance=Class.create();b2Distance.prototype={initialize:function(){}};
b2Distance.ProcessTwo=function(a,c,b,e,f){var g=-f[1].x,h=-f[1].y,i=f[0].x-f[1].x,k=f[0].y-f[1].y,j=Math.sqrt(i*i+k*k);i/=j;k/=j;g=g*i+h*k;if(g<=0||j<Number.MIN_VALUE)return a.SetV(b[1]),c.SetV(e[1]),b[0].SetV(b[1]),e[0].SetV(e[1]),f[0].SetV(f[1]),1;g/=j;a.x=b[1].x+g*(b[0].x-b[1].x);a.y=b[1].y+g*(b[0].y-b[1].y);c.x=e[1].x+g*(e[0].x-e[1].x);c.y=e[1].y+g*(e[0].y-e[1].y);return 2};
b2Distance.ProcessThree=function(a,c,b,e,f){var g=f[0].x,h=f[0].y,i=f[1].x,k=f[1].y,j=f[2].x,l=f[2].y,m=i-g,n=k-h,o=j-g,p=l-h,q=j-i,s=l-k,r=-(g*o+h*p),u=j*o+l*p,z=-(i*q+k*s),q=j*q+l*s;if(u<=0&&q<=0)return a.SetV(b[2]),c.SetV(e[2]),b[0].SetV(b[2]),e[0].SetV(e[2]),f[0].SetV(f[2]),1;n=m*p-n*o;m=n*(g*k-h*i);i=n*(i*l-k*j);if(i<=0&&z>=0&&q>=0)return r=z/(z+q),a.x=b[1].x+r*(b[2].x-b[1].x),a.y=b[1].y+r*(b[2].y-b[1].y),c.x=e[1].x+r*(e[2].x-e[1].x),c.y=e[1].y+r*(e[2].y-e[1].y),b[0].SetV(b[2]),e[0].SetV(e[2]),
f[0].SetV(f[2]),2;g=n*(j*h-l*g);if(g<=0&&r>=0&&u>=0)return r/=r+u,a.x=b[0].x+r*(b[2].x-b[0].x),a.y=b[0].y+r*(b[2].y-b[0].y),c.x=e[0].x+r*(e[2].x-e[0].x),c.y=e[0].y+r*(e[2].y-e[0].y),b[1].SetV(b[2]),e[1].SetV(e[2]),f[1].SetV(f[2]),2;r=1/(i+g+m);f=i*r;r*=g;u=1-f-r;a.x=f*b[0].x+r*b[1].x+u*b[2].x;a.y=f*b[0].y+r*b[1].y+u*b[2].y;c.x=f*e[0].x+r*e[1].x+u*e[2].x;c.y=f*e[0].y+r*e[1].y+u*e[2].y;return 3};b2Distance.InPoinsts=function(a,c,b){for(var e=0;e<b;++e)if(a.x==c[e].x&&a.y==c[e].y)return!0;return!1};
b2Distance.Distance=function(a,c,b,e){var f=Array(3),g=Array(3),h=Array(3),i=0;a.SetV(b.m_position);c.SetV(e.m_position);for(var k=0,j=0;j<20;++j){var l=c.x-a.x,m=c.y-a.y,n=b.Support(l,m),o=e.Support(-l,-m),k=l*l+m*m,p=o.x-n.x,q=o.y-n.y;if(k-b2Dot(l*p+m*q)<=0.01*k)return i==0&&(a.SetV(n),c.SetV(o)),b2Distance.g_GJK_Iterations=j,Math.sqrt(k);switch(i){case 0:f[0].SetV(n);g[0].SetV(o);h[0]=w;a.SetV(f[0]);c.SetV(g[0]);++i;break;case 1:f[1].SetV(n);g[1].SetV(o);h[1].x=p;h[1].y=q;i=b2Distance.ProcessTwo(a,
c,f,g,h);break;case 2:f[2].SetV(n),g[2].SetV(o),h[2].x=p,h[2].y=q,i=b2Distance.ProcessThree(a,c,f,g,h)}if(i==3)return b2Distance.g_GJK_Iterations=j,0;l=-Number.MAX_VALUE;for(m=0;m<i;++m)l=b2Math.b2Max(l,h[m].x*h[m].x+h[m].y*h[m].y);if(i==3||k<=100*Number.MIN_VALUE*l)return b2Distance.g_GJK_Iterations=j,Math.sqrt(k)}b2Distance.g_GJK_Iterations=20;return Math.sqrt(k)};b2Distance.g_GJK_Iterations=0;var b2Manifold=Class.create();
b2Manifold.prototype={initialize:function(){this.points=Array(b2Settings.b2_maxManifoldPoints);for(var a=0;a<b2Settings.b2_maxManifoldPoints;a++)this.points[a]=new b2ContactPoint;this.normal=new b2Vec2},points:null,normal:null,pointCount:0};var b2OBB=Class.create();b2OBB.prototype={R:new b2Mat22,center:new b2Vec2,extents:new b2Vec2,initialize:function(){this.R=new b2Mat22;this.center=new b2Vec2;this.extents=new b2Vec2}};var b2Proxy=Class.create();
b2Proxy.prototype={GetNext:function(){return this.lowerBounds[0]},SetNext:function(a){this.lowerBounds[0]=a},IsValid:function(){return this.overlapCount!=b2BroadPhase.b2_invalid},lowerBounds:[0,0],upperBounds:[0,0],overlapCount:0,timeStamp:0,userData:null,initialize:function(){this.lowerBounds=[0,0];this.upperBounds=[0,0]}};var ClipVertex=Class.create();ClipVertex.prototype={v:new b2Vec2,id:new b2ContactID,initialize:function(){this.v=new b2Vec2;this.id=new b2ContactID}};var b2Shape=Class.create();
b2Shape.prototype={TestPoint:function(){return!1},GetUserData:function(){return this.m_userData},GetType:function(){return this.m_type},GetBody:function(){return this.m_body},GetPosition:function(){return this.m_position},GetRotationMatrix:function(){return this.m_R},ResetProxy:function(){},GetNext:function(){return this.m_next},initialize:function(a,c){this.m_R=new b2Mat22;this.m_position=new b2Vec2;this.m_userData=a.userData;this.m_friction=a.friction;this.m_restitution=a.restitution;this.m_body=
c;this.m_proxyId=b2Pair.b2_nullProxy;this.m_maxRadius=0;this.m_categoryBits=a.categoryBits;this.m_maskBits=a.maskBits;this.m_groupIndex=a.groupIndex},DestroyProxy:function(){if(this.m_proxyId!=b2Pair.b2_nullProxy)this.m_body.m_world.m_broadPhase.DestroyProxy(this.m_proxyId),this.m_proxyId=b2Pair.b2_nullProxy},Synchronize:function(){},QuickSync:function(){},Support:function(){},GetMaxRadius:function(){return this.m_maxRadius},m_next:null,m_R:new b2Mat22,m_position:new b2Vec2,m_type:0,m_userData:null,
m_body:null,m_friction:null,m_restitution:null,m_maxRadius:null,m_proxyId:0,m_categoryBits:0,m_maskBits:0,m_groupIndex:0};b2Shape.Create=function(a,c,b){switch(a.type){case b2Shape.e_circleShape:return new b2CircleShape(a,c,b);case b2Shape.e_boxShape:case b2Shape.e_polyShape:return new b2PolyShape(a,c,b)}return null};b2Shape.Destroy=function(a){a.m_proxyId!=b2Pair.b2_nullProxy&&a.m_body.m_world.m_broadPhase.DestroyProxy(a.m_proxyId)};b2Shape.e_unknownShape=-1;b2Shape.e_circleShape=0;
b2Shape.e_boxShape=1;b2Shape.e_polyShape=2;b2Shape.e_meshShape=3;b2Shape.e_shapeTypeCount=4;
b2Shape.PolyMass=function(a,c,b,e){var f=new b2Vec2;f.SetZero();for(var g=0,h=0,i=new b2Vec2(0,0),k=1/3,j=0;j<b;++j){var l=i,m=c[j],n=j+1<b?c[j+1]:c[0],o=b2Math.SubtractVV(m,l),p=b2Math.SubtractVV(n,l),q=b2Math.b2CrossVV(o,p),s=0.5*q;g+=s;var r=new b2Vec2;r.SetV(l);r.Add(m);r.Add(n);r.Multiply(k*s);f.Add(r);m=l.x;l=l.y;n=o.x;o=o.y;s=p.x;p=p.y;h+=q*(k*(0.25*(n*n+s*n+s*s)+(m*n+m*s))+0.5*m*m+(k*(0.25*(o*o+p*o+p*p)+(l*o+l*p))+0.5*l*l))}a.mass=e*g;f.Multiply(1/g);a.center=f;h=e*(h-g*b2Math.b2Dot(f,f));
a.I=h};b2Shape.PolyCentroid=function(a,c,b){for(var e=0,f=0,g=0,h=1/3,i=0;i<c;++i){var k=a[i].x,j=a[i].y,l=i+1<c?a[i+1].x:a[0].x,m=i+1<c?a[i+1].y:a[0].y,n=0.5*((k-0)*(m-0)-(j-0)*(l-0));g+=n;e+=n*h*(0+k+l);f+=n*h*(0+j+m)}e*=1/g;f*=1/g;b.Set(e,f)};var b2ShapeDef=Class.create();
b2ShapeDef.prototype={initialize:function(){this.type=b2Shape.e_unknownShape;this.userData=null;this.localPosition=new b2Vec2(0,0);this.localRotation=0;this.friction=0.2;this.density=this.restitution=0;this.categoryBits=1;this.maskBits=65535;this.groupIndex=0},ComputeMass:function(a){a.center=new b2Vec2(0,0);if(this.density==0)a.mass=0,a.center.Set(0,0),a.I=0;switch(this.type){case b2Shape.e_circleShape:a.mass=this.density*b2Settings.b2_pi*this.radius*this.radius;a.center.Set(0,0);a.I=0.5*a.mass*
this.radius*this.radius;break;case b2Shape.e_boxShape:a.mass=4*this.density*this.extents.x*this.extents.y;a.center.Set(0,0);a.I=a.mass/3*b2Math.b2Dot(this.extents,this.extents);break;case b2Shape.e_polyShape:b2Shape.PolyMass(a,this.vertices,this.vertexCount,this.density);break;default:a.mass=0,a.center.Set(0,0),a.I=0}},type:0,userData:null,localPosition:null,localRotation:null,friction:null,restitution:null,density:null,categoryBits:0,maskBits:0,groupIndex:0};var b2BoxDef=Class.create();
Object.extend(b2BoxDef.prototype,b2ShapeDef.prototype);Object.extend(b2BoxDef.prototype,{initialize:function(){this.type=b2Shape.e_unknownShape;this.userData=null;this.localPosition=new b2Vec2(0,0);this.localRotation=0;this.friction=0.2;this.density=this.restitution=0;this.categoryBits=1;this.maskBits=65535;this.groupIndex=0;this.type=b2Shape.e_boxShape;this.extents=new b2Vec2(1,1)},extents:null});var b2CircleDef=Class.create();Object.extend(b2CircleDef.prototype,b2ShapeDef.prototype);
Object.extend(b2CircleDef.prototype,{initialize:function(){this.type=b2Shape.e_unknownShape;this.userData=null;this.localPosition=new b2Vec2(0,0);this.localRotation=0;this.friction=0.2;this.density=this.restitution=0;this.categoryBits=1;this.maskBits=65535;this.groupIndex=0;this.type=b2Shape.e_circleShape;this.radius=1},radius:null});var b2CircleShape=Class.create();Object.extend(b2CircleShape.prototype,b2Shape.prototype);
Object.extend(b2CircleShape.prototype,{TestPoint:function(a){var c=new b2Vec2;c.SetV(a);c.Subtract(this.m_position);return b2Math.b2Dot(c,c)<=this.m_radius*this.m_radius},initialize:function(a,c,b){this.m_R=new b2Mat22;this.m_position=new b2Vec2;this.m_userData=a.userData;this.m_friction=a.friction;this.m_restitution=a.restitution;this.m_body=c;this.m_proxyId=b2Pair.b2_nullProxy;this.m_maxRadius=0;this.m_categoryBits=a.categoryBits;this.m_maskBits=a.maskBits;this.m_groupIndex=a.groupIndex;this.m_localPosition=
new b2Vec2;this.m_localPosition.Set(a.localPosition.x-b.x,a.localPosition.y-b.y);this.m_type=b2Shape.e_circleShape;this.m_radius=a.radius;this.m_R.SetM(this.m_body.m_R);a=this.m_R.col1.x*this.m_localPosition.x+this.m_R.col2.x*this.m_localPosition.y;c=this.m_R.col1.y*this.m_localPosition.x+this.m_R.col2.y*this.m_localPosition.y;this.m_position.x=this.m_body.m_position.x+a;this.m_position.y=this.m_body.m_position.y+c;this.m_maxRadius=Math.sqrt(a*a+c*c)+this.m_radius;a=new b2AABB;a.minVertex.Set(this.m_position.x-
this.m_radius,this.m_position.y-this.m_radius);a.maxVertex.Set(this.m_position.x+this.m_radius,this.m_position.y+this.m_radius);c=this.m_body.m_world.m_broadPhase;this.m_proxyId=c.InRange(a)?c.CreateProxy(a,this):b2Pair.b2_nullProxy;this.m_proxyId==b2Pair.b2_nullProxy&&this.m_body.Freeze()},Synchronize:function(a,c,b,e){this.m_R.SetM(e);this.m_position.x=e.col1.x*this.m_localPosition.x+e.col2.x*this.m_localPosition.y+b.x;this.m_position.y=e.col1.y*this.m_localPosition.x+e.col2.y*this.m_localPosition.y+
b.y;if(this.m_proxyId!=b2Pair.b2_nullProxy){var b=a.x+(c.col1.x*this.m_localPosition.x+c.col2.x*this.m_localPosition.y),e=a.y+(c.col1.y*this.m_localPosition.x+c.col2.y*this.m_localPosition.y),a=Math.min(b,this.m_position.x),c=Math.min(e,this.m_position.y),b=Math.max(b,this.m_position.x),f=Math.max(e,this.m_position.y),e=new b2AABB;e.minVertex.Set(a-this.m_radius,c-this.m_radius);e.maxVertex.Set(b+this.m_radius,f+this.m_radius);a=this.m_body.m_world.m_broadPhase;a.InRange(e)?a.MoveProxy(this.m_proxyId,
e):this.m_body.Freeze()}},QuickSync:function(a,c){this.m_R.SetM(c);this.m_position.x=c.col1.x*this.m_localPosition.x+c.col2.x*this.m_localPosition.y+a.x;this.m_position.y=c.col1.y*this.m_localPosition.x+c.col2.y*this.m_localPosition.y+a.y},ResetProxy:function(a){if(this.m_proxyId!=b2Pair.b2_nullProxy){a.GetProxy(this.m_proxyId);a.DestroyProxy(this.m_proxyId);var c=new b2AABB;c.minVertex.Set(this.m_position.x-this.m_radius,this.m_position.y-this.m_radius);c.maxVertex.Set(this.m_position.x+this.m_radius,
this.m_position.y+this.m_radius);this.m_proxyId=a.InRange(c)?a.CreateProxy(c,this):b2Pair.b2_nullProxy;this.m_proxyId==b2Pair.b2_nullProxy&&this.m_body.Freeze()}},Support:function(a,c,b){var e=Math.sqrt(a*a+c*c);a/=e;c/=e;b.Set(this.m_position.x+this.m_radius*a,this.m_position.y+this.m_radius*c)},m_localPosition:new b2Vec2,m_radius:null});var b2MassData=Class.create();b2MassData.prototype={mass:0,center:new b2Vec2(0,0),I:0,initialize:function(){this.center=new b2Vec2(0,0)}};var b2PolyDef=Class.create();
Object.extend(b2PolyDef.prototype,b2ShapeDef.prototype);
Object.extend(b2PolyDef.prototype,{initialize:function(){this.type=b2Shape.e_unknownShape;this.userData=null;this.localPosition=new b2Vec2(0,0);this.localRotation=0;this.friction=0.2;this.density=this.restitution=0;this.categoryBits=1;this.maskBits=65535;this.groupIndex=0;this.vertices=Array(b2Settings.b2_maxPolyVertices);this.type=b2Shape.e_polyShape;for(var a=this.vertexCount=0;a<b2Settings.b2_maxPolyVertices;a++)this.vertices[a]=new b2Vec2},vertices:Array(b2Settings.b2_maxPolyVertices),vertexCount:0});
var b2PolyShape=Class.create();Object.extend(b2PolyShape.prototype,b2Shape.prototype);
Object.extend(b2PolyShape.prototype,{TestPoint:function(a){var c=new b2Vec2;c.SetV(a);c.Subtract(this.m_position);c.MulTM(this.m_R);for(a=0;a<this.m_vertexCount;++a){var b=new b2Vec2;b.SetV(c);b.Subtract(this.m_vertices[a]);if(b2Math.b2Dot(this.m_normals[a],b)>0)return!1}return!0},initialize:function(a,c,b){this.m_R=new b2Mat22;this.m_position=new b2Vec2;this.m_userData=a.userData;this.m_friction=a.friction;this.m_restitution=a.restitution;this.m_body=c;this.m_proxyId=b2Pair.b2_nullProxy;this.m_maxRadius=
0;this.m_categoryBits=a.categoryBits;this.m_maskBits=a.maskBits;this.m_groupIndex=a.groupIndex;this.syncAABB=new b2AABB;this.syncMat=new b2Mat22;this.m_localCentroid=new b2Vec2;this.m_localOBB=new b2OBB;var e=0,f,c=new b2AABB;this.m_vertices=Array(b2Settings.b2_maxPolyVertices);this.m_coreVertices=Array(b2Settings.b2_maxPolyVertices);this.m_normals=Array(b2Settings.b2_maxPolyVertices);this.m_type=b2Shape.e_polyShape;var g=new b2Mat22(a.localRotation);if(a.type==b2Shape.e_boxShape){this.m_localCentroid.x=
a.localPosition.x-b.x;this.m_localCentroid.y=a.localPosition.y-b.y;this.m_vertexCount=4;b=a.extents.x;f=a.extents.y;var a=Math.max(0,b-2*b2Settings.b2_linearSlop),h=Math.max(0,f-2*b2Settings.b2_linearSlop),e=this.m_vertices[0]=new b2Vec2;e.x=g.col1.x*b+g.col2.x*f;e.y=g.col1.y*b+g.col2.y*f;e=this.m_vertices[1]=new b2Vec2;e.x=g.col1.x*-b+g.col2.x*f;e.y=g.col1.y*-b+g.col2.y*f;e=this.m_vertices[2]=new b2Vec2;e.x=g.col1.x*-b+g.col2.x*-f;e.y=g.col1.y*-b+g.col2.y*-f;e=this.m_vertices[3]=new b2Vec2;e.x=g.col1.x*
b+g.col2.x*-f;e.y=g.col1.y*b+g.col2.y*-f;e=this.m_coreVertices[0]=new b2Vec2;e.x=g.col1.x*a+g.col2.x*h;e.y=g.col1.y*a+g.col2.y*h;e=this.m_coreVertices[1]=new b2Vec2;e.x=g.col1.x*-a+g.col2.x*h;e.y=g.col1.y*-a+g.col2.y*h;e=this.m_coreVertices[2]=new b2Vec2;e.x=g.col1.x*-a+g.col2.x*-h;e.y=g.col1.y*-a+g.col2.y*-h;e=this.m_coreVertices[3]=new b2Vec2;e.x=g.col1.x*a+g.col2.x*-h;e.y=g.col1.y*a+g.col2.y*-h}else{this.m_vertexCount=a.vertexCount;b2Shape.PolyCentroid(a.vertices,a.vertexCount,b2PolyShape.tempVec);
var h=b2PolyShape.tempVec.x,i=b2PolyShape.tempVec.y;this.m_localCentroid.x=a.localPosition.x+(g.col1.x*h+g.col2.x*i)-b.x;this.m_localCentroid.y=a.localPosition.y+(g.col1.y*h+g.col2.y*i)-b.y;for(e=0;e<this.m_vertexCount;++e){this.m_vertices[e]=new b2Vec2;this.m_coreVertices[e]=new b2Vec2;b=a.vertices[e].x-h;f=a.vertices[e].y-i;this.m_vertices[e].x=g.col1.x*b+g.col2.x*f;this.m_vertices[e].y=g.col1.y*b+g.col2.y*f;b=this.m_vertices[e].x;f=this.m_vertices[e].y;var k=Math.sqrt(b*b+f*f);k>Number.MIN_VALUE&&
(b*=1/k,f*=1/k);this.m_coreVertices[e].x=this.m_vertices[e].x-2*b2Settings.b2_linearSlop*b;this.m_coreVertices[e].y=this.m_vertices[e].y-2*b2Settings.b2_linearSlop*f}}a=g=Number.MAX_VALUE;b=-Number.MAX_VALUE;f=-Number.MAX_VALUE;for(e=this.m_maxRadius=0;e<this.m_vertexCount;++e)h=this.m_vertices[e],g=Math.min(g,h.x),a=Math.min(a,h.y),b=Math.max(b,h.x),f=Math.max(f,h.y),this.m_maxRadius=Math.max(this.m_maxRadius,h.Length());this.m_localOBB.R.SetIdentity();this.m_localOBB.center.Set((g+b)*0.5,(a+f)*
0.5);this.m_localOBB.extents.Set((b-g)*0.5,(f-a)*0.5);for(e=a=g=0;e<this.m_vertexCount;++e)this.m_normals[e]=new b2Vec2,g=e,a=e+1<this.m_vertexCount?e+1:0,this.m_normals[e].x=this.m_vertices[a].y-this.m_vertices[g].y,this.m_normals[e].y=-(this.m_vertices[a].x-this.m_vertices[g].x),this.m_normals[e].Normalize();for(e=0;e<this.m_vertexCount;++e);this.m_R.SetM(this.m_body.m_R);this.m_position.x=this.m_body.m_position.x+(this.m_R.col1.x*this.m_localCentroid.x+this.m_R.col2.x*this.m_localCentroid.y);this.m_position.y=
this.m_body.m_position.y+(this.m_R.col1.y*this.m_localCentroid.x+this.m_R.col2.y*this.m_localCentroid.y);b2PolyShape.tAbsR.col1.x=this.m_R.col1.x*this.m_localOBB.R.col1.x+this.m_R.col2.x*this.m_localOBB.R.col1.y;b2PolyShape.tAbsR.col1.y=this.m_R.col1.y*this.m_localOBB.R.col1.x+this.m_R.col2.y*this.m_localOBB.R.col1.y;b2PolyShape.tAbsR.col2.x=this.m_R.col1.x*this.m_localOBB.R.col2.x+this.m_R.col2.x*this.m_localOBB.R.col2.y;b2PolyShape.tAbsR.col2.y=this.m_R.col1.y*this.m_localOBB.R.col2.x+this.m_R.col2.y*
this.m_localOBB.R.col2.y;b2PolyShape.tAbsR.Abs();b=b2PolyShape.tAbsR.col1.x*this.m_localOBB.extents.x+b2PolyShape.tAbsR.col2.x*this.m_localOBB.extents.y;f=b2PolyShape.tAbsR.col1.y*this.m_localOBB.extents.x+b2PolyShape.tAbsR.col2.y*this.m_localOBB.extents.y;e=this.m_position.x+(this.m_R.col1.x*this.m_localOBB.center.x+this.m_R.col2.x*this.m_localOBB.center.y);g=this.m_position.y+(this.m_R.col1.y*this.m_localOBB.center.x+this.m_R.col2.y*this.m_localOBB.center.y);c.minVertex.x=e-b;c.minVertex.y=g-f;
c.maxVertex.x=e+b;c.maxVertex.y=g+f;e=this.m_body.m_world.m_broadPhase;this.m_proxyId=e.InRange(c)?e.CreateProxy(c,this):b2Pair.b2_nullProxy;this.m_proxyId==b2Pair.b2_nullProxy&&this.m_body.Freeze()},syncAABB:new b2AABB,syncMat:new b2Mat22,Synchronize:function(a,c,b,e){this.m_R.SetM(e);this.m_position.x=this.m_body.m_position.x+(e.col1.x*this.m_localCentroid.x+e.col2.x*this.m_localCentroid.y);this.m_position.y=this.m_body.m_position.y+(e.col1.y*this.m_localCentroid.x+e.col2.y*this.m_localCentroid.y);
if(this.m_proxyId!=b2Pair.b2_nullProxy){var f,g;f=c.col1;g=c.col2;var h=this.m_localOBB.R.col1,i=this.m_localOBB.R.col2;this.syncMat.col1.x=f.x*h.x+g.x*h.y;this.syncMat.col1.y=f.y*h.x+g.y*h.y;this.syncMat.col2.x=f.x*i.x+g.x*i.y;this.syncMat.col2.y=f.y*i.x+g.y*i.y;this.syncMat.Abs();f=this.m_localCentroid.x+this.m_localOBB.center.x;g=this.m_localCentroid.y+this.m_localOBB.center.y;h=a.x+(c.col1.x*f+c.col2.x*g);a=a.y+(c.col1.y*f+c.col2.y*g);f=this.syncMat.col1.x*this.m_localOBB.extents.x+this.syncMat.col2.x*
this.m_localOBB.extents.y;g=this.syncMat.col1.y*this.m_localOBB.extents.x+this.syncMat.col2.y*this.m_localOBB.extents.y;this.syncAABB.minVertex.x=h-f;this.syncAABB.minVertex.y=a-g;this.syncAABB.maxVertex.x=h+f;this.syncAABB.maxVertex.y=a+g;f=e.col1;g=e.col2;h=this.m_localOBB.R.col1;i=this.m_localOBB.R.col2;this.syncMat.col1.x=f.x*h.x+g.x*h.y;this.syncMat.col1.y=f.y*h.x+g.y*h.y;this.syncMat.col2.x=f.x*i.x+g.x*i.y;this.syncMat.col2.y=f.y*i.x+g.y*i.y;this.syncMat.Abs();f=this.m_localCentroid.x+this.m_localOBB.center.x;
g=this.m_localCentroid.y+this.m_localOBB.center.y;h=b.x+(e.col1.x*f+e.col2.x*g);a=b.y+(e.col1.y*f+e.col2.y*g);f=this.syncMat.col1.x*this.m_localOBB.extents.x+this.syncMat.col2.x*this.m_localOBB.extents.y;g=this.syncMat.col1.y*this.m_localOBB.extents.x+this.syncMat.col2.y*this.m_localOBB.extents.y;this.syncAABB.minVertex.x=Math.min(this.syncAABB.minVertex.x,h-f);this.syncAABB.minVertex.y=Math.min(this.syncAABB.minVertex.y,a-g);this.syncAABB.maxVertex.x=Math.max(this.syncAABB.maxVertex.x,h+f);this.syncAABB.maxVertex.y=
Math.max(this.syncAABB.maxVertex.y,a+g);b=this.m_body.m_world.m_broadPhase;b.InRange(this.syncAABB)?b.MoveProxy(this.m_proxyId,this.syncAABB):this.m_body.Freeze()}},QuickSync:function(a,c){this.m_R.SetM(c);this.m_position.x=a.x+(c.col1.x*this.m_localCentroid.x+c.col2.x*this.m_localCentroid.y);this.m_position.y=a.y+(c.col1.y*this.m_localCentroid.x+c.col2.y*this.m_localCentroid.y)},ResetProxy:function(a){if(this.m_proxyId!=b2Pair.b2_nullProxy){a.GetProxy(this.m_proxyId);a.DestroyProxy(this.m_proxyId);
var c=b2Math.b2MulMM(this.m_R,this.m_localOBB.R),c=b2Math.b2AbsM(c),c=b2Math.b2MulMV(c,this.m_localOBB.extents),b=b2Math.b2MulMV(this.m_R,this.m_localOBB.center);b.Add(this.m_position);var e=new b2AABB;e.minVertex.SetV(b);e.minVertex.Subtract(c);e.maxVertex.SetV(b);e.maxVertex.Add(c);this.m_proxyId=a.InRange(e)?a.CreateProxy(e,this):b2Pair.b2_nullProxy;this.m_proxyId==b2Pair.b2_nullProxy&&this.m_body.Freeze()}},Support:function(a,c,b){for(var e=a*this.m_R.col1.x+c*this.m_R.col1.y,a=a*this.m_R.col2.x+
c*this.m_R.col2.y,c=0,f=this.m_coreVertices[0].x*e+this.m_coreVertices[0].y*a,g=1;g<this.m_vertexCount;++g){var h=this.m_coreVertices[g].x*e+this.m_coreVertices[g].y*a;h>f&&(c=g,f=h)}b.Set(this.m_position.x+(this.m_R.col1.x*this.m_coreVertices[c].x+this.m_R.col2.x*this.m_coreVertices[c].y),this.m_position.y+(this.m_R.col1.y*this.m_coreVertices[c].x+this.m_R.col2.y*this.m_coreVertices[c].y))},m_localCentroid:new b2Vec2,m_localOBB:new b2OBB,m_vertices:null,m_coreVertices:null,m_vertexCount:0,m_normals:null});
b2PolyShape.tempVec=new b2Vec2;b2PolyShape.tAbsR=new b2Mat22;var b2Body=Class.create();
b2Body.prototype={SetOriginPosition:function(a,c){if(!this.IsFrozen()){this.m_rotation=c;this.m_R.Set(this.m_rotation);this.m_position=b2Math.AddVV(a,b2Math.b2MulMV(this.m_R,this.m_center));this.m_position0.SetV(this.m_position);this.m_rotation0=this.m_rotation;for(var b=this.m_shapeList;b!=null;b=b.m_next)b.Synchronize(this.m_position,this.m_R,this.m_position,this.m_R);this.m_world.m_broadPhase.Commit()}},GetOriginPosition:function(){return b2Math.SubtractVV(this.m_position,b2Math.b2MulMV(this.m_R,
this.m_center))},SetCenterPosition:function(a,c){if(!this.IsFrozen()){this.m_rotation=c;this.m_R.Set(this.m_rotation);this.m_position.SetV(a);this.m_position0.SetV(this.m_position);this.m_rotation0=this.m_rotation;for(var b=this.m_shapeList;b!=null;b=b.m_next)b.Synchronize(this.m_position,this.m_R,this.m_position,this.m_R);this.m_world.m_broadPhase.Commit()}},GetCenterPosition:function(){return this.m_position},GetRotation:function(){return this.m_rotation},GetRotationMatrix:function(){return this.m_R},
SetLinearVelocity:function(a){this.m_linearVelocity.SetV(a)},GetLinearVelocity:function(){return this.m_linearVelocity},SetAngularVelocity:function(a){this.m_angularVelocity=a},GetAngularVelocity:function(){return this.m_angularVelocity},ApplyForce:function(a,c){this.IsSleeping()==!1&&(this.m_force.Add(a),this.m_torque+=b2Math.b2CrossVV(b2Math.SubtractVV(c,this.m_position),a))},ApplyTorque:function(a){this.IsSleeping()==!1&&(this.m_torque+=a)},ApplyImpulse:function(a,c){this.IsSleeping()==!1&&(this.m_linearVelocity.Add(b2Math.MulFV(this.m_invMass,
a)),this.m_angularVelocity+=this.m_invI*b2Math.b2CrossVV(b2Math.SubtractVV(c,this.m_position),a))},GetMass:function(){return this.m_mass},GetInertia:function(){return this.m_I},GetWorldPoint:function(a){return b2Math.AddVV(this.m_position,b2Math.b2MulMV(this.m_R,a))},GetWorldVector:function(a){return b2Math.b2MulMV(this.m_R,a)},GetLocalPoint:function(a){return b2Math.b2MulTMV(this.m_R,b2Math.SubtractVV(a,this.m_position))},GetLocalVector:function(a){return b2Math.b2MulTMV(this.m_R,a)},IsStatic:function(){return(this.m_flags&
b2Body.e_staticFlag)==b2Body.e_staticFlag},IsFrozen:function(){return(this.m_flags&b2Body.e_frozenFlag)==b2Body.e_frozenFlag},IsSleeping:function(){return(this.m_flags&b2Body.e_sleepFlag)==b2Body.e_sleepFlag},AllowSleeping:function(a){a?this.m_flags|=b2Body.e_allowSleepFlag:(this.m_flags&=~b2Body.e_allowSleepFlag,this.WakeUp())},WakeUp:function(){this.m_flags&=~b2Body.e_sleepFlag;this.m_sleepTime=0},GetShapeList:function(){return this.m_shapeList},GetContactList:function(){return this.m_contactList},
GetJointList:function(){return this.m_jointList},GetNext:function(){return this.m_next},GetUserData:function(){return this.m_userData},initialize:function(a,c){this.sMat0=new b2Mat22;this.m_position=new b2Vec2;this.m_R=new b2Mat22(0);this.m_position0=new b2Vec2;var b=0,e,f;this.m_flags=0;this.m_position.SetV(a.position);this.m_rotation=a.rotation;this.m_R.Set(this.m_rotation);this.m_position0.SetV(this.m_position);this.m_rotation0=this.m_rotation;this.m_world=c;this.m_linearDamping=b2Math.b2Clamp(1-
a.linearDamping,0,1);this.m_angularDamping=b2Math.b2Clamp(1-a.angularDamping,0,1);this.m_force=new b2Vec2(0,0);this.m_mass=this.m_torque=0;for(var g=Array(b2Settings.b2_maxShapesPerBody),b=0;b<b2Settings.b2_maxShapesPerBody;b++)g[b]=new b2MassData;this.m_shapeCount=0;this.m_center=new b2Vec2(0,0);for(b=0;b<b2Settings.b2_maxShapesPerBody;++b){e=a.shapes[b];if(e==null)break;f=g[b];e.ComputeMass(f);this.m_mass+=f.mass;this.m_center.x+=f.mass*(e.localPosition.x+f.center.x);this.m_center.y+=f.mass*(e.localPosition.y+
f.center.y);++this.m_shapeCount}this.m_mass>0?(this.m_center.Multiply(1/this.m_mass),this.m_position.Add(b2Math.b2MulMV(this.m_R,this.m_center))):this.m_flags|=b2Body.e_staticFlag;for(b=this.m_I=0;b<this.m_shapeCount;++b)e=a.shapes[b],f=g[b],this.m_I+=f.I,e=b2Math.SubtractVV(b2Math.AddVV(e.localPosition,f.center),this.m_center),this.m_I+=f.mass*b2Math.b2Dot(e,e);this.m_invMass=this.m_mass>0?1/this.m_mass:0;this.m_invI=this.m_I>0&&a.preventRotation==!1?1/this.m_I:this.m_I=0;this.m_linearVelocity=b2Math.AddVV(a.linearVelocity,
b2Math.b2CrossFV(a.angularVelocity,this.m_center));this.m_angularVelocity=a.angularVelocity;this.m_shapeList=this.m_next=this.m_prev=this.m_contactList=this.m_jointList=null;for(b=0;b<this.m_shapeCount;++b)e=a.shapes[b],f=b2Shape.Create(e,this,this.m_center),f.m_next=this.m_shapeList,this.m_shapeList=f;this.m_sleepTime=0;a.allowSleep&&(this.m_flags|=b2Body.e_allowSleepFlag);a.isSleeping&&(this.m_flags|=b2Body.e_sleepFlag);if(this.m_flags&b2Body.e_sleepFlag||this.m_invMass==0)this.m_linearVelocity.Set(0,
0),this.m_angularVelocity=0;this.m_userData=a.userData},Destroy:function(){for(var a=this.m_shapeList;a;){var c=a,a=a.m_next;b2Shape.Destroy(c)}},sMat0:new b2Mat22,SynchronizeShapes:function(){this.sMat0.Set(this.m_rotation0);for(var a=this.m_shapeList;a!=null;a=a.m_next)a.Synchronize(this.m_position0,this.sMat0,this.m_position,this.m_R)},QuickSyncShapes:function(){for(var a=this.m_shapeList;a!=null;a=a.m_next)a.QuickSync(this.m_position,this.m_R)},IsConnected:function(a){for(var c=this.m_jointList;c!=
null;c=c.next)if(c.other==a)return c.joint.m_collideConnected==!1;return!1},Freeze:function(){this.m_flags|=b2Body.e_frozenFlag;this.m_linearVelocity.SetZero();this.m_angularVelocity=0;for(var a=this.m_shapeList;a!=null;a=a.m_next)a.DestroyProxy()},m_flags:0,m_position:new b2Vec2,m_rotation:null,m_R:new b2Mat22(0),m_position0:new b2Vec2,m_rotation0:null,m_linearVelocity:null,m_angularVelocity:null,m_force:null,m_torque:null,m_center:null,m_world:null,m_prev:null,m_next:null,m_shapeList:null,m_shapeCount:0,
m_jointList:null,m_contactList:null,m_mass:null,m_invMass:null,m_I:null,m_invI:null,m_linearDamping:null,m_angularDamping:null,m_sleepTime:null,m_userData:null};b2Body.e_staticFlag=1;b2Body.e_frozenFlag=2;b2Body.e_islandFlag=4;b2Body.e_sleepFlag=8;b2Body.e_allowSleepFlag=16;b2Body.e_destroyFlag=32;var b2BodyDef=Class.create();
b2BodyDef.prototype={initialize:function(){this.shapes=[];this.userData=null;for(var a=0;a<b2Settings.b2_maxShapesPerBody;a++)this.shapes[a]=null;this.position=new b2Vec2(0,0);this.rotation=0;this.linearVelocity=new b2Vec2(0,0);this.angularDamping=this.linearDamping=this.angularVelocity=0;this.allowSleep=!0;this.preventRotation=this.isSleeping=!1},userData:null,shapes:[],position:null,rotation:null,linearVelocity:null,angularVelocity:null,linearDamping:null,angularDamping:null,allowSleep:null,isSleeping:null,
preventRotation:null,AddShape:function(a){for(var c=0;c<b2Settings.b2_maxShapesPerBody;++c)if(this.shapes[c]==null){this.shapes[c]=a;break}}};var b2CollisionFilter=Class.create();b2CollisionFilter.prototype={ShouldCollide:function(a,c){if(a.m_groupIndex==c.m_groupIndex&&a.m_groupIndex!=0)return a.m_groupIndex>0;return(a.m_maskBits&c.m_categoryBits)!=0&&(a.m_categoryBits&c.m_maskBits)!=0},initialize:function(){}};b2CollisionFilter.b2_defaultFilter=new b2CollisionFilter;var b2Island=Class.create();
b2Island.prototype={initialize:function(a,c,b,e){var f=0;this.m_bodyCapacity=a;this.m_contactCapacity=c;this.m_jointCapacity=b;this.m_jointCount=this.m_contactCount=this.m_bodyCount=0;this.m_bodies=Array(a);for(f=0;f<a;f++)this.m_bodies[f]=null;this.m_contacts=Array(c);for(f=0;f<c;f++)this.m_contacts[f]=null;this.m_joints=Array(b);for(f=0;f<b;f++)this.m_joints[f]=null;this.m_allocator=e},Clear:function(){this.m_jointCount=this.m_contactCount=this.m_bodyCount=0},Solve:function(a,c){for(var b=0,e,b=
0;b<this.m_bodyCount;++b)if(e=this.m_bodies[b],e.m_invMass!=0)e.m_linearVelocity.Add(b2Math.MulFV(a.dt,b2Math.AddVV(c,b2Math.MulFV(e.m_invMass,e.m_force)))),e.m_angularVelocity+=a.dt*e.m_invI*e.m_torque,e.m_linearVelocity.Multiply(e.m_linearDamping),e.m_angularVelocity*=e.m_angularDamping,e.m_position0.SetV(e.m_position),e.m_rotation0=e.m_rotation;var f=new b2ContactSolver(this.m_contacts,this.m_contactCount,this.m_allocator);f.PreSolve();for(b=0;b<this.m_jointCount;++b)this.m_joints[b].PrepareVelocitySolver();
for(b=0;b<a.iterations;++b){f.SolveVelocityConstraints();for(e=0;e<this.m_jointCount;++e)this.m_joints[e].SolveVelocityConstraints(a)}for(b=0;b<this.m_bodyCount;++b)e=this.m_bodies[b],e.m_invMass!=0&&(e.m_position.x+=a.dt*e.m_linearVelocity.x,e.m_position.y+=a.dt*e.m_linearVelocity.y,e.m_rotation+=a.dt*e.m_angularVelocity,e.m_R.Set(e.m_rotation));for(b=0;b<this.m_jointCount;++b)this.m_joints[b].PreparePositionSolver();if(b2World.s_enablePositionCorrection)for(b2Island.m_positionIterationCount=0;b2Island.m_positionIterationCount<
a.iterations;++b2Island.m_positionIterationCount){e=f.SolvePositionConstraints(b2Settings.b2_contactBaumgarte);for(var g=!0,b=0;b<this.m_jointCount;++b)var h=this.m_joints[b].SolvePositionConstraints(),g=g&&h;if(e&&g)break}f.PostSolve();for(b=0;b<this.m_bodyCount;++b)if(e=this.m_bodies[b],e.m_invMass!=0)e.m_R.Set(e.m_rotation),e.SynchronizeShapes(),e.m_force.Set(0,0),e.m_torque=0},UpdateSleep:function(a){for(var c=0,b,e=Number.MAX_VALUE,f=b2Settings.b2_linearSleepTolerance*b2Settings.b2_linearSleepTolerance,
g=b2Settings.b2_angularSleepTolerance*b2Settings.b2_angularSleepTolerance,c=0;c<this.m_bodyCount;++c)if(b=this.m_bodies[c],b.m_invMass!=0){if((b.m_flags&b2Body.e_allowSleepFlag)==0)e=b.m_sleepTime=0;(b.m_flags&b2Body.e_allowSleepFlag)==0||b.m_angularVelocity*b.m_angularVelocity>g||b2Math.b2Dot(b.m_linearVelocity,b.m_linearVelocity)>f?e=b.m_sleepTime=0:(b.m_sleepTime+=a,e=b2Math.b2Min(e,b.m_sleepTime))}if(e>=b2Settings.b2_timeToSleep)for(c=0;c<this.m_bodyCount;++c)b=this.m_bodies[c],b.m_flags|=b2Body.e_sleepFlag},
AddBody:function(a){this.m_bodies[this.m_bodyCount++]=a},AddContact:function(a){this.m_contacts[this.m_contactCount++]=a},AddJoint:function(a){this.m_joints[this.m_jointCount++]=a},m_allocator:null,m_bodies:null,m_contacts:null,m_joints:null,m_bodyCount:0,m_jointCount:0,m_contactCount:0,m_bodyCapacity:0,m_contactCapacity:0,m_jointCapacity:0,m_positionError:null};b2Island.m_positionIterationCount=0;var b2TimeStep=Class.create();b2TimeStep.prototype={dt:null,inv_dt:null,iterations:0,initialize:function(){}};
var b2ContactNode=Class.create();b2ContactNode.prototype={other:null,contact:null,prev:null,next:null,initialize:function(){}};var b2Contact=Class.create();
b2Contact.prototype={GetManifolds:function(){return null},GetManifoldCount:function(){return this.m_manifoldCount},GetNext:function(){return this.m_next},GetShape1:function(){return this.m_shape1},GetShape2:function(){return this.m_shape2},initialize:function(a,c){this.m_node1=new b2ContactNode;this.m_node2=new b2ContactNode;this.m_flags=0;!a||!c?this.m_shape2=this.m_shape1=null:(this.m_shape1=a,this.m_shape2=c,this.m_manifoldCount=0,this.m_friction=Math.sqrt(this.m_shape1.m_friction*this.m_shape2.m_friction),
this.m_restitution=b2Math.b2Max(this.m_shape1.m_restitution,this.m_shape2.m_restitution),this.m_next=this.m_prev=null,this.m_node1.contact=null,this.m_node1.prev=null,this.m_node1.next=null,this.m_node1.other=null,this.m_node2.contact=null,this.m_node2.prev=null,this.m_node2.next=null,this.m_node2.other=null)},Evaluate:function(){},m_flags:0,m_prev:null,m_next:null,m_node1:new b2ContactNode,m_node2:new b2ContactNode,m_shape1:null,m_shape2:null,m_manifoldCount:0,m_friction:null,m_restitution:null};
b2Contact.e_islandFlag=1;b2Contact.e_destroyFlag=2;b2Contact.AddType=function(a,c,b,e){b2Contact.s_registers[b][e].createFcn=a;b2Contact.s_registers[b][e].destroyFcn=c;b2Contact.s_registers[b][e].primary=!0;if(b!=e)b2Contact.s_registers[e][b].createFcn=a,b2Contact.s_registers[e][b].destroyFcn=c,b2Contact.s_registers[e][b].primary=!1};
b2Contact.InitializeRegisters=function(){b2Contact.s_registers=Array(b2Shape.e_shapeTypeCount);for(var a=0;a<b2Shape.e_shapeTypeCount;a++){b2Contact.s_registers[a]=Array(b2Shape.e_shapeTypeCount);for(var c=0;c<b2Shape.e_shapeTypeCount;c++)b2Contact.s_registers[a][c]=new b2ContactRegister}b2Contact.AddType(b2CircleContact.Create,b2CircleContact.Destroy,b2Shape.e_circleShape,b2Shape.e_circleShape);b2Contact.AddType(b2PolyAndCircleContact.Create,b2PolyAndCircleContact.Destroy,b2Shape.e_polyShape,b2Shape.e_circleShape);
b2Contact.AddType(b2PolyContact.Create,b2PolyContact.Destroy,b2Shape.e_polyShape,b2Shape.e_polyShape)};b2Contact.Create=function(a,c,b){if(b2Contact.s_initialized==!1)b2Contact.InitializeRegisters(),b2Contact.s_initialized=!0;var e=a.m_type,f=c.m_type,g=b2Contact.s_registers[e][f].createFcn;if(g)if(b2Contact.s_registers[e][f].primary)return g(a,c,b);else{a=g(c,a,b);for(c=0;c<a.GetManifoldCount();++c)b=a.GetManifolds()[c],b.normal=b.normal.Negative();return a}else return null};
b2Contact.Destroy=function(a,c){a.GetManifoldCount()>0&&(a.m_shape1.m_body.WakeUp(),a.m_shape2.m_body.WakeUp());var b=b2Contact.s_registers[a.m_shape1.m_type][a.m_shape2.m_type].destroyFcn;b(a,c)};b2Contact.s_registers=null;b2Contact.s_initialized=!1;var b2ContactConstraint=Class.create();
b2ContactConstraint.prototype={initialize:function(){this.normal=new b2Vec2;this.points=Array(b2Settings.b2_maxManifoldPoints);for(var a=0;a<b2Settings.b2_maxManifoldPoints;a++)this.points[a]=new b2ContactConstraintPoint},points:null,normal:new b2Vec2,manifold:null,body1:null,body2:null,friction:null,restitution:null,pointCount:0};var b2ContactConstraintPoint=Class.create();
b2ContactConstraintPoint.prototype={localAnchor1:new b2Vec2,localAnchor2:new b2Vec2,normalImpulse:null,tangentImpulse:null,positionImpulse:null,normalMass:null,tangentMass:null,separation:null,velocityBias:null,initialize:function(){this.localAnchor1=new b2Vec2;this.localAnchor2=new b2Vec2}};var b2ContactRegister=Class.create();b2ContactRegister.prototype={createFcn:null,destroyFcn:null,primary:null,initialize:function(){}};var b2ContactSolver=Class.create();
b2ContactSolver.prototype={initialize:function(a,c,b){this.m_constraints=[];this.m_allocator=b;for(var b=0,e,f,b=this.m_constraintCount=0;b<c;++b)this.m_constraintCount+=a[b].GetManifoldCount();for(b=0;b<this.m_constraintCount;b++)this.m_constraints[b]=new b2ContactConstraint;for(var g=0,b=0;b<c;++b)for(var h=a[b],i=h.m_shape1.m_body,k=h.m_shape2.m_body,j=h.GetManifoldCount(),l=h.GetManifolds(),m=h.m_friction,h=h.m_restitution,n=i.m_linearVelocity.x,o=i.m_linearVelocity.y,p=k.m_linearVelocity.x,q=
k.m_linearVelocity.y,s=i.m_angularVelocity,r=k.m_angularVelocity,u=0;u<j;++u){var z=l[u],x=z.normal.x,B=z.normal.y,y=this.m_constraints[g];y.body1=i;y.body2=k;y.manifold=z;y.normal.x=x;y.normal.y=B;y.pointCount=z.pointCount;y.friction=m;y.restitution=h;for(var C=0;C<y.pointCount;++C){var t=z.points[C],v=y.points[C];v.normalImpulse=t.normalImpulse;v.tangentImpulse=t.tangentImpulse;v.separation=t.separation;var A=t.position.x-i.m_position.x,D=t.position.y-i.m_position.y,F=t.position.x-k.m_position.x,
t=t.position.y-k.m_position.y;e=v.localAnchor1;f=i.m_R;e.x=A*f.col1.x+D*f.col1.y;e.y=A*f.col2.x+D*f.col2.y;e=v.localAnchor2;f=k.m_R;e.x=F*f.col1.x+t*f.col1.y;e.y=F*f.col2.x+t*f.col2.y;e=A*A+D*D;f=F*F+t*t;var E=A*x+D*B,G=F*x+t*B,H=i.m_invMass+k.m_invMass;H+=i.m_invI*(e-E*E)+k.m_invI*(f-G*G);v.normalMass=1/H;G=B;H=-x;E=A*G+D*H;G=F*G+t*H;H=i.m_invMass+k.m_invMass;H+=i.m_invI*(e-E*E)+k.m_invI*(f-G*G);v.tangentMass=1/H;v.velocityBias=0;if(v.separation>0)v.velocityBias=-60*v.separation;A=y.normal.x*(p+
-r*t-n- -s*D)+y.normal.y*(q+r*F-o-s*A);A<-b2Settings.b2_velocityThreshold&&(v.velocityBias+=-y.restitution*A)}++g}},PreSolve:function(){for(var a,c,b=0;b<this.m_constraintCount;++b){var e=this.m_constraints[b],f=e.body1,g=e.body2,h=f.m_invMass,i=f.m_invI,k=g.m_invMass,j=g.m_invI,l=e.normal.x,m=e.normal.y,n=m,o=-l,p=0,q=0;if(b2World.s_enableWarmStarting){q=e.pointCount;for(p=0;p<q;++p){var s=e.points[p],r=s.normalImpulse*l+s.tangentImpulse*n,u=s.normalImpulse*m+s.tangentImpulse*o;c=f.m_R;a=s.localAnchor1;
var z=c.col1.x*a.x+c.col2.x*a.y,x=c.col1.y*a.x+c.col2.y*a.y;c=g.m_R;a=s.localAnchor2;var B=c.col1.x*a.x+c.col2.x*a.y;a=c.col1.y*a.x+c.col2.y*a.y;f.m_angularVelocity-=i*(z*u-x*r);f.m_linearVelocity.x-=h*r;f.m_linearVelocity.y-=h*u;g.m_angularVelocity+=j*(B*u-a*r);g.m_linearVelocity.x+=k*r;g.m_linearVelocity.y+=k*u;s.positionImpulse=0}}else{q=e.pointCount;for(p=0;p<q;++p)f=e.points[p],f.normalImpulse=0,f.tangentImpulse=0,f.positionImpulse=0}}},SolveVelocityConstraints:function(){for(var a=0,c,b,e,f,
g,h,i,k,j=0;j<this.m_constraintCount;++j){for(var l=this.m_constraints[j],m=l.body1,n=l.body2,o=m.m_angularVelocity,p=m.m_linearVelocity,q=n.m_angularVelocity,s=n.m_linearVelocity,r=m.m_invMass,u=m.m_invI,z=n.m_invMass,x=n.m_invI,B=l.normal.x,y=l.normal.y,C=y,t=-B,v=l.pointCount,a=0;a<v;++a)c=l.points[a],g=m.m_R,h=c.localAnchor1,b=g.col1.x*h.x+g.col2.x*h.y,e=g.col1.y*h.x+g.col2.y*h.y,g=n.m_R,h=c.localAnchor2,f=g.col1.x*h.x+g.col2.x*h.y,g=g.col1.y*h.x+g.col2.y*h.y,h=s.x+-q*g-p.x- -o*e,i=s.y+q*f-p.y-
o*b,h=-c.normalMass*(h*B+i*y-c.velocityBias),i=b2Math.b2Max(c.normalImpulse+h,0),h=i-c.normalImpulse,k=h*B,h*=y,p.x-=r*k,p.y-=r*h,o-=u*(b*h-e*k),s.x+=z*k,s.y+=z*h,q+=x*(f*h-g*k),c.normalImpulse=i,h=s.x+-q*g-p.x- -o*e,i=s.y+q*f-p.y-o*b,h=c.tangentMass*-(h*C+i*t),i=l.friction*c.normalImpulse,i=b2Math.b2Clamp(c.tangentImpulse+h,-i,i),h=i-c.tangentImpulse,k=h*C,h*=t,p.x-=r*k,p.y-=r*h,o-=u*(b*h-e*k),s.x+=z*k,s.y+=z*h,q+=x*(f*h-g*k),c.tangentImpulse=i;m.m_angularVelocity=o;n.m_angularVelocity=q}},SolvePositionConstraints:function(a){for(var c=
0,b,e,f=0;f<this.m_constraintCount;++f){for(var g=this.m_constraints[f],h=g.body1,i=g.body2,k=h.m_position,j=h.m_rotation,l=i.m_position,m=i.m_rotation,n=h.m_invMass,o=h.m_invI,p=i.m_invMass,q=i.m_invI,s=g.normal.x,r=g.normal.y,u=g.pointCount,z=0;z<u;++z){var x=g.points[z];b=h.m_R;e=x.localAnchor1;var B=b.col1.x*e.x+b.col2.x*e.y,y=b.col1.y*e.x+b.col2.y*e.y;b=i.m_R;e=x.localAnchor2;var C=b.col1.x*e.x+b.col2.x*e.y;b=b.col1.y*e.x+b.col2.y*e.y;e=(l.x+C-(k.x+B))*s+(l.y+b-(k.y+y))*r+x.separation;c=b2Math.b2Min(c,
e);e=a*b2Math.b2Clamp(e+b2Settings.b2_linearSlop,-b2Settings.b2_maxLinearCorrection,0);e*=-x.normalMass;var t=x.positionImpulse;x.positionImpulse=b2Math.b2Max(t+e,0);e=x.positionImpulse-t;x=e*s;e*=r;k.x-=n*x;k.y-=n*e;j-=o*(B*e-y*x);h.m_R.Set(j);l.x+=p*x;l.y+=p*e;m+=q*(C*e-b*x);i.m_R.Set(m)}h.m_rotation=j;i.m_rotation=m}return c>=-b2Settings.b2_linearSlop},PostSolve:function(){for(var a=0;a<this.m_constraintCount;++a)for(var c=this.m_constraints[a],b=c.manifold,e=0;e<c.pointCount;++e){var f=b.points[e],
g=c.points[e];f.normalImpulse=g.normalImpulse;f.tangentImpulse=g.tangentImpulse}},m_allocator:null,m_constraints:[],m_constraintCount:0};var b2CircleContact=Class.create();Object.extend(b2CircleContact.prototype,b2Contact.prototype);
Object.extend(b2CircleContact.prototype,{initialize:function(a,c){this.m_node1=new b2ContactNode;this.m_node2=new b2ContactNode;this.m_flags=0;!a||!c?this.m_shape2=this.m_shape1=null:(this.m_shape1=a,this.m_shape2=c,this.m_manifoldCount=0,this.m_friction=Math.sqrt(this.m_shape1.m_friction*this.m_shape2.m_friction),this.m_restitution=b2Math.b2Max(this.m_shape1.m_restitution,this.m_shape2.m_restitution),this.m_next=this.m_prev=null,this.m_node1.contact=null,this.m_node1.prev=null,this.m_node1.next=
null,this.m_node1.other=null,this.m_node2.contact=null,this.m_node2.prev=null,this.m_node2.next=null,this.m_node2.other=null,this.m_manifold=[new b2Manifold],this.m_manifold[0].pointCount=0,this.m_manifold[0].points[0].normalImpulse=0,this.m_manifold[0].points[0].tangentImpulse=0)},Evaluate:function(){b2Collision.b2CollideCircle(this.m_manifold[0],this.m_shape1,this.m_shape2,!1);this.m_manifoldCount=this.m_manifold[0].pointCount>0?1:0},GetManifolds:function(){return this.m_manifold},m_manifold:[new b2Manifold]});
b2CircleContact.Create=function(a,c){return new b2CircleContact(a,c)};b2CircleContact.Destroy=function(){};var b2Conservative=Class.create();b2Conservative.prototype={initialize:function(){}};b2Conservative.R1=new b2Mat22;b2Conservative.R2=new b2Mat22;b2Conservative.x1=new b2Vec2;b2Conservative.x2=new b2Vec2;
b2Conservative.Conservative=function(a,c){var b=a.GetBody(),e=c.GetBody(),f=b.m_position.x-b.m_position0.x,g=b.m_position.y-b.m_position0.y,h=b.m_rotation-b.m_rotation0,i=e.m_position.x-e.m_position0.x,k=e.m_position.y-e.m_position0.y,j=e.m_rotation-e.m_rotation0,l=a.GetMaxRadius(),m=c.GetMaxRadius(),n=b.m_position0.x,o=b.m_position0.y,p=b.m_rotation0,q=e.m_position0.x,s=e.m_position0.y,r=e.m_rotation0,u=n,z=o,x=p,B=q,y=s,C=r;b2Conservative.R1.Set(x);b2Conservative.R2.Set(C);a.QuickSync(p1,b2Conservative.R1);
c.QuickSync(p2,b2Conservative.R2);var t=0,v,A;v=0;for(var D=!0,F=0;F<10;++F){var E=b2Distance.Distance(b2Conservative.x1,b2Conservative.x2,a,c);if(E<b2Settings.b2_linearSlop){D=F==0?!1:!0;break}if(F==0){v=b2Conservative.x2.x-b2Conservative.x1.x;A=b2Conservative.x2.y-b2Conservative.x1.y;v=v*(f-i)+A*(g-k)+Math.abs(h)*l+Math.abs(j)*m;if(Math.abs(v)<Number.MIN_VALUE){D=!1;break}v=1/v}E=t+E*v;if(E<0||1<E){D=!1;break}if(E<(1+100*Number.MIN_VALUE)*t){D=!0;break}t=E;u=n+t*v1.x;z=o+t*v1.y;x=p+t*h;B=q+t*v2.x;
y=s+t*v2.y;C=r+t*j;b2Conservative.R1.Set(x);b2Conservative.R2.Set(C);a.QuickSync(p1,b2Conservative.R1);c.QuickSync(p2,b2Conservative.R2)}if(D)return v=b2Conservative.x2.x-b2Conservative.x1.x,A=b2Conservative.x2.y-b2Conservative.x1.y,f=Math.sqrt(v*v+A*A),f>FLT_EPSILON&&(d*=b2_linearSlop/f),b.IsStatic()?(b.m_position.x=u,b.m_position.y=z):(b.m_position.x=u-v,b.m_position.y=z-A),b.m_rotation=x,b.m_R.Set(x),b.QuickSyncShapes(),e.IsStatic()?(e.m_position.x=B,e.m_position.y=y):(e.m_position.x=B+v,e.m_position.y=
y+A),e.m_position.x=B+v,e.m_position.y=y+A,e.m_rotation=C,e.m_R.Set(C),e.QuickSyncShapes(),!0;a.QuickSync(b.m_position,b.m_R);c.QuickSync(e.m_position,e.m_R);return!1};var b2NullContact=Class.create();Object.extend(b2NullContact.prototype,b2Contact.prototype);
Object.extend(b2NullContact.prototype,{initialize:function(a,c){this.m_node1=new b2ContactNode;this.m_node2=new b2ContactNode;this.m_flags=0;!a||!c?this.m_shape2=this.m_shape1=null:(this.m_shape1=a,this.m_shape2=c,this.m_manifoldCount=0,this.m_friction=Math.sqrt(this.m_shape1.m_friction*this.m_shape2.m_friction),this.m_restitution=b2Math.b2Max(this.m_shape1.m_restitution,this.m_shape2.m_restitution),this.m_next=this.m_prev=null,this.m_node1.contact=null,this.m_node1.prev=null,this.m_node1.next=null,
this.m_node1.other=null,this.m_node2.contact=null,this.m_node2.prev=null,this.m_node2.next=null,this.m_node2.other=null)},Evaluate:function(){},GetManifolds:function(){return null}});var b2PolyAndCircleContact=Class.create();Object.extend(b2PolyAndCircleContact.prototype,b2Contact.prototype);
Object.extend(b2PolyAndCircleContact.prototype,{initialize:function(a,c){this.m_node1=new b2ContactNode;this.m_node2=new b2ContactNode;this.m_flags=0;!a||!c?this.m_shape2=this.m_shape1=null:(this.m_shape1=a,this.m_shape2=c,this.m_manifoldCount=0,this.m_friction=Math.sqrt(this.m_shape1.m_friction*this.m_shape2.m_friction),this.m_restitution=b2Math.b2Max(this.m_shape1.m_restitution,this.m_shape2.m_restitution),this.m_next=this.m_prev=null,this.m_node1.contact=null,this.m_node1.prev=null,this.m_node1.next=
null,this.m_node1.other=null,this.m_node2.contact=null,this.m_node2.prev=null,this.m_node2.next=null,this.m_node2.other=null,this.m_manifold=[new b2Manifold],b2Settings.b2Assert(this.m_shape1.m_type==b2Shape.e_polyShape),b2Settings.b2Assert(this.m_shape2.m_type==b2Shape.e_circleShape),this.m_manifold[0].pointCount=0,this.m_manifold[0].points[0].normalImpulse=0,this.m_manifold[0].points[0].tangentImpulse=0)},Evaluate:function(){b2Collision.b2CollidePolyAndCircle(this.m_manifold[0],this.m_shape1,this.m_shape2,
!1);this.m_manifoldCount=this.m_manifold[0].pointCount>0?1:0},GetManifolds:function(){return this.m_manifold},m_manifold:[new b2Manifold]});b2PolyAndCircleContact.Create=function(a,c){return new b2PolyAndCircleContact(a,c)};b2PolyAndCircleContact.Destroy=function(){};var b2PolyContact=Class.create();Object.extend(b2PolyContact.prototype,b2Contact.prototype);
Object.extend(b2PolyContact.prototype,{initialize:function(a,c){this.m_node1=new b2ContactNode;this.m_node2=new b2ContactNode;this.m_flags=0;!a||!c?this.m_shape2=this.m_shape1=null:(this.m_shape1=a,this.m_shape2=c,this.m_manifoldCount=0,this.m_friction=Math.sqrt(this.m_shape1.m_friction*this.m_shape2.m_friction),this.m_restitution=b2Math.b2Max(this.m_shape1.m_restitution,this.m_shape2.m_restitution),this.m_next=this.m_prev=null,this.m_node1.contact=null,this.m_node1.prev=null,this.m_node1.next=null,
this.m_node1.other=null,this.m_node2.contact=null,this.m_node2.prev=null,this.m_node2.next=null,this.m_node2.other=null,this.m0=new b2Manifold,this.m_manifold=[new b2Manifold],this.m_manifold[0].pointCount=0)},m0:new b2Manifold,Evaluate:function(){for(var a=this.m_manifold[0],c=this.m0.points,b=0;b<a.pointCount;b++){var e=c[b],f=a.points[b];e.normalImpulse=f.normalImpulse;e.tangentImpulse=f.tangentImpulse;e.id=f.id.Copy()}this.m0.pointCount=a.pointCount;b2Collision.b2CollidePoly(a,this.m_shape1,this.m_shape2,
!1);if(a.pointCount>0){c=[!1,!1];for(b=0;b<a.pointCount;++b){e=a.points[b];e.normalImpulse=0;e.tangentImpulse=0;for(var f=e.id.key,g=0;g<this.m0.pointCount;++g)if(c[g]!=!0){var h=this.m0.points[g];if(h.id.key==f){c[g]=!0;e.normalImpulse=h.normalImpulse;e.tangentImpulse=h.tangentImpulse;break}}}this.m_manifoldCount=1}else this.m_manifoldCount=0},GetManifolds:function(){return this.m_manifold},m_manifold:[new b2Manifold]});b2PolyContact.Create=function(a,c){return new b2PolyContact(a,c)};
b2PolyContact.Destroy=function(){};var b2ContactManager=Class.create();Object.extend(b2ContactManager.prototype,b2PairCallback.prototype);
Object.extend(b2ContactManager.prototype,{initialize:function(){this.m_nullContact=new b2NullContact;this.m_world=null;this.m_destroyImmediate=!1},PairAdded:function(a,c){var b=a,e=c,f=b.m_body,g=e.m_body;if(f.IsStatic()&&g.IsStatic())return this.m_nullContact;if(b.m_body==e.m_body)return this.m_nullContact;if(g.IsConnected(f))return this.m_nullContact;if(this.m_world.m_filter!=null&&this.m_world.m_filter.ShouldCollide(b,e)==!1)return this.m_nullContact;g.m_invMass==0&&(f=b,b=e,e=f);b=b2Contact.Create(b,
e,this.m_world.m_blockAllocator);if(b==null)return this.m_nullContact;else{b.m_prev=null;b.m_next=this.m_world.m_contactList;if(this.m_world.m_contactList!=null)this.m_world.m_contactList.m_prev=b;this.m_world.m_contactList=b;this.m_world.m_contactCount++}return b},PairRemoved:function(a,c,b){b!=null&&b!=this.m_nullContact&&(this.m_destroyImmediate==!0?this.DestroyContact(b):b.m_flags|=b2Contact.e_destroyFlag)},DestroyContact:function(a){if(a.m_prev)a.m_prev.m_next=a.m_next;if(a.m_next)a.m_next.m_prev=
a.m_prev;if(a==this.m_world.m_contactList)this.m_world.m_contactList=a.m_next;if(a.GetManifoldCount()>0){var c=a.m_shape1.m_body,b=a.m_shape2.m_body,e=a.m_node1,f=a.m_node2;c.WakeUp();b.WakeUp();if(e.prev)e.prev.next=e.next;if(e.next)e.next.prev=e.prev;if(e==c.m_contactList)c.m_contactList=e.next;e.prev=null;e.next=null;if(f.prev)f.prev.next=f.next;if(f.next)f.next.prev=f.prev;if(f==b.m_contactList)b.m_contactList=f.next;f.prev=null;f.next=null}b2Contact.Destroy(a,this.m_world.m_blockAllocator);--this.m_world.m_contactCount},
CleanContactList:function(){for(var a=this.m_world.m_contactList;a!=null;){var c=a,a=a.m_next;c.m_flags&b2Contact.e_destroyFlag&&this.DestroyContact(c)}},Collide:function(){for(var a,c,b,e,f=this.m_world.m_contactList;f!=null;f=f.m_next)if(!f.m_shape1.m_body.IsSleeping()||!f.m_shape2.m_body.IsSleeping())if(a=f.GetManifoldCount(),f.Evaluate(),c=f.GetManifoldCount(),a==0&&c>0){a=f.m_shape1.m_body;c=f.m_shape2.m_body;b=f.m_node1;e=f.m_node2;b.contact=f;b.other=c;b.prev=null;b.next=a.m_contactList;if(b.next!=
null)b.next.prev=f.m_node1;a.m_contactList=f.m_node1;e.contact=f;e.other=a;e.prev=null;e.next=c.m_contactList;if(e.next!=null)e.next.prev=e;c.m_contactList=e}else if(a>0&&c==0){a=f.m_shape1.m_body;c=f.m_shape2.m_body;b=f.m_node1;e=f.m_node2;if(b.prev)b.prev.next=b.next;if(b.next)b.next.prev=b.prev;if(b==a.m_contactList)a.m_contactList=b.next;b.prev=null;b.next=null;if(e.prev)e.prev.next=e.next;if(e.next)e.next.prev=e.prev;if(e==c.m_contactList)c.m_contactList=e.next;e.prev=null;e.next=null}},m_world:null,
m_nullContact:new b2NullContact,m_destroyImmediate:null});var b2World=Class.create();
b2World.prototype={initialize:function(a,c,b){this.step=new b2TimeStep;this.m_contactManager=new b2ContactManager;this.m_listener=null;this.m_filter=b2CollisionFilter.b2_defaultFilter;this.m_jointList=this.m_contactList=this.m_bodyList=null;this.m_jointCount=this.m_contactCount=this.m_bodyCount=0;this.m_bodyDestroyList=null;this.m_allowSleep=b;this.m_gravity=c;this.m_contactManager.m_world=this;this.m_broadPhase=new b2BroadPhase(a,this.m_contactManager);this.m_groundBody=this.CreateBody(new b2BodyDef)},
SetListener:function(a){this.m_listener=a},SetFilter:function(a){this.m_filter=a},CreateBody:function(a){a=new b2Body(a,this);a.m_prev=null;if(a.m_next=this.m_bodyList)this.m_bodyList.m_prev=a;this.m_bodyList=a;++this.m_bodyCount;return a},DestroyBody:function(a){if(!(a.m_flags&b2Body.e_destroyFlag)){if(a.m_prev)a.m_prev.m_next=a.m_next;if(a.m_next)a.m_next.m_prev=a.m_prev;if(a==this.m_bodyList)this.m_bodyList=a.m_next;a.m_flags|=b2Body.e_destroyFlag;--this.m_bodyCount;a.m_prev=null;a.m_next=this.m_bodyDestroyList;
this.m_bodyDestroyList=a}},CleanBodyList:function(){this.m_contactManager.m_destroyImmediate=!0;for(var a=this.m_bodyDestroyList;a;){for(var c=a,a=a.m_next,b=c.m_jointList;b;){var e=b,b=b.next;this.m_listener&&this.m_listener.NotifyJointDestroyed(e.joint);this.DestroyJoint(e.joint)}c.Destroy()}this.m_bodyDestroyList=null;this.m_contactManager.m_destroyImmediate=!1},CreateJoint:function(a){var c=b2Joint.Create(a,this.m_blockAllocator);c.m_prev=null;if(c.m_next=this.m_jointList)this.m_jointList.m_prev=
c;this.m_jointList=c;++this.m_jointCount;c.m_node1.joint=c;c.m_node1.other=c.m_body2;c.m_node1.prev=null;if(c.m_node1.next=c.m_body1.m_jointList)c.m_body1.m_jointList.prev=c.m_node1;c.m_body1.m_jointList=c.m_node1;c.m_node2.joint=c;c.m_node2.other=c.m_body1;c.m_node2.prev=null;if(c.m_node2.next=c.m_body2.m_jointList)c.m_body2.m_jointList.prev=c.m_node2;c.m_body2.m_jointList=c.m_node2;if(a.collideConnected==!1)for(a=(a.body1.m_shapeCount<a.body2.m_shapeCount?a.body1:a.body2).m_shapeList;a;a=a.m_next)a.ResetProxy(this.m_broadPhase);
return c},DestroyJoint:function(a){var c=a.m_collideConnected;if(a.m_prev)a.m_prev.m_next=a.m_next;if(a.m_next)a.m_next.m_prev=a.m_prev;if(a==this.m_jointList)this.m_jointList=a.m_next;var b=a.m_body1,e=a.m_body2;b.WakeUp();e.WakeUp();if(a.m_node1.prev)a.m_node1.prev.next=a.m_node1.next;if(a.m_node1.next)a.m_node1.next.prev=a.m_node1.prev;if(a.m_node1==b.m_jointList)b.m_jointList=a.m_node1.next;a.m_node1.prev=null;a.m_node1.next=null;if(a.m_node2.prev)a.m_node2.prev.next=a.m_node2.next;if(a.m_node2.next)a.m_node2.next.prev=
a.m_node2.prev;if(a.m_node2==e.m_jointList)e.m_jointList=a.m_node2.next;a.m_node2.prev=null;a.m_node2.next=null;b2Joint.Destroy(a,this.m_blockAllocator);--this.m_jointCount;if(c==!1)for(a=(b.m_shapeCount<e.m_shapeCount?b:e).m_shapeList;a;a=a.m_next)a.ResetProxy(this.m_broadPhase)},GetGroundBody:function(){return this.m_groundBody},step:new b2TimeStep,Step:function(a,c){var b,e;this.step.dt=a;this.step.iterations=c;this.step.inv_dt=a>0?1/a:0;this.m_positionIterationCount=0;this.m_contactManager.CleanContactList();
this.CleanBodyList();this.m_contactManager.Collide();var f=new b2Island(this.m_bodyCount,this.m_contactCount,this.m_jointCount,this.m_stackAllocator);for(b=this.m_bodyList;b!=null;b=b.m_next)b.m_flags&=~b2Body.e_islandFlag;for(var g=this.m_contactList;g!=null;g=g.m_next)g.m_flags&=~b2Contact.e_islandFlag;for(g=this.m_jointList;g!=null;g=g.m_next)g.m_islandFlag=!1;for(var g=Array(this.m_bodyCount),h=0;h<this.m_bodyCount;h++)g[h]=null;for(h=this.m_bodyList;h!=null;h=h.m_next)if(!(h.m_flags&(b2Body.e_staticFlag|
b2Body.e_islandFlag|b2Body.e_sleepFlag|b2Body.e_frozenFlag))){f.Clear();var i=0;g[i++]=h;for(h.m_flags|=b2Body.e_islandFlag;i>0;)if(b=g[--i],f.AddBody(b),b.m_flags&=~b2Body.e_sleepFlag,!(b.m_flags&b2Body.e_staticFlag)){for(var k=b.m_contactList;k!=null;k=k.next)if(!(k.contact.m_flags&b2Contact.e_islandFlag))f.AddContact(k.contact),k.contact.m_flags|=b2Contact.e_islandFlag,e=k.other,e.m_flags&b2Body.e_islandFlag||(g[i++]=e,e.m_flags|=b2Body.e_islandFlag);for(b=b.m_jointList;b!=null;b=b.next)if(b.joint.m_islandFlag!=
!0)f.AddJoint(b.joint),b.joint.m_islandFlag=!0,e=b.other,e.m_flags&b2Body.e_islandFlag||(g[i++]=e,e.m_flags|=b2Body.e_islandFlag)}f.Solve(this.step,this.m_gravity);this.m_positionIterationCount=b2Math.b2Max(this.m_positionIterationCount,b2Island.m_positionIterationCount);this.m_allowSleep&&f.UpdateSleep(a);for(e=0;e<f.m_bodyCount;++e)b=f.m_bodies[e],b.m_flags&b2Body.e_staticFlag&&(b.m_flags&=~b2Body.e_islandFlag),b.IsFrozen()&&this.m_listener&&this.m_listener.NotifyBoundaryViolated(b)==b2WorldListener.b2_destroyBody&&
(this.DestroyBody(b),f.m_bodies[e]=null)}this.m_broadPhase.Commit()},Query:function(a,c,b){for(var e=[],a=this.m_broadPhase.QueryAABB(a,e,b),b=0;b<a;++b)c[b]=e[b];return a},GetBodyList:function(){return this.m_bodyList},GetJointList:function(){return this.m_jointList},GetContactList:function(){return this.m_contactList},m_blockAllocator:null,m_stackAllocator:null,m_broadPhase:null,m_contactManager:new b2ContactManager,m_bodyList:null,m_contactList:null,m_jointList:null,m_bodyCount:0,m_contactCount:0,
m_jointCount:0,m_bodyDestroyList:null,m_gravity:null,m_allowSleep:null,m_groundBody:null,m_listener:null,m_filter:null,m_positionIterationCount:0};b2World.s_enablePositionCorrection=1;b2World.s_enableWarmStarting=1;var b2WorldListener=Class.create();b2WorldListener.prototype={NotifyJointDestroyed:function(){},NotifyBoundaryViolated:function(){return b2WorldListener.b2_freezeBody},initialize:function(){}};b2WorldListener.b2_freezeBody=0;b2WorldListener.b2_destroyBody=1;var b2JointNode=Class.create();
b2JointNode.prototype={other:null,joint:null,prev:null,next:null,initialize:function(){}};var b2Joint=Class.create();
b2Joint.prototype={GetType:function(){return this.m_type},GetAnchor1:function(){return null},GetAnchor2:function(){return null},GetReactionForce:function(){return null},GetReactionTorque:function(){return 0},GetBody1:function(){return this.m_body1},GetBody2:function(){return this.m_body2},GetNext:function(){return this.m_next},GetUserData:function(){return this.m_userData},initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;
this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData},PrepareVelocitySolver:function(){},SolveVelocityConstraints:function(){},PreparePositionSolver:function(){},SolvePositionConstraints:function(){return!1},m_type:0,m_prev:null,m_next:null,m_node1:new b2JointNode,m_node2:new b2JointNode,m_body1:null,m_body2:null,m_islandFlag:null,m_collideConnected:null,m_userData:null};
b2Joint.Create=function(a){var c=null;switch(a.type){case b2Joint.e_distanceJoint:c=new b2DistanceJoint(a);break;case b2Joint.e_mouseJoint:c=new b2MouseJoint(a);break;case b2Joint.e_prismaticJoint:c=new b2PrismaticJoint(a);break;case b2Joint.e_revoluteJoint:c=new b2RevoluteJoint(a);break;case b2Joint.e_pulleyJoint:c=new b2PulleyJoint(a);break;case b2Joint.e_gearJoint:c=new b2GearJoint(a)}return c};b2Joint.Destroy=function(){};b2Joint.e_unknownJoint=0;b2Joint.e_revoluteJoint=1;
b2Joint.e_prismaticJoint=2;b2Joint.e_distanceJoint=3;b2Joint.e_pulleyJoint=4;b2Joint.e_mouseJoint=5;b2Joint.e_gearJoint=6;b2Joint.e_inactiveLimit=0;b2Joint.e_atLowerLimit=1;b2Joint.e_atUpperLimit=2;b2Joint.e_equalLimits=3;var b2JointDef=Class.create();b2JointDef.prototype={initialize:function(){this.type=b2Joint.e_unknownJoint;this.body2=this.body1=this.userData=null;this.collideConnected=!1},type:0,userData:null,body1:null,body2:null,collideConnected:null};var b2DistanceJoint=Class.create();
Object.extend(b2DistanceJoint.prototype,b2Joint.prototype);
Object.extend(b2DistanceJoint.prototype,{initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.m_localAnchor1=new b2Vec2;this.m_localAnchor2=new b2Vec2;this.m_u=new b2Vec2;var c,b,e;c=this.m_body1.m_R;b=a.anchorPoint1.x-this.m_body1.m_position.x;e=a.anchorPoint1.y-this.m_body1.m_position.y;
this.m_localAnchor1.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor1.y=b*c.col2.x+e*c.col2.y;c=this.m_body2.m_R;b=a.anchorPoint2.x-this.m_body2.m_position.x;e=a.anchorPoint2.y-this.m_body2.m_position.y;this.m_localAnchor2.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor2.y=b*c.col2.x+e*c.col2.y;b=a.anchorPoint2.x-a.anchorPoint1.x;e=a.anchorPoint2.y-a.anchorPoint1.y;this.m_length=Math.sqrt(b*b+e*e);this.m_impulse=0},PrepareVelocitySolver:function(){var a;a=this.m_body1.m_R;var c=a.col1.x*this.m_localAnchor1.x+
a.col2.x*this.m_localAnchor1.y,b=a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y;a=this.m_body2.m_R;var e=a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y;a=a.col1.y*this.m_localAnchor2.x+a.col2.y*this.m_localAnchor2.y;this.m_u.x=this.m_body2.m_position.x+e-this.m_body1.m_position.x-c;this.m_u.y=this.m_body2.m_position.y+a-this.m_body1.m_position.y-b;var f=Math.sqrt(this.m_u.x*this.m_u.x+this.m_u.y*this.m_u.y);f>b2Settings.b2_linearSlop?this.m_u.Multiply(1/f):this.m_u.SetZero();
var f=c*this.m_u.y-b*this.m_u.x,g=e*this.m_u.y-a*this.m_u.x;this.m_mass=this.m_body1.m_invMass+this.m_body1.m_invI*f*f+this.m_body2.m_invMass+this.m_body2.m_invI*g*g;this.m_mass=1/this.m_mass;b2World.s_enableWarmStarting?(f=this.m_impulse*this.m_u.x,g=this.m_impulse*this.m_u.y,this.m_body1.m_linearVelocity.x-=this.m_body1.m_invMass*f,this.m_body1.m_linearVelocity.y-=this.m_body1.m_invMass*g,this.m_body1.m_angularVelocity-=this.m_body1.m_invI*(c*g-b*f),this.m_body2.m_linearVelocity.x+=this.m_body2.m_invMass*
f,this.m_body2.m_linearVelocity.y+=this.m_body2.m_invMass*g,this.m_body2.m_angularVelocity+=this.m_body2.m_invI*(e*g-a*f)):this.m_impulse=0},SolveVelocityConstraints:function(){var a;a=this.m_body1.m_R;var c=a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y,b=a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y;a=this.m_body2.m_R;var e=a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y;a=a.col1.y*this.m_localAnchor2.x+a.col2.y*this.m_localAnchor2.y;var f=-this.m_mass*
(this.m_u.x*(this.m_body2.m_linearVelocity.x+-this.m_body2.m_angularVelocity*a-(this.m_body1.m_linearVelocity.x+-this.m_body1.m_angularVelocity*b))+this.m_u.y*(this.m_body2.m_linearVelocity.y+this.m_body2.m_angularVelocity*e-(this.m_body1.m_linearVelocity.y+this.m_body1.m_angularVelocity*c)));this.m_impulse+=f;var g=f*this.m_u.x;f*=this.m_u.y;this.m_body1.m_linearVelocity.x-=this.m_body1.m_invMass*g;this.m_body1.m_linearVelocity.y-=this.m_body1.m_invMass*f;this.m_body1.m_angularVelocity-=this.m_body1.m_invI*
(c*f-b*g);this.m_body2.m_linearVelocity.x+=this.m_body2.m_invMass*g;this.m_body2.m_linearVelocity.y+=this.m_body2.m_invMass*f;this.m_body2.m_angularVelocity+=this.m_body2.m_invI*(e*f-a*g)},SolvePositionConstraints:function(){var a;a=this.m_body1.m_R;var c=a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y,b=a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y;a=this.m_body2.m_R;var e=a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y;a=a.col1.y*this.m_localAnchor2.x+
a.col2.y*this.m_localAnchor2.y;var f=this.m_body2.m_position.x+e-this.m_body1.m_position.x-c,g=this.m_body2.m_position.y+a-this.m_body1.m_position.y-b,h=Math.sqrt(f*f+g*g);f/=h;g/=h;h-=this.m_length;var h=b2Math.b2Clamp(h,-b2Settings.b2_maxLinearCorrection,b2Settings.b2_maxLinearCorrection),i=-this.m_mass*h;this.m_u.Set(f,g);f=i*this.m_u.x;g=i*this.m_u.y;this.m_body1.m_position.x-=this.m_body1.m_invMass*f;this.m_body1.m_position.y-=this.m_body1.m_invMass*g;this.m_body1.m_rotation-=this.m_body1.m_invI*
(c*g-b*f);this.m_body2.m_position.x+=this.m_body2.m_invMass*f;this.m_body2.m_position.y+=this.m_body2.m_invMass*g;this.m_body2.m_rotation+=this.m_body2.m_invI*(e*g-a*f);this.m_body1.m_R.Set(this.m_body1.m_rotation);this.m_body2.m_R.Set(this.m_body2.m_rotation);return b2Math.b2Abs(h)<b2Settings.b2_linearSlop},GetAnchor1:function(){return b2Math.AddVV(this.m_body1.m_position,b2Math.b2MulMV(this.m_body1.m_R,this.m_localAnchor1))},GetAnchor2:function(){return b2Math.AddVV(this.m_body2.m_position,b2Math.b2MulMV(this.m_body2.m_R,
this.m_localAnchor2))},GetReactionForce:function(a){var c=new b2Vec2;c.SetV(this.m_u);c.Multiply(this.m_impulse*a);return c},GetReactionTorque:function(){return 0},m_localAnchor1:new b2Vec2,m_localAnchor2:new b2Vec2,m_u:new b2Vec2,m_impulse:null,m_mass:null,m_length:null});var b2DistanceJointDef=Class.create();Object.extend(b2DistanceJointDef.prototype,b2JointDef.prototype);
Object.extend(b2DistanceJointDef.prototype,{initialize:function(){this.type=b2Joint.e_unknownJoint;this.body2=this.body1=this.userData=null;this.collideConnected=!1;this.anchorPoint1=new b2Vec2;this.anchorPoint2=new b2Vec2;this.type=b2Joint.e_distanceJoint},anchorPoint1:new b2Vec2,anchorPoint2:new b2Vec2});var b2Jacobian=Class.create();
b2Jacobian.prototype={linear1:new b2Vec2,angular1:null,linear2:new b2Vec2,angular2:null,SetZero:function(){this.linear1.SetZero();this.angular1=0;this.linear2.SetZero();this.angular2=0},Set:function(a,c,b,e){this.linear1.SetV(a);this.angular1=c;this.linear2.SetV(b);this.angular2=e},Compute:function(a,c,b,e){return this.linear1.x*a.x+this.linear1.y*a.y+this.angular1*c+(this.linear2.x*b.x+this.linear2.y*b.y)+this.angular2*e},initialize:function(){this.linear1=new b2Vec2;this.linear2=new b2Vec2}};
var b2GearJoint=Class.create();Object.extend(b2GearJoint.prototype,b2Joint.prototype);
Object.extend(b2GearJoint.prototype,{GetAnchor1:function(){var a=this.m_body1.m_R;return new b2Vec2(this.m_body1.m_position.x+(a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y),this.m_body1.m_position.y+(a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y))},GetAnchor2:function(){var a=this.m_body2.m_R;return new b2Vec2(this.m_body2.m_position.x+(a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y),this.m_body2.m_position.y+(a.col1.y*this.m_localAnchor2.x+a.col2.y*
this.m_localAnchor2.y))},GetReactionForce:function(){return new b2Vec2},GetReactionTorque:function(){return 0},GetRatio:function(){return this.m_ratio},initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.m_groundAnchor1=new b2Vec2;this.m_groundAnchor2=new b2Vec2;this.m_localAnchor1=new b2Vec2;
this.m_localAnchor2=new b2Vec2;this.m_J=new b2Jacobian;this.m_prismatic2=this.m_revolute2=this.m_prismatic1=this.m_revolute1=null;var c,b;this.m_ground1=a.joint1.m_body1;this.m_body1=a.joint1.m_body2;a.joint1.m_type==b2Joint.e_revoluteJoint?(this.m_revolute1=a.joint1,this.m_groundAnchor1.SetV(this.m_revolute1.m_localAnchor1),this.m_localAnchor1.SetV(this.m_revolute1.m_localAnchor2),c=this.m_revolute1.GetJointAngle()):(this.m_prismatic1=a.joint1,this.m_groundAnchor1.SetV(this.m_prismatic1.m_localAnchor1),
this.m_localAnchor1.SetV(this.m_prismatic1.m_localAnchor2),c=this.m_prismatic1.GetJointTranslation());this.m_ground2=a.joint2.m_body1;this.m_body2=a.joint2.m_body2;a.joint2.m_type==b2Joint.e_revoluteJoint?(this.m_revolute2=a.joint2,this.m_groundAnchor2.SetV(this.m_revolute2.m_localAnchor1),this.m_localAnchor2.SetV(this.m_revolute2.m_localAnchor2),b=this.m_revolute2.GetJointAngle()):(this.m_prismatic2=a.joint2,this.m_groundAnchor2.SetV(this.m_prismatic2.m_localAnchor1),this.m_localAnchor2.SetV(this.m_prismatic2.m_localAnchor2),
b=this.m_prismatic2.GetJointTranslation());this.m_ratio=a.ratio;this.m_constant=c+this.m_ratio*b;this.m_impulse=0},PrepareVelocitySolver:function(){var a=this.m_ground1,c=this.m_ground2,b=this.m_body1,e=this.m_body2,f,g,h,i=0;this.m_J.SetZero();this.m_revolute1?(this.m_J.angular1=-1,i+=b.m_invI):(h=a.m_R,f=this.m_prismatic1.m_localXAxis1,a=h.col1.x*f.x+h.col2.x*f.y,f=h.col1.y*f.x+h.col2.y*f.y,h=b.m_R,g=h.col1.x*this.m_localAnchor1.x+h.col2.x*this.m_localAnchor1.y,h=h.col1.y*this.m_localAnchor1.x+
h.col2.y*this.m_localAnchor1.y,g=g*f-h*a,this.m_J.linear1.Set(-a,-f),this.m_J.angular1=-g,i+=b.m_invMass+b.m_invI*g*g);this.m_revolute2?(this.m_J.angular2=-this.m_ratio,i+=this.m_ratio*this.m_ratio*e.m_invI):(h=c.m_R,f=this.m_prismatic2.m_localXAxis1,a=h.col1.x*f.x+h.col2.x*f.y,f=h.col1.y*f.x+h.col2.y*f.y,h=e.m_R,g=h.col1.x*this.m_localAnchor2.x+h.col2.x*this.m_localAnchor2.y,h=h.col1.y*this.m_localAnchor2.x+h.col2.y*this.m_localAnchor2.y,g=g*f-h*a,this.m_J.linear2.Set(-this.m_ratio*a,-this.m_ratio*
f),this.m_J.angular2=-this.m_ratio*g,i+=this.m_ratio*this.m_ratio*(e.m_invMass+e.m_invI*g*g));this.m_mass=1/i;b.m_linearVelocity.x+=b.m_invMass*this.m_impulse*this.m_J.linear1.x;b.m_linearVelocity.y+=b.m_invMass*this.m_impulse*this.m_J.linear1.y;b.m_angularVelocity+=b.m_invI*this.m_impulse*this.m_J.angular1;e.m_linearVelocity.x+=e.m_invMass*this.m_impulse*this.m_J.linear2.x;e.m_linearVelocity.y+=e.m_invMass*this.m_impulse*this.m_J.linear2.y;e.m_angularVelocity+=e.m_invI*this.m_impulse*this.m_J.angular2},
SolveVelocityConstraints:function(){var a=this.m_body1,c=this.m_body2,b=-this.m_mass*this.m_J.Compute(a.m_linearVelocity,a.m_angularVelocity,c.m_linearVelocity,c.m_angularVelocity);this.m_impulse+=b;a.m_linearVelocity.x+=a.m_invMass*b*this.m_J.linear1.x;a.m_linearVelocity.y+=a.m_invMass*b*this.m_J.linear1.y;a.m_angularVelocity+=a.m_invI*b*this.m_J.angular1;c.m_linearVelocity.x+=c.m_invMass*b*this.m_J.linear2.x;c.m_linearVelocity.y+=c.m_invMass*b*this.m_J.linear2.y;c.m_angularVelocity+=c.m_invI*b*
this.m_J.angular2},SolvePositionConstraints:function(){var a=this.m_body1,c=this.m_body2,b,e;b=this.m_revolute1?this.m_revolute1.GetJointAngle():this.m_prismatic1.GetJointTranslation();e=this.m_revolute2?this.m_revolute2.GetJointAngle():this.m_prismatic2.GetJointTranslation();b=-this.m_mass*(this.m_constant-(b+this.m_ratio*e));a.m_position.x+=a.m_invMass*b*this.m_J.linear1.x;a.m_position.y+=a.m_invMass*b*this.m_J.linear1.y;a.m_rotation+=a.m_invI*b*this.m_J.angular1;c.m_position.x+=c.m_invMass*b*this.m_J.linear2.x;
c.m_position.y+=c.m_invMass*b*this.m_J.linear2.y;c.m_rotation+=c.m_invI*b*this.m_J.angular2;a.m_R.Set(a.m_rotation);c.m_R.Set(c.m_rotation);return 0<b2Settings.b2_linearSlop},m_ground1:null,m_ground2:null,m_revolute1:null,m_prismatic1:null,m_revolute2:null,m_prismatic2:null,m_groundAnchor1:new b2Vec2,m_groundAnchor2:new b2Vec2,m_localAnchor1:new b2Vec2,m_localAnchor2:new b2Vec2,m_J:new b2Jacobian,m_constant:null,m_ratio:null,m_mass:null,m_impulse:null});var b2GearJointDef=Class.create();
Object.extend(b2GearJointDef.prototype,b2JointDef.prototype);Object.extend(b2GearJointDef.prototype,{initialize:function(){this.type=b2Joint.e_gearJoint;this.joint2=this.joint1=null;this.ratio=1},joint1:null,joint2:null,ratio:null});var b2MouseJoint=Class.create();Object.extend(b2MouseJoint.prototype,b2Joint.prototype);
Object.extend(b2MouseJoint.prototype,{GetAnchor1:function(){return this.m_target},GetAnchor2:function(){var a=b2Math.b2MulMV(this.m_body2.m_R,this.m_localAnchor);a.Add(this.m_body2.m_position);return a},GetReactionForce:function(a){var c=new b2Vec2;c.SetV(this.m_impulse);c.Multiply(a);return c},GetReactionTorque:function(){return 0},SetTarget:function(a){this.m_body2.WakeUp();this.m_target=a},initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=
this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.K=new b2Mat22;this.K1=new b2Mat22;this.K2=new b2Mat22;this.m_localAnchor=new b2Vec2;this.m_target=new b2Vec2;this.m_impulse=new b2Vec2;this.m_ptpMass=new b2Mat22;this.m_C=new b2Vec2;this.m_target.SetV(a.target);var c=this.m_target.x-this.m_body2.m_position.x,b=this.m_target.y-this.m_body2.m_position.y;this.m_localAnchor.x=c*this.m_body2.m_R.col1.x+
b*this.m_body2.m_R.col1.y;this.m_localAnchor.y=c*this.m_body2.m_R.col2.x+b*this.m_body2.m_R.col2.y;this.m_maxForce=a.maxForce;this.m_impulse.SetZero();var b=this.m_body2.m_mass,e=2*b2Settings.b2_pi*a.frequencyHz,c=2*b*a.dampingRatio*e,b=b*e*e;this.m_gamma=1/(c+a.timeStep*b);this.m_beta=a.timeStep*b/(c+a.timeStep*b)},K:new b2Mat22,K1:new b2Mat22,K2:new b2Mat22,PrepareVelocitySolver:function(){var a=this.m_body2,c;c=a.m_R;var b=c.col1.x*this.m_localAnchor.x+c.col2.x*this.m_localAnchor.y;c=c.col1.y*
this.m_localAnchor.x+c.col2.y*this.m_localAnchor.y;var e=a.m_invMass,f=a.m_invI;this.K1.col1.x=e;this.K1.col2.x=0;this.K1.col1.y=0;this.K1.col2.y=e;this.K2.col1.x=f*c*c;this.K2.col2.x=-f*b*c;this.K2.col1.y=-f*b*c;this.K2.col2.y=f*b*b;this.K.SetM(this.K1);this.K.AddM(this.K2);this.K.col1.x+=this.m_gamma;this.K.col2.y+=this.m_gamma;this.K.Invert(this.m_ptpMass);this.m_C.x=a.m_position.x+b-this.m_target.x;this.m_C.y=a.m_position.y+c-this.m_target.y;a.m_angularVelocity*=0.98;var g=this.m_impulse.x,h=
this.m_impulse.y;a.m_linearVelocity.x+=e*g;a.m_linearVelocity.y+=e*h;a.m_angularVelocity+=f*(b*h-c*g)},SolveVelocityConstraints:function(a){var c=this.m_body2,b;b=c.m_R;var e=b.col1.x*this.m_localAnchor.x+b.col2.x*this.m_localAnchor.y,f=b.col1.y*this.m_localAnchor.x+b.col2.y*this.m_localAnchor.y,g=c.m_linearVelocity.x+-c.m_angularVelocity*f,h=c.m_linearVelocity.y+c.m_angularVelocity*e;b=this.m_ptpMass;var g=g+this.m_beta*a.inv_dt*this.m_C.x+this.m_gamma*this.m_impulse.x,i=h+this.m_beta*a.inv_dt*this.m_C.y+
this.m_gamma*this.m_impulse.y,h=-(b.col1.x*g+b.col2.x*i),i=-(b.col1.y*g+b.col2.y*i);b=this.m_impulse.x;g=this.m_impulse.y;this.m_impulse.x+=h;this.m_impulse.y+=i;h=this.m_impulse.Length();h>a.dt*this.m_maxForce&&this.m_impulse.Multiply(a.dt*this.m_maxForce/h);h=this.m_impulse.x-b;i=this.m_impulse.y-g;c.m_linearVelocity.x+=c.m_invMass*h;c.m_linearVelocity.y+=c.m_invMass*i;c.m_angularVelocity+=c.m_invI*(e*i-f*h)},SolvePositionConstraints:function(){return!0},m_localAnchor:new b2Vec2,m_target:new b2Vec2,
m_impulse:new b2Vec2,m_ptpMass:new b2Mat22,m_C:new b2Vec2,m_maxForce:null,m_beta:null,m_gamma:null});var b2MouseJointDef=Class.create();Object.extend(b2MouseJointDef.prototype,b2JointDef.prototype);
Object.extend(b2MouseJointDef.prototype,{initialize:function(){this.type=b2Joint.e_unknownJoint;this.body2=this.body1=this.userData=null;this.collideConnected=!1;this.target=new b2Vec2;this.type=b2Joint.e_mouseJoint;this.maxForce=0;this.frequencyHz=5;this.dampingRatio=0.7;this.timeStep=1/60},target:new b2Vec2,maxForce:null,frequencyHz:null,dampingRatio:null,timeStep:null});var b2PrismaticJoint=Class.create();Object.extend(b2PrismaticJoint.prototype,b2Joint.prototype);
Object.extend(b2PrismaticJoint.prototype,{GetAnchor1:function(){var a=this.m_body1,c=new b2Vec2;c.SetV(this.m_localAnchor1);c.MulM(a.m_R);c.Add(a.m_position);return c},GetAnchor2:function(){var a=this.m_body2,c=new b2Vec2;c.SetV(this.m_localAnchor2);c.MulM(a.m_R);c.Add(a.m_position);return c},GetJointTranslation:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;
b=c.m_R;e=c.m_position.x+(b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y)-(a.m_position.x+e);c=c.m_position.y+(b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y)-(a.m_position.y+f);b=a.m_R;return(b.col1.x*this.m_localXAxis1.x+b.col2.x*this.m_localXAxis1.y)*e+(b.col1.y*this.m_localXAxis1.x+b.col2.y*this.m_localXAxis1.y)*c},GetJointSpeed:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+
b.col2.y*this.m_localAnchor1.y;b=c.m_R;var g=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y,h=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y,i=c.m_position.x+g-(a.m_position.x+e),k=c.m_position.y+h-(a.m_position.y+f);b=a.m_R;var j=b.col1.x*this.m_localXAxis1.x+b.col2.x*this.m_localXAxis1.y;b=b.col1.y*this.m_localXAxis1.x+b.col2.y*this.m_localXAxis1.y;var l=a.m_linearVelocity,m=c.m_linearVelocity,a=a.m_angularVelocity,c=c.m_angularVelocity;return i*-a*b+k*a*j+(j*(m.x+
-c*h-l.x- -a*f)+b*(m.y+c*g-l.y-a*e))},GetMotorForce:function(a){return a*this.m_motorImpulse},SetMotorSpeed:function(a){this.m_motorSpeed=a},SetMotorForce:function(a){this.m_maxMotorForce=a},GetReactionForce:function(a){a*=this.m_limitImpulse;var c;c=this.m_body1.m_R;return new b2Vec2(a*(c.col1.x*this.m_localXAxis1.x+c.col2.x*this.m_localXAxis1.y)+a*(c.col1.x*this.m_localYAxis1.x+c.col2.x*this.m_localYAxis1.y),a*(c.col1.y*this.m_localXAxis1.x+c.col2.y*this.m_localXAxis1.y)+a*(c.col1.y*this.m_localYAxis1.x+
c.col2.y*this.m_localYAxis1.y))},GetReactionTorque:function(a){return a*this.m_angularImpulse},initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.m_localAnchor1=new b2Vec2;this.m_localAnchor2=new b2Vec2;this.m_localXAxis1=new b2Vec2;this.m_localYAxis1=new b2Vec2;this.m_linearJacobian=
new b2Jacobian;this.m_motorJacobian=new b2Jacobian;var c,b,e;c=this.m_body1.m_R;b=a.anchorPoint.x-this.m_body1.m_position.x;e=a.anchorPoint.y-this.m_body1.m_position.y;this.m_localAnchor1.Set(b*c.col1.x+e*c.col1.y,b*c.col2.x+e*c.col2.y);c=this.m_body2.m_R;b=a.anchorPoint.x-this.m_body2.m_position.x;e=a.anchorPoint.y-this.m_body2.m_position.y;this.m_localAnchor2.Set(b*c.col1.x+e*c.col1.y,b*c.col2.x+e*c.col2.y);c=this.m_body1.m_R;b=a.axis.x;e=a.axis.y;this.m_localXAxis1.Set(b*c.col1.x+e*c.col1.y,b*
c.col2.x+e*c.col2.y);this.m_localYAxis1.x=-this.m_localXAxis1.y;this.m_localYAxis1.y=this.m_localXAxis1.x;this.m_initialAngle=this.m_body2.m_rotation-this.m_body1.m_rotation;this.m_linearJacobian.SetZero();this.m_angularImpulse=this.m_angularMass=this.m_linearImpulse=this.m_linearMass=0;this.m_motorJacobian.SetZero();this.m_limitPositionImpulse=this.m_limitImpulse=this.m_motorImpulse=this.m_motorMass=0;this.m_lowerTranslation=a.lowerTranslation;this.m_upperTranslation=a.upperTranslation;this.m_maxMotorForce=
a.motorForce;this.m_motorSpeed=a.motorSpeed;this.m_enableLimit=a.enableLimit;this.m_enableMotor=a.enableMotor},PrepareVelocitySolver:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;b=c.m_R;var g=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y,h=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y,i=a.m_invMass,k=c.m_invMass,j=a.m_invI,l=
c.m_invI;b=a.m_R;var m=b.col1.x*this.m_localYAxis1.x+b.col2.x*this.m_localYAxis1.y;b=b.col1.y*this.m_localYAxis1.x+b.col2.y*this.m_localYAxis1.y;var n=c.m_position.x+g-a.m_position.x,o=c.m_position.y+h-a.m_position.y;this.m_linearJacobian.linear1.x=-m;this.m_linearJacobian.linear1.y=-b;this.m_linearJacobian.linear2.x=m;this.m_linearJacobian.linear2.y=b;this.m_linearJacobian.angular1=-(n*b-o*m);this.m_linearJacobian.angular2=g*b-h*m;this.m_linearMass=i+j*this.m_linearJacobian.angular1*this.m_linearJacobian.angular1+
k+l*this.m_linearJacobian.angular2*this.m_linearJacobian.angular2;this.m_linearMass=1/this.m_linearMass;this.m_angularMass=1/(j+l);if(this.m_enableLimit||this.m_enableMotor)if(b=a.m_R,m=b.col1.x*this.m_localXAxis1.x+b.col2.x*this.m_localXAxis1.y,b=b.col1.y*this.m_localXAxis1.x+b.col2.y*this.m_localXAxis1.y,this.m_motorJacobian.linear1.x=-m,this.m_motorJacobian.linear1.y=-b,this.m_motorJacobian.linear2.x=m,this.m_motorJacobian.linear2.y=b,this.m_motorJacobian.angular1=-(n*b-o*m),this.m_motorJacobian.angular2=
g*b-h*m,this.m_motorMass=i+j*this.m_motorJacobian.angular1*this.m_motorJacobian.angular1+k+l*this.m_motorJacobian.angular2*this.m_motorJacobian.angular2,this.m_motorMass=1/this.m_motorMass,this.m_enableLimit)if(e=m*(n-e)+b*(o-f),b2Math.b2Abs(this.m_upperTranslation-this.m_lowerTranslation)<2*b2Settings.b2_linearSlop)this.m_limitState=b2Joint.e_equalLimits;else if(e<=this.m_lowerTranslation){if(this.m_limitState!=b2Joint.e_atLowerLimit)this.m_limitImpulse=0;this.m_limitState=b2Joint.e_atLowerLimit}else if(e>=
this.m_upperTranslation){if(this.m_limitState!=b2Joint.e_atUpperLimit)this.m_limitImpulse=0;this.m_limitState=b2Joint.e_atUpperLimit}else this.m_limitState=b2Joint.e_inactiveLimit,this.m_limitImpulse=0;if(this.m_enableMotor==!1)this.m_motorImpulse=0;if(this.m_enableLimit==!1)this.m_limitImpulse=0;b2World.s_enableWarmStarting?(e=this.m_linearImpulse*this.m_linearJacobian.linear1.y+(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.linear1.y,f=this.m_linearImpulse*this.m_linearJacobian.linear2.x+
(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.linear2.x,g=this.m_linearImpulse*this.m_linearJacobian.linear2.y+(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.linear2.y,h=this.m_linearImpulse*this.m_linearJacobian.angular1-this.m_angularImpulse+(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.angular1,n=this.m_linearImpulse*this.m_linearJacobian.angular2+this.m_angularImpulse+(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.angular2,a.m_linearVelocity.x+=
i*(this.m_linearImpulse*this.m_linearJacobian.linear1.x+(this.m_motorImpulse+this.m_limitImpulse)*this.m_motorJacobian.linear1.x),a.m_linearVelocity.y+=i*e,a.m_angularVelocity+=j*h,c.m_linearVelocity.x+=k*f,c.m_linearVelocity.y+=k*g,c.m_angularVelocity+=l*n):this.m_motorImpulse=this.m_limitImpulse=this.m_angularImpulse=this.m_linearImpulse=0;this.m_limitPositionImpulse=0},SolveVelocityConstraints:function(a){var c=this.m_body1,b=this.m_body2,e=c.m_invMass,f=b.m_invMass,g=c.m_invI,h=b.m_invI,i=-this.m_linearMass*
this.m_linearJacobian.Compute(c.m_linearVelocity,c.m_angularVelocity,b.m_linearVelocity,b.m_angularVelocity);this.m_linearImpulse+=i;c.m_linearVelocity.x+=e*i*this.m_linearJacobian.linear1.x;c.m_linearVelocity.y+=e*i*this.m_linearJacobian.linear1.y;c.m_angularVelocity+=g*i*this.m_linearJacobian.angular1;b.m_linearVelocity.x+=f*i*this.m_linearJacobian.linear2.x;b.m_linearVelocity.y+=f*i*this.m_linearJacobian.linear2.y;b.m_angularVelocity+=h*i*this.m_linearJacobian.angular2;i=-this.m_angularMass*(b.m_angularVelocity-
c.m_angularVelocity);this.m_angularImpulse+=i;c.m_angularVelocity-=g*i;b.m_angularVelocity+=h*i;if(this.m_enableMotor&&this.m_limitState!=b2Joint.e_equalLimits){var i=-this.m_motorMass*(this.m_motorJacobian.Compute(c.m_linearVelocity,c.m_angularVelocity,b.m_linearVelocity,b.m_angularVelocity)-this.m_motorSpeed),k=this.m_motorImpulse;this.m_motorImpulse=b2Math.b2Clamp(this.m_motorImpulse+i,-a.dt*this.m_maxMotorForce,a.dt*this.m_maxMotorForce);i=this.m_motorImpulse-k;c.m_linearVelocity.x+=e*i*this.m_motorJacobian.linear1.x;
c.m_linearVelocity.y+=e*i*this.m_motorJacobian.linear1.y;c.m_angularVelocity+=g*i*this.m_motorJacobian.angular1;b.m_linearVelocity.x+=f*i*this.m_motorJacobian.linear2.x;b.m_linearVelocity.y+=f*i*this.m_motorJacobian.linear2.y;b.m_angularVelocity+=h*i*this.m_motorJacobian.angular2}if(this.m_enableLimit&&this.m_limitState!=b2Joint.e_inactiveLimit){i=-this.m_motorMass*this.m_motorJacobian.Compute(c.m_linearVelocity,c.m_angularVelocity,b.m_linearVelocity,b.m_angularVelocity);if(this.m_limitState==b2Joint.e_equalLimits)this.m_limitImpulse+=
i;else if(this.m_limitState==b2Joint.e_atLowerLimit)a=this.m_limitImpulse,this.m_limitImpulse=b2Math.b2Max(this.m_limitImpulse+i,0),i=this.m_limitImpulse-a;else if(this.m_limitState==b2Joint.e_atUpperLimit)a=this.m_limitImpulse,this.m_limitImpulse=b2Math.b2Min(this.m_limitImpulse+i,0),i=this.m_limitImpulse-a;c.m_linearVelocity.x+=e*i*this.m_motorJacobian.linear1.x;c.m_linearVelocity.y+=e*i*this.m_motorJacobian.linear1.y;c.m_angularVelocity+=g*i*this.m_motorJacobian.angular1;b.m_linearVelocity.x+=
f*i*this.m_motorJacobian.linear2.x;b.m_linearVelocity.y+=f*i*this.m_motorJacobian.linear2.y;b.m_angularVelocity+=h*i*this.m_motorJacobian.angular2}},SolvePositionConstraints:function(){var a,c,b=this.m_body1,e=this.m_body2,f=b.m_invMass,g=e.m_invMass,h=b.m_invI,i=e.m_invI;a=b.m_R;var k=a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y,j=a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y;a=e.m_R;var l=a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y;a=a.col1.y*this.m_localAnchor2.x+
a.col2.y*this.m_localAnchor2.y;var k=b.m_position.x+k,j=b.m_position.y+j,l=e.m_position.x+l,m=e.m_position.y+a;a=b.m_R;var n=(a.col1.x*this.m_localYAxis1.x+a.col2.x*this.m_localYAxis1.y)*(l-k)+(a.col1.y*this.m_localYAxis1.x+a.col2.y*this.m_localYAxis1.y)*(m-j),n=b2Math.b2Clamp(n,-b2Settings.b2_maxLinearCorrection,b2Settings.b2_maxLinearCorrection);c=-this.m_linearMass*n;b.m_position.x+=f*c*this.m_linearJacobian.linear1.x;b.m_position.y+=f*c*this.m_linearJacobian.linear1.y;b.m_rotation+=h*c*this.m_linearJacobian.angular1;
e.m_position.x+=g*c*this.m_linearJacobian.linear2.x;e.m_position.y+=g*c*this.m_linearJacobian.linear2.y;e.m_rotation+=i*c*this.m_linearJacobian.angular2;n=b2Math.b2Abs(n);c=e.m_rotation-b.m_rotation-this.m_initialAngle;c=b2Math.b2Clamp(c,-b2Settings.b2_maxAngularCorrection,b2Settings.b2_maxAngularCorrection);var o=-this.m_angularMass*c;b.m_rotation-=b.m_invI*o;b.m_R.Set(b.m_rotation);e.m_rotation+=e.m_invI*o;e.m_R.Set(e.m_rotation);o=b2Math.b2Abs(c);if(this.m_enableLimit&&this.m_limitState!=b2Joint.e_inactiveLimit){a=
b.m_R;k=a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y;j=a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y;a=e.m_R;l=a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y;a=a.col1.y*this.m_localAnchor2.x+a.col2.y*this.m_localAnchor2.y;k=b.m_position.x+k;j=b.m_position.y+j;l=e.m_position.x+l;m=e.m_position.y+a;a=b.m_R;k=(a.col1.x*this.m_localXAxis1.x+a.col2.x*this.m_localXAxis1.y)*(l-k)+(a.col1.y*this.m_localXAxis1.x+a.col2.y*this.m_localXAxis1.y)*(m-j);a=0;if(this.m_limitState==
b2Joint.e_equalLimits)a=b2Math.b2Clamp(k,-b2Settings.b2_maxLinearCorrection,b2Settings.b2_maxLinearCorrection),a*=-this.m_motorMass,n=b2Math.b2Max(n,b2Math.b2Abs(c));else if(this.m_limitState==b2Joint.e_atLowerLimit)a=k-this.m_lowerTranslation,n=b2Math.b2Max(n,-a),a=b2Math.b2Clamp(a+b2Settings.b2_linearSlop,-b2Settings.b2_maxLinearCorrection,0),a*=-this.m_motorMass,c=this.m_limitPositionImpulse,this.m_limitPositionImpulse=b2Math.b2Max(this.m_limitPositionImpulse+a,0),a=this.m_limitPositionImpulse-
c;else if(this.m_limitState==b2Joint.e_atUpperLimit)a=k-this.m_upperTranslation,n=b2Math.b2Max(n,a),a=b2Math.b2Clamp(a-b2Settings.b2_linearSlop,0,b2Settings.b2_maxLinearCorrection),a*=-this.m_motorMass,c=this.m_limitPositionImpulse,this.m_limitPositionImpulse=b2Math.b2Min(this.m_limitPositionImpulse+a,0),a=this.m_limitPositionImpulse-c;b.m_position.x+=f*a*this.m_motorJacobian.linear1.x;b.m_position.y+=f*a*this.m_motorJacobian.linear1.y;b.m_rotation+=h*a*this.m_motorJacobian.angular1;b.m_R.Set(b.m_rotation);
e.m_position.x+=g*a*this.m_motorJacobian.linear2.x;e.m_position.y+=g*a*this.m_motorJacobian.linear2.y;e.m_rotation+=i*a*this.m_motorJacobian.angular2;e.m_R.Set(e.m_rotation)}return n<=b2Settings.b2_linearSlop&&o<=b2Settings.b2_angularSlop},m_localAnchor1:new b2Vec2,m_localAnchor2:new b2Vec2,m_localXAxis1:new b2Vec2,m_localYAxis1:new b2Vec2,m_initialAngle:null,m_linearJacobian:new b2Jacobian,m_linearMass:null,m_linearImpulse:null,m_angularMass:null,m_angularImpulse:null,m_motorJacobian:new b2Jacobian,
m_motorMass:null,m_motorImpulse:null,m_limitImpulse:null,m_limitPositionImpulse:null,m_lowerTranslation:null,m_upperTranslation:null,m_maxMotorForce:null,m_motorSpeed:null,m_enableLimit:null,m_enableMotor:null,m_limitState:0});var b2PrismaticJointDef=Class.create();Object.extend(b2PrismaticJointDef.prototype,b2JointDef.prototype);
Object.extend(b2PrismaticJointDef.prototype,{initialize:function(){this.type=b2Joint.e_unknownJoint;this.body2=this.body1=this.userData=null;this.collideConnected=!1;this.type=b2Joint.e_prismaticJoint;this.anchorPoint=new b2Vec2(0,0);this.axis=new b2Vec2(0,0);this.motorSpeed=this.motorForce=this.upperTranslation=this.lowerTranslation=0;this.enableMotor=this.enableLimit=!1},anchorPoint:null,axis:null,lowerTranslation:null,upperTranslation:null,motorForce:null,motorSpeed:null,enableLimit:null,enableMotor:null});
var b2PulleyJoint=Class.create();Object.extend(b2PulleyJoint.prototype,b2Joint.prototype);
Object.extend(b2PulleyJoint.prototype,{GetAnchor1:function(){var a=this.m_body1.m_R;return new b2Vec2(this.m_body1.m_position.x+(a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y),this.m_body1.m_position.y+(a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y))},GetAnchor2:function(){var a=this.m_body2.m_R;return new b2Vec2(this.m_body2.m_position.x+(a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y),this.m_body2.m_position.y+(a.col1.y*this.m_localAnchor2.x+a.col2.y*
this.m_localAnchor2.y))},GetGroundPoint1:function(){return new b2Vec2(this.m_ground.m_position.x+this.m_groundAnchor1.x,this.m_ground.m_position.y+this.m_groundAnchor1.y)},GetGroundPoint2:function(){return new b2Vec2(this.m_ground.m_position.x+this.m_groundAnchor2.x,this.m_ground.m_position.y+this.m_groundAnchor2.y)},GetReactionForce:function(){return new b2Vec2},GetReactionTorque:function(){return 0},GetLength1:function(){var a;a=this.m_body1.m_R;var c=this.m_body1.m_position.x+(a.col1.x*this.m_localAnchor1.x+
a.col2.x*this.m_localAnchor1.y)-(this.m_ground.m_position.x+this.m_groundAnchor1.x);a=this.m_body1.m_position.y+(a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y)-(this.m_ground.m_position.y+this.m_groundAnchor1.y);return Math.sqrt(c*c+a*a)},GetLength2:function(){var a;a=this.m_body2.m_R;var c=this.m_body2.m_position.x+(a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y)-(this.m_ground.m_position.x+this.m_groundAnchor2.x);a=this.m_body2.m_position.y+(a.col1.y*this.m_localAnchor2.x+
a.col2.y*this.m_localAnchor2.y)-(this.m_ground.m_position.y+this.m_groundAnchor2.y);return Math.sqrt(c*c+a*a)},GetRatio:function(){return this.m_ratio},initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.m_groundAnchor1=new b2Vec2;this.m_groundAnchor2=new b2Vec2;this.m_localAnchor1=new b2Vec2;
this.m_localAnchor2=new b2Vec2;this.m_u1=new b2Vec2;this.m_u2=new b2Vec2;var c,b,e;this.m_ground=this.m_body1.m_world.m_groundBody;this.m_groundAnchor1.x=a.groundPoint1.x-this.m_ground.m_position.x;this.m_groundAnchor1.y=a.groundPoint1.y-this.m_ground.m_position.y;this.m_groundAnchor2.x=a.groundPoint2.x-this.m_ground.m_position.x;this.m_groundAnchor2.y=a.groundPoint2.y-this.m_ground.m_position.y;c=this.m_body1.m_R;b=a.anchorPoint1.x-this.m_body1.m_position.x;e=a.anchorPoint1.y-this.m_body1.m_position.y;
this.m_localAnchor1.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor1.y=b*c.col2.x+e*c.col2.y;c=this.m_body2.m_R;b=a.anchorPoint2.x-this.m_body2.m_position.x;e=a.anchorPoint2.y-this.m_body2.m_position.y;this.m_localAnchor2.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor2.y=b*c.col2.x+e*c.col2.y;this.m_ratio=a.ratio;b=a.groundPoint1.x-a.anchorPoint1.x;e=a.groundPoint1.y-a.anchorPoint1.y;c=Math.sqrt(b*b+e*e);b=a.groundPoint2.x-a.anchorPoint2.x;e=a.groundPoint2.y-a.anchorPoint2.y;b=Math.sqrt(b*b+e*e);e=b2Math.b2Max(0.5*
b2PulleyJoint.b2_minPulleyLength,c);b=b2Math.b2Max(0.5*b2PulleyJoint.b2_minPulleyLength,b);this.m_constant=e+this.m_ratio*b;this.m_maxLength1=b2Math.b2Clamp(a.maxLength1,e,this.m_constant-this.m_ratio*b2PulleyJoint.b2_minPulleyLength);this.m_maxLength2=b2Math.b2Clamp(a.maxLength2,b,(this.m_constant-b2PulleyJoint.b2_minPulleyLength)/this.m_ratio);this.m_limitImpulse2=this.m_limitImpulse1=this.m_pulleyImpulse=0},PrepareVelocitySolver:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*
this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;b=c.m_R;var g=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y;b=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y;var h=c.m_position.x+g,i=c.m_position.y+b,k=this.m_ground.m_position.x+this.m_groundAnchor2.x,j=this.m_ground.m_position.y+this.m_groundAnchor2.y;this.m_u1.Set(a.m_position.x+e-(this.m_ground.m_position.x+this.m_groundAnchor1.x),a.m_position.y+
f-(this.m_ground.m_position.y+this.m_groundAnchor1.y));this.m_u2.Set(h-k,i-j);h=this.m_u1.Length();i=this.m_u2.Length();h>b2Settings.b2_linearSlop?this.m_u1.Multiply(1/h):this.m_u1.SetZero();i>b2Settings.b2_linearSlop?this.m_u2.Multiply(1/i):this.m_u2.SetZero();h<this.m_maxLength1?(this.m_limitState1=b2Joint.e_inactiveLimit,this.m_limitImpulse1=0):(this.m_limitState1=b2Joint.e_atUpperLimit,this.m_limitPositionImpulse1=0);i<this.m_maxLength2?(this.m_limitState2=b2Joint.e_inactiveLimit,this.m_limitImpulse2=
0):(this.m_limitState2=b2Joint.e_atUpperLimit,this.m_limitPositionImpulse2=0);h=e*this.m_u1.y-f*this.m_u1.x;i=g*this.m_u2.y-b*this.m_u2.x;this.m_limitMass1=a.m_invMass+a.m_invI*h*h;this.m_limitMass2=c.m_invMass+c.m_invI*i*i;this.m_pulleyMass=this.m_limitMass1+this.m_ratio*this.m_ratio*this.m_limitMass2;this.m_limitMass1=1/this.m_limitMass1;this.m_limitMass2=1/this.m_limitMass2;this.m_pulleyMass=1/this.m_pulleyMass;h=(-this.m_pulleyImpulse-this.m_limitImpulse1)*this.m_u1.x;i=(-this.m_pulleyImpulse-
this.m_limitImpulse1)*this.m_u1.y;k=(-this.m_ratio*this.m_pulleyImpulse-this.m_limitImpulse2)*this.m_u2.x;j=(-this.m_ratio*this.m_pulleyImpulse-this.m_limitImpulse2)*this.m_u2.y;a.m_linearVelocity.x+=a.m_invMass*h;a.m_linearVelocity.y+=a.m_invMass*i;a.m_angularVelocity+=a.m_invI*(e*i-f*h);c.m_linearVelocity.x+=c.m_invMass*k;c.m_linearVelocity.y+=c.m_invMass*j;c.m_angularVelocity+=c.m_invI*(g*j-b*k)},SolveVelocityConstraints:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*this.m_localAnchor1.x+
b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;b=c.m_R;var g=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y;b=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y;var h,i,k,j;h=a.m_linearVelocity.x+-a.m_angularVelocity*f;i=a.m_linearVelocity.y+a.m_angularVelocity*e;k=c.m_linearVelocity.x+-c.m_angularVelocity*b;j=c.m_linearVelocity.y+c.m_angularVelocity*g;h=-(this.m_u1.x*h+this.m_u1.y*i)-this.m_ratio*(this.m_u2.x*k+this.m_u2.y*
j);j=-this.m_pulleyMass*h;this.m_pulleyImpulse+=j;h=-j*this.m_u1.x;i=-j*this.m_u1.y;k=-this.m_ratio*j*this.m_u2.x;j=-this.m_ratio*j*this.m_u2.y;a.m_linearVelocity.x+=a.m_invMass*h;a.m_linearVelocity.y+=a.m_invMass*i;a.m_angularVelocity+=a.m_invI*(e*i-f*h);c.m_linearVelocity.x+=c.m_invMass*k;c.m_linearVelocity.y+=c.m_invMass*j;c.m_angularVelocity+=c.m_invI*(g*j-b*k);if(this.m_limitState1==b2Joint.e_atUpperLimit)h=a.m_linearVelocity.x+-a.m_angularVelocity*f,i=a.m_linearVelocity.y+a.m_angularVelocity*
e,h=-(this.m_u1.x*h+this.m_u1.y*i),j=-this.m_limitMass1*h,h=this.m_limitImpulse1,this.m_limitImpulse1=b2Math.b2Max(0,this.m_limitImpulse1+j),j=this.m_limitImpulse1-h,h=-j*this.m_u1.x,i=-j*this.m_u1.y,a.m_linearVelocity.x+=a.m_invMass*h,a.m_linearVelocity.y+=a.m_invMass*i,a.m_angularVelocity+=a.m_invI*(e*i-f*h);if(this.m_limitState2==b2Joint.e_atUpperLimit)k=c.m_linearVelocity.x+-c.m_angularVelocity*b,j=c.m_linearVelocity.y+c.m_angularVelocity*g,h=-(this.m_u2.x*k+this.m_u2.y*j),j=-this.m_limitMass2*
h,h=this.m_limitImpulse2,this.m_limitImpulse2=b2Math.b2Max(0,this.m_limitImpulse2+j),j=this.m_limitImpulse2-h,k=-j*this.m_u2.x,j=-j*this.m_u2.y,c.m_linearVelocity.x+=c.m_invMass*k,c.m_linearVelocity.y+=c.m_invMass*j,c.m_angularVelocity+=c.m_invI*(g*j-b*k)},SolvePositionConstraints:function(){var a=this.m_body1,c=this.m_body2,b,e=this.m_ground.m_position.x+this.m_groundAnchor1.x,f=this.m_ground.m_position.y+this.m_groundAnchor1.y,g=this.m_ground.m_position.x+this.m_groundAnchor2.x,h=this.m_ground.m_position.y+
this.m_groundAnchor2.y,i,k,j,l,m,n,o,p=0;b=a.m_R;i=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y;k=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;b=c.m_R;j=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y;b=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y;l=a.m_position.x+i;m=a.m_position.y+k;n=c.m_position.x+j;o=c.m_position.y+b;this.m_u1.Set(l-e,m-f);this.m_u2.Set(n-g,o-h);l=this.m_u1.Length();m=this.m_u2.Length();l>b2Settings.b2_linearSlop?
this.m_u1.Multiply(1/l):this.m_u1.SetZero();m>b2Settings.b2_linearSlop?this.m_u2.Multiply(1/m):this.m_u2.SetZero();l=this.m_constant-l-this.m_ratio*m;p=b2Math.b2Max(p,Math.abs(l));l=b2Math.b2Clamp(l,-b2Settings.b2_maxLinearCorrection,b2Settings.b2_maxLinearCorrection);o=-this.m_pulleyMass*l;l=-o*this.m_u1.x;m=-o*this.m_u1.y;n=-this.m_ratio*o*this.m_u2.x;o=-this.m_ratio*o*this.m_u2.y;a.m_position.x+=a.m_invMass*l;a.m_position.y+=a.m_invMass*m;a.m_rotation+=a.m_invI*(i*m-k*l);c.m_position.x+=c.m_invMass*
n;c.m_position.y+=c.m_invMass*o;c.m_rotation+=c.m_invI*(j*o-b*n);a.m_R.Set(a.m_rotation);c.m_R.Set(c.m_rotation);if(this.m_limitState1==b2Joint.e_atUpperLimit)b=a.m_R,i=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,k=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y,l=a.m_position.x+i,m=a.m_position.y+k,this.m_u1.Set(l-e,m-f),l=this.m_u1.Length(),l>b2Settings.b2_linearSlop?(this.m_u1.x*=1/l,this.m_u1.y*=1/l):this.m_u1.SetZero(),l=this.m_maxLength1-l,p=b2Math.b2Max(p,-l),
l=b2Math.b2Clamp(l+b2Settings.b2_linearSlop,-b2Settings.b2_maxLinearCorrection,0),o=-this.m_limitMass1*l,e=this.m_limitPositionImpulse1,this.m_limitPositionImpulse1=b2Math.b2Max(0,this.m_limitPositionImpulse1+o),o=this.m_limitPositionImpulse1-e,l=-o*this.m_u1.x,m=-o*this.m_u1.y,a.m_position.x+=a.m_invMass*l,a.m_position.y+=a.m_invMass*m,a.m_rotation+=a.m_invI*(i*m-k*l),a.m_R.Set(a.m_rotation);if(this.m_limitState2==b2Joint.e_atUpperLimit)b=c.m_R,j=b.col1.x*this.m_localAnchor2.x+b.col2.x*this.m_localAnchor2.y,
b=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y,n=c.m_position.x+j,o=c.m_position.y+b,this.m_u2.Set(n-g,o-h),m=this.m_u2.Length(),m>b2Settings.b2_linearSlop?(this.m_u2.x*=1/m,this.m_u2.y*=1/m):this.m_u2.SetZero(),l=this.m_maxLength2-m,p=b2Math.b2Max(p,-l),l=b2Math.b2Clamp(l+b2Settings.b2_linearSlop,-b2Settings.b2_maxLinearCorrection,0),o=-this.m_limitMass2*l,e=this.m_limitPositionImpulse2,this.m_limitPositionImpulse2=b2Math.b2Max(0,this.m_limitPositionImpulse2+o),o=this.m_limitPositionImpulse2-
e,n=-o*this.m_u2.x,o=-o*this.m_u2.y,c.m_position.x+=c.m_invMass*n,c.m_position.y+=c.m_invMass*o,c.m_rotation+=c.m_invI*(j*o-b*n),c.m_R.Set(c.m_rotation);return p<b2Settings.b2_linearSlop},m_ground:null,m_groundAnchor1:new b2Vec2,m_groundAnchor2:new b2Vec2,m_localAnchor1:new b2Vec2,m_localAnchor2:new b2Vec2,m_u1:new b2Vec2,m_u2:new b2Vec2,m_constant:null,m_ratio:null,m_maxLength1:null,m_maxLength2:null,m_pulleyMass:null,m_limitMass1:null,m_limitMass2:null,m_pulleyImpulse:null,m_limitImpulse1:null,
m_limitImpulse2:null,m_limitPositionImpulse1:null,m_limitPositionImpulse2:null,m_limitState1:0,m_limitState2:0});b2PulleyJoint.b2_minPulleyLength=b2Settings.b2_lengthUnitsPerMeter;var b2PulleyJointDef=Class.create();Object.extend(b2PulleyJointDef.prototype,b2JointDef.prototype);
Object.extend(b2PulleyJointDef.prototype,{initialize:function(){this.type=b2Joint.e_unknownJoint;this.body2=this.body1=this.userData=null;this.collideConnected=!1;this.groundPoint1=new b2Vec2;this.groundPoint2=new b2Vec2;this.anchorPoint1=new b2Vec2;this.anchorPoint2=new b2Vec2;this.type=b2Joint.e_pulleyJoint;this.groundPoint1.Set(-1,1);this.groundPoint2.Set(1,1);this.anchorPoint1.Set(-1,0);this.anchorPoint2.Set(1,0);this.maxLength1=0.5*b2PulleyJoint.b2_minPulleyLength;this.maxLength2=0.5*b2PulleyJoint.b2_minPulleyLength;
this.ratio=1;this.collideConnected=!0},groundPoint1:new b2Vec2,groundPoint2:new b2Vec2,anchorPoint1:new b2Vec2,anchorPoint2:new b2Vec2,maxLength1:null,maxLength2:null,ratio:null});var b2RevoluteJoint=Class.create();Object.extend(b2RevoluteJoint.prototype,b2Joint.prototype);
Object.extend(b2RevoluteJoint.prototype,{GetAnchor1:function(){var a=this.m_body1.m_R;return new b2Vec2(this.m_body1.m_position.x+(a.col1.x*this.m_localAnchor1.x+a.col2.x*this.m_localAnchor1.y),this.m_body1.m_position.y+(a.col1.y*this.m_localAnchor1.x+a.col2.y*this.m_localAnchor1.y))},GetAnchor2:function(){var a=this.m_body2.m_R;return new b2Vec2(this.m_body2.m_position.x+(a.col1.x*this.m_localAnchor2.x+a.col2.x*this.m_localAnchor2.y),this.m_body2.m_position.y+(a.col1.y*this.m_localAnchor2.x+a.col2.y*
this.m_localAnchor2.y))},GetJointAngle:function(){return this.m_body2.m_rotation-this.m_body1.m_rotation},GetJointSpeed:function(){return this.m_body2.m_angularVelocity-this.m_body1.m_angularVelocity},GetMotorTorque:function(a){return a*this.m_motorImpulse},SetMotorSpeed:function(a){this.m_motorSpeed=a},SetMotorTorque:function(a){this.m_maxMotorTorque=a},GetReactionForce:function(a){var c=this.m_ptpImpulse.Copy();c.Multiply(a);return c},GetReactionTorque:function(a){return a*this.m_limitImpulse},
initialize:function(a){this.m_node1=new b2JointNode;this.m_node2=new b2JointNode;this.m_type=a.type;this.m_next=this.m_prev=null;this.m_body1=a.body1;this.m_body2=a.body2;this.m_collideConnected=a.collideConnected;this.m_islandFlag=!1;this.m_userData=a.userData;this.K=new b2Mat22;this.K1=new b2Mat22;this.K2=new b2Mat22;this.K3=new b2Mat22;this.m_localAnchor1=new b2Vec2;this.m_localAnchor2=new b2Vec2;this.m_ptpImpulse=new b2Vec2;this.m_ptpMass=new b2Mat22;var c,b,e;c=this.m_body1.m_R;b=a.anchorPoint.x-
this.m_body1.m_position.x;e=a.anchorPoint.y-this.m_body1.m_position.y;this.m_localAnchor1.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor1.y=b*c.col2.x+e*c.col2.y;c=this.m_body2.m_R;b=a.anchorPoint.x-this.m_body2.m_position.x;e=a.anchorPoint.y-this.m_body2.m_position.y;this.m_localAnchor2.x=b*c.col1.x+e*c.col1.y;this.m_localAnchor2.y=b*c.col2.x+e*c.col2.y;this.m_intialAngle=this.m_body2.m_rotation-this.m_body1.m_rotation;this.m_ptpImpulse.Set(0,0);this.m_limitPositionImpulse=this.m_limitImpulse=this.m_motorImpulse=
0;this.m_lowerAngle=a.lowerAngle;this.m_upperAngle=a.upperAngle;this.m_maxMotorTorque=a.motorTorque;this.m_motorSpeed=a.motorSpeed;this.m_enableLimit=a.enableLimit;this.m_enableMotor=a.enableMotor},K:new b2Mat22,K1:new b2Mat22,K2:new b2Mat22,K3:new b2Mat22,PrepareVelocitySolver:function(){var a=this.m_body1,c=this.m_body2,b;b=a.m_R;var e=b.col1.x*this.m_localAnchor1.x+b.col2.x*this.m_localAnchor1.y,f=b.col1.y*this.m_localAnchor1.x+b.col2.y*this.m_localAnchor1.y;b=c.m_R;var g=b.col1.x*this.m_localAnchor2.x+
b.col2.x*this.m_localAnchor2.y;b=b.col1.y*this.m_localAnchor2.x+b.col2.y*this.m_localAnchor2.y;var h=a.m_invMass,i=c.m_invMass,k=a.m_invI,j=c.m_invI;this.K1.col1.x=h+i;this.K1.col2.x=0;this.K1.col1.y=0;this.K1.col2.y=h+i;this.K2.col1.x=k*f*f;this.K2.col2.x=-k*e*f;this.K2.col1.y=-k*e*f;this.K2.col2.y=k*e*e;this.K3.col1.x=j*b*b;this.K3.col2.x=-j*g*b;this.K3.col1.y=-j*g*b;this.K3.col2.y=j*g*g;this.K.SetM(this.K1);this.K.AddM(this.K2);this.K.AddM(this.K3);this.K.Invert(this.m_ptpMass);this.m_motorMass=
1/(k+j);if(this.m_enableMotor==!1)this.m_motorImpulse=0;if(this.m_enableLimit){var l=c.m_rotation-a.m_rotation-this.m_intialAngle;if(b2Math.b2Abs(this.m_upperAngle-this.m_lowerAngle)<2*b2Settings.b2_angularSlop)this.m_limitState=b2Joint.e_equalLimits;else if(l<=this.m_lowerAngle){if(this.m_limitState!=b2Joint.e_atLowerLimit)this.m_limitImpulse=0;this.m_limitState=b2Joint.e_atLowerLimit}else if(l>=this.m_upperAngle){if(this.m_limitState!=b2Joint.e_atUpperLimit)this.m_limitImpulse=0;this.m_limitState=
b2Joint.e_atUpperLimit}else this.m_limitState=b2Joint.e_inactiveLimit,this.m_limitImpulse=0}else this.m_limitImpulse=0;b2World.s_enableWarmStarting?(a.m_linearVelocity.x-=h*this.m_ptpImpulse.x,a.m_linearVelocity.y-=h*this.m_ptpImpulse.y,a.m_angularVelocity-=k*(e*this.m_ptpImpulse.y-f*this.m_ptpImpulse.x+this.m_motorImpulse+this.m_limitImpulse),c.m_linearVelocity.x+=i*this.m_ptpImpulse.x,c.m_linearVelocity.y+=i*this.m_ptpImpulse.y,c.m_angularVelocity+=j*(g*this.m_ptpImpulse.y-b*this.m_ptpImpulse.x+
this.m_motorImpulse+this.m_limitImpulse)):(this.m_ptpImpulse.SetZero(),this.m_limitImpulse=this.m_motorImpulse=0);this.m_limitPositionImpulse=0},SolveVelocityConstraints:function(a){var c=this.m_body1,b=this.m_body2,e;e=c.m_R;var f=e.col1.x*this.m_localAnchor1.x+e.col2.x*this.m_localAnchor1.y,g=e.col1.y*this.m_localAnchor1.x+e.col2.y*this.m_localAnchor1.y;e=b.m_R;var h=e.col1.x*this.m_localAnchor2.x+e.col2.x*this.m_localAnchor2.y;e=e.col1.y*this.m_localAnchor2.x+e.col2.y*this.m_localAnchor2.y;var i=
b.m_linearVelocity.x+-b.m_angularVelocity*e-c.m_linearVelocity.x- -c.m_angularVelocity*g,k=b.m_linearVelocity.y+b.m_angularVelocity*h-c.m_linearVelocity.y-c.m_angularVelocity*f,j=-(this.m_ptpMass.col1.x*i+this.m_ptpMass.col2.x*k),i=-(this.m_ptpMass.col1.y*i+this.m_ptpMass.col2.y*k);this.m_ptpImpulse.x+=j;this.m_ptpImpulse.y+=i;c.m_linearVelocity.x-=c.m_invMass*j;c.m_linearVelocity.y-=c.m_invMass*i;c.m_angularVelocity-=c.m_invI*(f*i-g*j);b.m_linearVelocity.x+=b.m_invMass*j;b.m_linearVelocity.y+=b.m_invMass*
i;b.m_angularVelocity+=b.m_invI*(h*i-e*j);if(this.m_enableMotor&&this.m_limitState!=b2Joint.e_equalLimits)f=-this.m_motorMass*(b.m_angularVelocity-c.m_angularVelocity-this.m_motorSpeed),g=this.m_motorImpulse,this.m_motorImpulse=b2Math.b2Clamp(this.m_motorImpulse+f,-a.dt*this.m_maxMotorTorque,a.dt*this.m_maxMotorTorque),f=this.m_motorImpulse-g,c.m_angularVelocity-=c.m_invI*f,b.m_angularVelocity+=b.m_invI*f;if(this.m_enableLimit&&this.m_limitState!=b2Joint.e_inactiveLimit){f=-this.m_motorMass*(b.m_angularVelocity-
c.m_angularVelocity);if(this.m_limitState==b2Joint.e_equalLimits)this.m_limitImpulse+=f;else if(this.m_limitState==b2Joint.e_atLowerLimit)a=this.m_limitImpulse,this.m_limitImpulse=b2Math.b2Max(this.m_limitImpulse+f,0),f=this.m_limitImpulse-a;else if(this.m_limitState==b2Joint.e_atUpperLimit)a=this.m_limitImpulse,this.m_limitImpulse=b2Math.b2Min(this.m_limitImpulse+f,0),f=this.m_limitImpulse-a;c.m_angularVelocity-=c.m_invI*f;b.m_angularVelocity+=b.m_invI*f}},SolvePositionConstraints:function(){var a,
c=this.m_body1,b=this.m_body2,e=0,e=c.m_R,f=e.col1.x*this.m_localAnchor1.x+e.col2.x*this.m_localAnchor1.y,g=e.col1.y*this.m_localAnchor1.x+e.col2.y*this.m_localAnchor1.y,e=b.m_R;a=e.col1.x*this.m_localAnchor2.x+e.col2.x*this.m_localAnchor2.y;var h=e.col1.y*this.m_localAnchor2.x+e.col2.y*this.m_localAnchor2.y,i=b.m_position.x+a-(c.m_position.x+f),k=b.m_position.y+h-(c.m_position.y+g),e=Math.sqrt(i*i+k*k),j=c.m_invMass,l=b.m_invMass,m=c.m_invI,n=b.m_invI;this.K1.col1.x=j+l;this.K1.col2.x=0;this.K1.col1.y=
0;this.K1.col2.y=j+l;this.K2.col1.x=m*g*g;this.K2.col2.x=-m*f*g;this.K2.col1.y=-m*f*g;this.K2.col2.y=m*f*f;this.K3.col1.x=n*h*h;this.K3.col2.x=-n*a*h;this.K3.col1.y=-n*a*h;this.K3.col2.y=n*a*a;this.K.SetM(this.K1);this.K.AddM(this.K2);this.K.AddM(this.K3);this.K.Solve(b2RevoluteJoint.tImpulse,-i,-k);i=b2RevoluteJoint.tImpulse.x;k=b2RevoluteJoint.tImpulse.y;c.m_position.x-=c.m_invMass*i;c.m_position.y-=c.m_invMass*k;c.m_rotation-=c.m_invI*(f*k-g*i);c.m_R.Set(c.m_rotation);b.m_position.x+=b.m_invMass*
i;b.m_position.y+=b.m_invMass*k;b.m_rotation+=b.m_invI*(a*k-h*i);b.m_R.Set(b.m_rotation);f=0;if(this.m_enableLimit&&this.m_limitState!=b2Joint.e_inactiveLimit){a=b.m_rotation-c.m_rotation-this.m_intialAngle;g=0;if(this.m_limitState==b2Joint.e_equalLimits)a=b2Math.b2Clamp(a,-b2Settings.b2_maxAngularCorrection,b2Settings.b2_maxAngularCorrection),g=-this.m_motorMass*a,f=b2Math.b2Abs(a);else if(this.m_limitState==b2Joint.e_atLowerLimit)a-=this.m_lowerAngle,f=b2Math.b2Max(0,-a),a=b2Math.b2Clamp(a+b2Settings.b2_angularSlop,
-b2Settings.b2_maxAngularCorrection,0),g=-this.m_motorMass*a,a=this.m_limitPositionImpulse,this.m_limitPositionImpulse=b2Math.b2Max(this.m_limitPositionImpulse+g,0),g=this.m_limitPositionImpulse-a;else if(this.m_limitState==b2Joint.e_atUpperLimit)a-=this.m_upperAngle,f=b2Math.b2Max(0,a),a=b2Math.b2Clamp(a-b2Settings.b2_angularSlop,0,b2Settings.b2_maxAngularCorrection),g=-this.m_motorMass*a,a=this.m_limitPositionImpulse,this.m_limitPositionImpulse=b2Math.b2Min(this.m_limitPositionImpulse+g,0),g=this.m_limitPositionImpulse-
a;c.m_rotation-=c.m_invI*g;c.m_R.Set(c.m_rotation);b.m_rotation+=b.m_invI*g;b.m_R.Set(b.m_rotation)}return e<=b2Settings.b2_linearSlop&&f<=b2Settings.b2_angularSlop},m_localAnchor1:new b2Vec2,m_localAnchor2:new b2Vec2,m_ptpImpulse:new b2Vec2,m_motorImpulse:null,m_limitImpulse:null,m_limitPositionImpulse:null,m_ptpMass:new b2Mat22,m_motorMass:null,m_intialAngle:null,m_lowerAngle:null,m_upperAngle:null,m_maxMotorTorque:null,m_motorSpeed:null,m_enableLimit:null,m_enableMotor:null,m_limitState:0});
b2RevoluteJoint.tImpulse=new b2Vec2;
