#pragma once
#include <algorithm>

#include "imgui/imgui.h"
#include "imgui/imgui_impl_win32.h"
#include "imgui/imgui_impl_dx11.h"

#include "cache/cache.h"

namespace rbx {
	struct joint {
		std::string from;
		std::string to;
	};

	inline std::vector<joint> r6_bones = {
		{ "Head", "Torso" },
		{ "Torso", "Left Arm" },
		{ "Torso", "Right Arm" },
		{ "Torso", "Left Leg" },
		{ "Torso", "Right Leg" }
	};

	inline std::vector<joint> r15_bones = {
		{ "Head", "UpperTorso" },
		{ "UpperTorso", "LowerTorso" },
		{ "UpperTorso", "LeftUpperArm" },
		{ "UpperTorso", "RightUpperArm" },
		{ "LeftUpperArm", "LeftLowerArm" },
		{ "RightUpperArm", "RightLowerArm" },
		{ "LeftLowerArm", "LeftHand" },
		{ "RightLowerArm", "RightHand" },
		{ "LowerTorso", "LeftUpperLeg" },
		{ "LowerTorso", "RightUpperLeg" },
		{ "LeftUpperLeg", "LeftLowerLeg" },
		{ "RightUpperLeg", "RightLowerLeg" },
		{ "LeftLowerLeg", "LeftFoot" },
		{ "RightLowerLeg", "RightFoot" }
	};

	inline cache::bone find_bone(cache::cache_player p, std::string name) {
		for (auto bone : p.bones)
			if (bone.bone_name == name)
				return bone;

		return cache::bone();
	}

	class visuals {
	private:
		static void esp(); // box, corner, skeleton
		static void misc(); // name, distance, health, head dot
	public:
		static void render();
	};
}