#include "entity.h"

#include "misc/globals.h"

rbx::entity rbx::entity::get_model_instance() {
	auto model_instance = read<uint64_t>(this->self + offsets::ModelInstance);
	return entity(model_instance);
}

rbx::part rbx::entity::get_humanoid() {
	auto h = this->find_first_child("Humanoid");
	return part(h.self);
}

rbx::part rbx::entity::get_humanoid_root_part() {
	auto hrp = this->find_first_child("HumanoidRootPart");
	return part(hrp.self);
}

rbx::part rbx::entity::get_head() {
	auto head = this->find_first_child("Head");
	return part(head.self);
}

std::string rbx::entity::get_display_name() {
	auto display_name_ptr = read<uint64_t>(this->self + offsets::DisplayName);
	auto display_name = read_string(display_name_ptr);
	if (display_name.empty()) return "???_display";
	return display_name;
}

float rbx::entity::get_health() {
	auto ch = this->get_model_instance();
	auto h = ch.get_humanoid();
	auto health = read<float>(h.self + offsets::Health);
	return health;
}

rbx::instance rbx::entity::get_team() {
	auto team = read<uint64_t>(this->self + offsets::Team);
	return instance(team);
}

bool rbx::entity::is_teammate(entity& target) {
	auto a = this->get_team();
	auto b = target.get_team();
	return a.self && b.self && a.self == b.self;
}

rbx::rig_type rbx::entity::get_rig_type() {
	auto ch = this->get_model_instance();
	auto h = ch.get_humanoid();
	auto r = read<uint64_t>(h.self + offsets::RigType);
	if (r == 0)
		return rig_type::r6;
	else
		return rig_type::r15;
}