#include "instance.h"

std::string rbx::instance::get_name() {
	auto name_ptr = read<uint64_t>(this->self + offsets::Name);
	auto name = read_string(name_ptr);
	if (name.empty()) return "???";
	return name;
}

std::string rbx::instance::get_class_name() {
	auto class_desc = read<uint64_t>(this->self + offsets::ClassDescriptor);
	if (!class_desc) return "???_class1";
	auto class_name_ptr = read<uint64_t>(class_desc + offsets::ClassDescriptorToClassName);
	auto class_name = read_string(class_name_ptr);
	if (class_name.empty()) return "???_class2";
	return class_name;
}

std::vector<rbx::instance> rbx::instance::get_children() {
	std::vector<instance> children;
	auto start = read<uint64_t>(this->self + offsets::Children);
	auto end = read<uint64_t>(start + offsets::ChildrenEnd);
	for (auto child = read<uint64_t>(start); child != end; child += 0x10) {
		if (!child) continue;
		children.push_back(instance(read<uint64_t>(child)));
	}
	return children;
}

rbx::instance rbx::instance::find_first_child(std::string name) {
	for (auto child : this->get_children()) {
		if (child.get_name() == name)
			return child;
	}
	return instance();
}

rbx::instance rbx::instance::find_first_child_of_class(std::string name) {
	for (auto child : this->get_children()) {
		if (child.get_class_name() == name)
			return child;
	}
	return instance();
}