#pragma once
#include "misc/globals.h"

#include "classes/entity/entity.h"

namespace rbx {
	namespace cache {
		struct bone {
			std::string bone_name;
			part bone_part;
		};

		struct cache_player {
			entity player_object;
			part humanoid;
			part head;
			part humanoidrootpart;
			instance team;
			float health;
			float distance;
			std::string name;
			std::string display_name;
			rig_type rig;
			std::vector<bone> bones;
		};

		namespace threads {
			void globals_cache();
			void visuals_cache();
			void combat_cache();
		}

		inline std::mutex mutex_v;
		inline std::mutex mutex_c;
		inline std::vector<cache_player> targets_v; // visuals
		inline std::vector<cache_player> targets_c; // combat
	}
}