#pragma once
#include "classes/instance/instance.h"
#include "classes/part/part.h"

namespace rbx {
	enum rig_type {
		r6,
		r15
	};

	struct entity : instance {
		entity get_model_instance();
		part get_humanoid();
		part get_humanoid_root_part();
		part get_head();

		std::string get_display_name();
		float get_health();
		instance get_team();
		bool is_teammate(entity& target);
		rig_type get_rig_type();
	};
}