#include "camera.h"

rbx::vector3_t rbx::camera::get_camera_position() {
    auto pos = read<vector3_t>(this->self + offsets::CameraPos);
    return pos;
}

bool rbx::camera::set_camera_position(vector3_t pos) {
    auto res = write<vector3_t>(this->self + offsets::CameraPos, pos);
    return res;
}

rbx::matrix3_t rbx::camera::get_camera_rotation() {
    auto rot = read<matrix3_t>(this->self + offsets::CameraRotation);
    return rot;
}

bool rbx::camera::set_camera_rotation(matrix3_t rot) {
    auto res = write<matrix3_t>(this->self + offsets::CameraRotation, rot);
    return res;
}

rbx::instance rbx::camera::get_camera_subject() {
    auto sub = read<uintptr_t>(this->self + offsets::CameraSubject);
    return instance(sub);
}

bool rbx::camera::set_camera_subject(instance subject) {
    auto res = write<uintptr_t>(this->self + offsets::CameraSubject, subject.self);
    return res;
}

int rbx::camera::get_camera_type() {
    auto type = read<int>(this->self + offsets::CameraType);
    return type;
}

bool rbx::camera::set_camera_type(int type) {
    auto res = write<int>(this->self + offsets::CameraType, type);
    return res;
}

int rbx::camera::get_camera_mode() {
    auto mode = read<int>(this->self + offsets::CameraMode);
    return mode;
}

bool rbx::camera::set_camera_mode(int mode) {
    auto res = write<int>(this->self + offsets::CameraMode, mode);
    return res;
}