#pragma once
#include <windows.h>
#include <string>
#include <vector>
#include <cstdint>

#include "driver/driver.h"
#include "misc/update.h"
#include "misc/structs.h"

namespace rbx {
	struct instance {
		uint64_t self;

		instance() : self(0) {}
		instance(uint64_t x) : self(x) {}

		std::string get_name();
		std::string get_class_name();

		std::vector<instance> get_children();
		instance find_first_child(std::string name);
		instance find_first_child_of_class(std::string name);
	};
}