#include "part.h"

rbx::instance rbx::part::get_part_primitive() {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	return instance(prim);
}

rbx::vector3_t rbx::part::get_part_position() {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto pos = read<vector3_t>(prim + offsets::Position);
	return pos;
}

rbx::matrix3_t rbx::part::get_part_rotation() {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto rot = read<matrix3_t>(prim + offsets::Rotation);
	return rot;
}

rbx::vector3_t rbx::part::get_part_velocity() {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto velocity = read<vector3_t>(prim + offsets::Velocity);
	return velocity;
}

float rbx::part::get_distance(part target_part) {
	auto a = this->get_part_position();
	auto b = target_part.get_part_position();
	auto x = (a.x - b.x) * (a.x - b.x);
	auto y = (a.y - b.y) * (a.y - b.y);
	auto z = (a.z - b.z) * (a.z - b.z);
	auto d = sqrt(x + y + z);
	return d;
}

bool rbx::part::set_part_position(vector3_t pos) {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto res = write<vector3_t>(prim + offsets::Position, pos);
	return res;
}

bool rbx::part::set_part_rotation(matrix3_t rot) {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto res = write<matrix3_t>(prim + offsets::Rotation, rot);
	return res;
}

bool rbx::part::set_part_velocity(vector3_t velocity) {
	auto prim = read<uint64_t>(this->self + offsets::Primitive);
	auto res = write<vector3_t>(prim + offsets::Velocity, velocity);
	return res;
}