/*
 * Decompiled with CFR 0.152.
 */
package io.github.garawaa.fxml2java.plugin;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.krm.fxml2java.FXMLToJavaConvertor;
import com.krm.fxml2java.MainClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Icon;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;

public class MenuHandleAction
extends AnAction {
    FXMLToJavaConvertor convertor;

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MenuHandleAction.$$$reportNull$$$0(0);
        }
        VirtualFile vFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        String path = vFile.getPath();
        String fileName = vFile != null ? vFile.getName() : null;
        String[] fn = fileName.split("\\.");
        String ext = "";
        if (fn.length <= 1) {
            return;
        }
        ext = fn[1];
        String sourcePath = ProjectFileIndex.SERVICE.getInstance((Project)e.getProject()).getSourceRootForFile(vFile.getParent()).getPath();
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)vFile.getParent(), (VirtualFile)ProjectFileIndex.SERVICE.getInstance((Project)e.getProject()).getSourceRootForFile(vFile.getParent()));
        String packageName = ProjectFileIndex.SERVICE.getInstance((Project)e.getProject()).getPackageNameByDirectory(vFile.getParent());
        String className = fn[0] + "Base";
        className = className.substring(0, 1).toUpperCase() + className.substring(1);
        try {
            this.convertor = new FXMLToJavaConvertor();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        String newClassName = Messages.showInputDialog((String)"Class name: ", (String)"Generate code", null, (String)className, null);
        if (newClassName == null || newClassName.equals("")) {
            return;
        }
        className = newClassName;
        try {
            MainClass mainClass = new MainClass(className, packageName);
            mainClass.setClassModifiers(new int[]{1, 1024});
            mainClass.setNodeModifiers(new int[]{4, 16});
            mainClass.setMethodModifiers(new int[]{4, 1024});
            this.convertor.convert(mainClass, path);
            String outputFileName = sourcePath + "/" + relativePath + "/" + className + ".java";
            String content = mainClass.toString();
            File file = new File(outputFileName);
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
            fw.close();
            ProjectView.getInstance((Project)e.getProject()).refresh();
            VirtualFileManager.getInstance().syncRefresh();
            Messages.showMessageDialog((String)("File created at path:\n" + outputFileName), (String)"Successful", (Icon)Messages.getInformationIcon());
        }
        catch (IOException ioException) {
            Messages.showErrorDialog((String)ioException.getMessage(), (String)"Failed");
        }
    }

    public void update(@NotNull AnActionEvent e) {
        String fileName;
        if (e == null) {
            MenuHandleAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null);
        VirtualFile vFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        String string = fileName = vFile != null ? vFile.getName() : null;
        if (fileName == null) {
            return;
        }
        String[] fn = fileName.split("\\.");
        String ext = "";
        if (fn.length > 1) {
            ext = fn[1];
        }
        if (ext.equals("") || !ext.equals("fxml")) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "io/github/garawaa/fxml2java/plugin/MenuHandleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

