/*
 * Decompiled with CFR 0.152.
 */
package com.krm.fxml2java;

import com.krm.fxml2java.DeclarationNode;
import com.krm.fxml2java.MainClass;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FXMLToJavaConvertor {
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder documentBuilder;
    private Document document;
    private Exception exception;

    public FXMLToJavaConvertor() throws ParserConfigurationException {
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
    }

    private boolean convert(MainClass mainClass, Document document) {
        NodeList childNodes = document.getChildNodes();
        block4: for (int index = 0; index < childNodes.getLength(); ++index) {
            Node item = childNodes.item(index);
            switch (item.getNodeType()) {
                case 7: {
                    MainClass.getImport().add(new DeclarationNode("{0} {1}{2}", "import", item.getNodeValue(), ";"));
                    continue block4;
                }
                case 1: {
                    mainClass.setRootNode(item);
                }
            }
        }
        return true;
    }

    public boolean convert(MainClass mainClass, InputStream inputStream) {
        try {
            this.document = this.documentBuilder.parse(inputStream);
            return this.convert(mainClass, this.document);
        }
        catch (IOException | SAXException ex) {
            this.exception = ex;
            return false;
        }
    }

    public boolean convert(MainClass mainClass, File file) {
        try {
            this.document = this.documentBuilder.parse(file);
            return this.convert(mainClass, this.document);
        }
        catch (IOException | SAXException ex) {
            this.exception = ex;
            return false;
        }
    }

    public boolean convert(MainClass mainClass, String uri) {
        try {
            this.document = this.documentBuilder.parse(uri);
            return this.convert(mainClass, this.document);
        }
        catch (IOException | SAXException ex) {
            this.exception = ex;
            return false;
        }
    }

    public Exception getException() {
        return this.exception;
    }
}

