/*
 * Decompiled with CFR 0.152.
 */
package com.krm.fxml2java;

import com.krm.fxml2java.DeclarationNode;
import com.krm.fxml2java.MainClass;
import com.krm.fxml2java.StringList;
import com.krm.fxml2java.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.w3c.dom.Node;

public class FXNode {
    private final StringList attributeList;
    private final StringList childList;
    private final String nodeName;
    private String variableName;
    private final Class<?> nodeClass;
    private final Node node;
    private final boolean declared;
    private Constructor shortestConstructor;
    private int shortesetParameterCount;
    private boolean isFinal;

    public FXNode(Node node, boolean isRoot) {
        this.node = node;
        this.attributeList = new StringList();
        this.childList = new StringList();
        String elementName = node.getNodeName();
        this.nodeName = elementName = elementName.equals("fx:root") ? node.getAttributes().getNamedItem("type").getNodeValue() : elementName;
        this.nodeClass = Utils.getFullClass(this.nodeName);
        StringList declarationList = MainClass.getDeclarationList();
        this.isFinal = Modifier.isFinal(this.nodeClass.getModifiers());
        this.shortestConstructor = this.getShortestConstructor(this.nodeClass.getConstructors());
        int n = this.shortesetParameterCount = this.shortestConstructor == null ? 0 : this.shortestConstructor.getParameterCount();
        isRoot = this.isFinal ? !this.isFinal : isRoot;
        this.variableName = isRoot && this.shortesetParameterCount == 0 ? "" : Utils.getVariableNameFor(declarationList, node);
        String dot = isRoot && this.shortesetParameterCount == 0 ? "" : ".";
        DeclarationNode declarationNode = new DeclarationNode("{0} {1} {2}{3}", Modifier.toString(MainClass.getNodeModifier()), this.nodeName, this.variableName, ";");
        if (this.shortesetParameterCount == 0) {
            if (isRoot) {
                Utils.setAttributes(this, this.variableName, dot);
                Utils.parseChildrens(this, this.variableName, dot);
            } else {
                declarationList.add(declarationNode);
                MainClass.getInitList().add(this.variableName + " = new " + this.nodeName + "();");
                this.attributeList.add("");
                Utils.setAttributes(this, this.variableName, dot);
                Utils.parseChildrens(this, this.variableName, dot);
            }
            this.declared = true;
        } else {
            switch (this.nodeName) {
                case "SubScene": {
                    Object arg0 = null;
                    Object arg1 = 0;
                    Object arg2 = 0;
                    Utils.parseChildrens(this, this.variableName, dot);
                    Utils.setAttributes(this, this.variableName, dot);
                    declarationList.add(declarationNode);
                    if (!this.childList.isEmpty()) {
                        DeclarationNode childNode = (DeclarationNode)this.childList.get(0);
                        arg0 = childNode.getNodeString(2);
                    }
                    String widthString = this.variableName + ".setWidth";
                    String heightString = this.variableName + ".setHeight";
                    for (Object attribute : this.attributeList) {
                        String attributeString = attribute.toString();
                        if (attributeString.startsWith(widthString)) {
                            arg1 = Utils.getValueFromAttribute(attributeString, 100, "(", ")");
                            continue;
                        }
                        if (!attributeString.startsWith(heightString)) continue;
                        arg2 = Utils.getValueFromAttribute(attributeString, 100, "(", ")");
                    }
                    this.attributeList.removeIf(object -> object.toString().startsWith(widthString) || object.toString().startsWith(heightString));
                    String arguments = arg0 + ", " + arg1 + ", " + arg2;
                    MainClass.getInitList().add(this.variableName + " = new " + this.nodeName + "(" + arguments + ");");
                    this.childList.clear();
                    this.declared = true;
                    break;
                }
                case "AreaChart": 
                case "BarChart": 
                case "BubbleChart": 
                case "LineChart": 
                case "ScatterChart": 
                case "StackedAreaChart": 
                case "StackedBarChart": {
                    Object arg1 = null;
                    Utils.parseChildrens(this, this.variableName, dot);
                    Utils.setAttributes(this, this.variableName, dot);
                    declarationList.add(declarationNode);
                    if (!this.childList.isEmpty()) {
                        DeclarationNode childNode = (DeclarationNode)this.childList.get(0);
                        Object arg0 = childNode.getNodeString(2);
                        if (this.childList.size() > 1) {
                            childNode = (DeclarationNode)this.childList.get(1);
                            arg1 = childNode.getNodeString(2);
                        }
                        String arguments = arg0 + ", " + arg1;
                        MainClass.getInitList().add(this.variableName + " = new " + this.nodeName + "(" + arguments + ");");
                    }
                    this.childList.clear();
                    this.declared = true;
                    break;
                }
                default: {
                    this.declared = false;
                }
            }
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public int getShortestParameterCount() {
        return this.shortesetParameterCount;
    }

    public Constructor getShortestConstructor() {
        return this.shortestConstructor;
    }

    private Constructor getShortestConstructor(Constructor<?>[] constructors) {
        Constructor<?> shortest = constructors.length > 0 ? constructors[0] : null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() >= shortest.getParameterCount()) continue;
            shortest = constructor;
        }
        return shortest;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public Node getNode() {
        return this.node;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Class<?> getNodeClass() {
        return this.nodeClass;
    }

    public StringList getChildList() {
        return this.childList;
    }

    public String toString() {
        return this.variableName;
    }

    public StringList getAttributeList() {
        return this.attributeList;
    }
}

