/*
 * Decompiled with CFR 0.152.
 */
package com.krm.fxml2java;

import com.krm.fxml2java.DeclarationNode;
import com.krm.fxml2java.FXNode;
import com.krm.fxml2java.MainClass;
import com.krm.fxml2java.StringList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class Utils {
    public static Double[] getInsets(org.w3c.dom.Node insets) {
        org.w3c.dom.Node valueNode = insets.getAttributes().getNamedItem("top");
        double top = Double.valueOf(valueNode == null ? "0.0" : valueNode.getNodeValue());
        valueNode = insets.getAttributes().getNamedItem("right");
        double right = Double.valueOf(valueNode == null ? "0.0" : valueNode.getNodeValue());
        valueNode = insets.getAttributes().getNamedItem("bottom");
        double bottom = Double.valueOf(valueNode == null ? "0.0" : valueNode.getNodeValue());
        valueNode = insets.getAttributes().getNamedItem("left");
        double left = Double.valueOf(valueNode == null ? "0.0" : valueNode.getNodeValue());
        if (top == right && top == bottom && top == left) {
            return new Double[]{top};
        }
        return new Double[]{top, right, bottom, left};
    }

    public static String getVariableNameFor(StringList declarationList, org.w3c.dom.Node node) {
        String newVariableName = node.getNodeName();
        newVariableName = Character.toLowerCase(newVariableName.charAt(0)) + newVariableName.substring(1);
        org.w3c.dom.Node namedItem = node.getAttributes().getNamedItem("fx:id");
        if (namedItem != null) {
            newVariableName = namedItem.getNodeValue();
        }
        return Utils.getVariableNameFor(declarationList, newVariableName);
    }

    public static String getVariableNameFor(StringList declarationList, String className) {
        String newVariableName = className;
        for (Object object : declarationList) {
            DeclarationNode previousDeclaration = (DeclarationNode)object;
            String previousName = previousDeclaration.getNodeString(2).toString();
            if (!previousName.equals(newVariableName)) continue;
            char last = previousName.charAt(previousName.length() - 1);
            if (Character.isDigit(last)) {
                int counter = Integer.valueOf(Character.toString(last));
                newVariableName = newVariableName.substring(0, newVariableName.length() - 1) + ++counter;
                continue;
            }
            newVariableName = newVariableName + 0;
        }
        int dotIndex = newVariableName.lastIndexOf(46);
        dotIndex = dotIndex < 0 ? 0 : dotIndex + 1;
        return newVariableName.substring(dotIndex);
    }

    public static String arrayToValue(Object[] objects) {
        String arrayString = Arrays.toString(objects);
        return Utils.getValueFromAttribute(arrayString, "", "[", "]").toString();
    }

    public static Object getValueFromAttribute(String attributeString, Object defaultValue, String bracketOpen, String bracketClose) {
        Matcher matcher = Pattern.compile("\\" + bracketOpen + "(.*?)\\" + bracketClose).matcher(attributeString);
        return matcher.find() ? matcher.group(1) : defaultValue;
    }

    public static void parseChildrens(FXNode fXNode, String variableName, String dot) {
        StringList attributeList = fXNode.getAttributeList();
        StringList childList = fXNode.getChildList();
        NodeList childNodes = fXNode.getNode().getChildNodes();
        block66: for (int i = 0; i < childNodes.getLength(); ++i) {
            String insetString;
            Object[] inset;
            org.w3c.dom.Node insets;
            org.w3c.dom.Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            String newNodeName = childNode.getNodeName();
            String[] splits = newNodeName.split("\\.");
            if (splits.length > 1) {
                String methodName;
                switch (methodName = splits[1]) {
                    case "margin": {
                        methodName = "set" + Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
                        insets = childNode.getChildNodes().item(1);
                        inset = Utils.getInsets(insets);
                        insetString = Arrays.toString(inset);
                        insetString = "new Insets(" + insetString.substring(1, insetString.length() - 1) + ")";
                        attributeList.add(splits[0] + "." + methodName + "(" + variableName + ", " + insetString + ");");
                    }
                }
                continue;
            }
            switch (newNodeName) {
                case "stylesheets": {
                    NodeList styleSheets = childNode.getChildNodes();
                    for (int a = 0; a < styleSheets.getLength(); ++a) {
                        org.w3c.dom.Node styleSheet = styleSheets.item(a);
                        if (styleSheet.getNodeType() != 1) continue;
                        org.w3c.dom.Node value = styleSheet.getAttributes().getNamedItem("value");
                        String nodeValue = value.getNodeValue().replace("@", "");
                        nodeValue = "/" + MainClass.getPackageName().replace(".", "/") + "/" + nodeValue;
                        attributeList.add(variableName + dot + "getStylesheets().add(\"" + nodeValue + "\");");
                    }
                    continue block66;
                }
                case "padding": 
                case "opaqueInsets": {
                    newNodeName = "set" + Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    insets = childNode.getChildNodes().item(1);
                    inset = Utils.getInsets(insets);
                    insetString = "new Insets(" + Utils.arrayToValue(inset) + ")";
                    attributeList.add(variableName + dot + newNodeName + "(" + insetString + ");");
                    continue block66;
                }
                case "cursor": 
                case "columnResizePolicy": {
                    newNodeName = "set" + Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    org.w3c.dom.Node selectedNode = childNode.getChildNodes().item(1);
                    org.w3c.dom.Node cursorName = selectedNode.getAttributes().getNamedItem("fx:constant");
                    String nodeSelectedName = selectedNode.getNodeName();
                    attributeList.add(variableName + dot + newNodeName + "(" + nodeSelectedName + "." + cursorName.getNodeValue() + ");");
                    continue block66;
                }
                case "image": {
                    org.w3c.dom.Node imageNode = childNode.getChildNodes().item(1);
                    org.w3c.dom.Node image = imageNode.getAttributes().getNamedItem("url");
                    String imageURL = image.getNodeValue().replace("@", "");
                    String urlLocation = "getClass().getResource(\"" + imageURL + "\").toExternalForm()";
                    attributeList.add(variableName + dot + "setImage(new Image(" + urlLocation + "));");
                    continue block66;
                }
                case "font": {
                    childNode = childNode.getChildNodes().item(1);
                    org.w3c.dom.Node fontNode = childNode.getAttributes().getNamedItem("name");
                    String fontValue = fontNode == null ? "" : "\"" + fontNode.getNodeValue() + "\", ";
                    fontNode = childNode.getAttributes().getNamedItem("size");
                    fontValue = fontValue + (fontNode == null ? "14" : fontNode.getNodeValue());
                    newNodeName = "set" + Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    String fontString = "new Font(" + fontValue + ")";
                    attributeList.add(variableName + dot + newNodeName + "(" + fontString + ");");
                    continue block66;
                }
                case "points": {
                    String listName = Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    String listMethodName = "get" + listName + "()";
                    NodeList childrens = childNode.getChildNodes();
                    ArrayList<String> points = new ArrayList<String>();
                    for (int a = 0; a < childrens.getLength(); ++a) {
                        org.w3c.dom.Node children = childrens.item(a);
                        if (children.getNodeType() != 1) continue;
                        String point = children.getAttributes().getNamedItem("fx:value").getNodeValue();
                        points.add(point);
                    }
                    String value = Utils.arrayToValue(points.toArray());
                    String prefix = variableName + dot + listMethodName;
                    DeclarationNode declarationNode = new DeclarationNode("{0}{1}({2});", prefix, ".addAll", value);
                    childList.add(declarationNode);
                    continue block66;
                }
                case "accelerator": {
                    String methodName = Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    methodName = "set" + methodName;
                    org.w3c.dom.Node contentNode = childNode.getChildNodes().item(1);
                    NamedNodeMap namedNodeMap = contentNode.getAttributes();
                    String codeValue = "";
                    org.w3c.dom.Node codeNode = namedNodeMap.getNamedItem("code");
                    String nodeValue = codeNode.getNodeValue();
                    codeValue = codeValue + "KeyCode." + nodeValue;
                    for (int index = 0; index < namedNodeMap.getLength(); ++index) {
                        org.w3c.dom.Node item = namedNodeMap.item(index);
                        String nodeName = item.getNodeName();
                        nodeValue = item.getNodeValue();
                        if (nodeName.equals("code")) continue;
                        codeValue = codeValue + (nodeValue.equals("UP") ? "" : ", KeyCombination." + nodeName.toUpperCase() + "_" + nodeValue);
                    }
                    String attributeValue = "new KeyCodeCombination(" + codeValue + ")";
                    String prefix = variableName + dot + methodName;
                    DeclarationNode declarationNode = new DeclarationNode("{0}({1});", prefix, attributeValue);
                    attributeList.add(declarationNode);
                    String keyCodeImport = "javafx.scene.input.KeyCode";
                    String keyCombinationImport = "javafx.scene.input.KeyCombination";
                    if (!MainClass.containsImport(keyCodeImport)) {
                        MainClass.getImport().add(new DeclarationNode("{0} {1}{2}", "import", keyCodeImport, ";"));
                    }
                    if (MainClass.containsImport(keyCombinationImport)) continue block66;
                    MainClass.getImport().add(new DeclarationNode("{0} {1}{2}", "import", keyCombinationImport, ";"));
                    continue block66;
                }
                case "effect": 
                case "contextMenu": 
                case "graphic": 
                case "topInput": 
                case "tooltip": 
                case "bottomInput": 
                case "input": 
                case "content": 
                case "top": 
                case "right": 
                case "center": 
                case "bottom": 
                case "left": 
                case "side": 
                case "header": 
                case "toggleGroup": 
                case "expandableContent": {
                    String methodName = Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    methodName = "set" + methodName;
                    org.w3c.dom.Node contentNode = childNode.getChildNodes().item(1);
                    fXNode = new FXNode(contentNode, false);
                    if (!fXNode.isDeclared()) continue block66;
                    attributeList.addAll(fXNode.getAttributeList());
                    childList.addAll(fXNode.getChildList());
                    String prefix = variableName + dot + methodName;
                    DeclarationNode declarationNode = new DeclarationNode("{0}({1});", prefix, fXNode);
                    attributeList.add(declarationNode);
                    continue block66;
                }
                case "buttonTypes": {
                    org.w3c.dom.Node children;
                    int a;
                    String listName = Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    String listMethodName = "get" + listName + "()";
                    NodeList childrens = childNode.getChildNodes();
                    ArrayList<String> buttonTypes = new ArrayList<String>();
                    for (a = 0; a < childrens.getLength(); ++a) {
                        children = childrens.item(a);
                        if (children.getNodeType() != 1) continue;
                        org.w3c.dom.Node fxValue = children.getAttributes().getNamedItem("fx:constant");
                        buttonTypes.add(children.getNodeName() + "." + fxValue.getNodeValue());
                    }
                    String prefix = variableName + dot + listMethodName;
                    DeclarationNode declarationNode = new DeclarationNode("{0}{1}({2});", prefix, ".addAll", Utils.arrayToValue(buttonTypes.toArray()));
                    attributeList.add(declarationNode);
                    continue block66;
                }
                case "children": 
                case "buttons": 
                case "elements": 
                case "tabs": 
                case "menus": 
                case "items": 
                case "columns": 
                case "panes": 
                case "xAxis": 
                case "yAxis": 
                case "root": 
                case "columnConstraints": 
                case "rowConstraints": {
                    org.w3c.dom.Node children;
                    int a;
                    DeclarationNode declarationNode;
                    String prefix;
                    String listName = Character.toUpperCase(newNodeName.charAt(0)) + newNodeName.substring(1);
                    String listMethodName = "get" + listName + "()";
                    NodeList childrens = childNode.getChildNodes();
                    block71: for (a = 0; a < childrens.getLength(); ++a) {
                        String nodeName;
                        children = childrens.item(a);
                        if (children.getNodeType() != 1) continue;
                        switch (nodeName = children.getNodeName()) {
                            case "fx:include": {
                                org.w3c.dom.Node source = children.getAttributes().getNamedItem("source");
                                String includeName = source.getNodeValue();
                                includeName = includeName.substring(0, includeName.lastIndexOf(46));
                                if (includeName == null || includeName.isEmpty()) continue block71;
                                String includeNode = Utils.createInclude(includeName);
                                prefix = variableName + dot + listMethodName;
                                declarationNode = new DeclarationNode("{0}{1}({2});", prefix, ".add", includeNode);
                                childList.add(declarationNode);
                                continue block71;
                            }
                            default: {
                                fXNode = new FXNode(children, false);
                                if (!fXNode.isDeclared()) continue block71;
                                attributeList.addAll(fXNode.getAttributeList());
                                childList.addAll(fXNode.getChildList());
                                prefix = variableName + dot + listMethodName;
                                declarationNode = new DeclarationNode("{0}{1}({2});", prefix, ".add", fXNode);
                                childList.add(declarationNode);
                            }
                        }
                    }
                    continue block66;
                }
            }
        }
    }

    public static String createInclude(String nodeName) {
        StringList declarationList = MainClass.getDeclarationList();
        String variableName = Character.toLowerCase(nodeName.charAt(0)) + nodeName.substring(1);
        variableName = Utils.getVariableNameFor(declarationList, variableName);
        DeclarationNode declarationNode = new DeclarationNode("{0} {1} {2}{3}", Modifier.toString(MainClass.getNodeModifier()), nodeName, variableName, ";");
        declarationList.add(declarationNode);
        MainClass.getInitList().add(variableName + " = new " + nodeName + "();");
        return variableName;
    }

    public static Class<?> getFullClass(String className) {
        for (Object object : MainClass.getImport()) {
            Class<?> classFromName;
            DeclarationNode declarationNode = (DeclarationNode)object;
            String pName = declarationNode.getNodeString(1).toString();
            if (pName.endsWith(".*")) {
                pName = pName.substring(0, pName.length() - 1);
            } else {
                int len = pName.length() - className.length();
                String string = pName = len > 0 ? pName.substring(0, len) : pName;
            }
            if ((classFromName = Utils.getClassFromName(pName + className)) == null) continue;
            return classFromName;
        }
        return Node.class;
    }

    private static Class<?> getClassFromName(String fullName) {
        try {
            Class<?> loadClass = Class.forName(fullName, false, ClassLoader.getSystemClassLoader());
            return loadClass;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setAttributes(FXNode fXNode, String variableName, String dot) {
        Class<?> nodeClass = fXNode.getNodeClass();
        StringList attributeList = fXNode.getAttributeList();
        fXNode.getAttributeList();
        if (nodeClass != null) {
            NamedNodeMap attributes = fXNode.getNode().getAttributes();
            Method[] methods = nodeClass.getMethods();
            block8: for (int index = 0; index < attributes.getLength(); ++index) {
                org.w3c.dom.Node attributeNode = attributes.item(index);
                String methodNodeName = attributeNode.getNodeName();
                String[] splits = methodNodeName.split("\\.");
                if (splits.length > 1) {
                    Class<?> fullClass = Utils.getFullClass(splits[0]);
                    Method[] staticClassMethods = fullClass.getMethods();
                    methodNodeName = splits[1];
                    methodNodeName = "set" + Character.toUpperCase(methodNodeName.charAt(0)) + methodNodeName.substring(1);
                    for (Method staticClassMethod : staticClassMethods) {
                        Class<?>[] parameterTypes;
                        Class<?>[] classArray;
                        int n;
                        int n2;
                        if (!staticClassMethod.getName().equals(methodNodeName) || (n2 = 0) >= (n = (classArray = (parameterTypes = staticClassMethod.getParameterTypes())).length)) continue;
                        Class<?> parameterType = classArray[n2];
                        if (parameterType.isEnum()) {
                            attributeList.add(splits[0] + "." + methodNodeName + "(" + variableName + ", " + parameterType.getName() + "." + attributeNode.getNodeValue() + ");");
                            continue block8;
                        }
                        String simpleName = attributeNode.getNodeValue();
                        String attribute = splits[0] + "." + methodNodeName;
                        if (Character.isUpperCase(simpleName.codePointAt(0))) {
                            Type[] types = staticClassMethod.getGenericParameterTypes();
                            String eventName = types[1].getTypeName().replace("$", ".");
                            attribute = attribute + "(" + variableName + ", " + eventName + "." + attributeNode.getNodeValue() + ");";
                        } else {
                            attribute = attribute + "(" + variableName + ", " + attributeNode.getNodeValue() + ");";
                        }
                        attributeList.add(attribute);
                        continue block8;
                    }
                    continue;
                }
                switch (methodNodeName) {
                    case "styleClass": {
                        attributeList.add(variableName + dot + "getStyleClass().add(\"" + attributeNode.getNodeValue() + "\");");
                        continue block8;
                    }
                    case "stylesheets": {
                        String nodeValue = attributeNode.getNodeValue().replace("@", "");
                        nodeValue = "/" + MainClass.getPackageName().replace(".", "/") + "/" + nodeValue;
                        String location = "\"" + nodeValue + "\"";
                        attributeList.add(variableName + dot + "getStylesheets().add(" + location + ");");
                        continue block8;
                    }
                    default: {
                        methodNodeName = "set" + Character.toUpperCase(methodNodeName.charAt(0)) + methodNodeName.substring(1);
                        for (Method method : methods) {
                            if (!method.getName().equals(methodNodeName)) continue;
                            Utils.addAttribute(variableName + dot, method, attributeNode, methodNodeName, attributeList);
                            continue block8;
                        }
                        continue block8;
                    }
                }
            }
        } else {
            throw new NullPointerException("Class not found");
        }
    }

    public static void addAttribute(String prefix, Method method, org.w3c.dom.Node node, String nodeName, StringList attributeList) {
        Class<?>[] parameterTypes;
        block10: for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
            String simpleName = parameterType.getSimpleName();
            String value = node.getNodeValue();
            String eventName = "";
            switch (simpleName) {
                case "String": {
                    value = value.replace("\"", "'");
                    nodeName = nodeName + "(\"" + value + "\");";
                    attributeList.add(prefix + nodeName);
                    continue block10;
                }
                case "ToggleGroup": {
                    value = value.substring(1);
                    nodeName = nodeName + "(" + value + ");";
                    attributeList.add(prefix + nodeName);
                    continue block10;
                }
                case "EventHandler": {
                    Type[] types = method.getGenericParameterTypes();
                    eventName = types[0].getTypeName();
                    int start = eventName.indexOf("<") + 1;
                    int end = eventName.indexOf(">");
                    eventName = eventName.substring(start, end);
                    String[] splits = eventName.split(" ");
                    eventName = splits[splits.length - 1];
                    if (method.getDeclaringClass() == ComboBoxBase.class && eventName.equals("javafx.event.ActionEvent")) {
                        eventName = "javafx.event.Event";
                    }
                    String variableName = eventName.substring(eventName.lastIndexOf(46) + 1);
                    variableName = Character.toLowerCase(variableName.charAt(0)) + variableName.substring(1);
                    String methodName = node.getNodeValue().substring(1);
                    MainClass.addMethod(methodName, eventName, variableName);
                    attributeList.add(prefix + nodeName + "(this::" + methodName + ");");
                    continue block10;
                }
                default: {
                    Type[] types;
                    if (value.equals("-Infinity")) {
                        value = "USE_PREF_SIZE";
                    }
                    if (value.equals("1.7976931348623157E308")) {
                        value = "Double.MAX_VALUE";
                    }
                    if (Character.isUpperCase(simpleName.codePointAt(0))) {
                        types = method.getGenericParameterTypes();
                        eventName = types[0].getTypeName().replace("$", ".");
                        if (eventName.endsWith(".Paint")) {
                            eventName = eventName.replace(".Paint", ".Color");
                            if (value.startsWith("#")) {
                                value = "valueOf(\"" + value + "\")";
                            }
                        }
                        eventName = eventName + ".";
                    }
                    nodeName = nodeName + "(" + eventName + value + ");";
                    attributeList.add(prefix + nodeName);
                }
            }
        }
    }
}

