#include "keys.bas"

DIM P$ AS STRING = "\A\B\C"
DIM PIDX AS UBYTE
DIM LEVEL AS UBYTE = 1
DIM KARMA AS UBYTE = 3
DIM TIME AS UBYTE
DIM X, Y, U, V, PX, PY AS INTEGER
DIM X1, Y1, X2, Y2 AS INTEGER
DIM RAY_TYPE, MRAYS AS UBYTE
DIM MOVES, MMOVES AS UBYTE
DIM POWERS, MPOWERS AS UBYTE
DIM LEVEL_DATA(0 TO 9, 0 TO 2) AS UBYTE => {             _
                                            {  5, 4, 1 }, _
                                            {  6, 4, 2 }, _
                                            {  6, 3, 3 }, _
                                            {  7, 4, 2 }, _
                                            {  7, 3, 3 }, _
                                            {  8, 5, 3 }, _
                                            {  8, 4, 4 }, _
                                            {  9, 4, 3 }, _
                                            {  9, 3, 4 }, _
                                            { 10, 3, 4 }  _
                                            }

DIM CARBOY_UDGS_DATA(143) AS UBYTE => { 3, 3, 2, 3, 2, 2, 6, 4, 192, 192, 64, 192, 64, 64, 96, 32, 0, 0, 0, 3, 12, 48, 64, 128, 4, 28, 228, 4, 4, 8, 16, 32, 32, 56, 39, 32, 32, 16, 8, 4, 0, 0, 0, 192, 48, 12, 2, 1, 224, 152, 134, 129, 128, 128, 192, 67, 24, 7, 0, 128, 96, 31, 0, 0, 24, 224, 0, 1, 6, 248, 0, 0, 7, 25, 97, 129, 1, 1, 3, 194, 68, 68, 68, 100, 36, 36, 36, 36, 128, 140, 146, 146, 146, 146, 146, 146, 1, 49, 73, 73, 73, 73, 73, 73, 34, 34, 34, 38, 36, 36, 36, 36, 52, 19, 16, 16, 16, 8, 7, 0, 146, 18, 18, 12, 0, 0, 0, 255, 73, 72, 72, 48, 0, 0, 0, 255, 44, 200, 8, 8, 8, 16, 224, 0 }
DIM GAME_UDGS_DATA(167) AS UBYTE => { 24, 24, 57, 126, 184, 188, 36, 54, 24, 24, 156, 126, 29, 61, 36, 108, 24, 24, 60, 126, 189, 189, 36, 102, 126, 129, 189, 129, 126, 60, 90, 255, 255, 128, 175, 128, 171, 160, 171, 170, 170, 171, 160, 171, 128, 175, 128, 255, 85, 213, 5, 213, 1, 245, 1, 255, 255, 1, 245, 1, 213, 5, 213, 85, 170, 170, 146, 146, 146, 146, 170, 170, 85, 85, 73, 73, 73, 73, 85, 85, 255, 0, 195, 60, 195, 0, 255, 0, 0, 255, 0, 195, 60, 195, 0, 255, 255, 0, 195, 60, 60, 195, 0, 255, 171, 168, 167, 144, 144, 167, 168, 171, 213, 21, 229, 9, 9, 229, 21, 213, 4, 64, 0, 8, 128, 2, 0, 32, 0, 60, 66, 66, 82, 74, 60, 0, 0, 124, 66, 66, 124, 68, 66, 0, 0, 60, 64, 60, 2, 66, 60, 0, 0, 254, 16, 16, 16, 16, 16, 0, 0, 66, 66, 66, 66, 66, 60, 0 }

CONST MAX_LOAD_UDGS_DELAY AS UINTEGER = 1000
CONST MAX_MENU_TITLE_DELAY AS UBYTE = 125

DIM MENU_TITLE_DELAY AS UBYTE

SUB WAIT_KEYPRESS()
  DO WHILE INKEY <> "" LOOP:
  DO WHILE INKEY = "" LOOP:
  DO WHILE INKEY <> "" LOOP:
END SUB

SUB MENU_INITIALIZE_SCREEN()
  BORDER 1: PAPER 1: INK 4: CLS
  PLOT 0, 0: DRAW 255, 0: DRAW 0, 191: DRAW -255, 0: DRAW 0, -191
  PLOT 2, 47: DRAW 251, 0
  PLOT 2, 2: DRAW 251, 0: DRAW 0, 187: DRAW -251, 0: DRAW 0, -187
  PLOT 2, 49: DRAW 251, 0
  PLOT 2, 123: DRAW 61, 0
  PLOT 2, 125: DRAW 61, 0
  PLOT 253, 123: DRAW -61, 0
  PLOT 253, 125: DRAW -61, 0
  PLOT 63, 144: DRAW 129, 0: DRAW 0, -41: DRAW -129, 0: DRAW 0, 41
  PLOT 65, 142: DRAW 125, 0: DRAW 0, -37: DRAW -125, 0: DRAW 0, 37
  PRINT INK 6; AT 19, 1; "Conversion from Sinclair BASIC";
  PRINT INK 6; AT 20, 7; "to Boriel BASIC by";
  PRINT INK 3; AT 21, 4; "WWW:garrafonsoftware.com";
  PRINT INK 4; AT 22, 6; CHR$ (127); " 2024 @garrafonsoft";
END SUB

SUB MENU_SHOW_TITLE()
  IF MENU_TITLE_DELAY = 0 THEN
    POKE UBYTE 23606, RND + 0.5
    PRINT INK 2; OVER RND + 0.5; AT 7, 13 + RND + 0.5; " THE "; AT 8, 10; "UNFORGIVABLE"; AT 9, 11 + RND + 0.5; " INNOCENT ";
    POKE UBYTE 23606, 0
    LET MENU_TITLE_DELAY = MAX_MENU_TITLE_DELAY
  END IF
  LET MENU_TITLE_DELAY = MENU_TITLE_DELAY - 1
END SUB

SUB CLEAR_MENU_TEXTS()
  DIM A AS UBYTE

  FOR A = 1 TO 4
    PRINT AT A, 1; "                              ";
    PRINT AT A + 11, 1; "                              ";
  NEXT A
  PRINT AT 7, 9; "              ";
  PRINT AT 8, 9; "              ";
  PRINT AT 9, 9; "              ";
  PRINT AT 16, 1; "                              ";
  PRINT AT 5, 1; "      ";
  PRINT AT 6, 1; "      ";
  PRINT AT 7, 1; "      ";
  PRINT AT 5, 25; "      ";
  PRINT AT 6, 25; "      ";
  PRINT AT 7, 25; "      ";
END SUB

SUB MENU_SHOW_MAIN()
  DIM A AS UBYTE

  POKE UINTEGER 23675, @CARBOY_UDGS_DATA(0)
  FOR A = 0 TO 1
    PRINT INK 7; AT 2, 3 + 24 * A; "\A\B"; AT 3, 2 + 24 * A; "\C\D\E\F"; AT 4, 2 + 24 * A; "\G\H\I\J"; AT 5, 2 + 24 * A; "\K\L\M\N"; AT 6, 2 + 24 * A; "\O\P\Q\R";
  NEXT A
  POKE UINTEGER 23675, @GAME_UDGS_DATA(0)
  PRINT INK 7; AT 2, 7; "GARRAFON  SOFTWARE"; INK 6; AT 4, 10; "- PRESENTS -";
  PRINT INK 7; AT 13, 3; "Choose your option:";
  PRINT INK 5; FLASH 1; AT 15, 5; " <ENTER> TO PLAY GAME "; FLASH 0; AT 16, 6; "<I> FOR INSTRUCTIONS";
END SUB

SUB MENU_SHOW_INSTRUCTIONS()
  DIM A, B AS UBYTE
  DIM C AS BYTE
  DIM QA_TEXT$ AS STRING = "Q=Up  A=Down"
  DIM OP_TEXT$ AS STRING = "O=Left  P=Right"
  DIM INSTRUCTIONS$ AS STRING = "Collect all powers on each level avoiding the deathly rays before time runs out to escape the depths of the Underworld. "

  PRINT INK 5; AT 12, 5; "Control with Keyboard:";
  IF INT (RND + 0.5) = 1 THEN
    PRINT INK 6; AT 13, 1; QA_TEXT$; "   "; OP_TEXT$;
  ELSE
    PRINT INK 6; AT 13, 1; OP_TEXT$; "   "; QA_TEXT$;
  END IF
  PRINT INK 5; AT 14, 6; "or SINCLAIR joystick";
  LET C = LEN (INSTRUCTIONS$) - 1
  FOR A = 4 TO 1 STEP -1
    FOR B = 30 TO 1 STEP -1
      IF C >= 0 THEN
        POKE UBYTE 23606, RND + 0.5
        PRINT INK 7; AT A, B; INSTRUCTIONS$ (C);
        BEEP 0.03, 0
        LET C = C - 1
      END IF
    NEXT B
  NEXT A
  POKE UBYTE 23606, 0
  PRINT AT 6, 1; "Move"; AT 7, 2; "fast!"; AT 6, 25; "Good"; AT 7, 26; "luck!";
  PRINT INK 7; FLASH 1; AT 16, 4; " Press any key for menu ";
END SUB

SUB GAME_GET_LEVEL_DATA()
  LET MPOWERS = LEVEL_DATA (LEVEL - 1, 0)
  LET MMOVES = LEVEL_DATA (LEVEL - 1, 1)
  LET MRAYS = LEVEL_DATA (LEVEL - 1, 2)
END SUB

SUB GAME_INIT_PLAYFIELD()
  DIM A AS UBYTE

  FOR A = 1 TO 19
    PRINT PAPER 0; AT A, 1; "\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P";
    BEEP 0.02,A
  NEXT A
END SUB

SUB GAME_CLEAR_PLAYFIELD()
  DIM A AS UBYTE

  FOR A = 1 TO 19
    PRINT INK 4; OVER 1; AT A, 1; "                              ";
    BEEP 0.005, (19 - A)
  NEXT A
END SUB

SUB GAME_SHOW_LEVEL_COMPLETED()
  DIM A AS UINTEGER

  PRINT INK 7; PAPER 2; FLASH 1; AT 6, 7;"                  "; AT 7, 7; " LEVEL COMPLETED! "; AT 8, 7; "                  ";
  BEEP 0.1, 0
  BEEP 0.1, 2
  BEEP 0.1, 6
  BEEP 0.1, 4
  BEEP 0.1, 8
  BEEP 0.2, 10
  BEEP 0.2, 12
  FOR A = 0 TO 25000: NEXT A
END SUB

SUB GAME_SHOW_END_GAME()
  DIM A, B AS UBYTE

  PRINT INK 4; PAPER 1; FLASH 1; AT 3, 7; "                  "; AT 4, 7; " CONGRATULATIONS! "; AT 5, 7; "                  "; FLASH 0; AT 7, 6; "YOU EMERGED FROM THE"; AT 8, 3; "DEPTHS OF THE UNDERWORLD."; AT 10, 3; "WHAT WERE YOU SUPPOSED TO"; AT 11, 5; "BE DOING DOWN THERE!?"; AT 13, 1; "WHATEVER, YOU WILL HOPELESSLY"; AT 14, 7; "END BURNING IN...";
  PRINT FLASH 1; PAPER 2; INK 6; AT 16, 12; " "; INVERSE 1; "  "; INVERSE 0; " "; INVERSE 1; "  "; INVERSE 0; "  "; AT 17, 12; INVERSE 1; " "; INVERSE 0; " "; INVERSE 1; BRIGHT 1; "HE"; INVERSE 0; "LL"; BRIGHT 0; INVERSE 1; " "; INVERSE 0; " "; AT 18,12; INVERSE 0; "  "; INVERSE 1; " "; INVERSE 0; "  "; INVERSE 1; " "; INVERSE 0; " "; INVERSE 1; " ";
  FOR A = -10 TO 10
    FOR B = 7 TO 0 STEP -1
      OUT 254, B
    NEXT B
    BEEP 0.05, A
  NEXT A
  WAIT_KEYPRESS()
END SUB

SUB GAME_SHOW_TIME_UP()
  DIM A AS BYTE

  GAME_CLEAR_PLAYFIELD()
  PRINT INK 7; PAPER 1; FLASH 1; AT 4, 11; "          "; AT 5, 11; " TIME UP! "; AT 6, 11; "          "; FLASH 0; AT 8, 7; "THE CLAWS OF DEVIL"; AT 9, 7; "TRAPPED YOU IN THE"; AT 10, 5; "UNDERWORLD... FOREVER!";
  FOR A = 10 TO 0 STEP -1
    BEEP 0.05, A
  NEXT A
  GAME_SHOW_GAME_OVER()
END SUB

SUB GAME_SHOW_NO_KARMA_LEFT()
  DIM A AS UBYTE

  GAME_CLEAR_PLAYFIELD()
  PRINT INK 5; PAPER 1; FLASH 1; AT 4, 8; "                "; AT 5, 8; " NO KARMA LEFT! "; AT 6, 8; "                "; FLASH 0; AT 8, 8; "WEAKENED BY THE"; AT 9, 3; "DEATHLY RAYS, ROAM IN THE"; AT 10, 4; "UNDERWORLD... EVERMORE!";
  FOR A = 0 TO 10
    BEEP 0.05, A
  NEXT A
  GAME_SHOW_GAME_OVER()
END SUB

SUB GAME_SHOW_GAME_OVER()
  DIM A AS UBYTE

  PRINT INK 2; PAPER 6; FLASH 1; AT 13, 13; "      "; AT 14, 13; " GAME "; AT 15, 13; " OVER "; AT 16, 13; "      ";
  FOR A = 0 TO 10
    BEEP 0.05, A * 2
  NEXT A
  WAIT_KEYPRESS()
END SUB

SUB GAME_PRINT_SCORES()
  PRINT AT 22, 4; 11 - LEVEL; " ";
  PRINT AT 22, 13; KARMA; " ";
  PRINT AT 22, 19; TIME; " ";
  PRINT AT 22, 26; POWERS; " ";
END SUB

SUB GAME_SHOW_GET_READY()
  PRINT FLASH 1; AT 7, 10; "            "; AT 8, 10; " GET READY! "; AT 9, 10; "            ";
  WAIT_KEYPRESS()
  PRINT AT 7, 10; "\P\P\P\P\P\P\P\P\P\P\P\P"; AT 8, 10; "\P\P\P\P\P\P\P\P\P\P\P\P"; AT 9, 10; "\P\P\P\P\P\P\P\P\P\P\P\P";
END SUB

SUB GAME_DRAW_RAY()
  IF RAY_TYPE = 0 THEN
    LET X1 = INT (RND * 224) + 16
    LET Y1 = INT (RND * 136) + 40
    PLOT INK 1; X1, Y1
    BEEP 0.005, 4
    LET RAY_TYPE = 1
  ELSE IF RAY_TYPE = 1 THEN
    LET X2 = INT (RND * 224) + 16
    LET Y2 = INT (RND * 136) + 40
    PLOT INK 1; X2, Y2
    BEEP 0.005, 8
    LET RAY_TYPE = INT (RND * MRAYS) + 2
  ELSE IF RAY_TYPE = 2 THEN
    PLOT INK 4; X1, Y1
    DRAW INK 4; (X2 - X1), (Y2 - Y1)
    BEEP 0.005, 10
    LET RAY_TYPE = 0
  ELSE IF RAY_TYPE = 3 THEN
    PLOT INK 4; X1, Y1
    IF RND > 0.5 THEN
      DRAW INK 4; (X2 - X1), 0
      DRAW INK 4; 0, (Y2 - Y1)
    ELSE
      DRAW INK 4; 0, (Y2 - Y1)
      DRAW INK 4; (X2 - X1), 0
    END IF
    BEEP 0.005, 10
    LET RAY_TYPE = 0
  ELSE IF RAY_TYPE = 4 THEN
    PLOT INK 4; X1, Y1
    IF RND > 0.5 THEN
      DRAW INK 4; (X2 - X1), 0
      DRAW INK 4; 0, (Y2 - Y1)
      DRAW INK 4; -(X2 - X1), -(Y2 - Y1)
    ELSE
      DRAW INK 4; 0, (Y2 - Y1)
      DRAW INK 4; (X2 - X1), 0
      DRAW INK 4; -(X2 - X1), -(Y2 - Y1)
    END IF
    BEEP 0.005, 10
    LET RAY_TYPE = 0
  ELSE
    PLOT INK 4; X1, Y1
    DRAW INK 4; (X2 - X1), 0
    DRAW INK 4; 0, (Y2 - Y1)
    DRAW INK 4; -(X2 - X1), 0
    DRAW INK 4; 0, -(Y2 - Y1)
    BEEP 0.005, 10
    LET RAY_TYPE = 0
  END IF
  GAME_PRINT_POWER()
END SUB

SUB GAME_INIT_POWER_AND_TIME()
  DIM A AS UBYTE

  DO
    LET PX = INT (RND * 15) + 3
  LOOP UNTIL ABS (PX - X) >= 5
  DO
    LET PY = INT (RND * 26) + 3
  LOOP UNTIL ABS (PY - Y) >= 10
  LET TIME = ABS (PX - X) + ABS (PY - Y) + INT (10 - KARMA / 2) + INT (5 * MPOWERS / 3 - POWERS) + INT ((11 - LEVEL) / 5 + 2) * 4
  IF POWERS <> MPOWERS THEN
    FOR A = 2 TO 18
      PRINT AT A, PY; "\P";
    NEXT A
    PRINT AT PX, 2; "\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P\P"; INK 3; AT PX, PY; "\D";
  END IF
END SUB

SUB GAME_PRINT_POWER()
  DIM VALUE AS UBYTE

  VALUE = POWERS = 0

  PRINT FLASH VALUE; INK 3 + 2 * VALUE; AT PX, PY; "\D";
END SUB

FUNCTION GAME_RUN() AS UBYTE
  DIM A AS UINTEGER
  DIM C, D AS UBYTE

  DO
    FOR A = 0 TO 4000: NEXT A
    LET PIDX = 5
    IF (MULTIKEYS (KEYO) OR MULTIKEYS (KEY6)) AND Y > 1 THEN
      LET PIDX = 1
      LET Y = Y - 1
    ELSE IF (MULTIKEYS (KEYP) OR MULTIKEYS (KEY7)) AND Y < 30 THEN
      LET PIDX = 0
      LET Y = Y + 1
    ELSE IF (MULTIKEYS (KEYA) OR MULTIKEYS (KEY8)) AND X < 19 THEN
      LET PIDX = 2
      LET X = X + 1
    ELSE IF (MULTIKEYS (KEYQ) OR MULTIKEYS (KEY9)) AND X > 1 THEN
      LET PIDX = 2
      LET X = X - 1
    END IF
    LET C = PEEK (22528 + 32 * X + Y) = 3
    LET D = PEEK (22528 + 32 * X + Y) = 4
    IF PIDX <> 5 THEN
      PRINT AT U, V; "\P"; INK 6; AT X, Y; P$(PIDX);
      LET U = X
      LET V = Y
    END IF
    IF C = 1 THEN
      OUT 254, 3
      LET POWERS = POWERS - 1
      GAME_PRINT_SCORES()
      IF KARMA < 5 THEN
        LET KARMA = KARMA + 1
      END IF
      GAME_PRINT_SCORES()
      BEEP 0.015, 0
      BEEP 0.015,10
      IF POWERS = 0 THEN
        GAME_PRINT_POWER()
        GAME_SHOW_LEVEL_COMPLETED()
        LET LEVEL = LEVEL + 1
        RETURN 0
      ELSE
        GAME_INIT_POWER_AND_TIME()
      END IF
    END IF
    LET MOVES = MOVES - 1
    IF MOVES = 0 THEN
      LET MOVES = MMOVES
      GAME_DRAW_RAY()
      IF PEEK (22528 + 32 * X + Y) = 4 THEN
        LET D = PIDX = 5
        PRINT INK 6; AT X, Y; P$(PIDX + 3 * D);
        LET D = 1
      END IF
    END IF
    IF D = 1 THEN
      OUT 254, 4
      LET KARMA = KARMA - 1
      GAME_PRINT_SCORES()
      BEEP 0.03, 0
      IF KARMA = 0 THEN
        RETURN 1
      END IF
    END IF
    LET TIME = TIME -1
    GAME_PRINT_SCORES()
    IF TIME = 0 THEN
      RETURN 2
    END IF
  LOOP:

  RETURN 0
END FUNCTION

FUNCTION GAME_INIT() AS UBYTE
  DIM A, EXIT_GAME AS UBYTE

  LET LEVEL = 1
  LET KARMA = 3
  RANDOMIZE 0
  BORDER 0: PAPER 0: INK 7: CLS
  PRINT PAPER 1; AT 21, 1; " LEVEL    KARMA  TIME  POWERS ";
  FOR A = 1 TO 22
    IF A <> 20 THEN
      PRINT PAPER 2; AT A, 0; "\I"; AT A, 31; "\J";
    ELSE
      PRINT PAPER 2; AT 20, 0; "\N\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\M\O";
    END IF
  NEXT A
  PRINT PAPER 2; AT 0, 0; "\E\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\K\H";
  PRINT PAPER 2; AT 23, 0; "\F\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\L\G";
  DO
    GAME_INIT_PLAYFIELD()
    IF LEVEL > 10 THEN
      GAME_PRINT_SCORES()
      EXIT_GAME = 3
    ELSE
      GAME_GET_LEVEL_DATA()
      LET X = INT (RND * 19) + 1
      LET Y = INT (RND * 30) + 1
      LET U = X
      LET V = Y
      LET RAY_TYPE = 0
      LET MOVES = MMOVES
      LET POWERS = MPOWERS
      GAME_INIT_POWER_AND_TIME()
      GAME_PRINT_SCORES()
      GAME_SHOW_GET_READY()
      PRINT INK 6; AT X,Y; P$(1);
      GAME_PRINT_POWER()
      EXIT_GAME = GAME_RUN()
    END IF
  LOOP WHILE EXIT_GAME = 0
  RETURN EXIT_GAME
END FUNCTION

' MAIN
DIM KEY$ AS STRING
DIM EXIT_CODE AS UBYTE

DO
  MENU_INITIALIZE_SCREEN()
  DO
    MENU_TITLE_DELAY = 0
    MENU_SHOW_TITLE()
    MENU_SHOW_MAIN()
    DO WHILE INKEY <> "" LOOP:
    DO
      MENU_SHOW_TITLE()
      LET KEY$ = INKEY
    LOOP WHILE KEY$ <> CHR$ (13) AND KEY$ <> "i" AND KEY$ <> "I"
    IF KEY$ = CHR$ (13) THEN
      EXIT_CODE = GAME_INIT()
      IF EXIT_CODE = 1 THEN
        GAME_SHOW_NO_KARMA_LEFT()
      ELSE IF EXIT_CODE = 2 THEN
        GAME_SHOW_TIME_UP()
      ELSE IF EXIT_CODE = 3 THEN
        GAME_SHOW_END_GAME()
      ELSE
        ' Fallback value
        GAME_SHOW_GAME_OVER()
      END IF
    ELSE
      CLEAR_MENU_TEXTS()
      MENU_TITLE_DELAY = 0
      MENU_SHOW_TITLE()
      MENU_SHOW_INSTRUCTIONS()
      DO WHILE INKEY <> "" LOOP:
      DO
        MENU_SHOW_TITLE()
      LOOP WHILE INKEY = ""
      CLEAR_MENU_TEXTS()
    END IF
  LOOP WHILE KEY$ <> CHR$ (13)
LOOP:
' END MAIN