# LFM QuickStart

One‑command runner for the LFM validation suite. Prefers GPU automatically and falls back to CPU when needed. No admin privileges required; all changes are local to the `QuickStart/` folder.

License: CC BY-NC-ND 4.0 • Contact: latticefieldmediumresearch@gmail.com

## Prerequisites
- Windows 10/11, Linux, or macOS
- Python 3.10–3.12
- Internet access on first run (installs dependencies into a local venv)
- Recommended: NVIDIA GPU with modern drivers (CUDA 11/12). CPU fallback is automatic but slower.
- Windows (sometimes): Visual C++ 2015–2022 Redistributable may be required by some wheels.

## Where Results Are Saved
- `QuickStart/results/<Category>/<TEST-ID>/`

## Quick Start
```
py run_lfm_suite.py
```

- Runs ALL tiers (1–7) in parallel by default (GPU if available).
- Auto‑detects CUDA and installs a matching CuPy wheel (>=13.3,<14.0) for your CUDA 12.x/11.x driver.
- If needed, installs NVIDIA CUDA Python libraries (NVRTC/Runtime) and wires their DLL folders for you.
- If GPU is unavailable or unsupported, it automatically installs NumPy and runs on CPU.

## Optional Quick Run
- For a 14-test fast validation (2 tests per tier), use:
```
py run_lfm_suite.py --fast
```
This is the only supported flag; default runs the full suite.

## What the script does
- Creates a local virtual environment at `QuickStart/.venv` (idempotent)
- Installs `QuickStart/requirements.txt` into that venv
- Detects CUDA via `nvidia-smi`/`nvcc` and installs the matching CuPy wheel:
  - `cupy-cuda12x` or `cupy-cuda11x` pinned to `>=13.3,<14.0` (Python 3.12+ safe)
  - If CuPy reports a missing NVRTC DLL (e.g., `nvrtc64_120_0.dll`), installs the exact minor of NVIDIA CUDA Python libs (NVRTC/Runtime) and adds their `bin/`/`lib/` folders to the DLL search path
- If GPU remains unavailable, installs NumPy and runs on CPU
- Sets results root to `QuickStart/results` and launches the parallel suite from `QuickStart/runtime/src`

## Troubleshooting
- GPU error referencing `nvrtc64_XXX_Y.dll`:
  - Re‑run the command; the runner now auto‑installs matching NVRTC/Runtime packages and wires DLL search paths
  - Ensure recent NVIDIA drivers (CUDA 12+ preferred; CUDA 11 also supported)
- Python 3.12 compatibility:
  - CuPy is pinned to `>=13.3,<14.0` to ensure wheel availability
- Corporate network / offline:
  - If pip cannot reach PyPI, pre‑install wheels into `QuickStart/.venv` or configure your package index mirror
- macOS / WSL2:
  - CUDA acceleration is typically unavailable; the runner will use CPU automatically
- Path errors:
  - Run commands from the unzipped `QuickStart/` folder and keep its structure intact

## Notes
- All multi-test runs are executed via the parallel suite for correctness and speed.
- Tier 2 `GRAV-09` is intentionally skipped; all other tests run.

Each test writes `summary.json`, logs, and any diagnostics/plots under its folder.

Note: The runner only mutates environment variables inside its own process and child processes. It does not modify your system PATH or CUDA installation.