<!-- Copyright (c) 2025 Greg D. Partin. All rights reserved. -->
<!-- Licensed under CC BY-NC-ND 4.0 (Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International). -->
<!-- See LICENSE file in project root for full license text. -->
<!-- Commercial use prohibited without explicit written permission. -->
<!-- Contact: latticefieldmediumresearch@gmail.com -->

[![License: CC BY-NC-ND 4.0](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc-nd/4.0/)

## Standard Introduction

This document is part of the Lattice-Field Medium (LFM) Phase 1 publication set. It follows our standard formatting and reproducibility guidelines.

# src

This README is auto-generated by the environment builder.

- Directory: `./src`
- Generation: deterministic, reproducible

## Snapshot
- Files: 45
- Folders: 5
- Top file types: .py:44, .md:1

## Contents (tree)

- core/
  - core\__init__.py
  - core\lfm_backend.py
  - core\lfm_equation.py
  - core\lfm_fields.py
  - core\lfm_parallel.py
  - core\lfm_simulator.py
- harness/
  - harness\__init__.py
  - harness\lfm_test_harness.py
  - harness\lfm_test_metrics.py
  - harness\lfm_tiers.py
  - harness\StandardTierTemplate.py
- physics/
  - physics\__init__.py
  - physics\chi_field_equation.py
  - physics\em_analytical_framework.py
  - physics\em_test_implementation_template.py
  - physics\lorentz_transform.py
- ui/
  - ui\__init__.py
  - ui\lfm_console.py
  - ui\lfm_control_center.py
  - ui\lfm_gui.py
  - ui\lfm_plotting.py
  - ui\lfm_studio_ide.py
  - ui\lfm_visualizer.py
- utils/
  - utils\__init__.py
  - utils\energy_monitor.py
  - utils\lfm_config.py
  - utils\lfm_diagnostics.py
  - utils\lfm_logger.py
  - utils\lfm_results.py
  - utils\numeric_integrity.py
  - utils\path_utils.py
  - utils\resource_monitor.py
  - utils\resource_tracking.py
- __init__.py
- lfm_cloud_orchestrator.py
- run_parallel_suite.py
- run_parallel_tests.py
- run_tests_simple.py
- run_tier1_relativistic.py
- run_tier2_gravityanalogue.py
- run_tier3_energy.py
- run_tier4_quantization.py
- run_tier5_electromagnetic.py
- run_unif00_core_principle.py

---
Generated by build_test_environment.py. Do not edit by hand; re-run the builder to refresh.


## IP and License

This workspace is distributed under CC BY-NC-ND 4.0. Commercial use is prohibited without explicit permission.

- License: see LICENSE at the root.

## Provenance and Reproducibility

- This environment is initialized deterministically.
- Generated artifacts include explicit manifest and metadata.


## About src

- Python modules organized into subpackages (core, utils, harness, physics, ui).
- Avoid embedding secrets. Config via config/*.json only.


---

Prepared by LFM Research, Los Angeles CA USA
License: CC BY-NC-ND 4.0 • Contact: latticefieldmediumresearch@gmail.com
