<!-- Copyright (c) 2025 Greg D. Partin. All rights reserved. -->
<!-- Licensed under CC BY-NC-ND 4.0 (Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International). -->
<!-- See LICENSE file in project root for full license text. -->
<!-- Commercial use prohibited without explicit written permission. -->
<!-- Contact: latticefieldmediumresearch@gmail.com -->

[![License: CC BY-NC-ND 4.0](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc-nd/4.0/)

## Standard Introduction

This document is part of the Lattice-Field Medium (LFM) Phase 1 publication set. It follows our standard formatting and reproducibility guidelines.

# src/core

This README is auto-generated by the environment builder.

- Directory: `./src/core`
- Generation: deterministic, reproducible

## Snapshot
- Files: 7
- Folders: 0
- Top file types: .py:7

## Contents (tree)

- __init__.py
- lfm_backend.py
- lfm_equation.py
- lfm_equation_fused.py (NEW: GPU-accelerated kernel)
- lfm_fields.py
- lfm_parallel.py
- lfm_simulator.py

## Backend Selection

The LFM framework now supports two physics backends:

### Baseline Backend (Default)
- **File**: `lfm_equation.py`
- **Function**: `_baseline_lattice_step()`
- **Status**: Canonical reference implementation
- **Use**: All physics validation, cross-platform testing
- **Performance**: Portable NumPy/CuPy, ~0.7ms/step @ 64³

### Fused Backend (Optional GPU Accelerator)
- **File**: `lfm_equation_fused.py`
- **Function**: `fused_verlet_step()`
- **Status**: Production-ready, verified to P1 accuracy gate
- **Use**: GPU-accelerated production runs
- **Performance**: 3.3-5.1× faster than baseline (mean 3.94×)
- **Validation**:
  - Wave packet 256³: drift 8.48e-05 (P1 gate: <1e-4) ✓
  - Gravity sim 64³: drift within tolerance ✓
  - Lorentz covariance verified ✓

### Using Backends

**In tier tests**:
```bash
# Default (baseline)
python src/run_tier1_relativistic.py --test REL-01

# GPU-accelerated
python src/run_tier1_relativistic.py --test REL-01 --backend fused
```

**In code**:
```python
params = {
    "dt": dt, "dx": dx,
    "alpha": alpha, "beta": beta,
    "chi": chi,
    "backend": "fused",  # or "baseline" (default)
    # ... other params
}
E_next = lattice_step(E, E_prev, params)
```

**Backend dispatch** (`lfm_equation.py` line ~222):
- Checks `params.get('backend', 'baseline')`
- If `'fused'` + GPU available: imports and calls `fused_verlet_step()`
- Otherwise: falls back to `_baseline_lattice_step()`
- Zero breaking changes: defaults to baseline

### Performance Baselines

Measured on NVIDIA GeForce RTX 4060 Laptop (8GB VRAM, CuPy v13.6.0):

| Test Case | Grid | Steps | Baseline | Fused | Speedup |
|-----------|------|-------|----------|-------|---------|
| Wave packet 64³ | 64³ | — | 0.64 ms/step | 0.19 ms/step | **3.32×** |
| Wave packet 128³ | 128³ | — | 3.58 ms/step | 1.07 ms/step | **3.35×** |
| Wave packet 256³ | 256³ | — | 34.1 ms/step | 8.55 ms/step | **3.99×** |
| Gravity sim 64³ | 64³ | — | 0.70 ms/step | 0.14 ms/step | **5.10×** |

**Source**: `performance/benchmarks/fused_benchmark_results.csv` (2025-11-06)
**Accuracy**: Both backends match to machine precision (verified via diff).

### Design Rationale

1. **Single Source of Truth**: `_baseline_lattice_step()` is canonical
2. **Opt-In Acceleration**: Fused kernel requires explicit `--backend fused`
3. **Graceful Fallback**: Auto-detects GPU/CuPy availability
4. **Zero Breaking Changes**: Existing code continues to work unchanged
5. **Physics First**: Validation uses baseline; optimization is separate concern

See `performance/benchmarks/` for detailed performance analysis.

---
Generated by build_test_environment.py. Updated manually 2025-01-XX to document fused backend integration.


## IP and License

This workspace is distributed under CC BY-NC-ND 4.0. Commercial use is prohibited without explicit permission.

- License: see LICENSE at the root.

## Provenance and Reproducibility

- This environment is initialized deterministically.
- Generated artifacts include explicit manifest and metadata.


## Core

- Core solvers and equations.
- Public APIs kept stable across tests.


---

Prepared by LFM Research, Los Angeles CA USA
License: CC BY-NC-ND 4.0 • Contact: latticefieldmediumresearch@gmail.com
