<!-- Copyright (c) 2025 Greg D. Partin. All rights reserved. -->
<!-- Licensed under CC BY-NC-ND 4.0 (Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International). -->
<!-- See LICENSE file in project root for full license text. -->
<!-- Commercial use prohibited without explicit written permission. -->
<!-- Contact: latticefieldmediumresearch@gmail.com -->

[![License: CC BY-NC-ND 4.0](https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-nc-nd/4.0/)

## Standard Introduction

This document is part of the Lattice-Field Medium (LFM) Phase 1 publication set. It follows our standard formatting and reproducibility guidelines.

# src/harness

This README is auto-generated by the environment builder.

- Directory: `./src/harness`
- Generation: deterministic, reproducible

## Snapshot
- Files: 5
- Folders: 0
- Top file types: .py:5

## Contents (tree)

- __init__.py
- lfm_test_harness.py
- lfm_test_metrics.py
- lfm_tiers.py
- StandardTierTemplate.py

---
Generated by build_test_environment.py. Do not edit by hand; re-run the builder to refresh.


## IP and License

This workspace is distributed under CC BY-NC-ND 4.0. Commercial use is prohibited without explicit permission.

- License: see LICENSE at the root.

## Provenance and Reproducibility

- This environment is initialized deterministically.
- Generated artifacts include explicit manifest and metadata.


## Harness


New modular validation architecture (2025-11-09):
 - Shared validation utilities in `harness/validation.py` now centralize metadata-driven pass/fail logic.
 - Tier runners should compute raw physics metrics only (e.g., anisotropy value, dispersion error, momentum drift) and delegate threshold comparison to `check_primary_metric()`.
 - Energy conservation gating is standardized via `energy_conservation_check()`; runners no longer duplicate threshold fetch or drift formatting.
 - Exit code propagation: each runner must exit non-zero if any test's `passed` flag is False so the parallel scheduler can correctly aggregate failures.

Refactor plan (staged):
 1. Tier 1 integrated (metadata-driven checks added for all variants including isotropy, boosts, causality, dispersion, momentum, invariant mass).
 2. Introduce generic evaluators for common physics checks in `validation.py` (future):
	 - `evaluate_isotropy(direction_freqs)`
	 - `evaluate_dispersion(measured, theory)`
	 - `evaluate_causality(measured_speed, c)`
 3. Migrate Tier 2–7 runners to call these evaluators, shrinking variant code.
 4. Add unit tests covering each evaluator with synthetic inputs.
 5. Enhance `validate_metadata_results.py` to optionally re-run failed tests to confirm reproducibility before marking failure.

Pre-commit integration:
 - `tools/pre_commit_validation.py` now runs: website sync → parallel fast tests → metadata conformance.
 - Fails early if any metadata criteria violated (prevents drift of locked thresholds, e.g., Tier 1).

Developer guidance:
 - When adding a new test metric, update `PRIMARY_METRIC_KEY_MAP` in `validation.py` to maintain proper metadata mapping.
 - Keep metadata authoritative; do not hardcode thresholds inside runners.
 - Use `summary.json` to store raw metric values; derived pass/fail status should reflect only metadata comparisons.
 - For complex multi-metric tests, store all raw metrics; choose one primary gate in metadata.

Future enhancements:
 - Cross-tier consistency validator (e.g., dispersion series REL-11→14 monotonic behavior) implemented as secondary checks with informative warnings, not gating.
 - Automatic dt refinement suggestions logged when energy drift near threshold (numerical helper module TBD).
 - Performance regression hooks: compare runtime/resource metrics against historical telemetry and flag large slowdowns.


---

Prepared by LFM Research, Los Angeles CA USA
License: CC BY-NC-ND 4.0 • Contact: latticefieldmediumresearch@gmail.com
