import xbmc
import xbmcgui
import xbmcaddon
import time

# Get global paths
addon = xbmcaddon.Addon(id='plugin.program.carpc-xtouch')
addonpath = addon.getAddonInfo('path').decode("utf-8")
updating = 0

#control
HOME_BUTTON  = 1201
BACK_BUTTON  = 1202
BUTTON_FOCUS = 1203
SETTINGS_BUTTON  = 1204
LOADDAY_BUTTON  = 1205
LOADNIGHT_BUTTON  = 1206
SAVEDAY_BUTTON  = 1207
SAVENIGHT_BUTTON  = 1208
ACTION_BACK  = 92


COMMANDLIST = ['EnableBGPictures','BGPicturesAllowFocus','EnableBGColor','HideVisualisationHome','UseVisBg',
'UseVisBgCover','HideHomeButtonMusicPlayerTitle','HideHomeButtonRadioStationName','HideRandomRepeat','EnableBottomBG',
'EnablePlayerButtonsBG','HideHomeButtonMusic','HideHomeButtonMusicArtists','HideHomeButtonMusicAlbums',
'HideHomeButtonMusicGenre','HideHomeButtonVideo','HideHomeButtonNavigation','HideHomeButtonRadio',
'HideHomeButtonShutdownDialog','HideHomeButtonFileManager','HideHomeButtonConnect3g','HideHomeButtonOBD',
'HideHomeButtonWeather','HideHomeButtonFavourites','HideHomeButtonPrograms','HideHomeButtonConnectWiFi',
'HideHomeButtonDayNight','EnableSubmenuBG','Enable_Clock_Animation','Show_Clock_white','Enable_Clock_Second_Hand',
'HideHomeButtonTime','ShowOutlines','UseVisBgFull','MediaSubMenuVisible2','CustomBackgroundPath','CustomColorNofocus',
'HomeScreenTitleImage','HomeScreenTitle','Home1BG','Home1BGFocus','HBSolidColor','HBTransparency','CustomColorFocus',
'HBOutlineColor','CustomColorHomebuttons','Home2BG','Home2BGFocus','Home3BG','Home3BGFocus','Home4BG','Home4BGFocus',
'Home5BG','Home5BGFocus','Home6BG','Home6BGFocus','CustomLogoPath','CustomVisBgPath','BottomBGColor',
'BottomBGTransparency','PlayerButtonsBGColor','PlayerButtonsBGTransparency','DayNightModus','CustomSubmenuBGColor',
'SubmenuBGTransparency','SkinSettings','SaveDayNight','CustomHomeButtonAction1','CustomHomeButtonAction2',
'CustomHomeButtonAction3','CustomHomeButtonAction4','CustomHomeButtonAction5','CustomHomeButtonAction6',
'Startup_Playlist_Path','CustomVisBgFullPath','HideHomeButtonTime','HideHomeButtonMusicPlayerTitle',
'HideHomeButtonPictures','UseVisBg','HideHomeButtonVideo','PlayerControlsShowAudioInfo','HideHomeButtonFavourites',
'HideRandomRepeat','HideHomeButtonRadioStationName','HideHomeButtonNavigation','HideHomeButtonRadio',
'HideWeatherTitleWidget','PlayerControlsShowVideoInfo','HideHomeButtonConnect3g','HideHomeButtonShutdownDialog',
'HideHomeButtonPrograms','HideHomeButtonMusic','HideHomeButtonFileManager','HideSettingsManager','UseVisBgCover',
'HideHomeButtonWeather','ShowOutlines','EnableBottomBG','EnablePlayerButtonsBG','PlayerControlsSubMenuVisible',
'EnableBGPictures','UseCustomBackground','MediaSubMenuVisible','EnableBGColor','UseCustomLogo','HideVisualisationHome',
'Enable_Clock_Animation','Enable_Clock_Second_Hand','Show_Clock_white','UseVisBgFull','RadioAddonBackground',
'RadioAddonRadioText','ListRadioStation','DeleteRadioStation','SaveRadioStation','SkinHelper.EnableAnimatedPosters',
'SkinHelper.EnablePVRThumbs','SubtitleScript_Path','EnableTitleText','EnableTempOutput']

def readDaySetting(command):
    xbmc.executebuiltin('Skin.SetString(' + command + ',' + addon.getSetting("day_" + command) + ')')

def readNightSetting(command):
    xbmc.executebuiltin('Skin.SetString(' + command + ',' + addon.getSetting("night_" + command) + ')')

def saveDaySetting(command):
    addon.setSetting('day_' + command,str(xbmc.getInfoLabel('Skin.String(' + command + ')')))

def saveNightSetting(command):
    addon.setSetting('night_' + command,str(xbmc.getInfoLabel('Skin.String(' + command + ')')))

def loadDay():
	global COMMANDLIST
	xbmcgui.Window(10000).setProperty('xtouch.updating','true')
	time.sleep(0.5)
	for item in COMMANDLIST:
	    readDaySetting(item)
	time.sleep(1)
	xbmcgui.Window(10000).setProperty('xtouch.updating','false')
	addon.setSetting('state','day')
	xbmcgui.Window(10000).setProperty('xtouch.daynight','day')

def loadNight():
	global COMMANDLIST
	xbmcgui.Window(10000).setProperty('xtouch.updating','true')
	time.sleep(0.5)
	for item in COMMANDLIST:
	    readNightSetting(item)
	time.sleep(1)
	xbmcgui.Window(10000).setProperty('xtouch.updating','false')
	addon.setSetting('state','night')
	xbmcgui.Window(10000).setProperty('xtouch.daynight','night')

def saveDay():
	global COMMANDLIST
	xbmcgui.Window(10000).setProperty('xtouch.saving','true')
	time.sleep(0.5)
	for item in COMMANDLIST:
	    saveDaySetting(item)
	time.sleep(1)
	xbmcgui.Window(10000).setProperty('xtouch.saving','false')

def saveNight():
	global COMMANDLIST
	xbmcgui.Window(10000).setProperty('xtouch.saving','true')
	time.sleep(0.5)
	for item in COMMANDLIST:
	    saveNightSetting(item)
	time.sleep(0.5)
	xbmcgui.Window(10000).setProperty('xtouch.saving','false')

count = len(sys.argv) - 1
if count > 0:
    given_arg = sys.argv[1]
    if given_arg != "-1":
	if given_arg == "loadday":
	    loadDay()
    	    quit()

	if given_arg == "saveday":
	    saveDay()
    	    quit()

	if given_arg == "loadnight":
	    loadNight()
    	    quit()

	if given_arg == "savenight":
	    saveNight()
    	    quit()

class xtouch(xbmcgui.WindowXMLDialog):

    def onInit(self):
        xtouch.button_home=self.getControl(HOME_BUTTON)
        xtouch.button_back=self.getControl(BACK_BUTTON)
        xtouch.buttonfocus=self.getControl(BUTTON_FOCUS)
        xtouch.button_settings=self.getControl(SETTINGS_BUTTON)
	xbmcgui.Window(10000).setProperty('xtouch.updating','false')
	xbmcgui.Window(10000).setProperty('xtouch.saving','false')

	if str(xbmc.getSkinDir()) != "skin.carpc-xtouch":
	    xbmcgui.Window(10000).setProperty('xtouch.warning','true')
	else:
	    xbmcgui.Window(10000).setProperty('xtouch.warning','false')

    def onClick(self, controlID):

        if controlID == HOME_BUTTON:
            self.close()

        if controlID == BACK_BUTTON:
            self.close()

        if controlID == SETTINGS_BUTTON:
	    self.setFocus(self.buttonfocus)
	    addon.openSettings()
	    self.setFocus(self.buttonfocus)

        if controlID == LOADDAY_BUTTON:
	    loadDay()

        if controlID == LOADNIGHT_BUTTON:
	    loadNight()

        if controlID == SAVEDAY_BUTTON:
	    saveDay()

        if controlID == SAVENIGHT_BUTTON:
	    saveNight()

    def onFocus(self, controlID):
        pass
    
    def onControl(self, controlID):
        pass

xtouchdialog = xtouch("xtouch.xml", addonpath, 'default', '720')

xtouchdialog.doModal()
del xtouchdialog
