import xbmc
import xbmcgui
import xbmcaddon
import RPi.GPIO as GPIO
import time
from threading import Thread

# Get global paths
addon = xbmcaddon.Addon(id='plugin.program.gpiodiag')
addonpath = addon.getAddonInfo('path').decode('utf-8')

#control
HOME_BUTTON  = 1201
BACK_BUTTON  = 1202
BUTTON_FOCUS = 1203
#SETTINGS_BUTTON  = 1204
ACTION_BACK  = 92
kill = False

def checkGPIO():
    GPIO.setmode(GPIO.BCM)
    GPIO.setwarnings(False)
    ports = [2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27]
    pin_type = "GPIO"
    port_use = {0:"GPIO.OUT", 1:"GPIO.IN",40:"GPIO.SERIAL",41:"GPIO.SPI",42:"GPIO.I2C",43:"GPIO.HARD_PWM", -1:"GPIO.UNKNOWN"}
    revision = GPIO.RPI_INFO['TYPE']
    xbmcgui.Window(10000).setProperty("rpitype",str(revision))
    for port in ports:
	usage = GPIO.gpio_function(port)
	value = ""
	if usage == 1:
	    GPIO.setup(port, GPIO.IN)
	    value = GPIO.input(port)
	    xbmcgui.Window(10000).setProperty("gpio_usage" + str(port),str(port_use[usage]))
	    xbmcgui.Window(10000).setProperty("gpio_value" + str(port),str(value))
	    if value == 1:
		xbmcgui.Window(10000).setProperty("gpio_color" + str(port),"orange")
	    else:
		xbmcgui.Window(10000).setProperty("gpio_color" + str(port),"blue")
	elif usage == 0:
	    GPIO.setup(port, GPIO.OUT)
	    value = GPIO.input(port)
	    xbmcgui.Window(10000).setProperty("gpio_usage" + str(port),str(port_use[usage]))
	    xbmcgui.Window(10000).setProperty("gpio_value" + str(port),str(value))
	    if value == 1:
		xbmcgui.Window(10000).setProperty("gpio_color" + str(port),"orange")
	    else:
		xbmcgui.Window(10000).setProperty("gpio_color" + str(port),"blue")
	else:
	    xbmcgui.Window(10000).setProperty("gpio_usage" + str(port),str(port_use[usage]))
	    xbmcgui.Window(10000).setProperty("gpio_value" + str(port),"")
	    xbmcgui.Window(10000).setProperty("gpio_color" + str(port),"white")

def autoScan():
    global kill
    while True:
	checkGPIO()
	if kill == True:
	    break

t1 = Thread( target=autoScan)
t1.setDaemon( True )
t1.start()

class gpioclass(xbmcgui.WindowXMLDialog):

    def onInit(self):
        gpioclass.button_home=self.getControl(HOME_BUTTON)
        gpioclass.button_back=self.getControl(BACK_BUTTON)
        gpioclass.buttonfocus=self.getControl(BUTTON_FOCUS)
        #gpioclass.button_settings=self.getControl(SETTINGS_BUTTON)
	checkGPIO()

    def onAction(self, action):
        dummy = True
        
    def onClick(self, controlID):
	global kill
        if controlID == HOME_BUTTON:
	    kill = True
            self.close()

        if controlID == BACK_BUTTON:
	    kill = True
            self.close()

        #if controlID == SETTINGS_BUTTON:
	#    kill = True
	#    self.setFocus(self.buttonfocus)
	#    addon.openSettings()
	#    self.setFocus(self.buttonfocus)

    def onFocus(self, controlID):
	global kill
	kill = True
        pass
    
    def onControl(self, controlID):
	global kill
	kill = True
        pass

gpiodialog = gpioclass("Custom_GPIODiag.xml", addonpath, 'default', '720')

gpiodialog.doModal()
del gpiodialog
